      subroutine calc_bondvec
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include 'mpif.h'
      integer ierror
#endif
      include 'COMMON.IOUNITS'
      include 'COMMON.VAR'
      include 'COMMON.CHAIN'
      include 'COMMON.GEO'
      include 'COMMON.INTERACT'
      include 'COMMON.LOCAL'
      include 'COMMON.NAMES'
      include 'COMMON.SETUP'
      include 'COMMON.TIME1'
      integer i,j
      double precision dist
      double precision time01
#ifndef MPI
      double precision tcpu
#endif
#ifdef TIMING
#ifdef MPI
      time01=MPI_Wtime()
#else
      time01=tcpu()
#endif
#endif
c Calculate virtual-bond lengths and their inverses
!$OMP PARALLEL DO DEFAULT(SHARED)
      do i=2,nres
        vbld(i)=dist(c(1,i-1),c(1,i))
        vbld_inv(i)=1.0d0/vbld(i)
        vbld(nres+i)=dist(c(1,nres+i),c(1,i))
        if (itype(i).ne.10 .and. itype(i).ne.ntyp1) then
          vbld_inv(nres+i)=1.0d0/vbld(nres+i)
        else
          vbld_inv(nres+i)=0.0d0
        endif
      enddo   
c Calculate normalized backbone-virtual-bond vectors
!     do i=1,nres-1
!       do j=1,3
!         dc_norm(j,i)=dc(j,i)*vbld_inv(i+1)
!       enddo
!     enddo
      dc_norm(:,1)=dc(:,1)*vbld_inv(1+1)
c Calculate normalized sidechain-virtual-bond vectors
!$OMP PARALLEL DO DEFAULT(SHARED)
      do i=2,nres-1
        !do j=1,3
        !  dc_norm(j,i)=dc(j,i)*vbld_inv(i+1)
        !  dc_norm(j,i+nres)=dc(j,i+nres)*vbld_inv(i+nres)
        !enddo
        dc_norm(:,i)=dc(:,i)*vbld_inv(i+1)
        dc_norm(:,i+nres)=dc(:,i+nres)*vbld_inv(i+nres)
      enddo
#ifdef TIMING
#ifdef MPI
      time_bondvec=time_bondvec+MPI_Wtime()-time01
#else
      time_bondvec=tcpu()-time01
#endif
#endif
      return
      end
