      SUBROUTINE WRTCLUST(NCON,ICUT,PRINTANG,PRINTPDB,printmol2,ib)
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'sizesclu.dat'
      parameter (num_in_line=5)
      LOGICAL PRINTANG(max_cut)
      integer PRINTPDB(max_cut),printmol2(max_cut)
      include 'COMMON.CONTROL'
      include 'COMMON.HEADER'
      include 'COMMON.CHAIN'
      include 'COMMON.VAR'
      include 'COMMON.CLUSTER'
      include 'COMMON.IOUNITS'
      include 'COMMON.GEO'
      include 'COMMON.FREE'
      include 'COMMON.TEMPFAC'
      include 'COMMON.FFIELD'
      include 'COMMON.SBRIDGE'
      include 'COMMON.NMR'
      include 'COMMON.TORCNSTR'
      include 'COMMON.SAXS'
      include 'COMMON.INTERACT'
      include 'COMMON.NAMES'
      CHARACTER*64 prefixp,NUMM,MUMM,EXTEN,extmol
      character*120 cfname
      character*8 ctemper
      DATA EXTEN /'.pdb'/,extmol /'.mol2'/,NUMM /'000'/,MUMM /'000'/
      external ilen
      logical viol_nmr,viol_nmr_gross
      character*1 restr_viol(0:2) /' ','m','M'/
      integer ib,list_peak_viol(maxdim_cont)
      double precision Esaxs_all(maxgr),Pcalc_all(maxsaxs,maxgr)
      double precision rvec(3)
      character*4 resi,resj

      do i=1,64
        cfname(i:i)=" "
      enddo
c      write (iout,*)"calling WRTCLUST",ncon
c      write (iout,*) "ICUT",icut," PRINTPDB ",PRINTPDB(icut)
      rewind 80
      temper=1.0d0/(beta_h(ib)*1.987d-3)
      if (temper.lt.100.0d0) then
        write(ctemper,'(f3.0)') temper
        ctemper(3:3)=" "
      else if (temper.lt.1000.0) then
        write (ctemper,'(f4.0)') temper
        ctemper(4:4)=" "
      else
        write (ctemper,'(f5.0)') temper
        ctemper(5:5)=" "
      endif

      do i=1,ncon*(ncon-1)/2
        read (80) diss(i)
      enddo
c      close(80,status='delete')
C
C  PRINT OUT THE RESULTS OF CLUSTER ANALYSIS
C
      ii1= index(intinname,'/')
      ii2=ii1
      ii1=ii1+1
      do while (ii2.gt.0) 
        ii1=ii1+ii2
        ii2=index(intinname(ii1:),'/')
      enddo 
      ii = ii1+index(intinname(ii1:),'.')-1
      if (ii.eq.0) then
        ii=ilen(intinname)
      else
        ii=ii-1
      endif
      prefixp=intinname(ii1:ii)
cd    print *,icut,printang(icut),printpdb(icut),printmol2(icut)
cd    print *,'ecut=',ecut
      WRITE (iout,100) NGR
      DO 19 IGR=1,NGR
      WRITE (iout,200) IGR,totfree_gr(igr)/beta_h(ib),LICZ(IGR)
      NRECORD=LICZ(IGR)/num_in_line
      IND1=1
      DO 63 IRECORD=1,NRECORD
      IND2=IND1+num_in_line-1
      WRITE (iout,300) (list_conf(NCONF(IGR,ICO)),
     &    totfree(NCONF(IGR,ICO))/beta_h(ib),ICO=IND1,IND2)
      IND1=IND2+1
   63 CONTINUE
      WRITE (iout,300) (list_conf(NCONF(IGR,ICO)),
     &   totfree(NCONF(IGR,ICO))/beta_h(ib),ICO=IND1,LICZ(IGR))
      IND1=1
      ICON=list_conf(NCONF(IGR,1))
c      WRITE (iout,'(16F5.0)') (rad2deg*phiall(IND,icon),IND=4,nphi+3)
C 12/8/93 Estimation of "diameters" of the subsequent families.
      ave_dim=0.0
      amax_dim=0.0
      emin=totfree(nconf(igr,1))
c      write (iout,*) "ecut",ecut," emin",emin
      do i=2,licz(igr)
        ii=nconf(igr,i)
        if (totfree(ii)-emin .gt. ecut) goto 10
        do j=1,i-1
          jj=nconf(igr,j)
c          if (jj.eq.1) exit
          if (ii.lt.jj) then
            ind=ioffset(ncon,ii,jj)
          else
            ind=ioffset(ncon,jj,ii)
          endif
c          write (iout,*) " ncon",ncon,"i",i," j",j," ii",ii," jj",jj,
c     &     " ind",ind," diss",diss(ind)
c          call flush(iout)
          curr_dist=dabs(diss(ind)+0.0d0)
c          write(iout,'(i10,4i4,f12.4)') ind,ii,jj,list_conf(ii),
c     &      list_conf(jj),curr_dist
          if (curr_dist .gt. amax_dim) amax_dim=curr_dist
          ave_dim=ave_dim+curr_dist**2
        enddo
      enddo   
   10 if (licz(igr) .gt. 1) 
     & ave_dim=sqrt(ave_dim/(licz(igr)*(licz(igr)-1)/2)) 
      write (iout,'(/A,F8.1,A,F8.1)')
     & 'Max. distance in the family:',amax_dim,
     & '; average distance in the family:',ave_dim 
      rmsave(:,igr)=0.0d0
      gdt_ts_ave(:,igr)=0.0d0
      gdt_ha_ave(:,igr)=0.0d0
      tmscore_ave(:,igr)=0.0d0
      qpart=0.0d0
      e1=totfree(nconf(igr,1))
      do i=1,licz(igr)
        icon=nconf(igr,i)
        iconl=list_conf(icon)
        boltz=dexp(-(totfree(icon)-e1))
        do iref=1,refstr
        rmsave(iref,igr)=rmsave(iref,igr)+boltz*rmstb(iref,iconl)
        gdt_ts_ave(iref,igr)=gdt_ts_ave(iref,igr)
     &     +boltz*gdt_ts_tb(iref,iconl)
        gdt_ha_ave(iref,igr)=gdt_ha_ave(iref,igr)
     &     +boltz*gdt_ha_tb(iref,iconl)
        tmscore_ave(iref,igr)=tmscore_ave(iref,igr)
     &     +boltz*tmscore_tb(iref,iconl)
        enddo
        qpart=qpart+boltz
c        write (iout,'(2i5,10f10.5)') i,icon,boltz,rmstb(iref,icon),
c     &    gdt_ts_tb(iref,icon),gdt_ha_tb(iref,icon),
c     &    tmscore_tb(iref,icon)
      enddo
c      write (iout,*) "qpart",qpart
      do iref=1,refstr
        rmsave(iref,igr)=rmsave(iref,igr)/qpart
        gdt_ts_ave(iref,igr)=gdt_ts_ave(iref,igr)/qpart
        gdt_ha_ave(iref,igr)=gdt_ha_ave(iref,igr)/qpart
        tmscore_ave(iref,igr)=tmscore_ave(iref,igr)/qpart
      enddo
      write (iout,'(a,$)') "Cluster averages: RMSD"
      do iref=1,refstr
        write (iout,'(f7.2,a,$)') rmsave(iref,igr)," A"
      enddo
      write (iout,'(a,$)') ", TMscore"
      do iref=1,refstr
        write (iout,'(f7.4,$)') tmscore_ave(iref,igr)
      enddo
      write (iout,'(a,$)') ", GDT_TS"
      do iref=1,refstr
        write (iout,'(f7.4,$)') gdt_ts_ave(iref,igr)
      enddo
      write (iout,'(a,$)') ", GDT_HA"
      do iref=1,refstr
        write (iout,'(f7.4,$)') gdt_ha_ave(iref,igr)
      enddo
      write (iout,*)
   19 CONTINUE
      WRITE (iout,400)
      WRITE (iout,500) (list_conf(I),IASS(I),I=1,NCON)
c      print *,icut,printang(icut)
      IF (PRINTANG(ICUT) .and. (lprint_cart .or. lprint_int)) then
        emin=totfree_gr(1)
c        print *,'emin',emin,' ngr',ngr
        if (lprint_cart) then
          cfname=prefixp(:ilen(prefixp))//"_T"//ctemper(:ilen(ctemper))
     &      //"K"//".x"
        else
          cfname=prefixp(:ilen(prefixp))//"_T"//ctemper(:ilen(ctemper))
     &      //"K"//".int"
        endif
        do igr=1,ngr
          icon=nconf(igr,1)
          if (totfree_gr(igr)-emin.le.ecut) then
            if (lprint_cart) then
              call cartout(igr,icon,totfree(icon)/beta_h(ib),
     &          totfree_gr(igr)/beta_h(ib),
     &          rmstb(1,icon),cfname)
            else 
c              print '(a)','calling briefout'
              do i=1,2*nres
                do j=1,3
                  c(j,i)=allcart(j,i,icon)
                enddo
              enddo
              call int_from_cart1(.false.)
c              print *,"igr",igr," icon",icon," nss",nss_all(icon)
              if (dyn_ss) then
              call briefout(igr,iscore(icon),totfree(icon)/beta_h(ib),
     &          totfree_gr(igr),nss_all(icon),iss(ihpb_all(1,icon)),
     &          iss(jhpb_all(1,icon)),cfname)
              else
              call briefout(igr,iscore(icon),totfree(icon)/beta_h(ib),
     &          totfree_gr(igr),nss_all(icon),ihpb_all(1,icon)-nres,
     &          jhpb_all(1,icon)-nres,cfname)
c              print '(a)','exit briefout'
              endif
            endif
          endif
        enddo
        close(igeom)
      ENDIF
      IF (PRINTPDB(ICUT).gt.0) THEN
c Write out a number of conformations from each family in PDB format and
c create InsightII command file for their displaying in different colors
        cfname=prefixp(:ilen(prefixp))//"_T"//ctemper(:ilen(ctemper))
     &    //"K_"//'ave'//exten
c        write (iout,*) "cfname",cfname
        OPEN(ipdb,FILE=CFNAME,STATUS='UNKNOWN',FORM='FORMATTED')
        write (ipdb,'(a,f8.2)') 
     &    "REMARK AVERAGE CONFORMATIONS AT TEMPERATURE",temper
        close (ipdb)
        I=1
        ICON=NCONF(1,1)
        EMIN=totfree_gr(I)
        emin1=totfree(icon)
        DO WHILE(I.LE.NGR .AND. totfree_gr(i)-EMIN.LE.ECUT)
c          write (iout,*) "i",i," ngr",ngr,totfree_gr(I),EMIN,ecut
          write (NUMM,'(bz,i4.4)') i
          ncon_lim=min0(licz(i),printpdb(icut))
          cfname=prefixp(:ilen(prefixp))//"_T"//ctemper(:ilen(ctemper))
     &      //"K_"//numm(:ilen(numm))//exten
          OPEN(ipdb,FILE=CFNAME,STATUS='UNKNOWN',FORM='FORMATTED')
          if (refstr.gt.0) then
          write (ipdb,'("REMARK CLUSTER",i5," FREE ENERGY",1pe14.5,
     &     " AVE RMSD",10(0pf5.2))')
     &     i,totfree_gr(i)/beta_h(ib),rmsave(:refstr,i)
          else
          write (ipdb,'("REMARK CLUSTER",i5," FREE ENERGY",1pe14.5)')
     &     i,totfree_gr(i)/beta_h(ib)
          endif
c Write conformations of the family i to PDB files
          ncon_out=1
          do while (ncon_out.lt.printpdb(icut) .and.
     &     ncon_out.lt.licz(i).and.
     &     totfree(nconf(i,ncon_out+1))-EMIN1.LE.ECUT)
            ncon_out=ncon_out+1
c            write (iout,*) i,ncon_out,nconf(i,ncon_out),
c     &        totfree(nconf(i,ncon_out)),emin1,ecut
          enddo
c          write (iout,*) "ncon_out",ncon_out
c          call flush(iout)
          do j=1,nres
            tempfac(1,j)=5.0d0
            tempfac(2,j)=5.0d0
          enddo
          do j=1,ncon_out
            icon=nconf(i,j)
            do ii=1,2*nres
              do k=1,3
                c(k,ii)=allcart(k,ii,icon)
              enddo
            enddo
            nss=nss_all(icon)
c            write (iout,*) "GROUP",i," ICON",icon," nss",nss
c            write (*,*) "GROUP",i," ICON",icon," nss",nss
            if (dyn_ss) then
            do k=1,nss
              idssb(k)=iss(ihpb_all(k,icon))+nres
              jdssb(k)=iss(jhpb_all(k,icon))+nres
c              write (iout,*) ihpb(k),jhpb(k)
            enddo
            else
            do k=1,nss
              ihpb(k)=ihpb_all(k,icon)
              jhpb(k)=jhpb_all(k,icon)
c              write (iout,*) ihpb(k),jhpb(k)
            enddo
            endif
            call center
            call inbox
            call pdbout(totfree(icon)/beta_h(ib),rmstb(1,icon),titel)
            write (ipdb,'("TER")')
          enddo
          close(ipdb)
c Average structures and structures closest to average
          cfname=prefixp(:ilen(prefixp))//"_T"//ctemper(:ilen(ctemper))
     &    //"K_"//'ave'//exten
          OPEN(ipdb,FILE=CFNAME,STATUS='UNKNOWN',FORM='FORMATTED',
     &     position="APPEND")
          call ave_coord(i)
          write (ipdb,'(a,i5)') "REMARK CLUSTER",i
          call center
          call inbox
          call pdbout(totfree_gr(i)/beta_h(ib),rmsave(1,i),titel)
          write (ipdb,'("TER")')
          if (print_fittest.and.(nsaxs.gt.0 .or. nhpb.gt.0 
     &     .or.npeak.gt.0)) then
            call fittest_coord(i)
          else
            call closest_coord(i)
          endif
          do iref=1,refstr
c            write (iout,*) "Reference structure",iref
            rms_closest(iref,i) = rmsnat(i,iref)
#ifdef DEBUG
c diagnostics
            do k=nstart_sup,nend_sup
              write (iout,'(i5,3f8.3,5x,3f8.3)') k,
     &         (c(l,k),l=1,3),(cref_pdb(l,k,iref),l=1,3)
            enddo
            write (iout,*) "Cluster",i,"rms",rms_closest(iref,i)
c end diagnostics
#endif
            call TMscore_sub(rmsd,gdt_ts_closest(iref,i),
     &      gdt_ha_closest(iref,i),
     &      tmscore_closest(iref,i),cfname,iref,.true.)
c            write (iout,*) "WRTCLUST: nsaxs",nsaxs," i",i
          enddo
#ifdef DEBUG
          write (iout,*) "Before center"
          do k=nstart_sup,nend_sup
            write (iout,'(i5,3f8.3)') k,(c(l,k),l=1,3)
          enddo
#endif
          call center
          call inbox
#ifdef DEBUG
          write (iout,*) "After center"
          do k=nstart_sup,nend_sup
            write (iout,'(i5,3f8.3)') k,(c(l,k),l=1,3)
          enddo
#endif
          call pdbout(totfree_gr(i)/beta_h(ib),rms_closest(1,i),
     &      titel)
          write (ipdb,'("TER")')
          close (ipdb)
          if (nsaxs.gt.0 .and. saxs_mode.eq.0) then
            call e_saxs(Esaxs_constr)
            Cnorm=0.0d0
            do j=1,nsaxs-1
              Cnorm=Cnorm+(distsaxs(j+1)-distsaxs(j))*
     &             (Pcalc(j+1)+Pcalc(j))/2
            enddo
            do j=1,nsaxs
              Pcalc_all(j,i)=Pcalc(j)/Cnorm
            enddo
c            write (iout,*) "Pcalc"
c            write (iout,'(f6.2,f10.5)') (distsaxs(j),Pcalc(j),j=1,nsaxs)
            Esaxs_all(i)=Esaxs_constr
            write (iout,*) "Esaxs",Esaxs_constr
          endif
          nviolxlink=0
          if (link_start.gt.0) then
          do j=link_start,link_end
            if (irestr_type(j).eq.10 .or. irestr_type(j).eq. 11 
     &           .or. irestr_type(j).eq.13 ) then
              dxlink=dist(ihpb(j),jhpb(j))
              if (dxlink.le.25.0d0) then 
              write (iout,'(a,i2,2i5,f8.2)') "XLINK-",
     &          irestr_type(j),ihpb(j),jhpb(j),
     &          dxlink
              else
              nviolxlink=nviolxlink+1
              write (iout,'(a,i2,2i5,f8.2,2h *)') "XLINK-",
     &          irestr_type(j),ihpb(j),jhpb(j),
     &          dxlink
              endif
            endif
          enddo
          if (nviolxlink.gt.0) 
     &      write (iout,*) nviolxlink," crosslink violations."
c          write (iout,*) "Family",i," rmsd",rmsd,"gdt_ts",
c     &      gdt_ts_closest(i)," gdt_ha",gdt_ha_closest(i),
c     &      "tmscore",tmscore_closest(i)
          endif
c Determine # violated NMR restraints
          if (link_end_peak.gt.0) then

          nviolpeak=0
          nviolpeak_gross=0
          write (NUMM,'(bz,i4.4)') i
          cfname=prefixp(:ilen(prefixp))//"_T"//ctemper(:ilen(ctemper))
     &    //"K_"//NUMM(:ilen(NUMM))//'.nmr'
          open(jrms,file=cfname)
          call int_from_cart1(.false.)
          call vec_and_deriv
          call nmr_hpos(.false.)
          do j=1,npeak
            viol_nmr=.true.
            viol_nmr_gross=.true.
            do ip=ipeak(1,j),ipeak(2,j)
              ii=ihpb_peak(1,ip)
              iti=ihpb_peak(2,ip)
              jj=jhpb_peak(1,ip)
              itj=jhpb_peak(2,ip)
              call hdist(ii,iti,jj,itj,dd,rvec)
              iresi=ii-nnt+1
              iresj=jj-nnt+1
              if (iti.eq.0) then
                iresi=iresi+1
                resi=restyp(itype(ii+1))
              else
                resi=restyp(itype(ii))
              endif
              if (itj.eq.0) then
                iresj=iresj+1
                resj=restyp(itype(jj+1))
              else
                resj=restyp(itype(jj))
              endif
              if (dd.le.dhpb1_peak(ip)) then
                iviol=0
              else if (dd.le.dhpb1_peak(ip)+2.0d0) then
                iviol=1
              else
                iviol=2
              endif
              write (jrms,'(2(a3,i5,1x),i5,2f8.2,2a6,2x,a1)')
     &         resi,iresi,resj,iresj,num_peak(j),dd,dhpb1_peak(ip),
     &         proton1(ip),proton2(ip),restr_viol(iviol)
              if (dd.le.dhpb1_peak(ip)) then
                viol_nmr=.false.
                viol_nmr_gross=.false.
              else if (dd.le.dhpb1_peak(ip)+2.0d0) then
                viol_nmr_gross=.false.
              endif
            enddo
            write (jrms,*) 
            if (viol_nmr) then
              nviolpeak=nviolpeak+1
              list_peak_viol(nviolpeak)=j
            endif
            if (viol_nmr_gross) then
              nviolpeak_gross=nviolpeak_gross+1
            endif
          enddo
          if (nviolpeak.gt.0) then
           write (iout,'(a,i5,2h (f6.2,2h%))')
     &      "Number of violated NMR restraints:",
     &      nviolpeak,100*(nviolpeak+0.)/npeak
            write (iout,'(a,i5,2h (f6.2,2h%))')
     &    "Number of grossly violated NMR restraints (upper_limit+2A):",
     &      nviolpeak_gross,100*(nviolpeak_gross+0.)/npeak
            write (iout,'(a)')"List of violated restraints:"
            write (iout,'(16i5)') (list_peak_viol(j),j=1,nviolpeak)
          endif
          close(jrms)

          nviolpeak=0
          nviolpeak_gross=0
          write (NUMM,'(bz,i4.4)') i
          cfname=prefixp(:ilen(prefixp))//"_T"//ctemper(:ilen(ctemper))
     &    //"K_"//NUMM(:ilen(NUMM))//'.nmrave'
          open(jrms,file=cfname)
          call ave_restr(i)
          itot=0
          do j=1,npeak
            viol_nmr=.true.
            viol_nmr_gross=.true.
            do ip=ipeak(1,j),ipeak(2,j)
              itot=itot+1
              dd = dnmr_xave0(itot)
              ii=ihpb_peak(1,ip)
              iti=ihpb_peak(2,ip)
              jj=jhpb_peak(1,ip)
              itj=jhpb_peak(2,ip)
              iresi=ii-nnt+1
              iresj=jj-nnt+1
              if (iti.eq.0) then
                iresi=iresi+1
                resi=restyp(itype(ii+1))
              else
                resi=restyp(itype(ii))
              endif
              if (itj.eq.0) then
                iresj=iresj+1
                resj=restyp(itype(jj+1))
              else
                resj=restyp(itype(jj))
              endif
              if (dd.le.dhpb1_peak(ip)) then
                iviol=0
              else if (dd.le.dhpb1_peak(ip)+2.0d0) then
                iviol=1
              else
                iviol=2
              endif
              write (jrms,'(2(a3,i5,1x),i5,2f8.2,2a6,2x,a1)')
     &         resi,iresi,resj,iresj,num_peak(j),dd,dhpb1_peak(ip),
     &         proton1(ip),proton2(ip),restr_viol(iviol)
              if (dd.le.dhpb1_peak(ip)) then
                viol_nmr=.false.
                viol_nmr_gross=.false.
              else if (dd.le.dhpb1_peak(ip)+2.0d0) then
                viol_nmr_gross=.false.
              endif
            enddo
            write (jrms,*) 
            if (viol_nmr) then
              nviolpeak=nviolpeak+1
              list_peak_viol(nviolpeak)=j
            endif
            if (viol_nmr_gross) then
              nviolpeak_gross=nviolpeak_gross+1
            endif
          enddo
          if (nviolpeak.gt.0) then
           write (iout,'(a,i5,2h (f6.2,2h%))')
     &      "Number of violated NMR cluster-averaged restraints:",
     &      nviolpeak,100*(nviolpeak+0.)/npeak
            write (iout,'(2a,i5,2h (f6.2,2h%))')
     &       "Number of cluster-averaged grossly violated",
     &       " NMR restraints (upper_limit+2A):",
     &      nviolpeak_gross,100*(nviolpeak_gross+0.)/npeak
            write (iout,'(a)')
     &     "List of cluster-averaged violated restraints:"
            write (iout,'(16i5)') (list_peak_viol(j),j=1,nviolpeak)
          endif
          close(jrms)

          endif
          if (.not.raw_psipred .and. idihconstr_end.gt.0) then
            cfname=prefixp(:ilen(prefixp))//"_T"
     &      //ctemper(:ilen(ctemper))
     &      //"K_"//NUMM(:ilen(NUMM))//'.angle'
          open(jrms,file=cfname)
            call int_from_cart1(.false.)
            nangviol=0
            do j=idihconstr_start,idihconstr_end
              itori=idih_constr(j)
              phii=phi(itori)
              difi=pinorm(phii-phi0(j))
              if (difi.gt.drange(j) .or. difi.lt.-drange(j)) 
     &          nangviol=nangviol+1
              write (jrms,'(i5,3f10.3)') itori,phii*rad2deg,
     &          phi0(j)*rad2deg,rad2deg*drange(j)
            enddo
            write (iout,'(a,i5)')"Number of angle-restraint violations:"
     &           ,nangviol
            close(jrms)
          endif
          I=I+1
          ICON=NCONF(I,1)
          emin1=totfree(icon)
        ENDDO
        Cnorm=0.0d0
        do j=1,nsaxs-1
          Cnorm=Cnorm+(distsaxs(j+1)-distsaxs(j))*
     &         (Psaxs(j+1)+Psaxs(j))/2
        enddo
        ngr_print=i-1
        if (nsaxs.gt.0 .and. saxs_mode.eq.0) then
          cfname=prefixp(:ilen(prefixp))//"_T"//ctemper(:ilen(ctemper))
     &    //"K_"//'ave'//'.dist'
          OPEN(99,FILE=CFNAME,STATUS='UNKNOWN',FORM='FORMATTED')
          write (99,'(21h#distance        exp.,10f12.5)') 
     &      (Esaxs_all(i)*wsaxs,i=1,ngr_print)
          do j=1,nsaxs
            write (99,'(f9.4,20e12.4)') distsaxs(j),Psaxs(j)/Cnorm,
     &        (Pcalc_all(j,i),i=1,ngr_print)
          enddo
          close(99)
        endif
      ENDIF 
      IF (printmol2(icut).gt.0) THEN
c Write out a number of conformations from each family in PDB format and
c create InsightII command file for their displaying in different colors
        I=1
        ICON=NCONF(1,1)
        EMIN=ENERGY(0,ICON)
        emin1=emin
        DO WHILE(I.LE.NGR .AND. totfree_gr(i)-EMIN.LE.ECUT)
          write (NUMM,'(bz,i4.4)') i
          cfname=prefixp(:ilen(prefixp))//"_T"//ctemper(:ilen(ctemper))
     &      //"K_"//numm(:ilen(numm))//extmol
          OPEN(imol2,FILE=CFNAME,STATUS='UNKNOWN',FORM='FORMATTED')
          ncon_out=1
          do while (ncon_out.lt.printmol2(icut) .and.
     &     ncon_out.lt.licz(i).and.
     &     totfree(nconf(i,ncon_out+1))-EMIN1.LE.ECUT)
            ncon_out=ncon_out+1
          enddo
          do j=1,ncon_out
            icon=nconf(i,j)
            do ii=1,2*nres
              do k=1,3
                c(k,ii)=allcart(k,ii,icon)
              enddo
            enddo
            CALL MOL2OUT(totfree(icon)/beta_h(ib),'STRUCTURE'//numm)
          enddo
          CLOSE(imol2)
          I=I+1
          ICON=NCONF(I,1)
          emin1=totfree(icon)
        ENDDO
      ENDIF 
      call WRITE_STATS(ICUT,NCON,IB)
c
  100 FORMAT (//'THERE ARE ',I4,' FAMILIES OF CONFORMATIONS')
  200 FORMAT (/'FAMILY ',I4,' WITH TOTAL FREE ENERGY',1pE15.5,
     & ' CONTAINS ',I5,' CONFORMATION(S): ')
c 300 FORMAT ( 8(I4,F6.1))
  300 FORMAT (5(I6,1pe11.2))
  400 FORMAT (//'ASSIGNMENT OF CONSECUTIVE CONFORMATIONS TO FAMILIES:')
  500 FORMAT (8(I5,I4,2X)) 
  600 FORMAT ('REMARK FAMILY',I4,' CONFORMATION',I5,' ENERGY ',E15.6)
      RETURN
      END
c------------------------------------------------------------------------------
      subroutine ave_coord(igr)
      implicit none
      include 'DIMENSIONS'
      include 'sizesclu.dat'
      include 'COMMON.CONTROL'
      include 'COMMON.CLUSTER'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.VAR'
      include 'COMMON.TEMPFAC'
      include 'COMMON.IOUNITS'
      include 'COMMON.SBRIDGE'
      double precision przes(3),obrot(3,3)
      double precision xx(3,maxres2),csq(3,maxres2)
      double precision eref
      double precision rmscalc
c      double precision rmscheck
      integer i,ii,j,k,icon,jcon,igr,ipermmin
      double precision rms,boltz,qpart,cwork(3,maxres2),cref1(3,maxres2)
c      write (iout,*) "AVE_COORD: igr",igr
      jcon=nconf(igr,1)
      eref=totfree(jcon)
      boltz = dexp(-totfree(jcon)+eref)
      qpart=boltz
      do i=1,2*nres
        do j=1,3
          c(j,i)=allcart(j,i,jcon)*boltz
          cref1(j,i)=allcart(j,i,jcon)
          csq(j,i)=allcart(j,i,jcon)**2*boltz
        enddo
      enddo
      DO K=2,LICZ(IGR)
        jcon=nconf(igr,k)
c        write (iout,*) "k",k," jcon",jcon
        do i=1,2*nres
          do j=1,3
            cwork(j,i)=allcart(j,i,jcon)
          enddo
        enddo
        rms=rmscalc(cwork(1,1),cref1(1,1),przes,obrot,ipermmin)
c        write (iout,*) "rms",rms," ipermmin",ipermmin
c        do i=1,3
c          write (iout,'(i3,f10.5,5x,3f10.5)')i,przes(i),
c     &      (obrot(i,j),j=1,3)
c        enddo
c        if (rms.lt.0.0) then
c          print *,'error, rms^2 = ',rms,icon,jcon
c          stop
c        endif
        boltz=dexp(-totfree(jcon)+eref)
        qpart = qpart + boltz
        do i=1,2*nres
          do j=1,3
            xx(j,i)=allcart(j,i,jcon)
          enddo
        enddo
        call matvec(cwork,obrot,xx,2*nres)
        do i=1,2*nres
c          write (iout,'(i5,2(3f10.5,5x))') i,(cwork(j,i),j=1,3),
c     &    (allcart(j,i,jcon),j=1,3)
          do j=1,3
            cwork(j,i)=cwork(j,i)+przes(j)
            c(j,i)=c(j,i)+cwork(j,i)*boltz
            csq(j,i)=csq(j,i)+cwork(j,i)**2*boltz 
          enddo
        enddo
        nss=0
c rms check
c        rmscheck=0.0d0
c        do i=nnt,nct
c          do j=1,3
c            rmscheck=rmscheck+(cwork(j,i)-cref1(j,i))**2
c          enddo  
c        enddo
c        write (iout,*) "rmscheck",dsqrt(rmscheck/(nct-nnt+1)),rms
      ENDDO ! K
      do i=1,2*nres
        do j=1,3
          c(j,i)=c(j,i)/qpart
          csq(j,i)=csq(j,i)/qpart-c(j,i)**2
        enddo
c        write (iout,'(i5,3f10.5)') i,(csq(j,i),j=1,3)
      enddo
      do i=nnt,nct
        tempfac(1,i)=0.0d0
        tempfac(2,i)=0.0d0
        do j=1,3
          tempfac(1,i)=tempfac(1,i)+csq(j,i)
          tempfac(2,i)=tempfac(2,i)+csq(j,i+nres)
        enddo
        tempfac(1,i)=dsqrt(tempfac(1,i))
        tempfac(2,i)=dsqrt(tempfac(2,i))
      enddo
      return
      end
c------------------------------------------------------------------------------
      subroutine fittest_coord(igr)
      implicit none
      include 'DIMENSIONS'
      include 'sizesclu.dat'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      include 'COMMON.CLUSTER'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.VAR'
      include 'COMMON.FFIELD'
      include 'COMMON.TORCNSTR'
      include 'COMMON.SAXS'
      include 'COMMON.SBRIDGE'
      double precision przes(3),obrot(3,3)
      double precision xx(3,maxres2),yy(3,maxres2)
      integer i,ii,j,k,icon,jcon,jconmin,igr
      double precision rms,rmsmin,cwork(3,maxres2)
      double precision ehpb,Esaxs_constr,edihcnstr
c      double precision energia(0:max_ene),escloc
      rmsmin=1.0d10
      jconmin=nconf(igr,1)
      DO K=1,LICZ(IGR)
      jcon=nconf(igr,k)
      do i=1,2*nres
        do j=1,3
          c(j,i)=allcart(j,i,jcon)
        enddo
      enddo
      call int_from_cart1(.false.)
c      call etotal(energia(0))
      call vec_and_deriv
c      write (iout,*) energia(1)+energia(21),energia(2),energia(15)
      esaxs_constr=0
      ehpb=0
      edihcnstr=0
      if (nsaxs.gt.0) call e_saxs(Esaxs_constr)
      call edis(ehpb)
      if (ndih_constr.gt.0)  call etor_constr(edihcnstr)
      rms=wsaxs*esaxs_constr+wstrain*ehpb
      if (constr_dist.eq.12) rms=rms+edihcnstr
c      write (iout,*) "k",k," jcon",list_conf(jcon),
c     & "Esaxs_constr",esaxs_constr,
c     & " Ehpb",ehpb," Edihcnstr",edihcnstr," rms",rms
      if (rms.lt.rmsmin) then
        jconmin=nconf(igr,k)
        rmsmin=rms
      endif
      ENDDO ! K
      write (iout,'(/a,i5,a,i5,a,f10.5)') 
     &  "Family",igr," fittest conformation",list_conf(jconmin),
     &  " penalty",rmsmin
      do i=1,2*nres
        do j=1,3
          c(j,i)=allcart(j,i,jconmin)
        enddo
      enddo
      nss=nss_all(jconmin)
      if (dyn_ss) then
      do k=1,nss
        idssb(k)=iss(ihpb_all(k,jconmin))+nres
        jdssb(k)=iss(jhpb_all(k,jconmin))+nres
      enddo
      else
      do k=1,nss
        ihpb(k)=ihpb_all(k,jconmin)
        jhpb(k)=jhpb_all(k,jconmin)
      enddo
      endif
      return
      end
c------------------------------------------------------------------------------
      subroutine closest_coord(igr)
      implicit none
      include 'DIMENSIONS'
      include 'sizesclu.dat'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      include 'COMMON.CLUSTER'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.VAR'
      include 'COMMON.SBRIDGE'
      double precision przes(3),obrot(3,3)
      integer i,ii,j,k,icon,jcon,jconmin,igr,ipermmin
      double precision rms,rmsmin,cwork(3,maxres2)
      double precision xx(3,maxres2),yy(3,maxres2)
      double precision rmscalc
      rmsmin=1.0d10
      jconmin=nconf(igr,1)
c      write (iout,*) "CLOSEST_CONF: IGR",igr," LICZ",licz(igr)
c      write (iout,*) "CLOSEST_COORD: Average coords"
c      call cartprint
      DO K=1,LICZ(IGR)
        jcon=nconf(igr,k)
        do i=1,2*nres
          do j=1,3
            xx(j,i)=c(j,i)
            yy(j,i)=allcart(j,i,jcon)
          enddo
        enddo
        rms=rmscalc(xx(1,1),yy(1,1),przes,obrot,ipermmin)
c        write (iout,*) "jcon",jcon," rms",rms," rmsmin",rmsmin
        if (rms.lt.rmsmin) then
          rmsmin=rms
          jconmin=jcon
        endif
      ENDDO ! K
c      write (iout,*) "rmsmin",rmsmin," rms",rms
c      call flush(iout)
      do i=1,2*nres
        do j=1,3
          c(j,i)=allcart(j,i,jconmin)
        enddo
      enddo
      nss=nss_all(jconmin)
      if (dyn_ss) then
      do k=1,nss
        idssb(k)=iss(ihpb_all(k,jconmin))+nres
        jdssb(k)=iss(jhpb_all(k,jconmin))+nres
c        write (iout,*) "k",k," ihpb",ihpb(k)," jhpb",jhpb(k)
      enddo
      else
      do k=1,nss
        ihpb(k)=ihpb_all(k,jconmin)
        jhpb(k)=jhpb_all(k,jconmin)
c        write (iout,*) "k",k," ihpb",ihpb(k)," jhpb",jhpb(k)
      enddo
      endif
      return
      end
c------------------------------------------------------------------------------
      subroutine center
      implicit none
      include 'DIMENSIONS'
      include 'sizesclu.dat'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      include 'COMMON.CLUSTER'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.VAR'
      double precision przes(3)
      integer i,ii,j,k,icon,jcon,jconmin,igr
      przes=0.0d0
      do j=1,3
        ii=0
        do i=1,nres
          if (itype(i).eq.ntyp1) cycle
          ii=ii+1
          przes(j)=przes(j)+c(j,i)
        enddo
      enddo
      do j=1,3
c        przes(j)=przes(j)/nres
        przes(j)=przes(j)/ii
      enddo
      do i=1,2*nres
        do j=1,3
          c(j,i)=c(j,i)-przes(j)  
        enddo
        c(1,i)=c(1,i)+boxxsize/2
        c(2,i)=c(2,i)+boxysize/2
        c(3,i)=c(3,i)+boxysize/2
      enddo
      return
      end
c------------------------------------------------------------------------------
      subroutine ave_restr(igr)
      implicit none
      include 'DIMENSIONS'
      include 'sizesclu.dat'
      include 'COMMON.CONTROL'
      include 'COMMON.CLUSTER'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.VAR'
      include 'COMMON.TEMPFAC'
      include 'COMMON.IOUNITS'
      include 'COMMON.SBRIDGE'
      include 'COMMON.NMR'
      integer igr
      integer i,ii,j,jj,iti,itj,k,jcon,itot,ip
      double precision boltz,qpart,eref,dd,rvec(3),onesix
c      write (iout,*) "AVE_RESTR: igr",igr
      onesix=-1.0d0/6.0d0
      jcon=nconf(igr,1)
      eref=totfree(jcon)
      qpart=0.0d0
      dnmr_xave0=0.0d0
      DO K=1,LICZ(IGR)
        jcon=nconf(igr,k)
        do i=1,2*nres
          do j=1,3
            c(j,i)=allcart(j,i,jcon)
          enddo
        enddo
        boltz=dexp(-totfree(jcon)+eref)
        qpart = qpart + boltz
        call int_from_cart1(.false.)
        call vec_and_deriv
        call nmr_hpos(.false.)
        itot=0
        do j=1,npeak
          do ip=ipeak(1,j),ipeak(2,j)
            itot=itot+1
            ii=ihpb_peak(1,ip)
            iti=ihpb_peak(2,ip)
            jj=jhpb_peak(1,ip)
            itj=jhpb_peak(2,ip)
            call hdist(ii,iti,jj,itj,dd,rvec)
            dnmr_xave0(itot)=dnmr_xave0(itot)+1.0d0/dd**6*boltz
          enddo
        enddo
      enddo
      itot=0
      do j=1,npeak
        do ip=ipeak(1,j),ipeak(2,j)
          itot=itot+1
          dnmr_xave0(itot)=(dnmr_xave0(itot)/qpart)**onesix
        enddo
      enddo
      return
      end
