#ifdef MPI
      subroutine work_partition(lprint,ncon_work)
c Split the conformations between processors
      implicit none
      include "DIMENSIONS"
      include "sizesclu.dat"
      include "mpif.h"
      include "COMMON.IOUNITS"
      include "COMMON.CLUSTER"
      include "COMMON.MPI"
      integer n,chunk,i,j,ii,remainder
      integer kolor,key,ierror,errcode,ncon_work
      logical lprint 
C
C Divide conformations between processors; the first and
C the last conformation to handle by ith processor is stored in 
C indstart(i) and indend(i), respectively.
C
C First try to assign equal number of conformations to each processor.
C
        n=ncon_work
        write (iout,*) "n=",n," nprocs=",nprocs
        indstart(0)=1
        chunk = N/nprocs
        scount(0) = chunk
c        print *,"i",0," indstart",indstart(0)," scount",
c     &     scount(0)
        do i=1,nprocs-1
          indstart(i)=chunk+indstart(i-1) 
          scount(i)=scount(i-1)
c          print *,"i",i," indstart",indstart(i)," scount",
c     &     scount(i)
        enddo 
C
C Determine how many conformations remained yet unassigned.
C
        remainder=N-(indstart(nprocs-1)
     &    +scount(nprocs-1)-1)
c        print *,"remainder",remainder
C
C Assign the remainder conformations to consecutive processors, starting
C from the lowest rank; this continues until the list is exhausted.
C
        if (remainder .gt. 0) then 
          do i=1,remainder
            scount(i-1) = scount(i-1) + 1
            indstart(i) = indstart(i) + i
          enddo
          do i=remainder+1,nprocs-1
            indstart(i) = indstart(i) + remainder
          enddo
        endif

        indstart(nprocs)=N+1
        scount(nprocs)=0

        do i=0,NProcs
          indend(i)=indstart(i)+scount(i)-1
          idispl(i)=indstart(i)-1
        enddo

        N=0
        do i=0,Nprocs-1
          N=N+indend(i)-indstart(i)+1
        enddo

c        print *,"N",n," NCON_WORK",ncon_work
        if (N.ne.ncon_work) then
          write (iout,*) "!!! Checksum error on processor",me,
     &      n,ncon_work
          call flush(iout)
          call MPI_Abort( MPI_COMM_WORLD, Ierror, Errcode )
        endif

      if (lprint) then
        write (iout,*) "Partition of work between processors"
          do i=0,nprocs-1
            write (iout,'(a,i5,a,i7,a,i7,a,i7)')
     &        "Processor",i," indstart",indstart(i),
     &        " indend",indend(i)," count",scount(i)
         enddo
      endif 
c      write(iout,*) "just before leave"
      return
      end
#endif
