C $Date: 1994/10/05 16:41:52 $
C $Revision: 2.2 $
C
C
C
      subroutine set_timers
c
      double precision tcpu    ! function
      include 'COMMON.TIME1'
C Diminish the assigned time limit a little so that there is some time to
C end a batch job
c     timlim=batime-150.0
C Calculate the initial time, if it is not zero (e.g. for the SUN).
      stime=tcpu()
      return 
      end
      logical function stopx(nf)
C
C     ..................................................................
C
C     *****PURPOSE...
C     THIS FUNCTION MAY SERVE AS THE STOPX (ASYNCHRONOUS INTERRUPTION)
C     FUNCTION FOR THE NL2SOL (NONLINEAR LEAST-SQUARES) PACKAGE AT
C     THOSE INSTALLATIONS WHICH DO NOT WISH TO IMPLEMENT A
C     DYNAMIC STOPX.
C
C     *****ALGORITHM NOTES...
C     AT INSTALLATIONS WHERE THE NL2SOL SYSTEM IS USED
C     INTERACTIVELY, THIS DUMMY STOPX SHOULD BE REPLACED BY A
C     FUNCTION THAT RETURNS .TRUE. IF AND ONLY IF THE INTERRUPT
C     (BREAK) KEY HAS BEEN PRESSED SINCE THE LAST CALL ON STOPX.
C
C     $$$ MODIFIED FOR USE AS  THE TIMER ROUTINE.
C     $$$                              WHEN THE TIME LIMIT HAS BEEN
C     $$$ REACHED     STOPX IS SET TO .TRUE  AND INITIATES (IN ITSUM)
C     $$$ AND ORDERLY EXIT OUT OF SUMSL.  IF ARRAYS IV AND V ARE
C     $$$ SAVED, THE SUMSL ROUTINES CAN BE RESTARTED AT THE SAME
C     $$$ POINT AT WHICH THEY WERE INTERRUPTED.
C
C     ..................................................................
C
      include 'DIMENSIONS'
      integer nf
      logical ovrtim
      include 'COMMON.IOUNITS'
      include 'COMMON.TIME1'
#ifdef MPL
      include 'COMMON.INFO'
      integer Kwita

cd    print *,'Processor',MyID,' NF=',nf
#endif
      if (ovrtim()) then
C Finish if time is up.
         stopx = .true.
#ifdef MPL
      else if (mod(nf,100).eq.0) then
C Other processors might have finished. Check this every 100th function 
C evaluation.
cd       print *,'Processor ',MyID,' is checking STOP: nf=',nf
         call recv_stop_sig(Kwita)
         if (Kwita.eq.-1) then
           write (iout,'(a,i4,a,i5)') 'Processor',
     &     MyID,' has received STOP signal in STOPX; NF=',nf
           write (*,'(a,i4,a,i5)') 'Processor',
     &     MyID,' has received STOP signal in STOPX; NF=',nf
           stopx=.true.
         else
           stopx=.false.
         endif
#endif
      else
         stopx = .false.
      endif
      return
      end
C=========================================================================
C
      logical function ovrtim()
      double precision tcpu    ! function 
      include 'COMMON.TIME1'
C Set a 100.0 secs. safety margin, so as to allow for the termination of 
C a batch job.
c      double  safety /150.0D0/
      curtim= tcpu()
cd    print *,'curtim=',curtim,' timlim=',timlim
C  curtim is the current time in seconds.
      ovrtim=(curtim .ge. timlim - safety )
      return                                               
      end
C=========================================================================
C
      double precision function tcpu()
      include 'COMMON.TIME1'
#ifdef ES9000 
****************************
C Next definition for EAGLE (ibm-es9000)
      real*8 micseconds
      integer rcode
      tcpu=cputime(micseconds,rcode)
      tcpu=(micseconds/1.0E6) - stime
****************************
#endif
#ifdef SUN
****************************
C Next definitions for sun
      integer seconds
      call clock(seconds)
      tcpu=seconds - stime
****************************
#endif
#ifdef KSR
****************************
C Next definitions for ksr
C this function uses the ksr timer ALL_SECONDS from the PMON library to
C return the elapsed time in seconds
      tcpu= all_seconds() - stime
****************************
#endif
#ifdef SGI
****************************
C Next definitions for sgi
      real timar(2), etime
      seconds = etime(timar)
C      usrsec = timar(1)
C      syssec = timar(2)
      tcpu=seconds - stime
****************************
#endif
#ifdef CRAY
****************************
C Next definitions for Cray
C     call date(curdat)
C     curdat=curdat(1:9)
C     call clock(curtim)
C     curtim=curtim(1:8)
      cpusec = second()
      tcpu=cpusec - stime
****************************
#endif
#ifdef AIX
****************************
C Next definitions for RS6000
       integer*4 i1,mclock
       i1 = mclock()
       tcpu = (i1+0.0D0)/100.0D0
#endif
#ifdef LINUX
****************************
C Next definitions for sgi
      real timar(2), etime
      seconds = etime(timar)
Cd    print *,'seconds=',seconds,' stime=',stime
C      usrsec = timar(1)
C      syssec = timar(2)
      tcpu=seconds - stime
****************************
#endif
      return     
      end  
*
      subroutine dajczas(rntime,hrtime,mintime,sectime)
      include 'COMMON.IOUNITS'
      real*8 rntime,hrtime,mintime,sectime 
      hrtime=rntime/3600.0D0 
      hrtime=aint(hrtime)
      mintime=aint((rntime-3600.0D0*hrtime)/60.0D0)
      sectime=aint((rntime-3600.0D0*hrtime-60.0D0*mintime)+0.5D0)
      if (sectime.eq.60.0D0) then
        sectime=0.0D0
        mintime=mintime+1.0D0
      endif
      ihr=hrtime
      imn=mintime
      isc=sectime
      write (iout,328) ihr,imn,isc
  328 FORMAT(//'***** Computation time: ',I4  ,' hours ',I2  ,
     1         ' minutes ', I2  ,' seconds *****')       
      return
      end
