      SUBROUTINE SRTCLUST(ICUT,NCON,IB)
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'sizesclu.dat'
      include 'COMMON.CLUSTER'
      include 'COMMON.FREE'
      include 'COMMON.IOUNITS'
      double precision prob(maxgr)
c
c Compute free energies of clusters
c
      do igr=1,ngr
      emin=totfree(nconf(igr,1))
      totfree_gr(igr)=1.0d0
      do i=2,licz(igr)
        ii=nconf(igr,i)
        totfree_gr(igr)=totfree_gr(igr)+dexp(-totfree(ii)+emin)
      enddo
c      write (iout,*) "igr",igr," totfree",emin,
c     &    " totfree_gr",totfree_gr(igr)
      totfree_gr(igr)=emin-dlog(totfree_gr(igr))
c      write (iout,*) igr," efree",totfree_gr(igr)/beta_h(ib)
      enddo
C
C  SORT CONFORMATIONS IN GROUPS ACC. TO ENERGY
C
      DO 16 IGR=1,NGR
      LIGR=LICZ(IGR)
      DO 17 ICO=1,LIGR-1
      IND1=NCONF(IGR,ICO)
      ENE=totfree(IND1)
      DO 18 JCO=ICO+1,LIGR
      IND2=NCONF(IGR,JCO)
      EN1=totfree(IND2)
      IF (EN1.LT.ENE) THEN
        NCONF(IGR,ICO)=IND2
        NCONF(IGR,JCO)=IND1
        IND1=IND2
        ENE=EN1
      ENDIF
   18 CONTINUE
   17 CONTINUE
   16 CONTINUE
C
C  SORT GROUPS
C
      DO 71 IGR=1,NGR
      ENE=totfree_gr(IGR)
      DO 72 JGR=IGR+1,NGR
      EN1=totfree_gr(JGR)
      IF (EN1.LT.ENE) THEN
        LI1=LICZ(IGR)
        LI2=LICZ(JGR)
        LI=MAX0(LI1,LI2)
        DO 73 I=1,LI   
        NCO=NCONF(IGR,I)
        NCONF(IGR,I)=NCONF(JGR,I)
        NCONF(JGR,I)=NCO
   73   CONTINUE
        totfree_gr(igr)=en1
        totfree_gr(jgr)=ene
        ENE=EN1
        LICZ(IGR)=LI2
        LICZ(JGR)=LI1
      ENDIF
   72 CONTINUE
   71 CONTINUE
      DO 81 IGR=1,NGR
      LI=LICZ(IGR)
      DO 82 I=1,LI 
   82 IASS(NCONF(IGR,I))=IGR
   81 CONTINUE
      if (lgrp) then
        do i=1,ncon
          iass_tot(i,icut)=iass(i)
c          write (iout,*) icut,i,iass(i),iass_tot(i,icut)
        enddo
      endif
      return
      end
c----------------------------------------------------------------------
      SUBROUTINE WRITE_STATS(ICUT,NCON,IB)
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'sizesclu.dat'
      include 'COMMON.CLUSTER'
      include 'COMMON.FREE'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      double precision prob(maxgr)
      prob(1)=1.0d0
      sumprob=1.0d0
      do i=2,ngr
        prob(i)=dexp(-(totfree_gr(i)-totfree_gr(1)))
        sumprob=sumprob+prob(i)
      enddo
      do i=1,ngr
        prob(i)=prob(i)/sumprob
      enddo
      write (iout,*) 
      if (refstr.gt.0) then
        write (iout,
     & '("Free energies, probabilities and rmsds of clusters at",
     &   f6.1," K")') 1.0d0/(1.987d-3*beta_h(ib))
        write(iout,'(/7x,4a20)') " RMSD","TMscore","GDT_TS","GDT_HA"
        write(iout,'(a5,2x,a6,10a10)')"clust","efree","cl.ave.",
     &   "ave.str.",
     &   "cl.ave.","ave.str","cl.ave","ave.str.","cl.ave","ave.str.",
     &   "prob","sumprob"
        do iref=1,refstr
        sumprob=0.0d0
        write (iout,*) "Reference structure",iref
        do i=1,ngr
          sumprob=sumprob+prob(i)
          write (iout,'(i3,2x,f8.1,2f10.3,6f10.4,2f10.4)') 
     &    i,totfree_gr(i)/beta_h(ib),
     &    rmsave(iref,i),rms_closest(iref,i),tmscore_ave(iref,i),
     &    tmscore_closest(iref,i),
     &    gdt_ts_ave(iref,i),gdt_ts_closest(iref,i),gdt_ha_ave(iref,i),
     &    gdt_ha_closest(iref,i),prob(i),sumprob
        enddo
        enddo
      else
        write (iout,
     & '("Free energies and probabilities of clusters at",
     &   f6.1," K")') 1.0d0/(1.987d-3*beta_h(ib))
        write(iout,'(a5,2x,a6,3a10)')"clust","efree","prob","sumprob"
        do i=1,ngr
          sumprob=sumprob+prob(i)
          write (iout,'(i3,2x,f8.1,2f10.4)') 
     &    i,totfree_gr(i)/beta_h(ib),prob(i),sumprob
        enddo
      endif
      RETURN
      END
