      subroutine refsys(i2,i3,i4,e1,e2,e3,fail)
c This subroutine calculates unit vectors of a local reference system
c defined by atoms (i2), (i3), and (i4). The x axis is the axis from
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.IOUNITS'
      include "COMMON.CHAIN"
c this subroutine calculates unity vectors of a local reference system
c defined by atoms (i2), (i3), and (i4). the x axis is the axis from
c atom (i3) to atom (i2), and the xy plane is the plane defined by atoms
c (i2), (i3), and (i4). z axis is directed according to the sign of the
c vector product (i3)-(i2) and (i3)-(i4). sets fail to .true. if atoms
c (i2) and (i3) or (i3) and (i4) coincide or atoms (i2), (i3), and (i4)
c form a linear fragment. returns vectors e1, e2, and e3.
      logical fail
      double precision e1(3),e2(3),e3(3)
      double precision u(3),z(3)
      double precision coinc/1.0D-13/,align /1.0D-13/
c      print *,'just initialize'
      fail=.false.
c      print *,fail
      s1=0.0
      s2=0.0
      print *,s1,s2
      do 1 i=1,3
      print *, i2,i3,i4
      zi=c(i,i2)-c(i,i3)
      ui=c(i,i4)-c(i,i3)
      print *,zi,ui
      s1=s1+zi*zi
      s2=s2+ui*ui
      z(i)=zi
    1 u(i)=ui
      s1=sqrt(s1)
      s2=sqrt(s2)
      if (s1.gt.coinc) goto 2
      write (iout,1000) i2,i3,i1
      fail=.true.
      return
    2 if (s2.gt.coinc) goto 4
      write(iout,1000) i3,i4,i1
      fail=.true.
      return
      print *,'two if pass'
    4 s1=1.0/s1
      s2=1.0/s2
      v1=z(2)*u(3)-z(3)*u(2)
      v2=z(3)*u(1)-z(1)*u(3)
      v3=z(1)*u(2)-z(2)*u(1)
      anorm=sqrt(v1*v1+v2*v2+v3*v3)
      if (anorm.gt.align) goto 6
      write (iout,1010) i2,i3,i4,i1
      fail=.true.
      return
    6 anorm=1.0/anorm
      e3(1)=v1*anorm
      e3(2)=v2*anorm
      e3(3)=v3*anorm
      e1(1)=z(1)*s1
      e1(2)=z(2)*s1
      e1(3)=z(3)*s1
      e2(1)=e1(3)*e3(2)-e1(2)*e3(3)
      e2(2)=e1(1)*e3(3)-e1(3)*e3(1)
      e2(3)=e1(2)*e3(1)-e1(1)*e3(2)
 1000 format (/1x,' * * * Error - atoms',i4,' and',i4,' coincide.',
     1 'coordinates of atom',i4,' are set to zero.')
 1010 format (/1x,' * * * Error - atoms',2(i4,2h, ),i4,' form a linear',
     1 ' fragment. coordinates of atom',i4,' are set to zero.')
      return
      end
