      subroutine probabl(ib,nlist,ncon,*)
! construct the conformational ensembles at REMD temperatures
      implicit none
      include "DIMENSIONS"
      include "sizesclu.dat"
#ifdef MPI
      include "mpif.h"
      include "COMMON.MPI"
      integer ierror,errcode,status(MPI_STATUS_SIZE) 
#endif
      include "COMMON.CONTROL"
      include "COMMON.IOUNITS"
      include "COMMON.FREE"
      include "COMMON.FFIELD"
      include "COMMON.INTERACT"
      include "COMMON.SBRIDGE"
      include "COMMON.CHAIN"
      include "COMMON.CLUSTER"
      include "COMMON.NMR"
      real*4 csingle(3,maxres2)
      double precision fT(6),fTprim(6),fTbis(6),quot,quotl1,quotl,kfacl,
     &  eprim,ebis,temper,kfac/2.4d0/,T0/300.0d0/
      double precision etot,evdw,evdw2,ees,evdw1,ebe,etors,escloc,
     &      ehpb,ecorr,ecorr5,ecorr6,eello_turn4,eello_turn3,
     &      eturn6,eel_loc,edihcnstr,etors_d,estr,evdw2_14,esccor,
     &      evdw_t,esaxs,eliptran,ethetacnstr,ehomology_constr,
     &      edfadis,edfator,edfanei,edfabet
      integer i,ii,ik,iproc,iscor,j,k,l,ib,nlist,ncon
      double precision qfree,sumprob,eini,efree,rmsdev
      character*80 bxname
      character*2 licz1
      character*5 ctemper
      integer ilen,ijk
      external ilen
      integer iref
      character*80 structure/'Structure'/
      real*4 Fdimless(maxconf), Fdimless_buf(maxconf)
      double precision energia(0:max_ene), totfree_buf(0:maxconf),
     &  entfac_buf(maxconf)
      double precision buffer(maxref,maxconf)
      integer scount_rms(0:MaxProcs-1),idispl_rms(0:MaxProcs-1)
      double precision rmsnat
      external rmsnat
      do i=1,ncon
        list_conf(i)=i
      enddo
c      do i=1,ncon
c        write (iout,*) i,list_conf(i)
c      enddo
#ifdef DEBUG
      write (iout,*) "Probabl"
#endif
#ifdef MPI
c      write (iout,*) me," indstart",indstart(me)," indend",indend(me)
      call daread_ccoords(indstart(me),indend(me))
#endif
c      write (iout,*) "PROBABL: ncon",ncon
c      call flush(iout)
      temper=1.0d0/(beta_h(ib)*1.987D-3)
      if (rescale_mode.eq.1) then
        quot=1.0d0/(T0*beta_h(ib)*1.987D-3)
        quotl=1.0d0
        kfacl=1.0d0
        do l=1,5
          quotl1=quotl
          quotl=quotl*quot
          kfacl=kfacl*kfac
          fT(l)=kfacl/(kfacl-1.0d0+quotl)
        enddo
#if defined(FUNCTH)
        ft(6)=(320.0d0+80.0d0*dtanh((betaT-320.0d0)/80.0d0))/
     &             320.0d0
        ftprim(6)=1.0d0/(320.0d0*dcosh((betaT-320.0d0)/80.0d0)**2)
        ftbis(6)=-2.0d0*dtanh((betaT-320.0d0)/80.0d0)
     &         /(320.0d0*80.0d0*dcosh((betaT-320.0d0)/80.0d0)**3)
#elif defined(FUNCT)
        fT(6)=betaT/T0
        ftprim(6)=1.0d0/T0
        ftbis(6)=0.0d0
#else
        fT(6)=1.0d0
        ftprim(6)=0.0d0
        ftbis(6)=0.0d0
#endif

      else if (rescale_mode.eq.2) then
        quot=1.0d0/(T0*beta_h(ib)*1.987D-3)
        quotl=1.0d0
        do l=1,5
          quotl=quotl*quot
          fT(l)=1.12692801104297249644d0/
     &       dlog(dexp(quotl)+dexp(-quotl))
        enddo
c          write (iout,*) 1.0d0/(beta_h(ib)*1.987D-3),ft
c          call flush(iout)
#if defined(FUNCTH)
        ft(6)=(320.0d0+80.0d0*dtanh((betaT-320.0d0)/80.0d0))/
     &             320.0d0
        ftprim(6)=1.0d0/(320.0d0*dcosh((betaT-320.0d0)/80.0d0)**2)
        ftbis(6)=-2.0d0*dtanh((betaT-320.0d0)/80.0d0)
     &         /(320.0d0*80.0d0*dcosh((betaT-320.0d0)/80.0d0)**3)
#elif defined(FUNCT)
        fT(6)=betaT/T0
        ftprim(6)=1.0d0/T0
        ftbis(6)=0.0d0
#else
        fT(6)=1.0d0
        ftprim(6)=0.0d0
        ftbis(6)=0.0d0
#endif
      endif

#ifdef MPI
      do i=1,scount(me)
        ii=i+indstart(me)-1
#else
      do i=1,ncon
        ii=i
#endif
c        write (iout,*) "i",i," ii",ii,"ib",ib,scount(me)
c        call flush(iout)
c        if (ib.eq.1) then
        do j=1,nres
          do k=1,3
            c(k,j)=allcart(k,j,i)
            c(k,j+nres)=allcart(k,j+nres,i)
c              write(iout,*) "coord",i,j,k,allcart(k,j,i),c(k,j),
c     &        c(k,j+nres),allcart(k,j+nres,i)
          enddo
        enddo
C          write(iout,*) "out of j loop"
C          call flush(iout)
        do k=1,3
          c(k,nres+1)=c(k,1)
          c(k,nres+nres)=c(k,nres)
        enddo
C          write(iout,*) "after nres+nres",nss_all(i)
C          call flush(iout)
c        write(iout,*) "Conformation",i," ihpb,jhpb before substitution",
c     &   (ihpb(j),jhpb(j),j=1,nhpb)
        nss=nss_all(i)
        if (dyn_ss) then
        do j=1,nss
          idssb(j)=ihpb_all(j,i)
          jdssb(j)=jhpb_all(j,i)
        enddo 
        else
        do j=1,nss
          ihpb(j)=ihpb_all(j,i)
          jhpb(j)=jhpb_all(j,i)
        enddo 
        endif
c        write(iout,*) "Conformation",i," ihpb,jhpb after substitution",
c     &   (ihpb(j),jhpb(j),j=1,nhpb)
#ifdef DEBUG
        write (iout,*) "conformation", i," before etotal"
        if (dyn_ss) then
          write (iout,*) "nss",nss,
     &      " idssb,jdssb",(idssb(k),jdssb(k),k=1,nss)
        endif
#endif
        call int_from_cart1(.false.)
        call etotal(energia(0),fT)
        do iref=1,refstr
          write (structure(9:),'(bz,i6.6)') i
          call TMscore_sub(rmsdev,gdt_ts_tb(iref,i),
     &    gdt_ha_tb(iref,i),tmscore_tb(iref,i),Structure,iref,.false.)
#ifdef DEBUG
          write (iout,*) rmsdev,gdt_ts_tb(iref,i),gdt_ha_tb(iref,i),
     &      tmscore_tb(iref,i)
#endif
          if (recalc_rms) then
c            write (2,*) "original     rms",i,rmstb(iref,i)
            rmstb(iref,i)=rmsnat(i,iref)
c            write (2,*) "recalculated rms",i,rmstb(iref,i)
          endif
        enddo
        if (atimeave.gt.0) then
#ifdef DEBUG
          write (iout,*) "conformation",i,ii," energy",energia(0),
     &    energy(0,ii)," entfac",entfac(ii),
     &    " restraint energy",energia(15),energia(20),energia(24),
     &    " replaced with time-ave restraint energies",energy(1:3,ii)
#endif
          energia(0)=energia(0)+energy(1,ii)-energia(15)
     &      +energy(2,ii)-energia(20)
     &      +energy(3,ii)-energia(24)
          energia(15)=energy(1,ii)
          energia(20)=energy(2,ii)
          energia(24)=energy(3,ii)
        endif
        totfree(i)=energia(0)         
        totfree_buf(i)=totfree(i)
c          write (iout,'(8f10.5)') ((c(l,k),l=1,3),k=1,nres)
c          write (iout,'(8f10.5)') ((c(l,k+nres),l=1,3),k=nnt,nct)
c          call pdbout(totfree(i),16,i)
c          call flush(iout)
#ifdef DEBUG
        write (iout,*) "conformation", i
        if (dyn_ss) then
          write (iout,*) "nss",nss,
     &      " idssb,jdssb",(idssb(k),jdssb(k),k=1,nss)
        endif
c        write (iout,'(8f10.5)') ((c(l,k),l=1,3),k=1,nres),
c     &                            ((c(l,k+nres),l=1,3),k=nnt,nct)
        call enerprint(energia(0),fT)
#endif
        etot=energia(0)
        Fdimless(i)=beta_h(ib)*etot+entfac(ii)
#ifdef DEBUG
        write(iout,*) "beta",beta_h(ib)," etot",etot,
     &    " entfac",entfac(ii)," fdimless",Fdimless(i)
#endif
        Fdimless_buf(i)=Fdimless(i)
        totfree(i)=etot
        totfree_buf(i)=totfree(i)
#ifdef DEBUG
        write (iout,*) "fdim calc", i,ii,ib,
     &   1.0d0/(1.987d-3*beta_h(ib)),totfree(i),
     &   entfac(ii),Fdimless(i)
#endif
      enddo   ! i

      do ijk=1,maxconf
      entfac_buf(ijk)=entfac(ijk)
      Fdimless_buf(ijk)=Fdimless(ijk)
      enddo
      do ijk=0,maxconf
      totfree_buf(ijk)=totfree(ijk)
      enddo


c      scount_buf=scount(me)
c      scount_buf2=scount(0)

c      entfac_buf(indstart(me)+1)=entfac(indstart(me)+1)

#ifdef MPI
#ifdef DEBUG
        write (iout,*) "The FDIMLESS array before gather"
        do i=1,ncon
          write (iout,*) i,fdimless(i)
        enddo
#endif
c      WRITE (iout,*) "Wchodze do call MPI_Gatherv1 (Propabl)"
      call MPI_Gatherv(Fdimless_buf(1),scount(me),
     & MPI_REAL,Fdimless(1),
     & scount(0),idispl(0),MPI_REAL,Master,
     & MPI_COMM_WORLD, IERROR)
c      WRITE (iout,*) "Wchodze do call MPI_Gatherv2 (Propabl)"
      call MPI_Gatherv(totfree_buf(1),scount(me),
     & MPI_DOUBLE_PRECISION,totfree(1),
     & scount(0),idispl(0),MPI_DOUBLE_PRECISION,Master,
     & MPI_COMM_WORLD, IERROR)
c      WRITE (iout,*) "Wchodze do call MPI_Gatherv3 (Propabl)"
      call MPI_Gatherv(entfac_buf(indstart(me)+1),scount(me),
     & MPI_DOUBLE_PRECISION,entfac(1),
     & scount(0),idispl(0),MPI_DOUBLE_PRECISION,Master,
     & MPI_COMM_WORLD, IERROR)
c      WRITE (iout,*) "Wychodze z call MPI_Gatherv (Propabl)"
      if (refstr.gt.0) then
        scount_rms(0)=maxref*scount(0)
        idispl_rms(0)=0
        do i=1,nprocs-1
          scount_rms(i)=maxref*scount(i)
          idispl_rms(i)=idispl_rms(i-1)+scount_rms(i-1)
        enddo
        do i=1,scount(me)
          buffer(:refstr,i)=gdt_ts_tb(:refstr,i)
        enddo
        call MPI_Gatherv(buffer(1,1),scount_rms(me),
     &   MPI_DOUBLE_PRECISION,
     &   gdt_ts_tb(1,1),scount_rms(0),idispl_rms(0),
     &   MPI_DOUBLE_PRECISION,Master,
     &   MPI_COMM_WORLD,IERROR)
        do i=1,scount(me)
          buffer(:refstr,i)=gdt_ha_tb(:refstr,i)
        enddo
        call MPI_Gatherv(buffer(1,1),scount_rms(me),
     &   MPI_DOUBLE_PRECISION,
     &   gdt_ha_tb(1,1),scount_rms(0),idispl_rms(0),
     &   MPI_DOUBLE_PRECISION,Master,
     &   MPI_COMM_WORLD,IERROR)
        do i=1,scount(me)
          buffer(:refstr,i)=tmscore_tb(:refstr,i)
        enddo
        call MPI_Gatherv(buffer(1,1),scount_rms(me),
     &   MPI_DOUBLE_PRECISION,
     &  tmscore_tb(1,1),scount_rms(0),idispl_rms(0),
     &   MPI_DOUBLE_PRECISION,Master,
     &   MPI_COMM_WORLD,IERROR)
        if (recalc_rms) then
          do i=1,scount(me)
            buffer(:refstr,i)=rmstb(:refstr,i)
          enddo
          call MPI_Gatherv(buffer(1,1),scount_rms(me),
     &     MPI_DOUBLE_PRECISION,
     &     rmstb(1,1),scount_rms(0),idispl_rms(0),
     &     MPI_DOUBLE_PRECISION,Master,
     &     MPI_COMM_WORLD,IERROR)
        endif
      endif
      if (me.eq.Master) then
c      WRITE (iout,*) "me.eq.Master"
#endif
#ifdef DEBUG
        write (iout,*) "The FDIMLESS array before sorting"
        do i=1,ncon
          write (iout,*) i,fdimless(i)
        enddo
#endif
c      WRITE (iout,*) "Wchodze do call mysort1"
        call mysort1(ncon,Fdimless,list_conf)
c      WRITE (iout,*) "Wychodze z call mysort1"
#ifdef DEBUG
        write (iout,*) "The FDIMLESS array after sorting"
        do i=1,ncon
          write (iout,'(2i5,30f10.5)') i,list_conf(i),fdimless(i),
     &     (gdt_ts_tb(iref,i),gdt_ha_tb(iref,i),tmscore_tb(iref,i),
     &      rmstb(iref,i),iref=1,refstr)
        enddo
#endif
c      WRITE (iout,*) "Wchodze do petli i=1,ncon totfree(i)=fdimless(i)"
        do i=1,ncon
          totfree(i)=fdimless(i)
        enddo
        qfree=0.0d0
        do i=1,ncon
          qfree=qfree+exp(-fdimless(i)+fdimless(1))
c          write (iout,*) "fdimless", fdimless(i)
        enddo
c        write (iout,*) "qfree",qfree
c        nlist=1
        nlist=0
        sumprob=0.0
        write (iout,*) "ncon", ncon,maxconf
c        do i=1,min0(ncon,maxstr_proc)-1
        do i=1,ncon
          sumprob=sumprob+exp(-fdimless(i)+fdimless(1))/qfree
#ifdef DEBUG
          write (iout,*) i,ib,beta_h(ib),
     &     1.0d0/(1.987d-3*beta_h(ib)),list_conf(i),
     &     totfree(list_conf(i)),
     &     -entfac(list_conf(i)),fdimless(i),sumprob
#endif
          if (sumprob.gt.prob_limit) goto 122
c          if (sumprob.gt.1.00d0) goto 122
          nlist=nlist+1
        enddo
  122   continue
#ifdef MPI
      endif
#ifdef DEBUG
      write (iout,*) "Before MPI_Bcast: nlist",nlist
      do i=1,nlist
        write (iout,*) i,list_conf(i),totfree(i)
      enddo
#endif
      call MPI_Bcast(nlist, 1, MPI_INTEGER, Master, MPI_COMM_WORLD, 
     &   IERROR)
      call MPI_Bcast(list_conf,ncon,MPI_INTEGER,Master,MPI_COMM_WORLD,
     &   IERROR)
      call MPI_Bcast(totfree,ncon+1,MPI_DOUBLE_PRECISION,Master,
     &   MPI_COMM_WORLD,IERROR)
c      do iproc=0,nprocs
c        write (iout,*) "iproc",iproc," indstart",indstart(iproc),
c     &   " indend",indend(iproc) 
c      enddo
#ifdef DEBUG
      write (iout,*) "After MPI_Bcast: nlist",nlist
      do i=1,nlist
        write (iout,*) i,list_conf(i),totfree(i)
      enddo
#endif
#endif
      return
      end
!--------------------------------------------------
      subroutine mysort1(n, x, ipermut)
      implicit none
      integer i,j,imax,ipm,n
      real x(n)
      integer ipermut(n)
      real xtemp
      do i=1,n
        xtemp=x(i)
        imax=i
        do j=i+1,n
          if (x(j).lt.xtemp) then
            imax=j
            xtemp=x(j)
          endif
        enddo
        x(imax)=x(i)
        x(i)=xtemp
        ipm=ipermut(imax)
        ipermut(imax)=ipermut(i)
        ipermut(i)=ipm
      enddo
      return
      end
