      SUBROUTINE out_rmsgdt(NCON,ib)
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'sizesclu.dat'
      include 'COMMON.CONTROL'
      include 'COMMON.HEADER'
      include 'COMMON.CHAIN'
      include 'COMMON.VAR'
      include 'COMMON.CLUSTER'
      include 'COMMON.IOUNITS'
      include 'COMMON.GEO'
      include 'COMMON.FREE'
      include 'COMMON.TEMPFAC'
      include 'COMMON.FFIELD'
      include 'COMMON.SBRIDGE'
      include 'COMMON.NMR'
      include 'COMMON.TORCNSTR'
      include 'COMMON.SAXS'
      include 'COMMON.INTERACT'
      include 'COMMON.NAMES'
      CHARACTER*64 prefixp,NUMM,MUMM,EXTEN,extmol
      character*120 cfname
      character*8 ctemper
      DATA EXTEN /'.pdb'/,extmol /'.mol2'/,NUMM /'000'/,MUMM /'000'/
      external ilen

      do i=1,120
        cfname(i:i)=" "
      enddo
c      print *,"calling WRTCLUST",ncon
c      write (iout,*) "ICUT",icut," PRINTPDB ",PRINTPDB(icut)
      rewind 80
      temper=1.0d0/(beta_h(ib)*1.987d-3)
      if (temper.lt.100.0d0) then
        write(ctemper,'(f3.0)') temper
        ctemper(3:3)=" "
      else if (temper.lt.1000.0) then
        write (ctemper,'(f4.0)') temper
        ctemper(4:4)=" "
      else
        write (ctemper,'(f5.0)') temper
        ctemper(5:5)=" "
      endif
      ii1= index(intinname,'/')
      ii2=ii1
      ii1=ii1+1
      do while (ii2.gt.0) 
        ii1=ii1+ii2
        ii2=index(intinname(ii1:),'/')
      enddo 
      ii = ii1+index(intinname(ii1:),'.')-1
      if (ii.eq.0) then
        ii=ilen(intinname)
      else
        ii=ii-1
      endif
      prefixp=intinname(ii1:ii)
      cfname=prefixp(:ilen(prefixp))//"_T"//ctemper(:ilen(ctemper))
     &    //"K"//'.rmsgdt'
      open(jrms,file=cfname,form='formatted')
      prefixp=intinname(ii1:ii)
      qfree=0.0d0
      do i=1,ncon
        qfree=qfree+dexp(-(totfree(i)-totfree(1)))
      enddo
      write (iout,*) "qfree",qfree
      do i=1,ncon
        ii = list_conf(i)
        write (iout,'(2i6,f12.3,f12.8)') i,list_conf(i),totfree(i),
     &     dexp(-(totfree(i)-totfree(1)))/qfree
        write (jrms,'(i6,f12.8,$)') list_conf(i),
     &      dexp(-(totfree(i)-totfree(1)))/qfree
        do iref=1,refstr
          write (jrms,'(f8.3,$)') rmstb(iref,list_conf(i))
        enddo
        do iref=1,refstr
          write (jrms,'(f8.4,$)') gdt_ts_tb(iref,list_conf(i))
        enddo
        write (jrms,*)
      enddo
      close(jrms) 
      return
      end

