      subroutine make_conf_list(nlist,ncon,lbcast)
! construct the conformational ensembles at REMD temperatures
      implicit none
      include "DIMENSIONS"
      include "sizesclu.dat"
#ifdef MPI
      include "mpif.h"
      include "COMMON.MPI"
      integer ierror,errcode,status(MPI_STATUS_SIZE) 
#endif
      include "COMMON.CONTROL"
      include "COMMON.IOUNITS"
      include "COMMON.FREE"
      include "COMMON.FFIELD"
      include "COMMON.INTERACT"
      include "COMMON.SBRIDGE"
      include "COMMON.CHAIN"
      include "COMMON.CLUSTER"
      include "COMMON.NMR"
      integer i,ii,ik,iproc,iscor,j,k,l,ib,nlist,ncon
      integer ilen,ijk
      external ilen
      logical lbcast
      integer iref
      real*4 Fdimless(maxconf)
      double precision qfree,sumprob
c      print *,"me",me," iout",iout," prob_limit",prob_limit
      do i=1,ncon
        list_conf(i)=i
      enddo
#ifdef MPI
      if (me.eq.Master) then
#endif
        do i=1,ncon
          fdimless(i)=totfree(i)
        enddo
c      WRITE (iout,*) "me.eq.Master"
#ifdef DEBUG
        write (iout,*) "The FDIMLESS array before sorting"
        do i=1,ncon
          write (iout,*) i,fdimless(i)
        enddo
#endif
c      WRITE (iout,*) "Wchodze do call mysort1"
        call mysort1(ncon,Fdimless,list_conf)
        do i=1,ncon
          totfree(i)=fdimless(i)
        enddo
c      WRITE (iout,*) "Wychodze z call mysort1"
#ifdef DEBUG
        write (iout,*) "The FDIMLESS array after sorting"
        do i=1,ncon
          write (iout,'(2i5,30f10.5)') i,list_conf(i),fdimless(i)!,
!     &     (gdt_ts_tb(iref,i),gdt_ha_tb(iref,i),tmscore_tb(iref,i),
!     &      rmstb(iref,i),iref=1,refstr)
        enddo
#endif
c      WRITE (iout,*) "Wchodze do petli i=1,ncon totfree(i)=fdimless(i)"
        qfree=0.0d0
        do i=1,ncon
          qfree=qfree+exp(-fdimless(i)+fdimless(1))
        enddo
c        write (iout,*) "qfree",qfree
c        nlist=1
        nlist=0
        sumprob=0.0
        write (iout,*) "ncon", ncon,maxconf
        do i=1,ncon
          sumprob=sumprob+exp(-fdimless(i)+fdimless(1))/qfree
#ifdef DEBUG
          write (iout,*) i,list_conf(i),
     &     totfree(list_conf(i)),
     &     -entfac(list_conf(i)),fdimless(i),sumprob,prob_limit
#endif
          if (sumprob.gt.prob_limit) goto 122
c          if (sumprob.gt.1.00d0) goto 122
          nlist=nlist+1
        enddo
  122   continue
#ifdef MPI
      endif
      if (.not.lbcast) return
#ifdef DEBUG
      write (iout,*) "Before MPI_Bcast: nlist",nlist
      do i=1,nlist
        write (iout,*) i,list_conf(i),totfree(i)
      enddo
#endif
      call MPI_Bcast(nlist, 1, MPI_INTEGER, Master, MPI_COMM_WORLD, 
     &   IERROR)
      call MPI_Bcast(list_conf,nlist,MPI_INTEGER,Master,MPI_COMM_WORLD,
     &   IERROR)
      call MPI_Bcast(totfree,ncon+1,MPI_DOUBLE_PRECISION,Master,
     &   MPI_COMM_WORLD,IERROR)
c      do iproc=0,nprocs
c        write (iout,*) "iproc",iproc," indstart",indstart(iproc),
c     &   " indend",indend(iproc) 
c      enddo
#ifdef DEBUG
      write (iout,*) "After MPI_Bcast: nlist",nlist
      do i=1,nlist
        write (iout,*) i,list_conf(i),totfree(i)
      enddo
#endif
#endif
      return
      end

