      double precision function gnmr1(y,ymin,ymax)
      implicit none
      double precision y,ymin,ymax
      integer wykl /4/
      if (y.lt.ymin) then
        gnmr1=(ymin-y)**wykl/wykl
      else if (y.gt.ymax) then
        gnmr1=(y-ymax)**wykl/wykl
      else
        gnmr1=0.0d0
      endif
      return
      end
c------------------------------------------------------------------------------
      double precision function gnmr1prim(y,ymin,ymax)
      implicit none
      double precision y,ymin,ymax
      integer wykl /4/
      if (y.lt.ymin) then
        gnmr1prim=-(ymin-y)**(wykl-1)
      else if (y.gt.ymax) then
        gnmr1prim=(y-ymax)**(wykl-1)
      else
        gnmr1prim=0.0d0
      endif
      return
      end
c------------------------------------------------------------------------------
      double precision function harmonic(y,ymax)
      implicit none
      double precision y,ymax
      if (y.gt.ymax) then
        harmonic=(y-ymax)*(y-ymax)
      else
        harmonic=0.0d0
      endif
      return
      end
c-------------------------------------------------------------------------------
      double precision function harmonicprim(y,ymax)
      double precision y,ymin,ymax
      if (y.gt.ymax) then
        harmonicprim=2*(y-ymax)
      else
        harmonicprim=0.0d0
      endif
      return
      end
c---------------------------------------------------------------------------------
      double precision function rlornmr1(y,ymin,ymax,sigma)
      implicit none
      double precision y,ymin,ymax,sigma
      integer wykl /4/
      if (y.lt.ymin) then
        rlornmr1=(ymin-y)**wykl/((ymin-y)**wykl+sigma**wykl)
      else if (y.gt.ymax) then
        rlornmr1=(y-ymax)**wykl/((y-ymax)**wykl+sigma**wykl)
      else
        rlornmr1=0.0d0
      endif
      return
      end
c------------------------------------------------------------------------------
      double precision function rlornmr1prim(y,ymin,ymax,sigma)
      implicit none
      double precision y,ymin,ymax,sigma
      integer wykl /4/
      if (y.lt.ymin) then
        rlornmr1prim=-(ymin-y)**(wykl-1)*sigma**wykl*wykl/
     &   ((ymin-y)**wykl+sigma**wykl)**2
      else if (y.gt.ymax) then
        rlornmr1prim=(y-ymax)**(wykl-1)*sigma**wykl*wykl/
     & ((y-ymax)**wykl+sigma**wykl)**2
      else
        rlornmr1prim=0.0d0
      endif
      return
      end
c------------------------------------------------------------------------------
C 6/20/2020 by Adam: introducing linear ramp
      double precision function rlornmr2(y,ymin,ymax,sigma,slope)
      implicit none
      double precision y,ymin,ymax,sigma,slope
      integer wykl /4/
c      double precision slope /1.0d-2/
c f(x,a)=(x**4*(1+a*abs(x)))/(1+x**4)
      if (y.lt.ymin) then
        rlornmr2=(ymin-y)**wykl*(1.0d0+slope*dlog(dcosh(ymin-y)))/
     &    ((ymin-y)**wykl+sigma**wykl)
      else if (y.gt.ymax) then
        rlornmr2=(y-ymax)**wykl*(1.0d0+slope*dlog(dcosh(y-ymax)))/
     &    ((y-ymax)**wykl+sigma**wykl)
      else
        rlornmr2=0.0d0
      endif
      return
      end
c--------------------------------------  --------------------------------------
      double precision function rlornmr2prim(y,ymin,ymax,sigma,slope)
      implicit none
      double precision y,ymin,ymax,sigma,slope
      integer wykl /4/
c      double precision slope /1.0d-2/
      if (y.lt.ymin) then
        rlornmr2prim=
     &   -(ymin-y)**(wykl-1)*(1.0d0+slope*dlog(dcosh(ymin-y)))
     &   *sigma**wykl*wykl/((ymin-y)**wykl+sigma**wykl)**2-
     & slope*(ymin-y)**wykl*dtanh((ymin-y))/((ymin-y)**wykl+sigma**wykl)
      else if (y.gt.ymax) then
       rlornmr2prim=(y-ymax)**(wykl-1)*(1.0d0+slope*dlog(dcosh(y-ymax)))
     &   *sigma**wykl*wykl/((y-ymax)**wykl+sigma**wykl)**2+
     & slope*(y-ymax)**wykl*dtanh((y-ymax))/((y-ymax)**wykl+sigma**wykl)
      else
        rlornmr2prim=0.0d0
      endif
      return
      end
c------------------------------------------------------------------------------
      subroutine sub_rlornmr1(y,ymin,ymax,sigma,penalty,penaltyprim)
      implicit none
      double precision y,ymin,ymax,sigma
      double precision penalty,penaltyprim
      double precision dif,dif3,dif4,fac,sigma4
      sigma4=sigma*sigma
      sigma4=sigma4*sigma4
      if (y.lt.ymin) then
        dif = ymin-y
        dif3=dif*dif*dif
        dif4=dif3*dif  
        fac=dif/(dif4+sigma4)
        penalty=dif3*fac
        penaltyprim=-4*sigma4*dif*fac*fac
      else if (y.gt.ymax) then
        dif = y-ymax
        dif3=dif*dif*dif
        dif4=dif3*dif
        fac=dif/(dif4+sigma4)
        penalty=dif3*fac
        penaltyprim=4*sigma4*dif*fac*fac
      else
        penalty=0.0d0
        penaltyprim=0.0d0
      endif
      return
      end
c------------------------------------------------------------------------------
C 6/20/2020 by Adam: introducing linear ramp
      subroutine sub_rlornmr2(y,ymin,ymax,sigma,slope,
     & penalty,penaltyprim)
      implicit none
      double precision y,ymin,ymax,sigma,slope
      double precision penalty,penaltyprim
      double precision dif,dif3,dif4,fac,sigma4,edif,edif1,slopefac
      sigma4=sigma*sigma
      sigma4=sigma4*sigma4
      if (y.lt.ymin) then
        dif = ymin-y
        dif3=dif*dif*dif
        dif4=dif3*dif
        edif=dexp(dif)
        edif1=1.0d0/edif
        slopefac=1.0d0+slope*dlog(0.5d0*(edif+edif1))
        fac=dif/(dif4+sigma4)
        penalty=dif3*fac*slopefac
        penaltyprim=-4*sigma4*dif*fac*fac*slopefac
     &   -slope*(edif-edif1)/(edif+edif1)*dif3*fac
      else if (y.gt.ymax) then
        dif = y-ymax
        dif3=dif*dif*dif
        dif4=dif3*dif
        edif=dexp(dif)
        edif1=1.0d0/edif
        slopefac=1.0d0+slope*dlog(0.5d0*(edif+edif1))
        fac=dif/(dif4+sigma4)
        penalty=dif3*fac*slopefac
        penaltyprim=4*sigma4*dif*fac*fac*slopefac
     &   +slope*(edif-edif1)/(edif+edif1)*dif3*fac
      else
        penalty=0.0d0
        penaltyprim=0.0d0
      endif
      return
      end
c------------------------------------------------------------------------------
C 6/20/2020 by Adam: introducing linear ramp
      subroutine sub_rlornmr3(y,ymin,ymax,sigma,slope,
     & penalty,penaltyprim)
      implicit none
      double precision y,ymin,ymax,sigma,slope
      double precision penalty,penaltyprim
      double precision dif,dif3,dif4,fac,sigma4,edif,edif1,slopefac
      sigma4=sigma*sigma
      sigma4=sigma4*sigma4
      if (y.lt.ymin) then
        dif = ymin-y
        dif3=dif*dif*dif
        dif4=dif3*dif
        slopefac=1.0d0+slope*dif
        fac=dif/(dif4+sigma4)
        penalty=dif3*fac*slopefac
        penaltyprim=-4*sigma4*dif*fac*fac*slopefac-slope*dif3*fac
      else if (y.gt.ymax) then
        dif = y-ymax
        dif3=dif*dif*dif
        dif4=dif3*dif
        slopefac=1.0d0+slope*dif
        fac=dif/(dif4+sigma4)
        penalty=dif3*fac*slopefac
        penaltyprim=4*sigma4*dif*fac*fac*slopefac+slope*dif3*fac
      else
        penalty=0.0d0
        penaltyprim=0.0d0
      endif
      return
      end
c------------------------------------------------------------------------------
      subroutine sub_rlor2nmr1(y,ymin,ymax,sigma,penalty,penaltyprim)
      implicit none
      double precision y,ymin,ymax,sigma
      double precision penalty,penaltyprim
      double precision dif,dif2,fac,sigma2
      sigma2=sigma*sigma
      if (y.lt.ymin) then
        dif = ymin-y
        dif2=dif*dif
        fac=1.0d0/(dif2+sigma2)
        penalty=dif2*fac
        penaltyprim=-2*sigma2*dif*fac*fac
      else if (y.gt.ymax) then
        dif = y-ymax
        dif2=dif*dif
        fac=1.0d0/(dif2+sigma2)
        penalty=dif2*fac
        penaltyprim=2*sigma2*dif*fac*fac
      else
        penalty=0.0d0
        penaltyprim=0.0d0
      endif
      return
      end
c------------------------------------------------------------------------------
C 6/20/2020 by Adam: introducing linear ramp
      subroutine sub_rlor2nmr3(y,ymin,ymax,sigma,slope,
     & penalty,penaltyprim)
      implicit none
      double precision y,ymin,ymax,sigma,slope
      double precision penalty,penaltyprim
      double precision dif,dif2,fac,sigma2,slopefac
      sigma2=sigma*sigma
      if (y.lt.ymin) then
        dif = ymin-y
        dif2=dif*dif
        slopefac=1.0d0+slope*dif
        fac=1.0d0/(dif2+sigma2)
        penalty=dif2*fac*slopefac
        penaltyprim=(-2*sigma2*dif*fac*slopefac-slope*dif2)*fac
      else if (y.gt.ymax) then
        dif = y-ymax
        dif2=dif*dif
        slopefac=1.0d0+slope*dif
        fac=1.0d0/(dif2+sigma2)
        penalty=dif2*fac*slopefac
        penaltyprim=(2*sigma2*dif*fac*slopefac+slope*dif2)*fac
      else
        penalty=0.0d0
        penaltyprim=0.0d0
      endif
      return
      end
