      subroutine enecalc(ib,ncon)
! Compute free energies of conformations at the desired temperature
      implicit none
      include "DIMENSIONS"
      include "sizesclu.dat"
#ifdef MPI
      include "mpif.h"
      include "COMMON.MPI"
      integer ierror,errcode,status(MPI_STATUS_SIZE) 
#endif
      include "COMMON.CONTROL"
      include "COMMON.IOUNITS"
      include "COMMON.FREE"
      include "COMMON.FFIELD"
      include "COMMON.INTERACT"
      include "COMMON.SBRIDGE"
      include "COMMON.CHAIN"
      include "COMMON.CLUSTER"
      include "COMMON.NMR"
      real*4 csingle(3,maxres2)
      double precision fT(6),fTprim(6),fTbis(6),quot,quotl1,quotl,kfacl,
     &  eprim,ebis,temper,kfac/2.4d0/,T0/300.0d0/
      double precision etot,evdw,evdw2,ees,evdw1,ebe,etors,escloc,
     &      ehpb,ecorr,ecorr5,ecorr6,eello_turn4,eello_turn3,
     &      eturn6,eel_loc,edihcnstr,etors_d,estr,evdw2_14,esccor,
     &      evdw_t,esaxs,eliptran,ethetacnstr,ehomology_constr,
     &      edfadis,edfator,edfanei,edfabet
      integer i,ii,ik,iproc,iscor,j,k,l,ib,nlist,ncon
      double precision qfree,sumprob,eini,efree,rmsdev
      integer iref
      double precision energia(0:max_ene), totfree_buf(0:maxconf)
#ifdef MPI
      write (iout,*) me," indstart",indstart(me)," indend",indend(me)
      call daread_ccoords(indstart(me),indend(me))
#endif
#ifdef DEBUG
      write (iout,*) "ENECALC: ncon",ncon
      call flush(iout)
#endif
      temper=1.0d0/(beta_h(ib)*1.987D-3)
      if (rescale_mode.eq.1) then
        quot=1.0d0/(T0*beta_h(ib)*1.987D-3)
        quotl=1.0d0
        kfacl=1.0d0
        do l=1,5
          quotl1=quotl
          quotl=quotl*quot
          kfacl=kfacl*kfac
          fT(l)=kfacl/(kfacl-1.0d0+quotl)
        enddo
#if defined(FUNCTH)
        ft(6)=(320.0d0+80.0d0*dtanh((betaT-320.0d0)/80.0d0))/
     &             320.0d0
        ftprim(6)=1.0d0/(320.0d0*dcosh((betaT-320.0d0)/80.0d0)**2)
        ftbis(6)=-2.0d0*dtanh((betaT-320.0d0)/80.0d0)
     &         /(320.0d0*80.0d0*dcosh((betaT-320.0d0)/80.0d0)**3)
#elif defined(FUNCT)
        fT(6)=betaT/T0
        ftprim(6)=1.0d0/T0
        ftbis(6)=0.0d0
#else
        fT(6)=1.0d0
        ftprim(6)=0.0d0
        ftbis(6)=0.0d0
#endif

      else if (rescale_mode.eq.2) then
        quot=1.0d0/(T0*beta_h(ib)*1.987D-3)
        quotl=1.0d0
        do l=1,5
          quotl=quotl*quot
          fT(l)=1.12692801104297249644d0/
     &       dlog(dexp(quotl)+dexp(-quotl))
        enddo
c          write (iout,*) 1.0d0/(beta_h(ib)*1.987D-3),ft
c          call flush(iout)
#if defined(FUNCTH)
        ft(6)=(320.0d0+80.0d0*dtanh((betaT-320.0d0)/80.0d0))/
     &             320.0d0
        ftprim(6)=1.0d0/(320.0d0*dcosh((betaT-320.0d0)/80.0d0)**2)
        ftbis(6)=-2.0d0*dtanh((betaT-320.0d0)/80.0d0)
     &         /(320.0d0*80.0d0*dcosh((betaT-320.0d0)/80.0d0)**3)
#elif defined(FUNCT)
        fT(6)=betaT/T0
        ftprim(6)=1.0d0/T0
        ftbis(6)=0.0d0
#else
        fT(6)=1.0d0
        ftprim(6)=0.0d0
        ftbis(6)=0.0d0
#endif
      endif

#ifdef MPI
      do i=1,scount(me)
        ii=i+indstart(me)-1
#else
      do i=1,ncon
        ii=i
#endif
        do j=1,nres
          do k=1,3
            c(k,j)=allcart(k,j,i)
            c(k,j+nres)=allcart(k,j+nres,i)
          enddo
        enddo
        do k=1,3
          c(k,nres+1)=c(k,1)
          c(k,nres+nres)=c(k,nres)
        enddo
        nss=nss_all(i)
        if (dyn_ss) then
        do j=1,nss
          idssb(j)=ihpb_all(j,i)
          jdssb(j)=jhpb_all(j,i)
        enddo 
        else
        do j=1,nss
          ihpb(j)=ihpb_all(j,i)
          jhpb(j)=jhpb_all(j,i)
        enddo 
        endif
#ifdef DEBUG
        write (iout,*) "conformation", i," before etotal"
        if (dyn_ss) then
          write (iout,*) "nss",nss,
     &      " idssb,jdssb",(idssb(k),jdssb(k),k=1,nss)
        endif
#endif
        call int_from_cart1(.false.)
        call etotal(energia(0),fT)
        etot=energia(0)         
        if (atimeave.gt.0) then
#ifdef DEBUG
          write (iout,*) "conformation",i,ii,
     &    " restraint energy",energia(15),
     &    " replaced with time-ave restraint energies",energy(1:3,ii)
#endif
          etot=etot+energy(1,ii)-energia(15)+energy(2,ii)-energia(20)
     &      +energy(3,ii)-energia(24)
          energia(0)=etot
          energia(15)=energy(1,ii)
          energia(20)=energy(2,ii)
          energia(24)=energy(3,ii)
        endif
        totfree_buf(i)=beta_h(ib)*etot+entfac(ii)
        totfree(i)=totfree_buf(i)
#ifdef DEBUG
        write (iout,*) "conformation", i
        if (dyn_ss) then
          write (iout,*) "nss",nss,
     &      " idssb,jdssb",(idssb(k),jdssb(k),k=1,nss)
        endif
        write (iout,'(8f10.5)') ((c(l,k),l=1,3),k=1,nres),
     &                            ((c(l,k+nres),l=1,3),k=nnt,nct)
        call enerprint(energia(0),fT)
#endif
#ifdef DEBUG
        write (iout,*) "fdim calc", i,ii,ib,
     &   1.0d0/(1.987d-3*beta_h(ib)),totfree(i),
     &   entfac(ii)
#endif
      enddo   ! i
#ifdef DEBUG
        write (iout,*) "The totfree array before Gather"
        do i=1,ncon
          write (iout,*) i,totfree_buf(i)
        enddo
#endif
#ifdef MPI
      call MPI_Gatherv(totfree_buf(1),scount(me),
     & MPI_DOUBLE_PRECISION,totfree(1),
     & scount(0),idispl(0),MPI_DOUBLE_PRECISION,Master,
     & MPI_COMM_WORLD, IERROR)
      if (me.eq.Master) then
#endif
#ifdef DEBUG
        write (iout,*) "The totfree array after Gather"
        do i=1,ncon
          write (iout,*) i,totfree(i)
        enddo
#endif
#ifdef MPI
      endif
#endif
      return
      end
