      subroutine geom_to_var(n,x)
C
C Transfer the geometry parameters to the variable array.
C The positions of variables are as follows:
C 1. Virtual-bond torsional angles: 1 thru nres-3
C 2. Virtual-bond valence angles: nres-2 thru 2*nres-5
C 3. The polar angles alpha of local SC orientation: 2*nres-4 thru 
C    2*nres-4+nside
C 4. The torsional angles omega of SC orientation: 2*nres-4+nside+1
C    thru 2*nre-4+2*nside 
C
      include 'DIMENSIONS'
      include 'COMMON.VAR'
      include 'COMMON.GEO'
      include 'COMMON.CHAIN'
      double precision x(n)
cd    print *,'nres',nres,' nphi',nphi,' ntheta',ntheta,' nvar',nvar
      do i=4,nres
        x(i-3)=phi(i)
cd      print *,i,i-3,phi(i)
      enddo
      if (n.eq.nphi) return
      do i=3,nres
        x(i-2+nphi)=theta(i)
cd      print *,i,i-2+nphi,theta(i)
      enddo
      if (n.eq.nphi+ntheta) return
      do i=2,nres-1
	if (ialph(i,1).gt.0) then
	  x(ialph(i,1))=alph(i)
	  x(ialph(i,1)+nside)=omeg(i)
cd        print *,i,ialph(i,1),ialph(i,1)+nside,alph(i),omeg(i)
        endif
      enddo      
      return
      end
C--------------------------------------------------------------------
      subroutine var_to_geom(n,x)
C
C Update geometry parameters according to the variable array.
C
      include 'DIMENSIONS'
      include 'COMMON.VAR'
      include 'COMMON.CHAIN'
      dimension x(n)
      do i=4,nres
        phi(i)=pinorm(x(i-3))
      enddo
      if (n.eq.nphi) return
      do i=3,nres
        theta(i)=x(i-2+nphi)
      enddo
      if (n.eq.nphi+ntheta) return
      do i=1,nside
        alph(ialph(i,2))=x(nphi+ntheta+i)
        omeg(ialph(i,2))=pinorm(x(nphi+ntheta+nside+i))
      enddo      
      return
      end
