      subroutine calc_rmsgdt(ncon)
! construct the conformational ensembles at REMD temperatures
      implicit none
      include "DIMENSIONS"
      include "sizesclu.dat"
#ifdef MPI
      include "mpif.h"
      include "COMMON.MPI"
      integer ierror,errcode,status(MPI_STATUS_SIZE) 
#endif
      include "COMMON.CONTROL"
      include "COMMON.IOUNITS"
      include "COMMON.FREE"
      include "COMMON.FFIELD"
      include "COMMON.INTERACT"
      include "COMMON.SBRIDGE"
      include "COMMON.CHAIN"
      include "COMMON.CLUSTER"
      include "COMMON.NMR"
      real*4 csingle(3,maxres2)
      integer i,ii,ik,iproc,iscor,j,k,l,ib,nlist,ncon
      double precision rmsdev
      character*80 bxname
      character*2 licz1
      character*5 ctemper
      integer ilen,ijk
      external ilen
      integer iref
      character*80 structure/'Structure'/
      double precision buffer(maxref,maxconf)
      integer scount_rms(0:MaxProcs-1),idispl_rms(0:MaxProcs-1)
      double precision rmsnat
      external rmsnat
c      write (iout,*) "ncon",ncon
c      do i=1,ncon
c        list_conf(i)=i
c      enddo
c      do i=1,ncon
c        write (iout,*) i,list_conf(i)
c      enddo
#ifdef MPI
#ifdef DEBUG
      write (iout,*) "calc_rmsgdt: me," indstart",indstart(me),
     &   " indend",indend(me)
#endif
      call daread_ccoords(indstart(me),indend(me))
#endif

#ifdef MPI
      do i=1,scount(me)
        ii=i+indstart(me)-1
#else
      do i=1,ncon
        ii=i
#endif
C        write (iout,*) "i",i," ii",ii,"ib",ib,scount(me)
c        call flush(iout)
c        if (ib.eq.1) then
        do j=1,nres
          do k=1,3
            c(k,j)=allcart(k,j,i)
            c(k,j+nres)=allcart(k,j+nres,i)
C              write(iout,*) "coord",i,j,k,allcart(k,j,i),c(k,j),
C     &        c(k,j+nres),allcart(k,j+nres,i)
          enddo
        enddo
C          write(iout,*) "out of j loop"
C          call flush(iout)
        do k=1,3
          c(k,nres+1)=c(k,1)
          c(k,nres+nres)=c(k,nres)
        enddo
C          write(iout,*) "after nres+nres",nss_all(i)
C          call flush(iout)
        do iref=1,refstr
          write (structure(9:),'(bz,i6.6)') i
          call TMscore_sub(rmsdev,gdt_ts_tb(iref,i),
     &    gdt_ha_tb(iref,i),tmscore_tb(iref,i),Structure,iref,.false.)
#ifdef DEBUG
          write (iout,*) rmsdev,gdt_ts_tb(iref,i),gdt_ha_tb(iref,i),
     &      tmscore_tb(iref,i)
#endif
          if (recalc_rms) then
c            write (2,*) "original     rms",i,rmstb(iref,i)
            rmstb(iref,i)=rmsnat(i,iref)
c            write (2,*) "recalculated rms",i,rmstb(iref,i)
          endif
        enddo
      enddo   ! i

#ifdef MPI
      scount_rms(0)=maxref*scount(0)
      idispl_rms(0)=0
      do i=1,nprocs-1
        scount_rms(i)=maxref*scount(i)
        idispl_rms(i)=idispl_rms(i-1)+scount_rms(i-1)
      enddo
      do i=1,scount(me)
        buffer(:refstr,i)=gdt_ts_tb(:refstr,i)
      enddo
      call MPI_Gatherv(buffer(1,1),scount_rms(me),
     & MPI_DOUBLE_PRECISION,
     & gdt_ts_tb(1,1),scount_rms(0),idispl_rms(0),
     & MPI_DOUBLE_PRECISION,Master,
     & MPI_COMM_WORLD,IERROR)
      do i=1,scount(me)
        buffer(:refstr,i)=gdt_ha_tb(:refstr,i)
      enddo
      call MPI_Gatherv(buffer(1,1),scount_rms(me),
     & MPI_DOUBLE_PRECISION,
     & gdt_ha_tb(1,1),scount_rms(0),idispl_rms(0),
     & MPI_DOUBLE_PRECISION,Master,
     & MPI_COMM_WORLD,IERROR)
      do i=1,scount(me)
        buffer(:refstr,i)=tmscore_tb(:refstr,i)
      enddo
      call MPI_Gatherv(buffer(1,1),scount_rms(me),
     & MPI_DOUBLE_PRECISION,
     &tmscore_tb(1,1),scount_rms(0),idispl_rms(0),
     & MPI_DOUBLE_PRECISION,Master,
     & MPI_COMM_WORLD,IERROR)
      if (recalc_rms) then
        do i=1,scount(me)
          buffer(:refstr,i)=rmstb(:refstr,i)
        enddo
        call MPI_Gatherv(buffer(1,1),scount_rms(me),
     &   MPI_DOUBLE_PRECISION,
     &   rmstb(1,1),scount_rms(0),idispl_rms(0),
     &   MPI_DOUBLE_PRECISION,Master,
     &   MPI_COMM_WORLD,IERROR)
      endif
#endif
      return
      end
