      subroutine ave_restr_all1(iflag,ncon,x,f,g)
c
c 12/28/2023 AL compute conformation-averaged NOEs
c
      implicit none
      include 'DIMENSIONS'
      include 'sizesclu.dat'
#ifdef MPI
      include "mpif.h"
      integer IERROR
      include "COMMON.MPI"
      double precision dnmr_xave0_(maxdim)
#endif
      include 'COMMON.CONTROL'
      include 'COMMON.CLUSTER'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.VAR'
      include 'COMMON.TEMPFAC'
      include 'COMMON.IOUNITS'
      include 'COMMON.SBRIDGE'
      include 'COMMON.NMR'
      integer nviol
      common /nmrviol/ nviol
      double precision x(ncon),g(ncon),g_(maxconf)
      integer iflag,ncon,i,ii,j,jj,iti,itj,k,jcon,itot,ip
      double precision dd,rvec(3),aux
      double precision onesix /-.16666666666666666666D0/
      double precision f
      double precision harmonic,harmonicprim
c
      dnmr_xave0=0.0d0
      g(:ncon) = 0.0d0
      f = 0.0d0
#ifdef MPI
c      write (iout,*) "ave_restr1: ", me," indstart",indstart(me),
c     &   " indend",indend(me)
c      call flush(iout)
      call MPI_Bcast(iflag, 1, MPI_INTEGER, Master, MPI_COMM_WORLD,
     &   IERROR)
c      write (iout,*) "iflag",iflag
c      call flush(iout)
      if (iflag.le.0) return
      call MPI_Bcast(x(1), ncon, MPI_DOUBLE_PRECISION, Master, 
     &   MPI_COMM_WORLD,IERROR)
c      write (iout,*) "After broadcast x"
c      call flush(iout)
      call daread_ccoords(indstart(me),indend(me))
      do jcon=1,scount(me)
#else
      DO jcon=1,NCON
#endif
      do i=1,2*nres
        do j=1,3
          c(j,i)=allcart(j,i,jcon)
        enddo
      enddo
      call int_from_cart1(.false.)
      call vec_and_deriv
      call nmr_hpos(.false.)
      itot=0
      do j=1,npeak
        do ip=ipeak(1,j),ipeak(2,j)
          itot=itot+1
          ii=ihpb_peak(1,ip)
          iti=ihpb_peak(2,ip)
          jj=jhpb_peak(1,ip)
          itj=jhpb_peak(2,ip)
          call hdist(ii,iti,jj,itj,dd,rvec)
          dnmr_xave0(itot)=dnmr_xave0(itot)+x(jcon+indstart(me)-1)
     &     *dd**(-6)
        enddo
c        write (iout,*) "dnmr_xave0",itot,dnmr_xave0(itot)
      enddo

      enddo ! jcon

#ifdef MPI
      call MPI_AllReduce(dnmr_xave0(1),dnmr_xave0_(1),nhpb_peak,
     &    MPI_DOUBLE_PRECISION,MPI_SUM,MPI_COMM_WORLD,IERROR)
      dnmr_xave0(:itot)=dnmr_xave0_(:itot)
#endif
#ifdef DEBUG
      write (iout,*) "dnmr_xave0 after broadcast"
      do i=1,npeak
        write (iout,*) i,dnmr_xave0(i)
      enddo
#endif
      itot=0
      nviol=0
      do j=1,npeak
        do ip=ipeak(1,j),ipeak(2,j)
          itot=itot+1
c          write (iout,*) "dnmr_xave0",itot,dnmr_xave0(itot)
          dnmr_xave0(itot)=(dnmr_xave0(itot))**onesix
          if (dnmr_xave0(itot)-dhpb1_peak(ip).ge.1.0d0) nviol=nviol+1
          f=f+harmonic(dnmr_xave0(itot),dhpb1_peak(ip))
        enddo
      enddo
#ifdef DEBUG
      write (iout,*) "AVE_RESTR: f",f
#endif
#ifdef MPI
      do jcon=1,scount(me)
#else
      DO jcon=1,NCON
#endif
        do i=1,2*nres
          do j=1,3
            c(j,i)=allcart(j,i,jcon)
          enddo
        enddo
        call int_from_cart1(.false.)
        call vec_and_deriv
        call nmr_hpos(.false.)
        itot=0
        do j=1,npeak
          do ip=ipeak(1,j),ipeak(2,j)
            itot=itot+1
            ii=ihpb_peak(1,ip)
            iti=ihpb_peak(2,ip)
            jj=jhpb_peak(1,ip)
            itj=jhpb_peak(2,ip)
            call hdist(ii,iti,jj,itj,dd,rvec)
            aux=onesix*harmonicprim(dnmr_xave0(itot),dhpb1_peak(ip))
     &      *dnmr_xave0(itot)
c          write (iout,*)"itot",itot,"dnmr",dnmr_xave0(itot),
c     &      " dhpb1_peak",dhpb1_peak(ip)," aux",aux
            g(jcon)=g(jcon)+aux*((dnmr_xave0(itot)/dd)**6-1.0d0)
          enddo
        enddo
      enddo
      g_(:scount(me))=g(:scount(me))
      call MPI_Gatherv(g_(1),scount(me),MPI_DOUBLE_PRECISION,g(1),
     &    scount(0),idispl(0),MPI_DOUBLE_PRECISION,Master,
     &    MPI_COMM_WORLD,IERROR)
#ifdef DEBUG
      write (iout,* )"gradient"
      do i=1,ncon
        write (iout,*) i,g(i)
      enddo
#endif
      return
      end
