      subroutine ave_restr_all(ncon)
c
c 12/28/2023 AL compute conformation-averaged NOEs
c
      implicit none
      include 'DIMENSIONS'
      include 'sizesclu.dat'
#ifdef MPI
      include "mpif.h"
      integer IERR
      include "COMMON.MPI"
      double precision dnmr_xave0_(maxdim),cosphi_xave0_(maxres),
     &  sinphi_xave0_(maxres),qpart_
#endif
      include 'COMMON.CONTROL'
      include 'COMMON.CLUSTER'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.VAR'
      include 'COMMON.TEMPFAC'
      include 'COMMON.IOUNITS'
      include 'COMMON.SBRIDGE'
      include 'COMMON.NMR'
      include 'COMMON.TORCNSTR'
      integer ncon,i,ii,j,jj,iti,itj,k,jcon,itot,ip,itori
      double precision boltz,qpart,eref,dd,rvec(3)
      double precision onesix /-.16666666666666666666D0/
      double precision cosphii,sinphii,phii
c
c      onesix=-1.0d0/6.0d0
      eref=totfree(1)
#ifdef DEBUG
      write (iout,*) "eref",eref,totfree(1)," ncon",ncon
      do i=1,ncon
        write (iout,*) i,totfree(i)
      enddo
#endif
      qpart=0.0d0
      dnmr_xave0=0.0d0
#ifdef MPI
      call work_partition(.true.,ncon)
      write (iout,*) me," indstart",indstart(me)," indend",indend(me)
      call daread_ccoords(indstart(me),indend(me))
#else
      call daread_ccoords(1,ncon)
#endif
#ifdef MPI
      do jcon=1,scount(me)
#else
      DO jcon=1,NCON
#endif
        do i=1,2*nres
          do j=1,3
            c(j,i)=allcart(j,i,jcon)
          enddo
        enddo
        boltz=dexp(-totfree(jcon+indstart(me)-1)+eref)
#ifdef DEBUG
        write(iout,*)"jcon",jcon," conf",list_conf(jcon+indstart(me)-1),
     &   " totfree",totfree(jcon+indstart(me)-1),
     &   " boltz",boltz
#endif
        qpart = qpart + boltz
        call int_from_cart1(.false.)
        call vec_and_deriv
        call nmr_hpos(.false.)
        itot=0
        do j=1,npeak
          do ip=ipeak(1,j),ipeak(2,j)
            itot=itot+1
            ii=ihpb_peak(1,ip)
            iti=ihpb_peak(2,ip)
            jj=jhpb_peak(1,ip)
            itj=jhpb_peak(2,ip)
            if (ii.eq.0 .or. jj.eq.0) write (iout,*) "j",j," ip",ip,
     &           " ii",ii," jj",jj," iti",iti," itj",itj
            call hdist(ii,iti,jj,itj,dd,rvec)
            dnmr_xave0(itot)=dnmr_xave0(itot)+1.0d0/dd**6*boltz
          enddo
        enddo
        if (ndih_constr.gt.0) then
          do i=idihconstr_start,idihconstr_end
            itori=idih_constr(i)
            phii=phi(itori)
            cosphii=dcos(phii)
            sinphii=dsin(phii)
            cosphi_xave0(i)=cosphi_xave0(i)+cosphii*boltz
            sinphi_xave0(i)=sinphi_xave0(i)+sinphii*boltz
          enddo
        endif 
      enddo
#ifdef DEBUG
      write (iout,*) "qpart",qpart
#endif
#ifdef MPI
      call MPI_Reduce(qpart,qpart_,1,MPI_DOUBLE_PRECISION,
     &    MPI_SUM,Master,MPI_COMM_WORLD,IERR)
      call MPI_Reduce(dnmr_xave0(1),dnmr_xave0_(1),nhpb_peak,
     &    MPI_DOUBLE_PRECISION,MPI_SUM,Master,MPI_COMM_WORLD,IERR)
      if (ndih_constr.gt.0) then
        call MPI_Reduce(cosphi_xave0(1),cosphi_xave0_(1),ndih_constr,
     &    MPI_DOUBLE_PRECISION,MPI_SUM,Master,MPI_COMM_WORLD,IERR)
        call MPI_Reduce(sinphi_xave0(1),sinphi_xave0_(1),ndih_constr,
     &    MPI_DOUBLE_PRECISION,MPI_SUM,Master,MPI_COMM_WORLD,IERR)
      endif
      if (me.eq.Master) then
      qpart=qpart_
      itot=0
      do j=1,npeak
        do ip=ipeak(1,j),ipeak(2,j)
          itot=itot+1
          dnmr_xave0(itot)=(dnmr_xave0_(itot)/qpart)**onesix
        enddo
      enddo
      do i=1,ndih_constr
        cosphi_xave0(i)=cosphi_xave0_(i)/qpart
        sinphi_xave0(i)=sinphi_xave0_(i)/qpart
      enddo
      endif
#else
      itot=0
      do j=1,npeak
        do ip=ipeak(1,j),ipeak(2,j)
          itot=itot+1
          dnmr_xave0(itot)=(dnmr_xave0(itot)/qpart)**onesix
        enddo
      enddo
#endif
#ifdef DEBUG
      write (iout,*) "qpart",qpart," ncon",ncon
#endif
      return
      end
c------------------------------------------------------------------------------
      subroutine print_ave_restr_all(ncon,ib)
c
c 12/28/2023 AL print conformation-averaged NOEs
c
      implicit none
      include 'DIMENSIONS'
      include 'sizesclu.dat'
      include 'COMMON.GEO'
      include 'COMMON.CONTROL'
      include 'COMMON.CLUSTER'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.VAR'
      include 'COMMON.TEMPFAC'
      include 'COMMON.IOUNITS'
      include 'COMMON.SBRIDGE'
      include 'COMMON.NMR'
      include 'COMMON.TORCNSTR'
      include 'COMMON.FREE'
      include 'COMMON.NAMES'
      integer ncon,ib,iviol,iresi,iresj,list_peak_viol(maxdim_cont)
      integer i,ii,iii,ii1,ii2,j,jj,iti,itj,k,jcon,itot,ip,nviolpeak,
     & nviolpeak_gross,nviolang,itori
      double precision temper,dd,phii
      logical viol_nmr,viol_nmr_gross
      character*120 cfname
      character*8 ctemper
      character*4 resi,resj
      character*1 restr_viol(0:2) /' ','m','M'/
      character*1 angviol(-1:1) /'-',' ','+'/
      double precision difi
      double precision pinorm
      write (iout,*) "AVE_RESTR_ALL"
      temper=1.0d0/(beta_h(ib)*1.987d-3)
      if (temper.lt.100.0d0) then
        write(ctemper,'(f3.0)') temper
        ctemper(3:3)=" "
      else if (temper.lt.1000.0) then
        write (ctemper,'(f4.0)') temper
        ctemper(4:4)=" "
      else
        write (ctemper,'(f5.0)') temper
        ctemper(5:5)=" "
      endif
      ii1= index(intinname,'/')
      ii2=ii1
      ii1=ii1+1
      do while (ii2.gt.0) 
        ii1=ii1+ii2
        ii2=index(intinname(ii1:),'/')
      enddo 
      iii = ii1+index(intinname(ii1:),'.')-1
      if (iii.eq.0) then
        iii=len_trim(intinname)
      else
        iii=iii-1
      endif
      cfname=intinname(ii1:iii)//"_T"//ctemper(:len_trim(ctemper))
     &  //"K"//'.nmrave'
c
      open(jrms,file=cfname)
      itot=0
      nviolpeak=0
      nviolpeak_gross=0
      do j=1,npeak
        viol_nmr=.true.
        viol_nmr_gross=.true.
        do ip=ipeak(1,j),ipeak(2,j)
          itot=itot+1
          dd = dnmr_xave0(itot)
          ii=ihpb_peak(1,ip)
          iti=ihpb_peak(2,ip)
          jj=jhpb_peak(1,ip)
          itj=jhpb_peak(2,ip)
          iresi=ii-nnt+1
          iresj=jj-nnt+1
          if (iti.eq.0) then
            iresi=iresi+1
            resi=restyp(itype(ii+1))
          else
            resi=restyp(itype(ii))
          endif
          if (itj.eq.0) then
            iresj=iresj+1
            resj=restyp(itype(jj+1))
          else
            resj=restyp(itype(jj))
          endif
          if (dd.le.dhpb1_peak(ip)) then
            iviol=0
          else if (dd.le.dhpb1_peak(ip)+2.0d0) then
            iviol=1
          else
            iviol=2
          endif
          write (jrms,'(2(a3,i5,1x),i5,2f8.2,2a6,2x,a1)')
     &     resi,iresi,resj,iresj,num_peak(j),dd,dhpb1_peak(ip),
     &     proton1(ip),proton2(ip),restr_viol(iviol)
          if (dd.le.dhpb1_peak(ip)) then
            viol_nmr=.false.
            viol_nmr_gross=.false.
          else if (dd.le.dhpb1_peak(ip)+2.0d0) then
            viol_nmr_gross=.false.
          endif
        enddo
        write (jrms,*) 
        if (viol_nmr) then
          nviolpeak=nviolpeak+1
          list_peak_viol(nviolpeak)=j
        endif
        if (viol_nmr_gross) then
          nviolpeak_gross=nviolpeak_gross+1
        endif
      enddo
      if (nviolpeak.gt.0) then
       write (iout,'(a,i5,2h (f6.2,2h%))')
     &  "Number of violated NMR ensemble-averaged restraints:",
     &  nviolpeak,100*(nviolpeak+0.)/npeak
        write (iout,'(2a,i5,2h (f6.2,2h%))')
     &   "Number of ensemble-averaged grossly violated",
     &   " NMR restraints (upper_limit+2A):",
     &  nviolpeak_gross,100*(nviolpeak_gross+0.)/npeak
        write (iout,'(a)')
     & "List of ensemble-averaged violated restraints:"
        write (iout,'(16i5)') (list_peak_viol(j),j=1,nviolpeak)
      endif
      cfname=intinname(ii1:iii)//"_T"//ctemper(:len_trim(ctemper))
     &  //"K"//'.angleave'
c
      open(jrms,file=cfname)
c      write (iout,*) "cfname: ",cfname(:len_trim(cfname))
      nviolang=0
c      write (iout,*) "idihconstr_start,idihconstr_end",
c     &  idihconstr_start,idihconstr_end
      do i=idihconstr_start,idihconstr_end
        itori=idih_constr(i)
        phii = datan2(sinphi_xave0(i),cosphi_xave0(i))
        difi=pinorm(phii-phi0(i))
        if (difi.lt.-drange(i)) then
          iviol=-1
          nviolang=nviolang+1
        else if (difi.gt.drange(i)) then      
          iviol=1
          nviolang=nviolang+1
        else
          iviol=0
        endif
        write (jrms,'(4(a3,i5,1x),3f8.2,2x,a1)')
     &    restyp(itype(itori-3)),itori-nnt-2,
     &    restyp(itype(itori-2)),itori-nnt-1,
     &    restyp(itype(itori-1)),itori-nnt,
     &    restyp(itype(itori)),itori-nnt+1,phii*rad2deg,
     &    (phi0(i)-drange(i))*rad2deg,(phi0(i)+drange(i))*rad2deg,
     &    angviol(iviol)
      enddo
      close(jrms)
      write (iout,*) nviolang,
     & " dihedral-angle restraints violated by time-averaged angles."
      return
      end
