      subroutine ave_contact_all(ncon)
c
c 12/28/2023 AL compute conformation-averaged NOEs
c
      implicit none
      include 'DIMENSIONS'
      include 'sizesclu.dat'
#ifdef MPI
      include "mpif.h"
      integer IERR
      include "COMMON.MPI"
      double precision contmap_ave_(maxres,maxres),qpart_
#endif
      include 'COMMON.CONTROL'
      include 'COMMON.CLUSTER'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.VAR'
      include 'COMMON.TEMPFAC'
      include 'COMMON.IOUNITS'
      include 'COMMON.SBRIDGE'
      include 'COMMON.NAMES'
      integer ncon,i,ii,j,jj,iti,itj,k,jcon,itot,ip,itori
      double precision boltz,qpart,eref,dd,rvec(3)
      double precision contmap_ave(maxres,maxres),sumcont
      integer ncont,icont(2,maxcont)
 
      eref=totfree(1)
#ifdef DEBUG
      write (iout,*) "eref",eref,totfree(1)," ncon",ncon
      do i=1,ncon
        write (iout,*) i,totfree(i)
      enddo
#endif
      qpart=0.0d0
      contmap_ave(:,:)=0.0d0
#ifdef MPI
      call work_partition(.true.,ncon)
      write (iout,*) me," indstart",indstart(me)," indend",indend(me)
      call daread_ccoords(indstart(me),indend(me))
#else
      call daread_ccoords(1,ncon)
#endif
#ifdef MPI
      do jcon=1,scount(me)
#else
      DO jcon=1,NCON
#endif
        do i=1,2*nres
          do j=1,3
            c(j,i)=allcart(j,i,jcon)
          enddo
        enddo
        boltz=dexp(-totfree(jcon+indstart(me)-1)+eref)
#ifdef DEBUG
        write(iout,*)"jcon",jcon," conf",list_conf(jcon+indstart(me)-1),
     &   " totfree",totfree(jcon+indstart(me)-1),
     &   " boltz",boltz
#endif
        qpart = qpart + boltz
        call contact(.false.,ncont,icont)
        do i=1,ncont
          ii = icont(1,i)
          jj = icont(2,i)
#ifdef MPI
          contmap_ave_(ii,jj)=contmap_ave_(ii,jj)+boltz
          contmap_ave_(jj,ii)=contmap_ave_(jj,ii)+boltz
#else
          contmap_ave(ii,jj)=contmap_ave(ii,jj)+boltz
          contmap_ave(jj,ii)=contmap_ave(jj,ii)+boltz
#endif
        enddo
      enddo
#ifdef DEBUG
      write (iout,*) "qpart",qpart
#endif
#ifdef MPI
      call MPI_Reduce(qpart,qpart_,1,MPI_DOUBLE_PRECISION,
     &    MPI_SUM,Master,MPI_COMM_WORLD,IERR)
      call MPI_Reduce(contmap_ave_(1,1),contmap_ave(1,1),maxres*nres,
     &    MPI_DOUBLE_PRECISION,MPI_SUM,Master,MPI_COMM_WORLD,IERR)
      if (me.eq.Master) then
      qpart=qpart_
#endif
#ifdef DEBUG
      write (iout,*) "qpart",qpart," ncon",ncon
#endif
      write (iout,*) "Ensemble-averaged sidechain-sidechain contant map"
      do i=nnt,nct
        do j=nnt,nct
          write(iout,'(2(a3,i5,1x),f10.5)') restyp(itype(i)),i,
     &     restyp(itype(j)),j,contmap_ave(i,j)/qpart
        enddo
      enddo
      write (iout,*) 
     &   "Ensemble-averaged sidechain-sidechain contant profile"
      do i=nnt,nct
        sumcont = 0.0d0   
        do j=nnt,nct
          sumcont = sumcont + contmap_ave(j,i)/qpart
        enddo
        write(iout,'(a3,i5,f10.5)') restyp(itype(i)),i,sumcont
      enddo
#ifdef MPI
      endif
#endif
      return
      end
