      subroutine openunits(nunit,iunit,irw,forma,iovrd,dumfnm,flag)
C
C This subroutine parses the command line to get appropriate input and output 
C files and opens files for a serial or a parallel job. In the second case
C the output files will have names dependent on processor number, which 
C prevents overwriting by different processors.
C
C The command line is as follows:
C
C program [-O] -flag1 file1 -flag2 file2 ...
C 
C where -O indicates that all output files can be overwritten
C       -flag_i is the flag indicating that the next argument is file_i
C
C The integer array irw() stores the information showing whether a file
C is an input file (1) or not (0)
C
C The integer array iovrd stores information showing whether a file can
C be (0) or cannot be (1) overwritten (unless -O has been specified).
C
C The character array dumfnm stores the default filenames.
C
C The character array forma stores the form of files (formatted or unformatted).
C
C All of the above-mentioned arrays must be initialized in the calling 
C subroutine.
C
C A. Liwo 6/10/2000
C
#ifdef MPI
      include "parcom.dat"
      include 'mpif.h'
      integer numtasks,taskid
      common /rownia/ numtasks,taskid
#endif
      integer ilen
      external ilen
      character*(*) dumfnm(nunit)
      character*(*) flag(nunit)
      character*(*) forma(nunit)
      logical overwrite
      character*64 ff,fname
      dimension irw(nunit),iunit(nunit),iovrd(nunit)
      narg = iargc()
      do i=1,narg
        call getarg(i,ff)
        if (ff.eq.'-O') then
           overwrite=.true.
           goto 10
        else
           overwrite=.false.
        endif
      enddo
   10 continue
      do j=1,nunit
        do i=1,narg
          call getarg(i,ff)
          if (ff.eq.flag(j)) then
            call getarg(i+1,dumfnm(j))
          endif
        enddo 
      enddo
      do i=1,nunit
        if (irw(i).eq.1) then
          open(unit=iunit(i),file=dumfnm(i),status="old",
     &      form=forma(i),err=11)
        endif
      enddo
#ifdef MPI
      do i=1,nunit
        if (irw(i).eq.0) then
          write (fname,'(2a,bz,i3.3)') 
     &      dumfnm(i)(:ilen(dumfnm(i))),'_',taskid
          if (iovrd(i).eq.0 .or. overwrite) then
            open(unit=iunit(i),file=fname,status="unknown",
     &       form=forma(i),err=12)
          else
            open(unit=iunit(i),file=fname,status="new",
     &       form=forma(i),err=12)
          endif
        endif
      enddo
#else
      do i=1,nunit
        if (irw(i).eq.0) then
          fname=dumfnm(i)
          if (iovrd(i).eq.0 .or. overwrite) then
            open(unit=iunit(i),file=fname,status="unknown",err=12)
          else
            open(unit=iunit(i),file=fname,status="new",err=12)
          endif
        endif
      enddo
#endif
      return
   11 print *,"Error opening input file ",dumfnm(i)(:ilen(dumfnm(i)))
      stop 8886
   12 print *,"Error opening output file ",fname(:ilen(fname))
      stop 8887
      end
