      program xdrfpdb
!      implicit real*8 (a-h,o-z)
!      include 'DIMENSIONS'
!      include 'COMMON.CHAIN'
!      include 'COMMON.INTERACT'
!      include 'COMMON.SBRIDGE'
      use geometry_data, only: nres,c,nfrag
      use energy_data, only: itype,nnt,nct,nss,ihpb,jhpb,uconst_back
      use io_base!, only: maxres,ucase,iblnk,rescode,pdbout

      implicit none
      real(kind=4),allocatable,dimension(:,:) :: coord !(3,2*maxres)
      real(kind=4) :: prec,time,potE,uconst,t_bath,qfrag(100)
      real(kind=8) :: etot
      character(len=80) arg,seqfile,pdbfileX
      character(len=3),allocatable,dimension(:) :: sequenc !(maxres)
      character(len=50) tytul
      character(len=8) onethree,cfreq
!      external ucase
      logical :: oneletter
!      integer rescode
!      external rescode
!      logical iblnk
!      external iblnk
!el local variables      
      integer :: i,ii,j,k,kk,is,ie,ifreq,mnum,molec,iext,isize
      integer :: iret,ixdrf

      ifreq=1
      is=1
      ie=1000000000
      nres=0
      mnum=1
      molec=1
      allocate(sequenc(maxres))
      allocate(itype(maxres,5))
!      allocate(c(3,2*maxres+2))
      if (iargc().lt.3) then
        print '(2a)',&
          "Usage: xdrf2pdb one/three seqfile cxfile [freq]",&
          " [start] [end] [pdbfile]"
        stop
      endif
      call getarg(1,onethree)
      onethree = ucase(onethree)
      if (onethree.eq.'ONE') then
        oneletter = .true.
      else if (onethree.eq.'THREE') then
        oneletter = .false.
      else
        print *,"ONE or THREE must be specified"
      endif
      call getarg(2,seqfile)
      open (1,file=seqfile,status='old')
      if (oneletter) then
        read(1,'(80a1)',end=10,err=10) (sequenc(i)(1:1),i=1,maxres)
   10   continue
        nres=i
        i=0
        do while (.not.iblnk(sequenc(i+1)(1:1)))
          i=i+1
        enddo 
        nres=i
        do i=1,nres
          itype(i,mnum)=rescode(i,sequenc(i),1,molec)
        enddo
      else
        read(1,'(20(a3,1x))',end=11,err=11) (sequenc(i),i=1,maxres)
   11   continue
        nres=i
        i=0
        do while (.not.iblnk(sequenc(i+1)(1:1)))
          i=i+1
        enddo 
        nres=i
        do i=1,nres
          itype(i,mnum)=rescode(i,sequenc(i),0,molec)
        enddo
      endif
      call getarg(3,arg)
      iext = index(arg,'.cx') - 1
      if (iext.lt.0) then
        print *,"Error - not a cx file"
        stop
      endif
      if (iargc().gt.3) then
        call getarg(4,cfreq)
        read (cfreq,*) ifreq
      endif
      if (iargc().gt.4) then
        call getarg(5,cfreq)
        read (cfreq,*) is
      endif
      if (iargc().gt.5) then
        call getarg(6,cfreq)
        read (cfreq,*) ie
      endif
      if (iargc().gt.6) then
        call getarg(7,pdbfileX)
      else
        pdbfileX=arg(:iext)//'.pdb'
      endif
      open(9,file=pdbfileX)
      nnt = 1
      if (itype(1,mnum).eq.ntyp1) nnt = 2
      nct=nres
      if (itype(nres,mnum).eq.ntyp1) nct = nres-1
      print *,"nnt",nnt," nct",nct," nres",nres
      print *,"file",arg
      call xdrfopen(ixdrf,arg, "r", iret)
      if (iret.eq.0) stop
      print *,"iret",iret
      print *,"is",is," ie",ie
      kk = 0
      allocate(coord(3,2*nres))
      allocate(c(3,2*nres))
      do while(is.eq.0 .or. kk.lt.ie) 
       call xdrffloat(ixdrf, time, iret)
       print *,"time",time," iret",iret
       if(iret.eq.0) exit
       kk = kk + 1
       call xdrffloat(ixdrf, potE, iret)
       call xdrffloat(ixdrf, uconst, iret)
       print *,"potE",potE," uconst",uconst
       call xdrffloat(ixdrf, uconst_back, iret)
       call xdrffloat(ixdrf, t_bath, iret)
       print *,"t_bath",t_bath
!#ifdef NEWUNRES
!#endif
       print *,"uconst_back",uconst_back
!       call xdrffloat(ixdrf, t_bath, iret)
!       print *,"t_bath",t_bath
       call xdrfint(ixdrf, nss, iret) 
       do j=1,nss
        call xdrfint(ixdrf, ihpb(j), iret)
        call xdrfint(ixdrf, jhpb(j), iret)
       enddo
       print *,"nss",nss
!       call xdrffloat(ixdrf, t_bath, iret)
!       print *,"t_bath",t_bath
       call xdrfint(ixdrf, nfrag, iret)
       do i=1,nfrag
        call xdrffloat(ixdrf, qfrag(i), iret)
       enddo
       print *,"nfrag",nfrag
       prec=10000.0

       isize=0
       call xdrf3dfcoord(ixdrf, coord, isize, prec, iret)


!       write (*,'(e15.8,2e15.5,f12.5,$)') time,potE,uconst,t_bath
!       write (*,'(i4,$)') nss,(ihpb(j),jhpb(j),j=1,nss)
!       write (*,'(i4,20f7.4)') nfrag,(qfrag(i),i=1,nfrag)
       do j=1,isize
       write (*,'(3f10.5,i3)') (coord(k,j),k=1,3),j
       enddo
       if (kk.ge.is .and. mod(kk,ifreq).eq.0) then
         if (isize .ne. nres+nct-nnt+1) then
           print *,"Error: inconsistent sizes",isize,nres+nct-nnt+1
         endif
         do i=1,nres
           do j=1,3
             c(j,i)=coord(j,i)
           enddo
         enddo
         ii = 0
         do i=nnt,nct
           ii = ii + 1 
           do j=1,3
             c(j,i+nres)=coord(j,ii+nres)
           enddo
         enddo
!       do j=1,nres
!         write (*,'(8f10.5)') (c(k,j),k=1,3),(c(i,j+nres),i=1,3)
!       enddo
         etot=potE
         write (tytul,'(a,i6,a,f8.3)') "Structure",kk,"Temp",t_bath
         call pdbout(etot,tytul,9)
       endif
      enddo
     
      end
