      module wham_data
!---------------------------------------------------------------------------
!---------------------------------------------------------------------------
      integer,parameter :: max_eneW=57
      integer,parameter :: maxQ=1
      integer,parameter :: maxQ1=MaxQ+2
      integer,parameter :: max_parm=1
      integer,parameter :: MaxSlice=40
      integer,parameter :: MaxN=100
      integer,parameter :: MaxR=1
      integer,parameter :: MaxT_h=32
      integer,parameter :: maxstr=200000
      integer,parameter :: maxfile_prot=100
! Maximum number of structures to be dealt with by one processor
      integer,parameter :: maxstr_proc=10000
      integer :: n_eneW
      integer :: ijunk
!---------------------------------------------------------------------------

!---------------------------------------------------------------------------
! DIMENSIONS.COMPAR
! Array dimensions for level-based conformation comparison program:
!
! Max. number of conformations in the data set.
!
!      integer maxconf
!      PARAMETER (MAXCONF=maxstr_proc)
!
! Max. number levels of comparison
!
!      integer maxlevel
!      PARAMETER (MAXLEVEL=3)
!
! Max. number of fragments at a given level of comparison
!
      integer,parameter :: maxfrag=30
      integer,parameter :: MMAXFRAG=MAXFRAG*(MAXFRAG+1)/2
!
! Max. number of pieces forming a substructure to be compared
!
      integer,parameter :: MAXPIECE=20
!
!---------------------------------------------------------------------------
!---------------------------------------------------------------------------
!  COMMON.WEIGHTS
!      common /chujec/
      real(kind=8),dimension(:),allocatable :: ww,ww0,ww_low,ww_up,&
          ww_orig	!(max_ene)
      real(kind=8),dimension(:),allocatable :: x_orig,x_up,x_low	!(max_paropt)
      real(kind=8),dimension(2,2) :: epp_low,epp_up,rpp_low,rpp_up,&
          elpp6_low,elpp6_up,elpp3_low,elpp3_up
      real(kind=8),dimension(13,3) :: b_low,b_up
      real(kind=8),dimension(:,:),allocatable :: epscp_low,epscp_up,&
          rscp_low,rscp_up	!(0:ntyp,2)
      real(kind=8),dimension(:),allocatable :: epss_low,epss_up	!(ntyp)
      real(kind=8),dimension(:),allocatable :: epsp_low,epsp_up !(nntyp)
      real(kind=8),dimension(:,:),allocatable :: xm,xm1,&
          xm2	!(max_paropt,0:maxprot)

      integer,dimension(:),allocatable :: imask,iwW	!(max_ene)
      integer :: nsingle_sc,npair_sc
      integer,dimension(:),allocatable :: ityp_ssc !(ntyp)
      integer,dimension(:,:),allocatable :: ityp_psc !(2,nntyp)
      integer :: mask_elec(2,2,4),mask_fourier(13,3),mod_fourier(0:3)
      integer,dimension(:,:,:),allocatable :: mask_scp !(0:ntyp,2,2)
      integer,dimension(:,:),allocatable :: indz !(maxbatch+1,maxprot)
      logical :: mod_other_params,mod_elec,mod_scp,mod_side
!---------------------------------------------------------------------------
! COMMON.FREE
!      common /wham/
      integer :: nQ,nparmset,rescale_modeW,iparmprint,myparm
      integer,dimension(:),allocatable :: stot !(maxslice)
      logical :: hamil_rep,separate_parset
      real(kind=8),dimension(:,:,:,:),allocatable :: Kh,q0 !(MaxQ,MaxR,MaxT_h,max_parm)
      real(kind=8) :: delta,deltrms,deltrgy,fimin
      real(kind=8),dimension(:,:,:),allocatable :: f !(maxR,maxT_h,max_parm)
      real(kind=8),dimension(:,:),allocatable :: beta_h !(MaxT_h,max_parm)
      integer,dimension(:,:),allocatable  :: nR,nRR !(maxT_h,max_parm)
      integer,dimension(:,:,:,:),allocatable :: snk !(MaxR,MaxT_h,max_parm,MaxSlice)
      integer,dimension(:),allocatable :: nT_h !(max_parm)
      integer :: maxit
      integer,dimension(:,:),allocatable :: totraj !(maxR,max_parm)
      logical,dimension(:),allocatable :: replica,umbrella,read_iset !(max_parm)
!---------------------------------------------------------------------------
! COMMON.PROT
!      common /protein/
      integer,dimension(:),allocatable :: ntot	!(maxslice)
      integer,dimension(:),allocatable :: isampl	!(max_parm)
      integer :: nslice
!---------------------------------------------------------------------------
! COMMON.PROTFILES
!      common /protfil/
      character(len=80),dimension(:,:,:,:,:),allocatable :: protfiles !(maxfile_prot,2,MaxR,MaxT_h,Max_Parm)
      character(len=80) :: bprotfiles
      integer,dimension(:,:,:),allocatable :: nfile_bin,nfile_asc,&
         nfile_cx,rec_start,rec_end !(MaxR,MaxT_h,Max_Parm)
      integer :: lenrec,lenrec1,lenrec2
!---------------------------------------------------------------------------
! COMMON.ENERGIES
!      common /energies/
      real(kind=8),dimension(:,:),allocatable :: potE !(MaxStr_Proc,Max_Parm)
      real(kind=8),dimension(:),allocatable :: entfac !(MaxStr_Proc)
      real(kind=8),dimension(:,:),allocatable :: q !(MaxQ+2,MaxStr_Proc)
      real(kind=8),dimension(:,:,:),allocatable :: enetb !(max_ene,MaxStr_Proc,Max_Parm)
      integer :: einicheck
!---------------------------------------------------------------------------
! COMMON.CONTROL
!      common /cntrl/ 
      logical :: punch_dist,print_rms,caonly,verbose,merge_helices,&
        bxfile,cxfile,histfile,entfile,zscfile,rmsrgymap,&
        with_dihed_constr,check_conf,histout
      integer :: icomparfunc,pdbint,ensembles,oldion,shield_mode
!---------------------------------------------------------------------------
! COMMON.OBCINKA
!      common /obcinka/
      real(kind=8),dimension(:,:,:),allocatable :: time_start_collect,&
        time_end_collect !(maxR,MaxT_h,Max_Parm)
!---------------------------------------------------------------------------
! COMMON.PEPTCONT
!      common /peptcont/
      integer :: ncont_pept_ref
      integer,dimension(:,:),allocatable :: icont_pept_ref !(2,maxcont)
      integer,dimension(:),allocatable :: ncont_frag_ref !(mmaxfrag)
      integer,dimension(:,:,:),allocatable :: icont_frag_ref !(2,maxcont,mmaxfrag)
      integer,dimension(:),allocatable :: isec_ref !(maxres)
!---------------------------------------------------------------------------
! COMMON.CONTPAR
!      common /contpar/ 
!      real(kind=8),dimension(:,:),allocatable :: sig_comp,chi_comp,&
!        chip_comp,sc_cutoff !(ntyp,ntyp)
!---------------------------------------------------------------------------
      end module wham_data
