#!/bin/bash

if [ "$1" == "1L2Y_wham" ]; then
 file=1L2Y_wham.thermal
else
 exit 1
fi

# Check if file exist
if [ ! -f $file ]; then
    echo "CRITICAL: out $file do not exist"
    exit 2
fi

error=0
max=`awk '{print $1,$7*1}' $file | sort -n -k 2 | awk 'END{print $1}'`
echo 'T of max Cv(T) ' $max
rms=`awk '{if ($1<260) {a=a+$5;n++}}END{print a/n}' $file`
echo 'average rms for T<260 ' $rms

 if [ `grep differs 1L2Y_wham.out* |wc -l` != "0" ]; then
  echo 'ERROR: energy differs remarkably from  the value read in'  
  echo 'first 10 warnings'
  grep differs 1L2Y_wham.out*|head -10
  error=1
 fi

 if [ `echo "a=$max-316;if(0>a)a*=-1;a>10.0"|bc -l` != "0" ]; then
  echo 'ERROR wrong T max of Cv(T) by more than 10 K'
  error=1
 fi

 if [ `echo "a=$rms-3.0;if(0>a)a*=-1;a>0.2"|bc -l` != "0" ]; then
  echo 'ERROR wrong average rms for T<260 by more than 0.2'
  error=1
 fi

 if [ "$error" != "0" ];then
   exit 1
 fi
 