      module io_wham

      use io_units
      use io_base
      use wham_data
#ifndef CLUSTER
      use w_compar_data
#endif
!      use geometry_data
!      use geometry
      implicit none
!-----------------------------------------------------------------------------
!
!
!-----------------------------------------------------------------------------
      contains
!-----------------------------------------------------------------------------
! openunits.F
!-----------------------------------------------------------------------------
#ifndef CLUSTER
      subroutine openunits
#ifdef WIN
      use dfport
#endif
!      implicit real*8 (a-h,o-z)
!      include 'DIMENSIONS'    
!      include 'DIMENSIONS.ZSCOPT'
#ifdef MPI
      use MPI_data
      include 'mpif.h'
!      include 'COMMON.MPI'
!      integer :: MyRank
      character(len=3) :: liczba
#endif
!      include 'COMMON.IOUNITS'
      integer :: lenpre,lenpot !,ilen
!el      external ilen

#ifdef MPI
      MyRank=Me
#endif
      call mygetenv('PREFIX',prefix)
      call mygetenv('SCRATCHDIR',scratchdir)
      call mygetenv('POT',pot)
      lenpre=ilen(prefix)
      lenpot=ilen(pot)
      call mygetenv('POT',pot)
      entname=prefix(:lenpre)//'_'//pot(:lenpot)//'.entr'
! Get the names and open the input files
      open (1,file=prefix(:ilen(prefix))//'.inp',status='old')
! Get parameter filenames and open the parameter files.
      call mygetenv('BONDPAR',bondname)
      open (ibond,file=bondname,status='old')
      call mygetenv('BONDPAR_NUCL',bondname_nucl)
      open (ibond_nucl,file=bondname_nucl,status='old')
      call mygetenv('THETPAR',thetname)
      open (ithep,file=thetname,status='old')
      call mygetenv('ROTPAR',rotname)
      open (irotam,file=rotname,status='old')
      call mygetenv('TORPAR',torname)
      open (itorp,file=torname,status='old')
      call mygetenv('TORDPAR',tordname)
      open (itordp,file=tordname,status='old')
      call mygetenv('FOURIER',fouriername)
      open (ifourier,file=fouriername,status='old')
      call mygetenv('SCCORPAR',sccorname)
      open (isccor,file=sccorname,status='old')
      call mygetenv('ELEPAR',elename)
      open (ielep,file=elename,status='old')
      call mygetenv('SIDEPAR',sidename)
      open (isidep,file=sidename,status='old')
      call mygetenv('SIDEP',sidepname)
      open (isidep1,file=sidepname,status="old")
      call mygetenv('THETPAR_NUCL',thetname_nucl)
      open (ithep_nucl,file=thetname_nucl,status='old')
      call mygetenv('ROTPAR_NUCL',rotname_nucl)
      open (irotam_nucl,file=rotname_nucl,status='old')
      call mygetenv('TORPAR_NUCL',torname_nucl)
      open (itorp_nucl,file=torname_nucl,status='old')
      call mygetenv('TORDPAR_NUCL',tordname_nucl)
      open (itordp_nucl,file=tordname_nucl,status='old')
      call mygetenv('SIDEPAR_NUCL',sidename_nucl)
      open (isidep_nucl,file=sidename_nucl,status='old')
      call mygetenv('SIDEPAR_SCBASE',sidename_scbase)
      open (isidep_scbase,file=sidename_scbase,status='old')
      call mygetenv('PEPPAR_PEPBASE',pepname_pepbase)
      open (isidep_pepbase,file=pepname_pepbase,status='old')
      call mygetenv('SCPAR_PHOSPH',pepname_scpho)
      open (isidep_scpho,file=pepname_scpho,status='old')
      call mygetenv('PEPPAR_PHOSPH',pepname_peppho)
      open (isidep_peppho,file=pepname_peppho,status='old')
      call mygetenv('LIPTRANPAR',liptranname)
      open (iliptranpar,file=liptranname,status='old',action='read')
      call mygetenv('TUBEPAR',tubename)
      open (itube,file=tubename,status='old',action='read')
      call mygetenv('IONPAR',ionname)
      open (iion,file=ionname,status='old',action='read')
#ifdef SC_END
      call mygetenv('ROTPAR_END',rotname_end)
      open (irotam_end,file=rotname_end,status='old',action='read')
#endif


      call mygetenv('SCPPAR_NUCL',scpname_nucl)
      open (iscpp_nucl,file=scpname_nucl,status='old')
      call mygetenv('IONPAR_NUCL',ionnuclname)
      open (iionnucl,file=ionnuclname,status='old')
      call mygetenv('IONPAR_TRAN',iontranname)
      open (iiontran,file=iontranname,status='old',action='read')


#ifndef OLDSCP
!
! 8/9/01 In the newest version SCp interaction constants are read from a file
! Use -DOLDSCP to use hard-coded constants instead.
!
      call mygetenv('SCPPAR',scpname)
      open (iscpp,file=scpname,status='old')
#endif
#ifdef MPL
      if (MyID.eq.BossID) then
      MyRank = MyID/fgProcs
#endif
#ifdef MPI
      print *,'OpenUnits: processor',MyRank
      call numstr(MyRank,liczba)
      outname=prefix(:lenpre)//'.out_'//pot(:lenpot)//liczba
#else
      outname=prefix(:lenpre)//'.out_'//pot(:lenpot)
#endif
      open(iout,file=outname,status='unknown')
      write (iout,'(80(1h-))')
      write (iout,'(30x,a)') "FILE ASSIGNMENT"
      write (iout,'(80(1h-))')
      write (iout,*) "Input file                      : ",&
        prefix(:ilen(prefix))//'.inp'
      write (iout,*) "Output file                     : ",&
        outname(:ilen(outname))
      write (iout,*)
      write (iout,*) "Sidechain potential file        : ",&
        sidename(:ilen(sidename))
#ifndef OLDSCP
      write (iout,*) "SCp potential file              : ",&
        scpname(:ilen(scpname))
#endif  
      write (iout,*) "Electrostatic potential file    : ",&
        elename(:ilen(elename))
      write (iout,*) "Cumulant coefficient file       : ",&
        fouriername(:ilen(fouriername))
      write (iout,*) "Torsional parameter file        : ",&
        torname(:ilen(torname))
      write (iout,*) "Double torsional parameter file : ",&
        tordname(:ilen(tordname))
      write (iout,*) "Backbone-rotamer parameter file : ",&
        sccorname(:ilen(sccorname))
      write (iout,*) "Bond & inertia constant file    : ",&
        bondname(:ilen(bondname))
      write (iout,*) "Bending parameter file          : ",&
        thetname(:ilen(thetname))
      write (iout,*) "Rotamer parameter file          : ",&
        rotname(:ilen(rotname))
      write (iout,'(80(1h-))')
      write (iout,*)
      return
      end subroutine openunits
!-----------------------------------------------------------------------------
! molread_zs.F
!-----------------------------------------------------------------------------
      subroutine molread(*)
!
! Read molecular data.
!
      use energy_data
      use geometry_data, only:nres,deg2rad,c,dc,nres_molec,crefjlee,cref
      use control_data, only:iscode,pdbref,indpdb,symetr
      use io_base, only:rescode
      use control, only:setup_var,init_int_table,hpb_partition
      use geometry, only:alloc_geo_arrays
      use energy, only:alloc_ener_arrays     
!      implicit real*8 (a-h,o-z)
!      include 'DIMENSIONS'
!      include 'DIMENSIONS.ZSCOPT'
!      include 'COMMON.IOUNITS'
!      include 'COMMON.GEO'
!      include 'COMMON.VAR'
!      include 'COMMON.INTERACT'
!      include 'COMMON.LOCAL'
!      include 'COMMON.NAMES'
!      include 'COMMON.CHAIN'
!      include 'COMMON.FFIELD'
!      include 'COMMON.SBRIDGE'
!      include 'COMMON.TORCNSTR'
!      include 'COMMON.CONTROL'
      character(len=4),dimension(:),allocatable :: sequence !(nres)
!el      integer :: rescode
!el      real(kind=8) :: x(maxvar)
      character(len=320) :: controlcard !,ucase
      integer,dimension(nres,5) :: itype_pdb !(maxres)
      integer :: i,j,i1,i2,it1,it2,mnum
      real(kind=8) :: scalscp
!el      logical :: seq_comp
      write(iout,*) "START MOLREAD" 
      call flush(iout)
      do i=1,5
       nres_molec(i)=0
       print *,"nres_molec, initial",nres_molec(i)
      enddo
     
      call card_concat(controlcard,.true.)
      call reada(controlcard,'SCAL14',scal14,0.4d0)
      call reada(controlcard,'SCALSCP',scalscp,1.0d0)
      call reada(controlcard,'CUTOFF',cutoff_corr,7.0d0)
      call reada(controlcard,'TEMP0',temp0,300.0d0) !el
      call reada(controlcard,'DELT_CORR',delt_corr,0.5d0)
      r0_corr=cutoff_corr-delt_corr
      call readi(controlcard,"NRES",nres_molec(1),0)
      call readi(controlcard,"NRES_NUCL",nres_molec(2),0)
      call readi(controlcard,"NRES_CAT",nres_molec(5),0)
      nres=0
      do i=1,5
       nres=nres_molec(i)+nres
      enddo
!      allocate(sequence(nres+1))
!el znamy juz ilosc reszt wiec mozna zaalokowac tablice do liczenia enerii
      call alloc_geo_arrays
      call alloc_ener_arrays
! alokacja dodatkowych tablic, ktore w unresie byly alokowanie w locie
!----------------------------
      allocate(c(3,2*nres+2))
      allocate(dc(3,0:2*nres+2))
      allocate(itype(nres+2,5))
      allocate(itel(nres+2))
      if (.not. allocated(molnum)) allocate(molnum(nres+2))
!
! Zero out tableis.
      do i=1,2*nres+2
        do j=1,3
          c(j,i)=0.0D0
          dc(j,i)=0.0D0
        enddo
      enddo
      do i=1,nres+2
        molnum(i)=0
        do j=1,5
        itype(i,j)=0
        enddo
        itel(i)=0
      enddo
!--------------------------
!
      allocate(sequence(nres+1))
      iscode=index(controlcard,"ONE_LETTER")
      if (nres.le.0) then
        write (iout,*) "Error: no residues in molecule"
        return 1
      endif
      if (nres.gt.maxres) then
        write (iout,*) "Error: too many residues",nres,maxres
      endif
      write(iout,*) 'nres=',nres
! HERE F**** CHANGE
! Read sequence of the protein
      if (iscode.gt.0) then
        read (inp,'(80a1)') (sequence(i)(1:1),i=1,nres)
      else
        read (inp,'(20(1x,a3))') (sequence(i),i=1,nres)
      endif
! Convert sequence to numeric code
      do i=1,nres_molec(1)
        mnum=1
        molnum(i)=1
        itype(i,mnum)=rescode(i,sequence(i),iscode,mnum)
      enddo
      do i=nres_molec(1)+1,nres_molec(1)+nres_molec(2)
        mnum=2
        molnum(i)=2
        itype(i,mnum)=rescode(i,sequence(i),iscode,mnum)
      enddo
      do i=nres_molec(1)+nres_molec(2)+1,nres_molec(1)+nres_molec(2)+nres_molec(5)
        mnum=5
        molnum(i)=5
        itype(i,mnum)=rescode(i,sequence(i),iscode,mnum)
      enddo

      write (iout,*) "Numeric code:"
      write (iout,'(20i4)') (itype(i,molnum(i)),i=1,nres)
      do i=1,nres-1
        mnum=molnum(i)
#ifdef PROCOR
        if (itype(i,mnum).eq.ntyp1_molec(mnum) .or. itype(i+1,mnum).eq.ntyp1_molec(mnum)) then
#else
        if (itype(i,mnum).eq.ntyp1_molec(mnum)) then
#endif
          itel(i)=0
#ifdef PROCOR
        else if (iabs(itype(i+1,mnum)).ne.20) then
#else
        else if (iabs(itype(i,mnum)).ne.20) then
#endif
          itel(i)=1
        else
          itel(i)=2
        endif
      enddo
       write (iout,*) "ITEL"
       do i=1,nres-1
         mnum=molnum(i)
         write (iout,*) i,itype(i,mnum),itel(i)
       enddo
      write(iout,*) 
      call read_bridge

      if (with_dihed_constr) then

      read (inp,*) ndih_constr
      if (ndih_constr.gt.0) then
        read (inp,*) ftors
        write (iout,*) 'FTORS',ftors
        read (inp,*) (idih_constr(i),phi0(i),drange(i),i=1,ndih_constr)
        write (iout,*) &
         'There are',ndih_constr,' constraints on phi angles.'
        do i=1,ndih_constr
          write (iout,'(i5,2f8.3)') idih_constr(i),phi0(i),drange(i)
        enddo
        do i=1,ndih_constr
          phi0(i)=deg2rad*phi0(i)
          drange(i)=deg2rad*drange(i)
        enddo
      endif

      endif
      nnt=1
      nct=nres
      allocate(ireschain(nres))
      ireschain=0
      write(iout,*),"before seq2chains",ireschain
      call seq2chains
      write(iout,*) "after seq2chains",nchain
      allocate ( chain_border1(2,nchain))
      chain_border1(1,1)=1
      chain_border1(2,1)=chain_border(2,1)+1
      do i=2,nchain-1
        chain_border1(1,i)=chain_border(1,i)-1
        chain_border1(2,i)=chain_border(2,i)+1
      enddo
      if (nchain.gt.1) chain_border1(1,nchain)=chain_border(1,nchain)-1
      chain_border1(2,nchain)=nres
      write(iout,*) "nres",nres," nchain",nchain
      do i=1,nchain
        write(iout,*)"chain",i,chain_length(i),chain_border(1,i),&
         chain_border(2,i),chain_border1(1,i),chain_border1(2,i)
      enddo
      allocate(tabpermchain(50,5040))
      if (symetr.eq.1) then
        npermchain=1
        tabpermchain(1,1)=1
      else
      call chain_symmetry(npermchain,tabpermchain)
      endif
      print *,'NNT=',NNT,' NCT=',NCT

      if (itype(1,molnum(1)).eq.ntyp1_molec(molnum(1))) nnt=2
      if (itype(nres,molnum(nres)).eq.ntyp1_molec(molnum(nres))) nct=nct-1
      write(iout,*) 'NNT=',NNT,' NCT=',NCT
      if (constr_homology.gt.0) then
!c       write (iout,*) "About to call read_constr_homology"
!c       call flush(iout)
        call read_constr_homology
!c       write (iout,*) "Exit read_constr_homology"
!c       call flush(iout)
        if (indpdb.gt.0 .or. pdbref) then
          do i=1,2*nres
            do j=1,3
              c(j,i)=crefjlee(j,i)
              cref(j,i,1)=crefjlee(j,i)
            enddo
          enddo
        endif
        endif
#ifdef DEBUG
        write (iout,*) "Array C"
        do i=1,nres
          write (iout,'(i5,3f8.3,5x,3f8.3)') i,(c(j,i),j=1,3),
     &      (c(j,i+nres),j=1,3)
        enddo
        write (iout,*) "Array Cref"
        do i=1,nres
          write (iout,'(i5,3f8.3,5x,3f8.3)') i,(cref(j,i,1),j=1,3),
     &      (cref(j,i+nres,1),j=1,3)
        enddo
#endif
      call setup_var
      call init_int_table
      if (ns.gt.0) then
        write (iout,'(/a,i3,a)') 'The chain contains',ns,&
        ' disulfide-bridging cysteines.'
        write (iout,'(20i4)') (iss(i),i=1,ns)
        write (iout,'(/a/)') 'Pre-formed links are:' 
        do i=1,nss
          mnum=molnum(i)
	  i1=ihpb(i)-nres
	  i2=jhpb(i)-nres
	  it1=itype(i1,mnum)
	  it2=itype(i2,mnum)
         write (iout,'(2a,i3,3a,i3,a,3f10.3)') &
          restyp(it1,molnum(i1)),'(',i1,') -- ',restyp(it2,molnum(i2)),'(',i2,')',&
          dhpb(i),ebr,forcon(i)
        enddo
      endif
      if (ns.gt.0.and.dyn_ss) then
          do i=nss+1,nhpb
            ihpb(i-nss)=ihpb(i)
            jhpb(i-nss)=jhpb(i)
            forcon(i-nss)=forcon(i)
            dhpb(i-nss)=dhpb(i)
          enddo
          nhpb=nhpb-nss
          nss=0
          call hpb_partition
          do i=1,ns
            dyn_ss_mask(iss(i))=.true.
          enddo
      endif
      write (iout,'(a)')
      return
      end subroutine molread
!-----------------------------------------------------------------------------
! parmread.F
!-----------------------------------------------------------------------------
      subroutine parmread(iparm,*)
#else
      subroutine parmread
#endif
!
! Read the parameters of the probability distributions of the virtual-bond
! valence angles and the side chains and energy parameters.
!
      use wham_data

      use geometry_data
      use energy_data
      use control_data, only: maxterm,maxlor,maxterm_sccor,& !maxtor
          maxtermd_1,maxtermd_2,tor_mode,scelemode !,maxthetyp,maxthetyp1
      use MD_data
!el      use MPI_data
!el      use map_data
      use io_config, only: printmat
      use control, only: getenv_loc

#ifdef MPI
      use MPI_data
      include "mpif.h"
      integer :: IERROR
#endif
!      implicit real*8 (a-h,o-z)
!      include 'DIMENSIONS'
!      include 'DIMENSIONS.ZSCOPT'
!      include 'DIMENSIONS.FREE'
!      include 'COMMON.IOUNITS'
!      include 'COMMON.CHAIN'
!      include 'COMMON.INTERACT'
!      include 'COMMON.GEO'
!      include 'COMMON.LOCAL'
!      include 'COMMON.TORSION'
!      include 'COMMON.FFIELD'
!      include 'COMMON.NAMES'
!      include 'COMMON.SBRIDGE'
!      include 'COMMON.WEIGHTS'
!      include 'COMMON.ENEPS'
!      include 'COMMON.SCCOR'
!      include 'COMMON.SCROT'
!      include 'COMMON.FREE'
      character(len=1) :: t1,t2,t3
      character(len=1) :: onelett(4) = (/"G","A","P","D"/)
      character(len=1) :: toronelet(-2:2) = (/"p","a","G","A","P"/)
      logical :: lprint,SPLIT_FOURIERTOR
      real(kind=8),dimension(3,3,maxlob) :: blower      !(3,3,maxlob)
      character(len=800) :: controlcard
      character(len=256) :: bondname_t,thetname_t,rotname_t,torname_t,&
        tordname_t,fouriername_t,elename_t,sidename_t,scpname_t,&
        sccorname_t
!el      integer ilen
!el   external ilen
      character(len=16) :: key
      integer :: iparm,nkcctyp
!el      real(kind=8) :: ip,mp
      real(kind=8) :: dwa16,akl,si,rri,epsij,rrij,sigeps,sigt1sq,epsijlip,&
                sigt2sq,sigii1,sigii2,ratsig1,ratsig2,rsum_max,r_augm,    &
                epspeptube,epssctube,sigmapeptube,      &
                sigmasctube,ssscale

      real(kind=8) :: v0ij,v0ijsccor,v0ijsccor1,v0ijsccor2,v0ijsccor3,rjunk,&
                res1
      integer :: i,j,ichir1,ichir2,k,l,m,kk,ii,mm,junk,lll,ll,llll,n,jj
      integer :: nlobi,iblock,maxinter,iscprol,ncatprotparm
      character*3 string
      
!
! Body
!
! Set LPRINT=.TRUE. for debugging
      dwa16=2.0d0**(1.0d0/6.0d0)
      lprint=.false.
      itypro=20
! Assign virtual-bond length
      vbl=3.8D0
      vblinv=1.0D0/vbl
      vblinv2=vblinv*vblinv
      itime_mat=0
#ifndef CLUSTER
      call card_concat(controlcard,.true.)
      wname(4)="WCORRH"
!el
      call reada(controlcard,"D0CM",d0cm,3.78d0)
      call reada(controlcard,"AKCM",akcm,15.1d0)
      call reada(controlcard,"AKTH",akth,11.0d0)
      call reada(controlcard,"AKCT",akct,12.0d0)
      call reada(controlcard,"V1SS",v1ss,-1.08d0)
      call reada(controlcard,"V2SS",v2ss,7.61d0)
      call reada(controlcard,"V3SS",v3ss,13.7d0)
      call reada(controlcard,"EBR",ebr,-5.50D0)
      call reada(controlcard,"ATRISS",atriss,0.301D0)
      call reada(controlcard,"BTRISS",btriss,0.021D0)
      call reada(controlcard,"CTRISS",ctriss,1.001D0)
      call reada(controlcard,"DTRISS",dtriss,1.001D0)
      call reada(controlcard,"SSSCALE",ssscale,1.0D0)
      dyn_ss=(index(controlcard,'DYN_SS').gt.0)
      call reada(controlcard,"LIPSCALE",lipscale,1.0D0)
allocate(ww(max_eneW))
      do i=1,n_eneW
        key = wname(i)(:ilen(wname(i)))
       
        call reada(controlcard,key(:ilen(key)),ww(i),1.0d0)
        write(iout,*) "NAMES ",key(:ilen(key)),ww(i),i
      enddo

      write (iout,*) "iparm",iparm," myparm",myparm
! If reading not own parameters, skip assignment

      if (iparm.eq.myparm .or. .not.separate_parset) then

!
! Setup weights for UNRES
!
      wsc=ww(1)
      wscp=ww(2)
      welec=ww(3)
      wcorr=ww(4)
      wcorr5=ww(5)
      wcorr6=ww(6)
      wel_loc=ww(7)
      wturn3=ww(8)
      wturn4=ww(9)
      wturn6=ww(10)
      wang=ww(11)
      wscloc=ww(12)
      wtor=ww(13)
      wtor_d=ww(14)
      wstrain=ww(15)
      wvdwpp=ww(16)
      wbond=ww(18)
      wsccor=ww(19)
      wcatcat=ww(42)
      wcatprot=ww(41)
      wcorr3_nucl=ww(38)
      write(iout,*) "CZY TU BLAD", ww(38)
      wcorr_nucl=ww(37)
      wtor_d_nucl=ww(36)
      wtor_nucl=ww(35)
      wsbloc=ww(34)
      wang_nucl=ww(33)
      wbond_nucl=ww(32)
      welsb=ww(31)
      wvdwsb=ww(30)
      welpsb=ww(29)
      wvdwpsb=ww(28)
      welpp=ww(27)
      wvdwpp_nucl=ww(26)
      wscbase=ww(46)
      wpepbase=ww(47)
      wscpho=ww(48)
      wpeppho=ww(49)
      wcatnucl=ww(50)
      wcat_tran=ww(56)
!      print *,"KURWA",ww(48)
!        "WSCBASE   ","WPEPBASE  ","WSCPHO    ","WPEPPHO   "
!        "WVDWPP    ","WELPP     ","WVDWPSB   ","WELPSB    ","WVDWSB    ",&
!        "WELSB     ","WBOND     ","WANG      ","WSBLOC    ","WTOR      ",&
!        "WTORD     ","WCORR     ","WCORR3    ","WNULL     ","WNULL     ",&
!        "WCATPROT  ","WCATCAT  
!       +wbond_nucl*estr_nucl+wang_nucl*ebe_nucl&
!       +wvdwpp_nucl*evdwpp+welpp*eespp+wvdwpsb*evdwpsb+welpsb*eelpsb&
!       +wvdwsb*evdwsb+welsb*eelsb+wsbloc*esbloc+wtor_nucl*etors_nucl&
!       +wtor_d_nucl*etors_d_nucl+wcorr_nucl*ecorr_nucl+wcorr3_nucl*ecorr3_nucl&

      endif
!
!el------ 
      allocate(weights(n_ene))
      weights(1)=wsc
      weights(2)=wscp
      weights(3)=welec
      weights(4)=wcorr
      weights(5)=wcorr5
      weights(6)=wcorr6
      weights(7)=wel_loc
      weights(8)=wturn3
      weights(9)=wturn4
      weights(10)=wturn6
      weights(11)=wang
      weights(12)=wscloc
      weights(13)=wtor
      weights(14)=wtor_d
      weights(15)=wstrain !0
      weights(16)=wvdwpp !
      weights(17)=wbond
      weights(18)=0 !scal14 !
      weights(21)=wsccor
      weights(42)=wcatprot
      weights(41)=wcatcat
      weights(26)=    wvdwpp_nucl 

      weights(27) =welpp  
      weights(28) =wvdwpsb
      weights(29) =welpsb 
      weights(30) =wvdwsb 
      weights(31) =welsb  
      weights(32) =wbond_nucl  
      weights(33) =wang_nucl   
      weights(34) =wsbloc 
      weights(35) =wtor_nucl   
      weights(36) =wtor_d_nucl 
      weights(37) =wcorr_nucl  
      weights(38) =wcorr3_nucl 
      weights(41) =wcatcat
      weights(42) =wcatprot
      weights(46) =wscbase
      weights(47)= wpepbase
      weights(48) =wscpho
      weights(49) =wpeppho
      weights(50) =wcatnucl
      weights(56)=wcat_tran

! el--------
      call card_concat(controlcard,.false.)

! Return if not own parameters

      if (iparm.ne.myparm .and. separate_parset) return

      call reads(controlcard,"BONDPAR",bondname_t,bondname)
      open (ibond,file=bondname_t,status='old')
      rewind(ibond)
      call reads(controlcard,"THETPAR",thetname_t,thetname)
      open (ithep,file=thetname_t,status='old')
      rewind(ithep) 
      call reads(controlcard,"ROTPAR",rotname_t,rotname)
      open (irotam,file=rotname_t,status='old')
      rewind(irotam)
      call reads(controlcard,"TORPAR",torname_t,torname)
      open (itorp,file=torname_t,status='old')
      rewind(itorp)
      call reads(controlcard,"TORDPAR",tordname_t,tordname)
      open (itordp,file=tordname_t,status='old')
      rewind(itordp)
      call reads(controlcard,"SCCORPAR",sccorname_t,sccorname)
      open (isccor,file=sccorname_t,status='old')
      rewind(isccor)
      call reads(controlcard,"FOURIER",fouriername_t,fouriername)
      open (ifourier,file=fouriername_t,status='old')
      rewind(ifourier)
      call reads(controlcard,"ELEPAR",elename_t,elename)
      open (ielep,file=elename_t,status='old')
      rewind(ielep)
      call reads(controlcard,"SIDEPAR",sidename_t,sidename)
      open (isidep,file=sidename_t,status='old')
      rewind(isidep)
      call reads(controlcard,"SCPPAR",scpname_t,scpname)
      open (iscpp,file=scpname_t,status='old')
      rewind(iscpp)
      call getenv_loc('IONPAR',ionname)
      open (iion,file=ionname,status='old')
      rewind(iion)
      write (iout,*) "Parameter set:",iparm
      write (iout,*) "Energy-term weights:"
      do i=1,n_eneW
        write (iout,'(i3,a16,f10.5)') i,wname(i),ww(i)
      enddo
      write (iout,*) "Sidechain potential file        : ",&
        sidename_t(:ilen(sidename_t))
#ifndef OLDSCP
      write (iout,*) "SCp potential file              : ",&
        scpname_t(:ilen(scpname_t))
#endif  
      write (iout,*) "Electrostatic potential file    : ",&
        elename_t(:ilen(elename_t))
      write (iout,*) "Cumulant coefficient file       : ",&
        fouriername_t(:ilen(fouriername_t))
      write (iout,*) "Torsional parameter file        : ",&
        torname_t(:ilen(torname_t))
      write (iout,*) "Double torsional parameter file : ",&
        tordname_t(:ilen(tordname_t))
      write (iout,*) "Backbone-rotamer parameter file : ",&
        sccorname(:ilen(sccorname))
      write (iout,*) "Bond & inertia constant file    : ",&
        bondname_t(:ilen(bondname_t))
      write (iout,*) "Bending parameter file          : ",&
        thetname_t(:ilen(thetname_t))
      write (iout,*) "Rotamer parameter file          : ",&
        rotname_t(:ilen(rotname_t))
#endif
!
! Read the virtual-bond parameters, masses, and moments of inertia
! and Stokes' radii of the peptide group and side chains
!
      allocate(dsc(ntyp1)) !(ntyp1)
      allocate(dsc_inv(ntyp1)) !(ntyp1)
      allocate(nbondterm(ntyp)) !(ntyp)
      allocate(vbldsc0(maxbondterm,ntyp)) !(maxbondterm,ntyp)
      allocate(aksc(maxbondterm,ntyp)) !(maxbondterm,ntyp)
      allocate(nbondterm_nucl(ntyp_molec(2))) !(ntyp)
      allocate(vbldsc0_nucl(maxbondterm,ntyp_molec(2))) !(maxbondterm,ntyp)
      allocate(aksc_nucl(maxbondterm,ntyp_molec(2))) !(maxbondterm,ntyp)

!el      allocate(msc(ntyp+1)) !(ntyp+1)
!el      allocate(isc(ntyp+1)) !(ntyp+1)
!el      allocate(restok(ntyp+1)) !(ntyp+1)
      allocate(abond0(maxbondterm,ntyp)) !(maxbondterm,ntyp)

#ifdef CRYST_BOND
      read (ibond,*) vbldp0,akp
      do i=1,ntyp
        nbondterm(i)=1
        read (ibond,*) vbldsc0(1,i),aksc(1,i)
        dsc(i) = vbldsc0(1,i)
        if (i.eq.10) then
          dsc_inv(i)=0.0D0
        else
          dsc_inv(i)=1.0D0/dsc(i)
        endif
      enddo
#else
      read (ibond,*) ijunk,vbldp0,vbldpDUM,akp,rjunk
      do i=1,ntyp
        read (ibond,*) nbondterm(i),(vbldsc0(j,i),aksc(j,i),abond0(j,i),&
         j=1,nbondterm(i))
        dsc(i) = vbldsc0(1,i)
        if (i.eq.10) then
          dsc_inv(i)=0.0D0
        else
          dsc_inv(i)=1.0D0/dsc(i)
        endif
      enddo
#endif
      if (lprint) then
        write(iout,'(/a/)')"Force constants virtual bonds:"
        write (iout,'(a10,a3,6a10)') 'Type','N','VBL','K',&
         'inertia','Pstok'
        write(iout,'(a10,i3,6f10.5)') "p",1,vbldp0,akp,0.0d0
        do i=1,ntyp
          write (iout,'(a10,i3,6f10.5)') restyp(i,molnum(i)),nbondterm(i),&
            vbldsc0(1,i),aksc(1,i),abond0(1,i)
          do j=2,nbondterm(i)
            write (iout,'(13x,3f10.5)') &
              vbldsc0(j,i),aksc(j,i),abond0(j,i)
          enddo
        enddo
      endif
            if (.not. allocated(msc)) allocate(msc(-ntyp1:ntyp1,5))
            if (.not. allocated(restok)) allocate(restok(-ntyp1:ntyp1,5))
       if (oldion.eq.1) then

            do i=1,ntyp_molec(5)
             read(iion,*) msc(i,5),restok(i,5)
             print *,msc(i,5),restok(i,5)
            enddo
            ip(5)=0.2
!            isc(5)=0.2
            read (iion,*) ncatprotparm
            allocate(catprm(ncatprotparm,4))
            do k=1,4
            read (iion,*)  (catprm(i,k),i=1,ncatprotparm)
            enddo
            print *, catprm
      endif
      allocate(catnuclprm(14,ntyp_molec(2),ntyp_molec(5)))
      do i=1,ntyp_molec(5)
         do j=1,ntyp_molec(2)
         write(iout,*) i,j
            read(iionnucl,*) (catnuclprm(k,j,i),k=1,14)
         enddo
      enddo
      write(*,'(3(5x,a6)11(7x,a6))') "w1    ","w2    ","epslj ","pis1  ", &
      "sigma0","epsi0 ","chi1   ","chip1 ","sig   ","b1    ","b2    ", &
      "b3    ","b4    ","chis1  "
      do i=1,ntyp_molec(5)
         do j=1,ntyp_molec(2)
            write(*,'(3(f10.3,x),11(f12.6,x),a3,2a)') (catnuclprm(k,j,i),k=1,14), &
                                      restyp(i,5),"-",restyp(j,2)
         enddo
      enddo

      read (ibond_nucl,*) vbldp0_nucl,akp_nucl,mp(2),ip(2),pstok(2)
      do i=1,ntyp_molec(2)
        nbondterm_nucl(i)=1
        read (ibond_nucl,*) vbldsc0_nucl(1,i),aksc_nucl(1,i),msc(i,2),rjunk,restok(i,2)
!        dsc(i) = vbldsc0_nucl(1,i)
!        if (i.eq.10) then
!          dsc_inv(i)=0.0D0
!        else
!          dsc_inv(i)=1.0D0/dsc(i)
!        endif
      enddo


!----------------------------------------------------
      allocate(a0thet(-ntyp:ntyp),theta0(-ntyp:ntyp))
      allocate(sig0(-ntyp:ntyp),sigc0(-ntyp:ntyp))      !(-ntyp:ntyp)
      allocate(athet(2,-ntyp:ntyp,-1:1,-1:1))
      allocate(bthet(2,-ntyp:ntyp,-1:1,-1:1)) !(2,-ntyp:ntyp,-1:1,-1:1)
      allocate(polthet(0:3,-ntyp:ntyp)) !(0:3,-ntyp:ntyp)
      allocate(gthet(3,-ntyp:ntyp))     !(3,-ntyp:ntyp)
      do i=-ntyp,ntyp
        a0thet(i)=0.0D0
        do j=1,2
         do ichir1=-1,1
          do ichir2=-1,1
          athet(j,i,ichir1,ichir2)=0.0D0
          bthet(j,i,ichir1,ichir2)=0.0D0
          enddo
         enddo
        enddo
        do j=0,3
          polthet(j,i)=0.0D0
        enddo
        do j=1,3
          gthet(j,i)=0.0D0
        enddo
        theta0(i)=0.0D0
        sig0(i)=0.0D0
        sigc0(i)=0.0D0
      enddo
!elwrite(iout,*) "parmread kontrol"

#ifdef CRYST_THETA
!
! Read the parameters of the probability distribution/energy expression 
! of the virtual-bond valence angles theta
!
      do i=1,ntyp
        read (ithep,*) a0thet(i),(athet(j,i,1,1),j=1,2),&
          (bthet(j,i,1,1),j=1,2)
        read (ithep,*) (polthet(j,i),j=0,3)
!elwrite(iout,*) "parmread kontrol in cryst_theta"
        read (ithep,*) (gthet(j,i),j=1,3)
!elwrite(iout,*) "parmread kontrol in cryst_theta"
        read (ithep,*) theta0(i),sig0(i),sigc0(i)
        sigc0(i)=sigc0(i)**2
!elwrite(iout,*) "parmread kontrol in cryst_theta"
      enddo
!elwrite(iout,*) "parmread kontrol in cryst_theta"
      do i=1,ntyp
      athet(1,i,1,-1)=athet(1,i,1,1)
      athet(2,i,1,-1)=athet(2,i,1,1)
      bthet(1,i,1,-1)=-bthet(1,i,1,1)
      bthet(2,i,1,-1)=-bthet(2,i,1,1)
      athet(1,i,-1,1)=-athet(1,i,1,1)
      athet(2,i,-1,1)=-athet(2,i,1,1)
      bthet(1,i,-1,1)=bthet(1,i,1,1)
      bthet(2,i,-1,1)=bthet(2,i,1,1)
      enddo
!elwrite(iout,*) "parmread kontrol in cryst_theta"
      do i=-ntyp,-1
      a0thet(i)=a0thet(-i)
      athet(1,i,-1,-1)=athet(1,-i,1,1)
      athet(2,i,-1,-1)=-athet(2,-i,1,1)
      bthet(1,i,-1,-1)=bthet(1,-i,1,1)
      bthet(2,i,-1,-1)=-bthet(2,-i,1,1)
      athet(1,i,-1,1)=athet(1,-i,1,1)
      athet(2,i,-1,1)=-athet(2,-i,1,1)
      bthet(1,i,-1,1)=-bthet(1,-i,1,1)
      bthet(2,i,-1,1)=bthet(2,-i,1,1)
      athet(1,i,1,-1)=-athet(1,-i,1,1)
      athet(2,i,1,-1)=athet(2,-i,1,1)
      bthet(1,i,1,-1)=bthet(1,-i,1,1)
      bthet(2,i,1,-1)=-bthet(2,-i,1,1)
      theta0(i)=theta0(-i)
      sig0(i)=sig0(-i)
      sigc0(i)=sigc0(-i)
       do j=0,3
        polthet(j,i)=polthet(j,-i)
       enddo
       do j=1,3
         gthet(j,i)=gthet(j,-i)
       enddo
      enddo
!elwrite(iout,*) "parmread kontrol in cryst_theta"
      close (ithep)
!elwrite(iout,*) "parmread kontrol in cryst_theta"
      if (lprint) then
!       write (iout,'(a)') 
!    &    'Parameters of the virtual-bond valence angles:'
!       write (iout,'(/a/9x,5a/79(1h-))') 'Fourier coefficients:',
!    & '    ATHETA0   ','         A1   ','        A2    ',
!    & '        B1    ','         B2   '        
!       do i=1,ntyp
!         write(iout,'(a3,i4,2x,5(1pe14.5))') restyp(i),i,
!    &        a0thet(i),(athet(j,i),j=1,2),(bthet(j,i),j=1,2)
!       enddo
!       write (iout,'(/a/9x,5a/79(1h-))') 
!    & 'Parameters of the expression for sigma(theta_c):',
!    & '     ALPH0    ','      ALPH1   ','     ALPH2    ',
!    & '     ALPH3    ','    SIGMA0C   '        
!       do i=1,ntyp
!         write (iout,'(a3,i4,2x,5(1pe14.5))') restyp(i),i,
!    &      (polthet(j,i),j=0,3),sigc0(i) 
!       enddo
!       write (iout,'(/a/9x,5a/79(1h-))') 
!    & 'Parameters of the second gaussian:',
!    & '    THETA0    ','     SIGMA0   ','        G1    ',
!    & '        G2    ','         G3   '        
!       do i=1,ntyp
!         write (iout,'(a3,i4,2x,5(1pe14.5))') restyp(i),i,theta0(i),
!    &       sig0(i),(gthet(j,i),j=1,3)
!       enddo
	write (iout,'(a)') &
          'Parameters of the virtual-bond valence angles:'
        write (iout,'(/a/9x,5a/79(1h-))') &
       'Coefficients of expansion',&
       '     theta0   ','    a1*10^2   ','   a2*10^2    ',&
       '   b1*10^1    ','    b2*10^1   '        
        do i=1,ntyp
          write(iout,'(a3,1h&,2x,5(f8.3,1h&))') restyp(i),&
              a0thet(i),(100*athet(j,i,1,1),j=1,2),&
              (10*bthet(j,i,1,1),j=1,2)
        enddo
	write (iout,'(/a/9x,5a/79(1h-))') &
       'Parameters of the expression for sigma(theta_c):',&
       ' alpha0       ','  alph1       ',' alph2        ',&
       ' alhp3        ','   sigma0c    '        
	do i=1,ntyp
          write (iout,'(a3,1h&,2x,5(1pe12.3,1h&))') restyp(i),&
            (polthet(j,i),j=0,3),sigc0(i) 
	enddo
	write (iout,'(/a/9x,5a/79(1h-))') &
       'Parameters of the second gaussian:',&
       '    theta0    ','  sigma0*10^2 ','      G1*10^-1',&
       '        G2    ','   G3*10^1    '        
	do i=1,ntyp
          write (iout,'(a3,1h&,2x,5(f8.3,1h&))') restyp(i),theta0(i),&
             100*sig0(i),gthet(1,i)*0.1D0,gthet(2,i),gthet(3,i)*10.0D0
	enddo
      endif
#else
!
! Read the parameters of Utheta determined from ab initio surfaces
! Kozlowska et al., J. Phys.: Condens. Matter 19 (2007) 285203
!
      allocate(ithetyp(-ntyp1:ntyp1)) !(-ntyp1:ntyp1)
!      write (iout,*) "tu dochodze"
      IF (tor_mode.eq.0) THEN
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      read (ithep,*) nthetyp,ntheterm,ntheterm2,&
        ntheterm3,nsingle,ndouble
      nntheterm=max0(ntheterm,ntheterm2,ntheterm3)

!----------------------------------------------------
!      allocate(ithetyp(-ntyp1:ntyp1)) !(-ntyp1:ntyp1)
      allocate(aa0thet(-nthetyp-1:nthetyp+1,&
        -nthetyp-1:nthetyp+1,-nthetyp-1:nthetyp+1,2))
!(-maxthetyp1:maxthetyp1,-maxthetyp1:maxthetyp1,-maxthetyp1:maxthetyp1,2)
      allocate(aathet(ntheterm,-nthetyp-1:nthetyp+1,&
        -nthetyp-1:nthetyp+1,-nthetyp-1:nthetyp+1,2))
!(maxtheterm,-maxthetyp1:maxthetyp1,&
!        -maxthetyp1:maxthetyp1,-maxthetyp1:maxthetyp1,2)
      allocate(bbthet(nsingle,ntheterm2,-nthetyp-1:nthetyp+1,&
        -nthetyp-1:nthetyp+1,-nthetyp-1:nthetyp+1,2))
      allocate(ccthet(nsingle,ntheterm2,-nthetyp-1:nthetyp+1,&
        -nthetyp-1:nthetyp+1,-nthetyp-1:nthetyp+1,2))
      allocate(ddthet(nsingle,ntheterm2,-nthetyp-1:nthetyp+1,&
        -nthetyp-1:nthetyp+1,-nthetyp-1:nthetyp+1,2))
      allocate(eethet(nsingle,ntheterm2,-nthetyp-1:nthetyp+1,&
        -nthetyp-1:nthetyp+1,-nthetyp-1:nthetyp+1,2))
!(maxsingle,maxtheterm2,-maxthetyp1:maxthetyp1,&
!        -maxthetyp1:maxthetyp1,-maxthetyp1:maxthetyp1,2)
      allocate(ffthet(ndouble,ndouble,ntheterm3,-nthetyp-1:nthetyp+1,&
        -nthetyp-1:nthetyp+1,-nthetyp-1:nthetyp+1,2))
      allocate(ggthet(ndouble,ndouble,ntheterm3,-nthetyp-1:nthetyp+1,&
        -nthetyp-1:nthetyp+1,-nthetyp-1:nthetyp+1,2))
!(maxdouble,maxdouble,maxtheterm3,-maxthetyp1:maxthetyp1,&
!        -maxthetyp1:maxthetyp1,-maxthetyp1:maxthetyp1,2))


      read (ithep,*) (ithetyp(i),i=1,ntyp1)
      do i=-ntyp1,-1
        ithetyp(i)=-ithetyp(-i)
      enddo
!      write (iout,*) "tu dochodze"
      aa0thet(:,:,:,:)=0.0d0
      aathet(:,:,:,:,:)=0.0d0
      bbthet(:,:,:,:,:,:)=0.0d0
      ccthet(:,:,:,:,:,:)=0.0d0
      ddthet(:,:,:,:,:,:)=0.0d0
      eethet(:,:,:,:,:,:)=0.0d0
      ffthet(:,:,:,:,:,:,:)=0.0d0
      ggthet(:,:,:,:,:,:,:)=0.0d0

      do iblock=1,2
      do i=0,nthetyp
        do j=-nthetyp,nthetyp
          do k=-nthetyp,nthetyp
            read (ithep,'(6a)') res1
            read (ithep,*) aa0thet(i,j,k,iblock)
            read (ithep,*)(aathet(l,i,j,k,iblock),l=1,ntheterm)
            read (ithep,*) &
             ((bbthet(lll,ll,i,j,k,iblock),lll=1,nsingle),&
              (ccthet(lll,ll,i,j,k,iblock),lll=1,nsingle),&
              (ddthet(lll,ll,i,j,k,iblock),lll=1,nsingle),&
              (eethet(lll,ll,i,j,k,iblock),lll=1,nsingle),&
              ll=1,ntheterm2)
            read (ithep,*) &
            (((ffthet(llll,lll,ll,i,j,k,iblock),&
               ffthet(lll,llll,ll,i,j,k,iblock),&
               ggthet(llll,lll,ll,i,j,k,iblock),&
               ggthet(lll,llll,ll,i,j,k,iblock),&
               llll=1,lll-1),lll=2,ndouble),ll=1,ntheterm3)
          enddo
        enddo
      enddo
!
! For dummy ends assign glycine-type coefficients of theta-only terms; the
! coefficients of theta-and-gamma-dependent terms are zero.
!
      do i=1,nthetyp
        do j=1,nthetyp
          do l=1,ntheterm
            aathet(l,i,j,nthetyp+1,iblock)=0.0d0
            aathet(l,nthetyp+1,i,j,iblock)=0.0d0
          enddo
          aa0thet(i,j,nthetyp+1,iblock)=0.0d0
          aa0thet(nthetyp+1,i,j,iblock)=0.0d0
        enddo
        do l=1,ntheterm
          aathet(l,nthetyp+1,i,nthetyp+1,iblock)=0.0d0
        enddo
        aa0thet(nthetyp+1,i,nthetyp+1,iblock)=0.0d0
      enddo
      enddo
! Substitution for D aminoacids from symmetry.
      do iblock=1,2
      do i=-nthetyp,0
        do j=-nthetyp,nthetyp
          do k=-nthetyp,nthetyp
           aa0thet(i,j,k,iblock)=aa0thet(-i,-j,-k,iblock)
           do l=1,ntheterm
           aathet(l,i,j,k,iblock)=aathet(l,-i,-j,-k,iblock)
           enddo
           do ll=1,ntheterm2
            do lll=1,nsingle
            bbthet(lll,ll,i,j,k,iblock)=bbthet(lll,ll,-i,-j,-k,iblock)
            ccthet(lll,ll,i,j,k,iblock)=-ccthet(lll,ll,-i,-j,-k,iblock)
            ddthet(lll,ll,i,j,k,iblock)=ddthet(lll,ll,-i,-j,-k,iblock)
            eethet(lll,ll,i,j,k,iblock)=-eethet(lll,ll,-i,-j,-k,iblock)
            enddo
          enddo
          do ll=1,ntheterm3
           do lll=2,ndouble
            do llll=1,lll-1
            ffthet(llll,lll,ll,i,j,k,iblock)= &
            ffthet(llll,lll,ll,-i,-j,-k,iblock)
            ffthet(lll,llll,ll,i,j,k,iblock)= &
            ffthet(lll,llll,ll,-i,-j,-k,iblock)
            ggthet(llll,lll,ll,i,j,k,iblock)= &
            -ggthet(llll,lll,ll,-i,-j,-k,iblock)
            ggthet(lll,llll,ll,i,j,k,iblock)= &
            -ggthet(lll,llll,ll,-i,-j,-k,iblock)
            enddo !ll
           enddo  !lll  
          enddo   !llll
         enddo    !k
        enddo     !j
       enddo      !i
      enddo       !iblock

!
! Control printout of the coefficients of virtual-bond-angle potentials
!
      do iblock=1,2
      if (lprint) then
        write (iout,'(//a)') 'Parameter of virtual-bond-angle potential'
        do i=1,nthetyp+1
          do j=1,nthetyp+1
            do k=1,nthetyp+1
              write (iout,'(//4a)') &
               'Type ',onelett(i),onelett(j),onelett(k)
              write (iout,'(//a,10x,a)') " l","a[l]"
              write (iout,'(i2,1pe15.5)') 0,aa0thet(i,j,k,iblock)
              write (iout,'(i2,1pe15.5)') &
                 (l,aathet(l,i,j,k,iblock),l=1,ntheterm)
            do l=1,ntheterm2
              write (iout,'(//2h m,4(9x,a,3h[m,i1,1h]))') &
                "b",l,"c",l,"d",l,"e",l
              do m=1,nsingle
                write (iout,'(i2,4(1pe15.5))') m,&
                bbthet(m,l,i,j,k,iblock),ccthet(m,l,i,j,k,iblock),&
                ddthet(m,l,i,j,k,iblock),eethet(m,l,i,j,k,iblock)
              enddo
            enddo
            do l=1,ntheterm3
              write (iout,'(//3hm,n,4(6x,a,5h[m,n,i1,1h]))') &
                "f+",l,"f-",l,"g+",l,"g-",l
              do m=2,ndouble
                do n=1,m-1
                  write (iout,'(i1,1x,i1,4(1pe15.5))') n,m,&
                    ffthet(n,m,l,i,j,k,iblock),&
                    ffthet(m,n,l,i,j,k,iblock),&
                    ggthet(n,m,l,i,j,k,iblock),&
                    ggthet(m,n,l,i,j,k,iblock)
                enddo
              enddo 
            enddo
          enddo
        enddo
      enddo
      call flush(iout)
      endif
      enddo
      ELSE
!C here will be the apropriate recalibrating for D-aminoacid
      read (ithep,*) nthetyp
      allocate(nbend_kcc_Tb(-nthetyp:nthetyp))
      allocate(v1bend_chyb(0:36,-nthetyp:nthetyp))
      do i=-nthetyp+1,nthetyp-1
        read (ithep,*) nbend_kcc_Tb(i)
        do j=0,nbend_kcc_Tb(i)
          read (ithep,*) ijunk,v1bend_chyb(j,i)
        enddo
      enddo
      if (lprint) then
        write (iout,'(a)') &
         "Parameters of the valence-only potentials"
        do i=-nthetyp+1,nthetyp-1
        write (iout,'(2a)') "Type ",toronelet(i)
        do k=0,nbend_kcc_Tb(i)
          write(iout,'(i5,f15.5)') k,v1bend_chyb(k,i)
        enddo
        enddo
      endif
      ENDIF ! TOR_MODE

#endif
!--------------- Reading theta parameters for nucleic acid-------
      read (ithep_nucl,*) nthetyp_nucl,ntheterm_nucl,&
      ntheterm2_nucl,ntheterm3_nucl,nsingle_nucl,ndouble_nucl
      nntheterm_nucl=max0(ntheterm_nucl,ntheterm2_nucl,ntheterm3_nucl)
      allocate(ithetyp_nucl(ntyp1_molec(2))) !(-ntyp1:ntyp1)
      allocate(aa0thet_nucl(nthetyp_nucl+1,&
        nthetyp_nucl+1,nthetyp_nucl+1))
!(-maxthetyp1:maxthetyp1,-maxthetyp1:maxthetyp1,-maxthetyp1:maxthetyp1,2)
      allocate(aathet_nucl(ntheterm_nucl+1,nthetyp_nucl+1,&
        nthetyp_nucl+1,nthetyp_nucl+1))
!(maxtheterm,-maxthetyp1:maxthetyp1,&
!        -maxthetyp1:maxthetyp1,-maxthetyp1:maxthetyp1,2)
      allocate(bbthet_nucl(nsingle_nucl+1,ntheterm2_nucl+1,nthetyp_nucl+1,&
        nthetyp_nucl+1,nthetyp_nucl+1))
      allocate(ccthet_nucl(nsingle_nucl+1,ntheterm2_nucl+1,nthetyp_nucl+1,&
        nthetyp_nucl+1,nthetyp_nucl+1))
      allocate(ddthet_nucl(nsingle_nucl+1,ntheterm2_nucl+1,nthetyp_nucl+1,&
        nthetyp_nucl+1,nthetyp_nucl+1))
      allocate(eethet_nucl(nsingle_nucl+1,ntheterm2_nucl+1,nthetyp_nucl+1,&
        nthetyp_nucl+1,nthetyp_nucl+1))
!(maxsingle,maxtheterm2,-maxthetyp1:maxthetyp1,&
!        -maxthetyp1:maxthetyp1,-maxthetyp1:maxthetyp1,2)
      allocate(ffthet_nucl(ndouble_nucl+1,ndouble_nucl+1,ntheterm3_nucl+1,&
         nthetyp_nucl+1,nthetyp_nucl+1,nthetyp_nucl+1))
      allocate(ggthet_nucl(ndouble_nucl+1,ndouble_nucl+1,ntheterm3_nucl+1,&
         nthetyp_nucl+1,nthetyp_nucl+1,nthetyp_nucl+1))

!(maxdouble,maxdouble,maxtheterm3,-maxthetyp1:maxthetyp1,&
!        -maxthetyp1:maxthetyp1,-maxthetyp1:maxthetyp1,2))

      read (ithep_nucl,*) (ithetyp_nucl(i),i=1,ntyp1_molec(2))

      aa0thet_nucl(:,:,:)=0.0d0
      aathet_nucl(:,:,:,:)=0.0d0
      bbthet_nucl(:,:,:,:,:)=0.0d0
      ccthet_nucl(:,:,:,:,:)=0.0d0
      ddthet_nucl(:,:,:,:,:)=0.0d0
      eethet_nucl(:,:,:,:,:)=0.0d0
      ffthet_nucl(:,:,:,:,:,:)=0.0d0
      ggthet_nucl(:,:,:,:,:,:)=0.0d0

      do i=1,nthetyp_nucl
        do j=1,nthetyp_nucl
          do k=1,nthetyp_nucl
            read (ithep_nucl,'(3a)') t1,t2,t3
            read (ithep_nucl,*) aa0thet_nucl(i,j,k)
            read (ithep_nucl,*)(aathet_nucl(l,i,j,k),l=1,ntheterm_nucl)
            read (ithep_nucl,*) &
            (((bbthet_nucl(lll,ll,i,j,k),lll=1,nsingle_nucl), &
            (ccthet_nucl(lll,ll,i,j,k),lll=1,nsingle_nucl), &
            (ddthet_nucl(lll,ll,i,j,k),lll=1,nsingle_nucl), &
            (eethet_nucl(lll,ll,i,j,k),lll=1,nsingle_nucl)),ll=1,ntheterm2_nucl)
            read (ithep_nucl,*) &
           (((ffthet_nucl(llll,lll,ll,i,j,k),ffthet_nucl(lll,llll,ll,i,j,k), &
              ggthet_nucl(llll,lll,ll,i,j,k),ggthet_nucl(lll,llll,ll,i,j,k), &
              llll=1,lll-1),lll=2,ndouble_nucl),ll=1,ntheterm3_nucl)
          enddo
        enddo
      enddo


!-------------------------------------------
      allocate(nlob(ntyp1)) !(ntyp1)
      allocate(bsc(maxlob,ntyp)) !(maxlob,ntyp)
      allocate(censc(3,maxlob,-ntyp:ntyp)) !(3,maxlob,-ntyp:ntyp)
      allocate(gaussc(3,3,maxlob,-ntyp:ntyp)) !(3,3,maxlob,-ntyp:ntyp)

      do i=1,ntyp
        do j=1,maxlob
          bsc(j,i)=0.0D0
          nlob(i)=0
        enddo
      enddo
      nlob(ntyp1)=0
      dsc(ntyp1)=0.0D0

      do i=-ntyp,ntyp
        do j=1,maxlob
          do k=1,3
            censc(k,j,i)=0.0D0
          enddo
          do k=1,3
            do l=1,3
              gaussc(l,k,j,i)=0.0D0
            enddo
          enddo
        enddo
      enddo

#ifdef CRYST_SC
!
! Read the parameters of the probability distribution/energy expression
! of the side chains.
!
      do i=1,ntyp
!c      write (iout,*) "tu dochodze",i
	read (irotam,'(3x,i3,f8.3)') nlob(i),dsc(i)
        if (i.eq.10) then
          dsc_inv(i)=0.0D0
        else
          dsc_inv(i)=1.0D0/dsc(i)
        endif
	if (i.ne.10) then
        do j=1,nlob(i)
          do k=1,3
            do l=1,3
              blower(l,k,j)=0.0D0
            enddo
          enddo
        enddo  
	bsc(1,i)=0.0D0
        read(irotam,*)(censc(k,1,i),k=1,3),((blower(k,l,1),l=1,k),k=1,3)
        censc(1,1,-i)=censc(1,1,i)
        censc(2,1,-i)=censc(2,1,i)
        censc(3,1,-i)=-censc(3,1,i)
	do j=2,nlob(i)
	  read (irotam,*) bsc(j,i)
	  read (irotam,*) (censc(k,j,i),k=1,3),&
                                       ((blower(k,l,j),l=1,k),k=1,3)
        censc(1,j,-i)=censc(1,j,i)
        censc(2,j,-i)=censc(2,j,i)
        censc(3,j,-i)=-censc(3,j,i)
! BSC is amplitude of Gaussian
        enddo
	do j=1,nlob(i)
	  do k=1,3
	    do l=1,k
	      akl=0.0D0
	      do m=1,3
		akl=akl+blower(k,m,j)*blower(l,m,j)
              enddo
	      gaussc(k,l,j,i)=akl
	      gaussc(l,k,j,i)=akl
             if (((k.eq.3).and.(l.ne.3)) &
              .or.((l.eq.3).and.(k.ne.3))) then
                gaussc(k,l,j,-i)=-akl
                gaussc(l,k,j,-i)=-akl
              else
                gaussc(k,l,j,-i)=akl
                gaussc(l,k,j,-i)=akl
              endif
            enddo
          enddo 
	enddo
	endif
      enddo
      close (irotam)
      if (lprint) then
	write (iout,'(/a)') 'Parameters of side-chain local geometry'
	do i=1,ntyp
	  nlobi=nlob(i)
          if (nlobi.gt.0) then
          write (iout,'(/3a,i2,a,f8.3)') 'Residue type: ',restyp(i),&
           ' # of gaussian lobes:',nlobi,' dsc:',dsc(i)
!          write (iout,'(/a,8x,i1,4(25x,i1))') 'Lobe:',(j,j=1,nlobi)
!          write (iout,'(a,f10.4,4(16x,f10.4))')
!     &                             'Center  ',(bsc(j,i),j=1,nlobi)
!          write (iout,'(5(2x,3f8.4))') ((censc(k,j,i),k=1,3),j=1,nlobi)
           write (iout,'(1h&,a,3(2h&&,f8.3,2h&&))') &
                                   'log h',(bsc(j,i),j=1,nlobi)
           write (iout,'(1h&,a,3(1h&,f8.3,1h&,f8.3,1h&,f8.3,1h&))') &
          'x',((censc(k,j,i),k=1,3),j=1,nlobi)
!          write (iout,'(a)')
!         do j=1,nlobi
!           ind=0
!           do k=1,3
!             do l=1,k
!              ind=ind+1
!              blower(k,l,j)=gaussc(ind,j,i)
!             enddo
!           enddo
!         enddo
	  do k=1,3
            write (iout,'(2h& ,5(2x,1h&,3(f7.3,1h&)))') &
                       ((gaussc(k,l,j,i),l=1,3),j=1,nlobi)
          enddo
	  endif
        enddo
      endif
#else
!
! Read scrot parameters for potentials determined from all-atom AM1 calculations
! added by Urszula Kozlowska 07/11/2007
!
      allocate(sc_parmin(65,ntyp))      !(maxsccoef,ntyp)

      do i=1,ntyp
        read (irotam,*)
       if (i.eq.10) then
         read (irotam,*)
       else
         do j=1,65
           read(irotam,*) sc_parmin(j,i)
         enddo
       endif
      enddo
#endif
#ifdef SC_END
      allocate(nterm_scend(2,ntyp))
      allocate(arotam_end(0:6,2,ntyp))
      nterm_scend=0
      arotam_end=0.0d0
      read (irotam_end,*) ijunk
!c      write (iout,*) "ijunk",ijunk
      do i=1,ntyp
        if (i.eq.10) cycle
        do j=1,2
          read (irotam_end,'(a)')
          read (irotam_end,*) nterm_scend(j,i)
!c          write (iout,*) "i",i," j",j," nterm",nterm_scend(j,i)
          do k=0,nterm_scend(j,i)
            read (irotam_end,*) ijunk,arotam_end(k,j,i)
!c            write (iout,*) "k",k," arotam",arotam_end(k,j,i)
          enddo
        enddo
      enddo
!c      lprint=.true.
      if (lprint) then
        write (iout,'(a)') &
         "Parameters of the local potentials of sidechain ends"
        do i=1,ntyp
          write (iout,'(5x,9x,2hp-,a3,6x,9x,a3,2h-p)')&
          restyp(i,1),restyp(i,1)
          do j=0,max0(nterm_scend(1,i),nterm_scend(2,i))
            write (iout,'(i5,2f20.10)') &
             j,arotam_end(j,1,i),arotam_end(j,2,i)
          enddo
        enddo
      endif
!c      lprint=.false.
#endif

      close(irotam)
!---------reading nucleic acid parameters for rotamers-------------------
      allocate(sc_parmin_nucl(9,ntyp_molec(2)))      !(maxsccoef,ntyp)
      do i=1,ntyp_molec(2)
        read (irotam_nucl,*)
        do j=1,9
          read(irotam_nucl,*) sc_parmin_nucl(j,i)
        enddo
      enddo
      close(irotam_nucl)
      if (lprint) then
        write (iout,*)
        write (iout,*) "Base rotamer parameters"
        do i=1,ntyp_molec(2)
          write (iout,'(a)') restyp(i,2)
          write (iout,'(i5,f10.5)') (i,sc_parmin_nucl(j,i),j=1,9)
        enddo
      endif


      read (ifourier,*) nloctyp
!el write(iout,*)"nloctyp",nloctyp
      SPLIT_FOURIERTOR = nloctyp.lt.0
      nloctyp = iabs(nloctyp)
#ifdef NEWCORR
      if (.not.allocated(itype2loc)) allocate(itype2loc(-ntyp1:ntyp1))
       print *,"shape",shape(itype2loc)
      allocate(iloctyp(-nloctyp:nloctyp))
      allocate(bnew1(3,2,-nloctyp:nloctyp))
      allocate(bnew2(3,2,-nloctyp:nloctyp))
      allocate(ccnew(3,2,-nloctyp:nloctyp))
      allocate(ddnew(3,2,-nloctyp:nloctyp))
      allocate(e0new(3,-nloctyp:nloctyp))
      allocate(eenew(2,2,2,-nloctyp:nloctyp))
      allocate(bnew1tor(3,2,-nloctyp:nloctyp))
      allocate(bnew2tor(3,2,-nloctyp:nloctyp))
      allocate(ccnewtor(3,2,-nloctyp:nloctyp))
      allocate(ddnewtor(3,2,-nloctyp:nloctyp))
      allocate(e0newtor(3,-nloctyp:nloctyp))
      allocate(eenewtor(2,2,2,-nloctyp:nloctyp))

      read (ifourier,*) (itype2loc(i),i=1,ntyp)
      read (ifourier,*) (iloctyp(i),i=0,nloctyp-1)
      itype2loc(ntyp1)=nloctyp
      iloctyp(nloctyp)=ntyp1
      do i=1,ntyp1
        itype2loc(-i)=-itype2loc(i)
      enddo
#else
      allocate(iloctyp(-nloctyp:nloctyp))
      allocate(itype2loc(-ntyp1:ntyp1))
      iloctyp(0)=10
      iloctyp(1)=9
      iloctyp(2)=20
      iloctyp(3)=ntyp1
#endif
      do i=1,nloctyp
        iloctyp(-i)=-iloctyp(i)
      enddo
!c      write (iout,*) "itype2loc",(itype2loc(i),i=1,ntyp1)
!c      write (iout,*) "nloctyp",nloctyp,
!c     &  " iloctyp",(iloctyp(i),i=0,nloctyp)
!c      write (iout,*) "itype2loc",(itype2loc(i),i=1,ntyp1)
!c      write (iout,*) "nloctyp",nloctyp,
!c     &  " iloctyp",(iloctyp(i),i=0,nloctyp)
#ifdef NEWCORR
      do i=0,nloctyp-1
!c             write (iout,*) "NEWCORR",i
        read (ifourier,*)
        do ii=1,3
          do j=1,2
            read (ifourier,*) bnew1(ii,j,i)
          enddo
        enddo
!c             write (iout,*) "NEWCORR BNEW1"
!c             write (iout,*) ((bnew1(ii,j,i),ii=1,3),j=1,2)
        do ii=1,3
          do j=1,2
            read (ifourier,*) bnew2(ii,j,i)
          enddo
        enddo
!c             write (iout,*) "NEWCORR BNEW2"
!c             write (iout,*) ((bnew2(ii,j,i),ii=1,3),j=1,2)
        do kk=1,3
          read (ifourier,*) ccnew(kk,1,i)
          read (ifourier,*) ccnew(kk,2,i)
        enddo
!c             write (iout,*) "NEWCORR CCNEW"
!c             write (iout,*) ((ccnew(ii,j,i),ii=1,3),j=1,2)
        do kk=1,3
          read (ifourier,*) ddnew(kk,1,i)
          read (ifourier,*) ddnew(kk,2,i)
        enddo
!c             write (iout,*) "NEWCORR DDNEW"
!c             write (iout,*) ((ddnew(ii,j,i),ii=1,3),j=1,2)
        do ii=1,2
          do jj=1,2
            do kk=1,2
              read (ifourier,*) eenew(ii,jj,kk,i)
            enddo
          enddo
        enddo
!c             write (iout,*) "NEWCORR EENEW1"
!c             write(iout,*)(((eenew(ii,jj,kk,i),kk=1,2),jj=1,2),ii=1,2)
        do ii=1,3
          read (ifourier,*) e0new(ii,i)
        enddo
!c             write (iout,*) (e0new(ii,i),ii=1,3)
      enddo
!c             write (iout,*) "NEWCORR EENEW"
      do i=0,nloctyp-1
        do ii=1,3
          ccnew(ii,1,i)=ccnew(ii,1,i)/2
          ccnew(ii,2,i)=ccnew(ii,2,i)/2
          ddnew(ii,1,i)=ddnew(ii,1,i)/2
          ddnew(ii,2,i)=ddnew(ii,2,i)/2
        enddo
      enddo
      do i=1,nloctyp-1
        do ii=1,3
          bnew1(ii,1,-i)= bnew1(ii,1,i)
          bnew1(ii,2,-i)=-bnew1(ii,2,i)
          bnew2(ii,1,-i)= bnew2(ii,1,i)
          bnew2(ii,2,-i)=-bnew2(ii,2,i)
        enddo
        do ii=1,3
!c          ccnew(ii,1,i)=ccnew(ii,1,i)/2
!c          ccnew(ii,2,i)=ccnew(ii,2,i)/2
!c          ddnew(ii,1,i)=ddnew(ii,1,i)/2
!c          ddnew(ii,2,i)=ddnew(ii,2,i)/2
          ccnew(ii,1,-i)=ccnew(ii,1,i)
          ccnew(ii,2,-i)=-ccnew(ii,2,i)
          ddnew(ii,1,-i)=ddnew(ii,1,i)
          ddnew(ii,2,-i)=-ddnew(ii,2,i)
        enddo
        e0new(1,-i)= e0new(1,i)
        e0new(2,-i)=-e0new(2,i)
        e0new(3,-i)=-e0new(3,i)
        do kk=1,2
          eenew(kk,1,1,-i)= eenew(kk,1,1,i)
          eenew(kk,1,2,-i)=-eenew(kk,1,2,i)
          eenew(kk,2,1,-i)=-eenew(kk,2,1,i)
          eenew(kk,2,2,-i)= eenew(kk,2,2,i)
        enddo
      enddo
      if (lprint) then
        write (iout,'(a)') "Coefficients of the multibody terms"
        do i=-nloctyp+1,nloctyp-1
          write (iout,*) "Type: ",onelet(iloctyp(i))
          write (iout,*) "Coefficients of the expansion of B1"
          do j=1,2
            write (iout,'(3hB1(,i1,1h),3f10.5)') j,(bnew1(k,j,i),k=1,3)
          enddo
          write (iout,*) "Coefficients of the expansion of B2"
          do j=1,2
            write (iout,'(3hB2(,i1,1h),3f10.5)') j,(bnew2(k,j,i),k=1,3)
          enddo
          write (iout,*) "Coefficients of the expansion of C"
          write (iout,'(3hC11,3f10.5)') (ccnew(j,1,i),j=1,3)
          write (iout,'(3hC12,3f10.5)') (ccnew(j,2,i),j=1,3)
          write (iout,*) "Coefficients of the expansion of D"
          write (iout,'(3hD11,3f10.5)') (ddnew(j,1,i),j=1,3)
          write (iout,'(3hD12,3f10.5)') (ddnew(j,2,i),j=1,3)
          write (iout,*) "Coefficients of the expansion of E"
          write (iout,'(2hE0,3f10.5)') (e0new(j,i),j=1,3)
          do j=1,2
            do k=1,2
              write (iout,'(1hE,2i1,2f10.5)') j,k,(eenew(l,j,k,i),l=1,2)
            enddo
          enddo
        enddo
      endif
      IF (SPLIT_FOURIERTOR) THEN
      do i=0,nloctyp-1
!c             write (iout,*) "NEWCORR TOR",i
        read (ifourier,*)
        do ii=1,3
          do j=1,2
            read (ifourier,*) bnew1tor(ii,j,i)
          enddo
        enddo
!c             write (iout,*) "NEWCORR BNEW1 TOR"
!c             write (iout,*) ((bnew1tor(ii,j,i),ii=1,3),j=1,2)
        do ii=1,3
          do j=1,2
            read (ifourier,*) bnew2tor(ii,j,i)
          enddo
        enddo
!c             write (iout,*) "NEWCORR BNEW2 TOR"
!c             write (iout,*) ((bnew2tor(ii,j,i),ii=1,3),j=1,2)
        do kk=1,3
          read (ifourier,*) ccnewtor(kk,1,i)
          read (ifourier,*) ccnewtor(kk,2,i)
        enddo
!c             write (iout,*) "NEWCORR CCNEW TOR"
!c             write (iout,*) ((ccnew(ii,j,i),ii=1,3),j=1,2)
        do kk=1,3
          read (ifourier,*) ddnewtor(kk,1,i)
          read (ifourier,*) ddnewtor(kk,2,i)
        enddo
!c             write (iout,*) "NEWCORR DDNEW TOR"
!c             write (iout,*) ((ddnewtor(ii,j,i),ii=1,3),j=1,2)
        do ii=1,2
          do jj=1,2
            do kk=1,2
              read (ifourier,*) eenewtor(ii,jj,kk,i)
            enddo
          enddo
        enddo
!c         write (iout,*) "NEWCORR EENEW1 TOR"
!c         write(iout,*)(((eenewtor(ii,jj,kk,i),kk=1,2),jj=1,2),ii=1,2)
        do ii=1,3
          read (ifourier,*) e0newtor(ii,i)
        enddo
!c             write (iout,*) (e0newtor(ii,i),ii=1,3)
      enddo
!c             write (iout,*) "NEWCORR EENEW TOR"
      do i=0,nloctyp-1
        do ii=1,3
          ccnewtor(ii,1,i)=ccnewtor(ii,1,i)/2
          ccnewtor(ii,2,i)=ccnewtor(ii,2,i)/2
          ddnewtor(ii,1,i)=ddnewtor(ii,1,i)/2
          ddnewtor(ii,2,i)=ddnewtor(ii,2,i)/2
        enddo
      enddo
      do i=1,nloctyp-1
        do ii=1,3
          bnew1tor(ii,1,-i)= bnew1tor(ii,1,i)
          bnew1tor(ii,2,-i)=-bnew1tor(ii,2,i)
          bnew2tor(ii,1,-i)= bnew2tor(ii,1,i)
          bnew2tor(ii,2,-i)=-bnew2tor(ii,2,i)
        enddo
        do ii=1,3
          ccnewtor(ii,1,-i)=ccnewtor(ii,1,i)
          ccnewtor(ii,2,-i)=-ccnewtor(ii,2,i)
          ddnewtor(ii,1,-i)=ddnewtor(ii,1,i)
          ddnewtor(ii,2,-i)=-ddnewtor(ii,2,i)
        enddo
        e0newtor(1,-i)= e0newtor(1,i)
        e0newtor(2,-i)=-e0newtor(2,i)
        e0newtor(3,-i)=-e0newtor(3,i)
        do kk=1,2
          eenewtor(kk,1,1,-i)= eenewtor(kk,1,1,i)
          eenewtor(kk,1,2,-i)=-eenewtor(kk,1,2,i)
          eenewtor(kk,2,1,-i)=-eenewtor(kk,2,1,i)
          eenewtor(kk,2,2,-i)= eenewtor(kk,2,2,i)
        enddo
      enddo
      if (lprint) then
        write (iout,'(a)') &
         "Single-body coefficients of the torsional potentials"
        do i=-nloctyp+1,nloctyp-1
          write (iout,*) "Type: ",onelet(iloctyp(i))
          write (iout,*) "Coefficients of the expansion of B1tor"
          do j=1,2
            write (iout,'(3hB1(,i1,1h),3f10.5)') &
             j,(bnew1tor(k,j,i),k=1,3)
          enddo
          write (iout,*) "Coefficients of the expansion of B2tor"
          do j=1,2
            write (iout,'(3hB2(,i1,1h),3f10.5)') &
             j,(bnew2tor(k,j,i),k=1,3)
          enddo
          write (iout,*) "Coefficients of the expansion of Ctor"
          write (iout,'(3hC11,3f10.5)') (ccnewtor(j,1,i),j=1,3)
          write (iout,'(3hC12,3f10.5)') (ccnewtor(j,2,i),j=1,3)
          write (iout,*) "Coefficients of the expansion of Dtor"
          write (iout,'(3hD11,3f10.5)') (ddnewtor(j,1,i),j=1,3)
          write (iout,'(3hD12,3f10.5)') (ddnewtor(j,2,i),j=1,3)
          write (iout,*) "Coefficients of the expansion of Etor"
          write (iout,'(2hE0,3f10.5)') (e0newtor(j,i),j=1,3)
          do j=1,2
            do k=1,2
              write (iout,'(1hE,2i1,2f10.5)') &
               j,k,(eenewtor(l,j,k,i),l=1,2)
            enddo
          enddo
        enddo
      endif
      ELSE
      do i=-nloctyp+1,nloctyp-1
        do ii=1,3
          do j=1,2
            bnew1tor(ii,j,i)=bnew1(ii,j,i)
          enddo
        enddo
        do ii=1,3
          do j=1,2
            bnew2tor(ii,j,i)=bnew2(ii,j,i)
          enddo
        enddo
        do ii=1,3
          ccnewtor(ii,1,i)=ccnew(ii,1,i)
          ccnewtor(ii,2,i)=ccnew(ii,2,i)
          ddnewtor(ii,1,i)=ddnew(ii,1,i)
          ddnewtor(ii,2,i)=ddnew(ii,2,i)
        enddo
      enddo
      ENDIF !SPLIT_FOURIER_TOR
#else
      allocate(ccold(2,2,-nloctyp-1:nloctyp+1))
      allocate(ddold(2,2,-nloctyp-1:nloctyp+1))
      allocate(eeold(2,2,-nloctyp-1:nloctyp+1))
      allocate(b(13,-nloctyp-1:nloctyp+1))
      if (lprint) &
       write (iout,*) "Coefficients of the expansion of Eloc(l1,l2)"
      do i=0,nloctyp-1
        read (ifourier,*)
        read (ifourier,*) (b(ii,i),ii=1,13)
        if (lprint) then
        write (iout,*) 'Type ',onelet(iloctyp(i))
        write (iout,'(a,i2,a,f10.5)') ('b(',ii,')=',b(ii,i),ii=1,13)
        endif
        if (i.gt.0) then
        b(2,-i)= b(2,i)
        b(3,-i)= b(3,i)
        b(4,-i)=-b(4,i)
        b(5,-i)=-b(5,i)
        endif
        CCold(1,1,i)= b(7,i)
        CCold(2,2,i)=-b(7,i)
        CCold(2,1,i)= b(9,i)
        CCold(1,2,i)= b(9,i)
        CCold(1,1,-i)= b(7,i)
        CCold(2,2,-i)=-b(7,i)
        CCold(2,1,-i)=-b(9,i)
        CCold(1,2,-i)=-b(9,i)
        DDold(1,1,i)= b(6,i)
        DDold(2,2,i)=-b(6,i)
        DDold(2,1,i)= b(8,i)
        DDold(1,2,i)= b(8,i)
        DDold(1,1,-i)= b(6,i)
        DDold(2,2,-i)=-b(6,i)
        DDold(2,1,-i)=-b(8,i)
        DDold(1,2,-i)=-b(8,i)
        EEold(1,1,i)= b(10,i)+b(11,i)
        EEold(2,2,i)=-b(10,i)+b(11,i)
        EEold(2,1,i)= b(12,i)-b(13,i)
        EEold(1,2,i)= b(12,i)+b(13,i)
        EEold(1,1,-i)= b(10,i)+b(11,i)
        EEold(2,2,-i)=-b(10,i)+b(11,i)
        EEold(2,1,-i)=-b(12,i)+b(13,i)
        EEold(1,2,-i)=-b(12,i)-b(13,i)
        write(iout,*) "TU DOCHODZE"
        print *,"JESTEM"
      enddo
      if (lprint) then
      write (iout,*)
      write (iout,*) &
      "Coefficients of the cumulants (independent of valence angles)"
      do i=-nloctyp+1,nloctyp-1
        write (iout,*) 'Type ',onelet(iloctyp(i))
        write (iout,*) 'B1'
        write(iout,'(2f10.5)') B(3,i),B(5,i)
        write (iout,*) 'B2'
        write(iout,'(2f10.5)') B(2,i),B(4,i)
        write (iout,*) 'CC'
        do j=1,2
          write (iout,'(2f10.5)') CCold(j,1,i),CCold(j,2,i)
        enddo
        write(iout,*) 'DD'
        do j=1,2
          write (iout,'(2f10.5)') DDold(j,1,i),DDold(j,2,i)
        enddo
        write(iout,*) 'EE'
        do j=1,2
          write (iout,'(2f10.5)') EEold(j,1,i),EEold(j,2,i)
        enddo
      enddo
      endif
#endif
#ifdef CRYST_TOR
!
! Read torsional parameters in old format
!
      allocate(itortyp(ntyp1)) !(-ntyp1:ntyp1)

      read (itorp,*) ntortyp,nterm_old
      write (iout,*) 'ntortyp,nterm',ntortyp,nterm_old
      read (itorp,*) (itortyp(i),i=1,ntyp)

!el from energy module--------
      allocate(v1(nterm_old,ntortyp,ntortyp))
      allocate(v2(nterm_old,ntortyp,ntortyp)) !(maxterm,-maxtor:maxtor,-maxtor:maxtor)
!el---------------------------

      do i=1,ntortyp
	do j=1,ntortyp
	  read (itorp,'(a)')
	  do k=1,nterm_old
	    read (itorp,*) kk,v1(k,j,i),v2(k,j,i) 
          enddo
        enddo
      enddo
      close (itorp)
      if (lprint) then
	write (iout,'(/a/)') 'Torsional constants:'
	do i=1,ntortyp
	  do j=1,ntortyp
	    write (iout,'(2i3,6f10.5)') i,j,(v1(k,i,j),k=1,nterm_old)
	    write (iout,'(6x,6f10.5)') (v2(k,i,j),k=1,nterm_old)
          enddo
        enddo
      endif


#else
!
! Read torsional parameters
!
      IF (TOR_MODE.eq.0) THEN

      allocate(itortyp(-ntyp1:ntyp1)) !(-ntyp1:ntyp1)

      read (itorp,*) ntortyp
      read (itorp,*) (itortyp(i),i=1,ntyp)
      write (iout,*) 'ntortyp',ntortyp

!el from energy module---------
      allocate(nterm(-ntortyp:ntortyp,-ntortyp:ntortyp,2)) !(-maxtor:maxtor,-maxtor:maxtor,2)
      allocate(nlor(-ntortyp:ntortyp,-ntortyp:ntortyp,2)) !(-maxtor:maxtor,-maxtor:maxtor,2)

      allocate(vlor1(maxlor,-ntortyp:ntortyp,-ntortyp:ntortyp)) !(maxlor,-maxtor:maxtor,-maxtor:maxtor)
      allocate(vlor2(maxlor,ntortyp,ntortyp))
      allocate(vlor3(maxlor,ntortyp,ntortyp)) !(maxlor,maxtor,maxtor)
      allocate(v0(-ntortyp:ntortyp,-ntortyp:ntortyp,2)) !(-maxtor:maxtor,-maxtor:maxtor,2)

      allocate(v1(maxterm,-ntortyp:ntortyp,-ntortyp:ntortyp,2))
      allocate(v2(maxterm,-ntortyp:ntortyp,-ntortyp:ntortyp,2)) !(maxterm,-maxtor:maxtor,-maxtor:maxtor,2)
!el---------------------------
      do iblock=1,2
        do i=-ntortyp,ntortyp
          do j=-ntortyp,ntortyp
            nterm(i,j,iblock)=0
            nlor(i,j,iblock)=0
          enddo
        enddo
      enddo
!el---------------------------

      do iblock=1,2
      do i=-ntyp,-1
       itortyp(i)=-itortyp(-i)
      enddo
!      write (iout,*) 'ntortyp',ntortyp
      do i=0,ntortyp-1
        do j=-ntortyp+1,ntortyp-1
          read (itorp,*) nterm(i,j,iblock),&
                nlor(i,j,iblock)
          nterm(-i,-j,iblock)=nterm(i,j,iblock)
          nlor(-i,-j,iblock)=nlor(i,j,iblock)
          v0ij=0.0d0
          si=-1.0d0
          do k=1,nterm(i,j,iblock)
            read (itorp,*) kk,v1(k,i,j,iblock),&
            v2(k,i,j,iblock)
            v1(k,-i,-j,iblock)=v1(k,i,j,iblock)
            v2(k,-i,-j,iblock)=-v2(k,i,j,iblock)
            v0ij=v0ij+si*v1(k,i,j,iblock)
            si=-si
         enddo
          do k=1,nlor(i,j,iblock)
            read (itorp,*) kk,vlor1(k,i,j),&
              vlor2(k,i,j),vlor3(k,i,j)
            v0ij=v0ij+vlor1(k,i,j)/(1+vlor3(k,i,j)**2)
          enddo
          v0(i,j,iblock)=v0ij
          v0(-i,-j,iblock)=v0ij
        enddo
      enddo
      enddo
      close (itorp)
      if (lprint) then
        do iblock=1,2 !el
        write (iout,'(/a/)') 'Torsional constants:'
        do i=1,ntortyp
          do j=1,ntortyp
            write (iout,*) 'ityp',i,' jtyp',j
            write (iout,*) 'Fourier constants'
            do k=1,nterm(i,j,iblock)
              write (iout,'(2(1pe15.5))') v1(k,i,j,iblock),&
              v2(k,i,j,iblock)
            enddo
            write (iout,*) 'Lorenz constants'
            do k=1,nlor(i,j,iblock)
              write (iout,'(3(1pe15.5))') &
               vlor1(k,i,j),vlor2(k,i,j),vlor3(k,i,j)
            enddo
          enddo
        enddo
        enddo
      endif
!
! 6/23/01 Read parameters for double torsionals
!
!el from energy module------------
      allocate(v1c(2,maxtermd_1,-ntortyp+1:ntortyp-1,-ntortyp+1:ntortyp-1,-ntortyp+1:ntortyp-1,2))
      allocate(v1s(2,maxtermd_1,-ntortyp+1:ntortyp-1,-ntortyp+1:ntortyp-1,-ntortyp+1:ntortyp-1,2))
!(2,maxtermd_1,-maxtor:maxtor,-maxtor:maxtor,-maxtor:maxtor,2)
      allocate(v2c(maxtermd_2,maxtermd_2,-ntortyp+1:ntortyp-1,-ntortyp+1:ntortyp-1,-ntortyp+1:ntortyp-1,2))
      allocate(v2s(maxtermd_2,maxtermd_2,-ntortyp+1:ntortyp-1,-ntortyp+1:ntortyp-1,-ntortyp+1:ntortyp-1,2))
        !(maxtermd_2,maxtermd_2,-maxtor:maxtor,-maxtor:maxtor,-maxtor:maxtor,2)
      allocate(ntermd_1(-ntortyp+1:ntortyp-1,-ntortyp+1:ntortyp-1,-ntortyp+1:ntortyp-1,2))
      allocate(ntermd_2(-ntortyp+1:ntortyp-1,-ntortyp+1:ntortyp-1,-ntortyp+1:ntortyp-1,2))
        !(-maxtor:maxtor,-maxtor:maxtor,-maxtor:maxtor,2)
!---------------------------------

      do iblock=1,2
      do i=0,ntortyp-1
        do j=-ntortyp+1,ntortyp-1
          do k=-ntortyp+1,ntortyp-1
            read (itordp,'(3a1)') t1,t2,t3
!              write (iout,*) "OK onelett",
!     &         i,j,k,t1,t2,t3

            if (t1.ne.toronelet(i) .or. t2.ne.toronelet(j) &
              .or. t3.ne.toronelet(k)) then
              write (iout,*) "Error in double torsional parameter file",&
               i,j,k,t1,t2,t3
#ifdef MPI
              call MPI_Finalize(Ierror)
#endif
               stop "Error in double torsional parameter file"
            endif
          read (itordp,*) ntermd_1(i,j,k,iblock),&
               ntermd_2(i,j,k,iblock)
            ntermd_1(-i,-j,-k,iblock)=ntermd_1(i,j,k,iblock)
            ntermd_2(-i,-j,-k,iblock)=ntermd_2(i,j,k,iblock)
            read (itordp,*) (v1c(1,l,i,j,k,iblock),l=1,&
               ntermd_1(i,j,k,iblock))
            read (itordp,*) (v1s(1,l,i,j,k,iblock),l=1,&
               ntermd_1(i,j,k,iblock))
            read (itordp,*) (v1c(2,l,i,j,k,iblock),l=1,&
               ntermd_1(i,j,k,iblock))
            read (itordp,*) (v1s(2,l,i,j,k,iblock),l=1,&
               ntermd_1(i,j,k,iblock))
! Martix of D parameters for one dimesional foureir series
            do l=1,ntermd_1(i,j,k,iblock)
             v1c(1,l,-i,-j,-k,iblock)=v1c(1,l,i,j,k,iblock)
             v1s(1,l,-i,-j,-k,iblock)=-v1s(1,l,i,j,k,iblock)
             v1c(2,l,-i,-j,-k,iblock)=v1c(2,l,i,j,k,iblock)
             v1s(2,l,-i,-j,-k,iblock)=-v1s(2,l,i,j,k,iblock)
!            write(iout,*) "whcodze" ,
!     & v1s(2,l,-i,-j,-k,iblock),v1s(2,l,i,j,k,iblock)
            enddo
            read (itordp,*) ((v2c(l,m,i,j,k,iblock),&
               v2c(m,l,i,j,k,iblock),v2s(l,m,i,j,k,iblock),&
               v2s(m,l,i,j,k,iblock),&
               m=1,l-1),l=1,ntermd_2(i,j,k,iblock))
! Martix of D parameters for two dimesional fourier series
            do l=1,ntermd_2(i,j,k,iblock)
             do m=1,l-1
             v2c(l,m,-i,-j,-k,iblock)=v2c(l,m,i,j,k,iblock)
             v2c(m,l,-i,-j,-k,iblock)=v2c(m,l,i,j,k,iblock)
             v2s(l,m,-i,-j,-k,iblock)=-v2s(l,m,i,j,k,iblock)
             v2s(m,l,-i,-j,-k,iblock)=-v2s(m,l,i,j,k,iblock)
             enddo!m
            enddo!l
          enddo!k
        enddo!j
      enddo!i
      enddo!iblock
      if (lprint) then
      write (iout,*)
      write (iout,*) 'Constants for double torsionals'
      do iblock=1,2
      do i=0,ntortyp-1
        do j=-ntortyp+1,ntortyp-1
          do k=-ntortyp+1,ntortyp-1
            write (iout,*) 'ityp',i,' jtyp',j,' ktyp',k,&
              ' nsingle',ntermd_1(i,j,k,iblock),&
              ' ndouble',ntermd_2(i,j,k,iblock)
            write (iout,*)
            write (iout,*) 'Single angles:'
            do l=1,ntermd_1(i,j,k,iblock)
              write (iout,'(i5,2f10.5,5x,2f10.5,5x,2f10.5)') l,&
                 v1c(1,l,i,j,k,iblock),v1s(1,l,i,j,k,iblock),&
                 v1c(2,l,i,j,k,iblock),v1s(2,l,i,j,k,iblock),&
                 v1s(1,l,-i,-j,-k,iblock),v1s(2,l,-i,-j,-k,iblock)
            enddo
            write (iout,*)
            write (iout,*) 'Pairs of angles:'
            write (iout,'(3x,20i10)') (l,l=1,ntermd_2(i,j,k,iblock))
            do l=1,ntermd_2(i,j,k,iblock)
              write (iout,'(i5,20f10.5)') &
               l,(v2c(l,m,i,j,k,iblock),m=1,ntermd_2(i,j,k,iblock))
            enddo
            write (iout,*)
           write (iout,'(3x,20i10)') (l,l=1,ntermd_2(i,j,k,iblock))
            do l=1,ntermd_2(i,j,k,iblock)
              write (iout,'(i5,20f10.5)') &
               l,(v2s(l,m,i,j,k,iblock),m=1,ntermd_2(i,j,k,iblock)),&
               (v2s(l,m,-i,-j,-k,iblock),m=1,ntermd_2(i,j,k,iblock))
            enddo
            write (iout,*)
          enddo
        enddo
      enddo
      enddo
      endif
#ifndef NEWCORR
      do i=1,ntyp1
        itype2loc(i)=itortyp(i)
      enddo
#endif
      ELSE IF (TOR_MODE.eq.1) THEN

!C read valence-torsional parameters
      read (itorp,*) ntortyp
      nkcctyp=ntortyp
      write (iout,*) "Valence-torsional parameters read in ntortyp",&
        ntortyp
      read (itorp,*) (itortyp(i),i=1,ntyp)
      write (iout,*) "itortyp_kcc",(itortyp(i),i=1,ntyp)
#ifndef NEWCORR
      do i=1,ntyp1
        itype2loc(i)=itortyp(i)
      enddo
#endif
      do i=-ntyp,-1
        itortyp(i)=-itortyp(-i)
      enddo
      do i=-ntortyp+1,ntortyp-1
        do j=-ntortyp+1,ntortyp-1
!C first we read the cos and sin gamma parameters
          read (itorp,'(13x,a)') string
          write (iout,*) i,j,string
          read (itorp,*) &
         nterm_kcc(j,i),nterm_kcc_Tb(j,i)
!C           read (itorkcc,*,end=121,err=121) nterm_kcc_Tb(j,i)
          do k=1,nterm_kcc(j,i)
            do l=1,nterm_kcc_Tb(j,i)
              do ll=1,nterm_kcc_Tb(j,i)
              read (itorp,*) ii,jj,kk, &
               v1_kcc(ll,l,k,j,i),v2_kcc(ll,l,k,j,i)
              enddo
            enddo
          enddo
        enddo
      enddo
      ELSE
#ifdef NEWCORR
!c AL 4/8/16: Calculate coefficients from one-body parameters
      ntortyp=nloctyp
      allocate(itortyp(-ntyp1:ntyp1)) !(-ntyp1:ntyp1)
      allocate(nterm_kcc(-ntyp1:ntyp1,-ntyp1:ntyp1))
      allocate(nterm_kcc_Tb(-ntyp1:ntyp1,-ntyp1:ntyp1))
      allocate(v1_kcc(6,6,6,-ntyp1:ntyp1,-ntyp1:ntyp1))
      allocate(v2_kcc(6,6,6,-ntyp1:ntyp1,-ntyp1:ntyp1))

      do i=-ntyp1,ntyp1
       print *,i,itortyp(i)
       itortyp(i)=itype2loc(i)
      enddo
      write (iout,*) &
      "Val-tor parameters calculated from cumulant coefficients ntortyp"&
      ,ntortyp
      do i=-ntortyp+1,ntortyp-1
        do j=-ntortyp+1,ntortyp-1
          nterm_kcc(j,i)=2
          nterm_kcc_Tb(j,i)=3
          do k=1,nterm_kcc_Tb(j,i)
            do l=1,nterm_kcc_Tb(j,i)
              v1_kcc(k,l,1,i,j)=bnew1tor(k,1,i)*bnew2tor(l,1,j)&
                              +bnew1tor(k,2,i)*bnew2tor(l,2,j)
              v2_kcc(k,l,1,i,j)=bnew1tor(k,1,i)*bnew2tor(l,2,j)&
                              +bnew1tor(k,2,i)*bnew2tor(l,1,j)
            enddo
          enddo
          do k=1,nterm_kcc_Tb(j,i)
            do l=1,nterm_kcc_Tb(j,i)
#ifdef CORRCD
              v1_kcc(k,l,2,i,j)=-(ccnewtor(k,1,i)*ddnewtor(l,1,j) &
                              -ccnewtor(k,2,i)*ddnewtor(l,2,j))
              v2_kcc(k,l,2,i,j)=-(ccnewtor(k,2,i)*ddnewtor(l,1,j) &
                              +ccnewtor(k,1,i)*ddnewtor(l,2,j))
#else
              v1_kcc(k,l,2,i,j)=-0.25*(ccnewtor(k,1,i)*ddnewtor(l,1,j) &
                              -ccnewtor(k,2,i)*ddnewtor(l,2,j))
              v2_kcc(k,l,2,i,j)=-0.25*(ccnewtor(k,2,i)*ddnewtor(l,1,j) &
                              +ccnewtor(k,1,i)*ddnewtor(l,2,j))
#endif
            enddo
          enddo
!c f(theta,gamma)=-(b21(theta)*b11(theta)+b12(theta)*b22(theta))*cos(gamma)-(b22(theta)*b11(theta)+b21(theta)*b12(theta))*sin(gamma)+(c11(theta)*d11(theta)-c12(theta)*d12(theta))*cos(2*gamma)+(c12(theta)*d11(theta)+c11(theta)*d12(theta))*sin(2*gamma)
        enddo
      enddo
#else
      write (iout,*) "TOR_MODE>1 only with NEWCORR"
      stop
#endif
      ENDIF ! TOR_MODE
      if (tor_mode.gt.0 .and. lprint) then
!c Print valence-torsional parameters
        write (iout,'(a)') &
         "Parameters of the valence-torsional potentials"
        do i=-ntortyp+1,ntortyp-1
        do j=-ntortyp+1,ntortyp-1
        write (iout,'(3a)') "Type ",toronelet(i),toronelet(j)
        write (iout,'(3a5,2a15)') "itor","ival","jval","v_kcc","v2_kcc"
        do k=1,nterm_kcc(j,i)
          do l=1,nterm_kcc_Tb(j,i)
            do ll=1,nterm_kcc_Tb(j,i)
               write (iout,'(3i5,2f15.4)')&
                 k,l-1,ll-1,v1_kcc(ll,l,k,j,i),v2_kcc(ll,l,k,j,i)
            enddo
          enddo
        enddo
        enddo
        enddo
      endif

#endif
!elwrite(iout,*) "parmread kontrol sc-bb"
! Read of Side-chain backbone correlation parameters
! Modified 11 May 2012 by Adasko
!CC
!
     read (isccor,*) nsccortyp

     maxinter=3
!c maxinter is maximum interaction sites
!write(iout,*)"maxterm_sccor",maxterm_sccor
!el from module energy-------------
      allocate(nlor_sccor(nsccortyp,nsccortyp)) !(-ntyp:ntyp,-ntyp:ntyp)
      allocate(vlor1sccor(maxterm_sccor,nsccortyp,nsccortyp))
      allocate(vlor2sccor(maxterm_sccor,nsccortyp,nsccortyp))
      allocate(vlor3sccor(maxterm_sccor,nsccortyp,nsccortyp))   !(maxterm_sccor,20,20)
!-----------------------------------
      allocate(isccortyp(-ntyp:ntyp)) !(-ntyp:ntyp)
!-----------------------------------
      allocate(nterm_sccor(-nsccortyp:nsccortyp,-nsccortyp:nsccortyp)) !(-ntyp:ntyp,-ntyp:ntyp)
      allocate(v1sccor(maxterm_sccor,maxinter,-nsccortyp:nsccortyp,&
               -nsccortyp:nsccortyp))
      allocate(v2sccor(maxterm_sccor,maxinter,-nsccortyp:nsccortyp,&
               -nsccortyp:nsccortyp)) !(maxterm_sccor,3,-ntyp:ntyp,-ntyp:ntyp)
      allocate(v0sccor(maxinter,-nsccortyp:nsccortyp,&
               -nsccortyp:nsccortyp)) !(maxterm_sccor,-ntyp:ntyp,-ntyp:ntyp)
!-----------------------------------
      do i=-nsccortyp,nsccortyp
        do j=-nsccortyp,nsccortyp
          nterm_sccor(j,i)=0
        enddo
      enddo
!-----------------------------------

      read (isccor,*) (isccortyp(i),i=1,ntyp)
      do i=-ntyp,-1
        isccortyp(i)=-isccortyp(-i)
      enddo
      iscprol=isccortyp(20)
!      write (iout,*) 'ntortyp',ntortyp
!      maxinter=3
!c maxinter is maximum interaction sites
      do l=1,maxinter
      do i=1,nsccortyp
        do j=1,nsccortyp
          read (isccor,*) &
      nterm_sccor(i,j),nlor_sccor(i,j)
          v0ijsccor=0.0d0
          v0ijsccor1=0.0d0
          v0ijsccor2=0.0d0
          v0ijsccor3=0.0d0
          si=-1.0d0
          nterm_sccor(-i,j)=nterm_sccor(i,j)
          nterm_sccor(-i,-j)=nterm_sccor(i,j)
          nterm_sccor(i,-j)=nterm_sccor(i,j)
          do k=1,nterm_sccor(i,j)
            read (isccor,*) kk,v1sccor(k,l,i,j),&
            v2sccor(k,l,i,j)
            if (j.eq.iscprol) then
             if (i.eq.isccortyp(10)) then
             v1sccor(k,l,i,-j)=v1sccor(k,l,i,j)
             v2sccor(k,l,i,-j)=-v2sccor(k,l,i,j)
             else
             v1sccor(k,l,i,-j)=v1sccor(k,l,i,j)*0.5d0 &
                              +v2sccor(k,l,i,j)*dsqrt(0.75d0)
             v2sccor(k,l,i,-j)=-v2sccor(k,l,i,j)*0.5d0 &
                              +v1sccor(k,l,i,j)*dsqrt(0.75d0)
             v1sccor(k,l,-i,-j)=v1sccor(k,l,i,j)
             v2sccor(k,l,-i,-j)=-v2sccor(k,l,i,j)
             v1sccor(k,l,-i,j)=v1sccor(k,l,i,-j)
             v2sccor(k,l,-i,j)=-v2sccor(k,l,i,-j)
             endif
            else
             if (i.eq.isccortyp(10)) then
             v1sccor(k,l,i,-j)=v1sccor(k,l,i,j)
             v2sccor(k,l,i,-j)=-v2sccor(k,l,i,j)
             else
               if (j.eq.isccortyp(10)) then
             v1sccor(k,l,-i,j)=v1sccor(k,l,i,j)
             v2sccor(k,l,-i,j)=-v2sccor(k,l,i,j)
               else
             v1sccor(k,l,i,-j)=-v1sccor(k,l,i,j)
             v2sccor(k,l,i,-j)=-v2sccor(k,l,i,j)
             v1sccor(k,l,-i,-j)=v1sccor(k,l,i,j)
             v2sccor(k,l,-i,-j)=-v2sccor(k,l,i,j)
             v1sccor(k,l,-i,j)=v1sccor(k,l,i,-j)
             v2sccor(k,l,-i,j)=-v2sccor(k,l,i,-j)
                endif
               endif
            endif
            v0ijsccor=v0ijsccor+si*v1sccor(k,l,i,j)
            v0ijsccor1=v0ijsccor+si*v1sccor(k,l,-i,j)
            v0ijsccor2=v0ijsccor+si*v1sccor(k,l,i,-j)
            v0ijsccor3=v0ijsccor+si*v1sccor(k,l,-i,-j)
            si=-si
           enddo
          do k=1,nlor_sccor(i,j)
            read (isccor,*) kk,vlor1sccor(k,i,j),&
              vlor2sccor(k,i,j),vlor3sccor(k,i,j)
            v0ijsccor=v0ijsccor+vlor1sccor(k,i,j)/ &
      (1+vlor3sccor(k,i,j)**2)
          enddo
          v0sccor(l,i,j)=v0ijsccor
          v0sccor(l,-i,j)=v0ijsccor1
          v0sccor(l,i,-j)=v0ijsccor2
          v0sccor(l,-i,-j)=v0ijsccor3
          enddo
        enddo
      enddo
      close (isccor)
      if (lprint) then
        write (iout,'(/a/)') 'Torsional constants of SCCORR:'
        do i=1,nsccortyp
          do j=1,nsccortyp
            write (iout,*) 'ityp',i,' jtyp',j
            write (iout,*) 'Fourier constants'
            do k=1,nterm_sccor(i,j)
              write (iout,'(2(1pe15.5))') &
         (v1sccor(k,l,i,j),v2sccor(k,l,i,j),l=1,maxinter)
            enddo
            write (iout,*) 'Lorenz constants'
            do k=1,nlor_sccor(i,j)
              write (iout,'(3(1pe15.5))') &
               vlor1sccor(k,i,j),vlor2sccor(k,i,j),vlor3sccor(k,i,j)
            enddo
          enddo
        enddo
      endif

! 
! Read electrostatic-interaction parameters
!
      if (lprint) then
	write (iout,'(/a)') 'Electrostatic interaction constants:'
	write (iout,'(1x,a,1x,a,10x,a,11x,a,11x,a,11x,a)') &
                  'IT','JT','APP','BPP','AEL6','AEL3'
      endif
      read (ielep,*) ((epp(i,j),j=1,2),i=1,2)
      read (ielep,*) ((rpp(i,j),j=1,2),i=1,2)
      read (ielep,*) ((elpp6(i,j),j=1,2),i=1,2)
      read (ielep,*) ((elpp3(i,j),j=1,2),i=1,2)
      close (ielep)
      do i=1,2
        do j=1,2
        rri=rpp(i,j)**6
        app (i,j)=epp(i,j)*rri*rri 
        bpp (i,j)=-2.0D0*epp(i,j)*rri
        ael6(i,j)=elpp6(i,j)*4.2D0**6
        ael3(i,j)=elpp3(i,j)*4.2D0**3
        if (lprint) write(iout,'(2i3,4(1pe15.4))')i,j,app(i,j),bpp(i,j),&
                          ael6(i,j),ael3(i,j)
        enddo
      enddo
!
! Read side-chain interaction parameters.
!
!el from module energy - COMMON.INTERACT-------
      allocate(eps(ntyp,ntyp),sigmaii(ntyp,ntyp),rs0(ntyp,ntyp)) !(ntyp,ntyp)
      allocate(augm(ntyp,ntyp)) !(ntyp,ntyp)
      allocate(eps_scp(ntyp,2),rscp(ntyp,2)) !(ntyp,2)
      allocate(sigma0(ntyp),rr0(ntyp),sigii(ntyp)) !(ntyp)
      allocate(chip(ntyp1),alp(ntyp1)) !(ntyp)
      allocate(epslip(ntyp,ntyp))
      do i=1,ntyp
        do j=1,ntyp
          augm(i,j)=0.0D0
        enddo
        chip(i)=0.0D0
        alp(i)=0.0D0
        sigma0(i)=0.0D0
        sigii(i)=0.0D0
        rr0(i)=0.0D0
      enddo
!--------------------------------

      read (isidep,*) ipot,expon
!el      if (ipot.lt.1 .or. ipot.gt.5) then
!        write (iout,'(2a)') 'Error while reading SC interaction',&
!                     'potential file - unknown potential type.'
!        stop
!wl      endif
      expon2=expon/2
      write(iout,'(/3a,2i3)') 'Potential is ',potname(ipot),&
       ', exponents are ',expon,2*expon 
!      goto (10,20,30,30,40) ipot
      select case(ipot)
!----------------------- LJ potential ---------------------------------
       case (1)
!   10 read (isidep,*)((eps(i,j),j=i,ntyp),i=1,ntyp),(sigma0(i),i=1,ntyp)
        read (isidep,*)((eps(i,j),j=i,ntyp),i=1,ntyp),(sigma0(i),i=1,ntyp)
        if (lprint) then
	  write (iout,'(/a/)') 'Parameters of the LJ potential:'
	  write (iout,'(a/)') 'The epsilon array:'
	  call printmat(ntyp,ntyp,ntyp,iout,restyp,eps)
	  write (iout,'(/a)') 'One-body parameters:'
	  write (iout,'(a,4x,a)') 'residue','sigma'
	  write (iout,'(a3,6x,f10.5)') (restyp(i,molnum(i)),sigma0(i),i=1,ntyp)
        endif
!      goto 50
!----------------------- LJK potential --------------------------------
       case (2)
!   20 read (isidep,*)((eps(i,j),j=i,ntyp),i=1,ntyp),&
        read (isidep,*)((eps(i,j),j=i,ntyp),i=1,ntyp),&
          (sigma0(i),i=1,ntyp),(rr0(i),i=1,ntyp)
        if (lprint) then
          write (iout,'(/a/)') 'Parameters of the LJK potential:'
          write (iout,'(a/)') 'The epsilon array:'
          call printmat(ntyp,ntyp,ntyp,iout,restyp,eps)
          write (iout,'(/a)') 'One-body parameters:'
          write (iout,'(a,4x,2a)') 'residue','   sigma  ','    r0    '
          write (iout,'(a3,6x,2f10.5)') (restyp(i,molnum(i)),sigma0(i),rr0(i),&
                i=1,ntyp)
        endif
!      goto 50
!---------------------- GB or BP potential -----------------------------
       case (3:4)
!   30 do i=1,ntyp
        if (scelemode.eq.0) then
        do i=1,ntyp
         read (isidep,*)(eps(i,j),j=i,ntyp)
        enddo
        read (isidep,*)(sigma0(i),i=1,ntyp)
        read (isidep,*)(sigii(i),i=1,ntyp)
        read (isidep,*)(chip(i),i=1,ntyp)
        read (isidep,*)(alp(i),i=1,ntyp)
        do i=1,ntyp
         read (isidep,*)(epslip(i,j),j=i,ntyp)
        enddo
! For the GB potential convert sigma'**2 into chi'
        if (ipot.eq.4) then
	  do i=1,ntyp
	    chip(i)=(chip(i)-1.0D0)/(chip(i)+1.0D0)
          enddo
        endif
        if (lprint) then
	  write (iout,'(/a/)') 'Parameters of the BP potential:'
	  write (iout,'(a/)') 'The epsilon array:'
	  call printmat(ntyp,ntyp,ntyp,iout,restyp,eps)
	  write (iout,'(/a)') 'One-body parameters:'
	  write (iout,'(a,4x,4a)') 'residue','   sigma  ','s||/s_|_^2',&
               '    chip  ','    alph  '
	  write (iout,'(a3,6x,4f10.5)') (restyp(i,molnum(i)),sigma0(i),sigii(i),&
                           chip(i),alp(i),i=1,ntyp)
        endif
        else
      allocate(icharge(ntyp1))
!      print *,ntyp,icharge(i)
      icharge(:)=0
      read (isidep,*) (icharge(i),i=1,ntyp)
      print *,ntyp,icharge(i)
!      if(.not.allocated(eps)) allocate(eps(-ntyp
      write (2,*) "icharge",(icharge(i),i=1,ntyp)
       allocate(alphapol(ntyp,ntyp),epshead(ntyp,ntyp),sig0head(ntyp,ntyp))
       allocate(sigiso1(ntyp,ntyp),rborn(ntyp,ntyp),sigmap1(ntyp,ntyp))
       allocate(sigmap2(ntyp,ntyp),sigiso2(ntyp,ntyp))
       allocate(chis(ntyp,ntyp),wquad(ntyp,ntyp),chipp(ntyp,ntyp))
       allocate(epsintab(ntyp,ntyp))
       allocate(dtail(2,ntyp,ntyp))
      print *,"control line 1"
       allocate(alphasur(4,ntyp,ntyp),alphiso(4,ntyp,ntyp))
       allocate(wqdip(2,ntyp,ntyp))
       allocate(wstate(4,ntyp,ntyp))
       allocate(dhead(2,2,ntyp,ntyp))
       allocate(nstate(ntyp,ntyp))
       allocate(debaykap(ntyp,ntyp))
      print *,"control line 2"
      if (.not.allocated(sigma)) allocate(sigma(0:ntyp1,0:ntyp1))
      if (.not.allocated(chi)) allocate(chi(ntyp1,ntyp1)) !(ntyp,ntyp)

      do i=1,ntyp
       do j=1,i
!        write (*,*) "Im in ALAB", i, " ", j
        read(isidep,*) &
       eps(i,j),sigma(i,j),chi(i,j),chi(j,i),chipp(i,j),chipp(j,i), &
       (alphasur(k,i,j),k=1,4),sigmap1(i,j),sigmap2(i,j), &
       chis(i,j),chis(j,i), &
       nstate(i,j),(wstate(k,i,j),k=1,4), &
       dhead(1,1,i,j),dhead(1,2,i,j),dhead(2,1,i,j),dhead(2,2,i,j),&
       dtail(1,i,j),dtail(2,i,j), &
       epshead(i,j),sig0head(i,j), &
       rborn(i,j),rborn(j,i),(wqdip(k,i,j),k=1,2),wquad(i,j), &
       alphapol(i,j),alphapol(j,i), &
       (alphiso(k,i,j),k=1,4),sigiso1(i,j),sigiso2(i,j),epsintab(i,j),debaykap(i,j)
!       print *,eps(i,j),sigma(i,j),"SIGMAP",i,j,sigmap1(i,j),sigmap2(j,i) 
       END DO
      END DO
      DO i = 1, ntyp
       DO j = i+1, ntyp
        eps(i,j) = eps(j,i)
        sigma(i,j) = sigma(j,i)
        sigmap1(i,j)=sigmap1(j,i)
        sigmap2(i,j)=sigmap2(j,i)
        sigiso1(i,j)=sigiso1(j,i)
        sigiso2(i,j)=sigiso2(j,i)
!        print *,"ATU",sigma(j,i),sigma(i,j),i,j
        nstate(i,j) = nstate(j,i)
        dtail(1,i,j) = dtail(2,j,i)
        dtail(2,i,j) = dtail(1,j,i)
        DO k = 1, 4
         alphasur(k,i,j) = alphasur(k,j,i)
         wstate(k,i,j) = wstate(k,j,i)
         alphiso(k,i,j) = alphiso(k,j,i)
        END DO

        dhead(2,1,i,j) = dhead(1,1,j,i)
        dhead(2,2,i,j) = dhead(1,2,j,i)
        dhead(1,1,i,j) = dhead(2,1,j,i)
        dhead(1,2,i,j) = dhead(2,2,j,i)

        epshead(i,j) = epshead(j,i)
        sig0head(i,j) = sig0head(j,i)

        DO k = 1, 2
         wqdip(k,i,j) = wqdip(k,j,i)
        END DO

        wquad(i,j) = wquad(j,i)
        epsintab(i,j) = epsintab(j,i)
        debaykap(i,j)=debaykap(j,i)
!        if (epsintab(i,j).ne.1.0) print *,"WHAT?",i,j,epsintab(i,j)
       END DO
      END DO
      endif

!      goto 50
!--------------------- GBV potential -----------------------------------
       case (5)
!   40 read (isidep,*)((eps(i,j),j=i,ntyp),i=1,ntyp),&
        read (isidep,*)((eps(i,j),j=i,ntyp),i=1,ntyp),&
          (sigma0(i),i=1,ntyp),(rr0(i),i=1,ntyp),(sigii(i),i=1,ntyp),&
        (chip(i),i=1,ntyp),(alp(i),i=1,ntyp)
        if (lprint) then
	  write (iout,'(/a/)') 'Parameters of the GBV potential:'
	  write (iout,'(a/)') 'The epsilon array:'
	  call printmat(ntyp,ntyp,ntyp,iout,restyp,eps)
	  write (iout,'(/a)') 'One-body parameters:'
	  write (iout,'(a,4x,5a)') 'residue','   sigma  ','    r0    ',&
            's||/s_|_^2','    chip  ','    alph  '
	  write (iout,'(a3,6x,5f10.5)') (restyp(i,molnum(i)),sigma0(i),rr0(i),&
                 sigii(i),chip(i),alp(i),i=1,ntyp)
        endif
       case default
        write (iout,'(2a)') 'Error while reading SC interaction',&
                     'potential file - unknown potential type.'
        stop
!   50 continue
      end select
!      continue
      close (isidep)
!-----------------------------------------------------------------------
! Calculate the "working" parameters of SC interactions.

!el from module energy - COMMON.INTERACT-------
!      allocate(aa(ntyp1,ntyp1),bb(ntyp1,ntyp1),chi(ntyp1,ntyp1)) !(ntyp,ntyp)
            if (.not.allocated(chi)) allocate(chi(ntyp1,ntyp1))
      allocate(aa_aq(ntyp1,ntyp1),bb_aq(ntyp1,ntyp1)) !(ntyp,ntyp)
      allocate(aa_lip(ntyp1,ntyp1),bb_lip(ntyp1,ntyp1)) !(ntyp,ntyp)
      if (.not.allocated(sigma)) allocate(sigma(0:ntyp1,0:ntyp1))
      allocate(r0(ntyp1,ntyp1)) !(0:ntyp1,0:ntyp1)
      allocate(acavtub(ntyp1),bcavtub(ntyp1),ccavtub(ntyp1),&
        dcavtub(ntyp1))
      allocate(sc_aa_tube_par(ntyp1),sc_bb_tube_par(ntyp1),&
        tubetranene(ntyp1))
      do i=1,ntyp1
        do j=1,ntyp1
          aa_aq(i,j)=0.0D0
          bb_aq(i,j)=0.0D0
          aa_lip(i,j)=0.0d0
          bb_lip(i,j)=0.0d0
               if (scelemode.eq.0) then
          chi(i,j)=0.0D0
          sigma(i,j)=0.0D0
          r0(i,j)=0.0D0
            endif
        enddo
      enddo
!--------------------------------

      do i=2,ntyp
        do j=1,i-1
	  eps(i,j)=eps(j,i)
          epslip(i,j)=epslip(j,i)
        enddo
      enddo
      if (scelemode.eq.0) then
      do i=1,ntyp
        do j=i,ntyp
          sigma(i,j)=dsqrt(sigma0(i)**2+sigma0(j)**2)
          sigma(j,i)=sigma(i,j)
          rs0(i,j)=dwa16*sigma(i,j)
          rs0(j,i)=rs0(i,j)
        enddo
      enddo
      endif
      if (lprint) write (iout,'(/a/10x,7a/72(1h-))') &
       'Working parameters of the SC interactions:',&
       '     a    ','     b    ','   augm   ','  sigma ','   r0   ',&
       '  chi1   ','   chi2   ' 
      do i=1,ntyp
	do j=i,ntyp
	  epsij=eps(i,j)
	  if (ipot.eq.1 .or. ipot.eq.3 .or. ipot.eq.4) then
	    rrij=sigma(i,j)
            print *,"rrij",rrij
          else
	    rrij=rr0(i)+rr0(j)
          endif
	  r0(i,j)=rrij
	  r0(j,i)=rrij
	  rrij=rrij**expon
	  epsij=eps(i,j)
	  sigeps=dsign(1.0D0,epsij)
	  epsij=dabs(epsij)
          aa_aq(i,j)=epsij*rrij*rrij
          bb_aq(i,j)=-sigeps*epsij*rrij
          aa_aq(j,i)=aa_aq(i,j)
          bb_aq(j,i)=bb_aq(i,j)
          epsijlip=epslip(i,j)
          sigeps=dsign(1.0D0,epsijlip)
          epsijlip=dabs(epsijlip)
          aa_lip(i,j)=epsijlip*rrij*rrij
          bb_lip(i,j)=-sigeps*epsijlip*rrij
          aa_lip(j,i)=aa_lip(i,j)
          bb_lip(j,i)=bb_lip(i,j)
	  if ((ipot.gt.2).and. (scelemode.eq.0))then
	    sigt1sq=sigma0(i)**2
	    sigt2sq=sigma0(j)**2
	    sigii1=sigii(i)
	    sigii2=sigii(j)
            ratsig1=sigt2sq/sigt1sq
	    ratsig2=1.0D0/ratsig1
	    chi(i,j)=(sigii1-1.0D0)/(sigii1+ratsig1)
	    if (j.gt.i) chi(j,i)=(sigii2-1.0D0)/(sigii2+ratsig2)
            rsum_max=dsqrt(sigii1*sigt1sq+sigii2*sigt2sq)
          else
	    rsum_max=sigma(i,j)
          endif
!         if (ipot.eq.1 .or. ipot.eq.3 .or. ipot.eq.4) then
            sigmaii(i,j)=rsum_max
            sigmaii(j,i)=rsum_max 
!         else
!           sigmaii(i,j)=r0(i,j)
!           sigmaii(j,i)=r0(i,j)
!         endif
!d        write (iout,*) i,j,r0(i,j),sigma(i,j),rsum_max
          if ((ipot.eq.2 .or. ipot.eq.5) .and. r0(i,j).gt.rsum_max) then
            r_augm=sigma(i,j)*(rrij-sigma(i,j))/rrij
            augm(i,j)=epsij*r_augm**(2*expon)
!           augm(i,j)=0.5D0**(2*expon)*aa(i,j)
	    augm(j,i)=augm(i,j)
          else
	    augm(i,j)=0.0D0
	    augm(j,i)=0.0D0
          endif
	  if (lprint) then
            write (iout,'(2(a3,2x),3(1pe10.3),5(0pf8.3))')  &
            restyp(i,molnum(i)),restyp(j,molnum(i)),aa_aq(i,j),bb_aq(i,j),augm(i,j),&
            sigma(i,j),r0(i,j),chi(i,j),chi(j,i)
	  endif
        enddo
      enddo
      allocate(eps_nucl(ntyp_molec(2),ntyp_molec(2)))
      allocate(sigma_nucl(ntyp_molec(2),ntyp_molec(2))) !(ntyp_molec(2),ntyp_molec(2))
      allocate(elpp6_nucl(ntyp_molec(2),ntyp_molec(2))) !(ntyp_molec(2),ntyp_molec(2))
      allocate(elpp3_nucl(ntyp_molec(2),ntyp_molec(2))) !(ntyp,2)
      allocate(elpp63_nucl(ntyp_molec(2),ntyp_molec(2))) !(ntyp_molec(2),ntyp_molec(2))
      allocate(elpp32_nucl(ntyp_molec(2),ntyp_molec(2))) !(ntyp,2)
      allocate(chi_nucl(ntyp_molec(2),ntyp_molec(2)),chip_nucl(ntyp_molec(2),ntyp_molec(2))) !(ntyp_molec(2),ntyp_molec(2))
      allocate(ael3_nucl(ntyp_molec(2),ntyp_molec(2))) !(ntyp,2)
      allocate(ael6_nucl(ntyp_molec(2),ntyp_molec(2))) !(ntyp,2)
      allocate(ael32_nucl(ntyp_molec(2),ntyp_molec(2))) !(ntyp,2)
      allocate(ael63_nucl(ntyp_molec(2),ntyp_molec(2))) !(ntyp,2)
      allocate(aa_nucl(ntyp_molec(2),ntyp_molec(2))) !(ntyp,2)
      allocate(bb_nucl(ntyp_molec(2),ntyp_molec(2))) !(ntyp,2)
      allocate(r0_nucl(ntyp_molec(2),ntyp_molec(2))) !(ntyp,2)
      allocate(sigmaii_nucl(ntyp_molec(2),ntyp_molec(2))) !(ntyp_molec(2),ntyp_molec(2))
      allocate(eps_scp_nucl(ntyp_molec(2)),rscp_nucl(ntyp_molec(2))) !(ntyp,2)

!      augm(:,:)=0.0D0
!      chip(:)=0.0D0
!      alp(:)=0.0D0
!      sigma0(:)=0.0D0
!      sigii(:)=0.0D0
!      rr0(:)=0.0D0

      read (isidep_nucl,*) ipot_nucl
!      print *,"TU?!",ipot_nucl
      if (ipot_nucl.eq.1) then
        do i=1,ntyp_molec(2)
          do j=i,ntyp_molec(2)
            read (isidep_nucl,*) eps_nucl(i,j),sigma_nucl(i,j),elpp6_nucl(i,j),&
            elpp3_nucl(i,j), elpp63_nucl(i,j),elpp32_nucl(i,j)
          enddo
        enddo
      else
        do i=1,ntyp_molec(2)
          do j=i,ntyp_molec(2)
            read (isidep_nucl,*) eps_nucl(i,j),sigma_nucl(i,j),chi_nucl(i,j),&
               chi_nucl(j,i),chip_nucl(i,j),chip_nucl(j,i),&
               elpp6_nucl(i,j),elpp3_nucl(i,j),elpp63_nucl(i,j),elpp32_nucl(i,j)
          enddo
        enddo
      endif
!      rpp(1,1)=2**(1.0/6.0)*5.16158
      do i=1,ntyp_molec(2)
        do j=i,ntyp_molec(2)
          rrij=sigma_nucl(i,j)
          r0_nucl(i,j)=rrij
          r0_nucl(j,i)=rrij
          rrij=rrij**expon
          epsij=4*eps_nucl(i,j)
          sigeps=dsign(1.0D0,epsij)
          epsij=dabs(epsij)
          aa_nucl(i,j)=epsij*rrij*rrij
          bb_nucl(i,j)=-sigeps*epsij*rrij
          ael3_nucl(i,j)=elpp3_nucl(i,j)*dsqrt(rrij)
          ael6_nucl(i,j)=elpp6_nucl(i,j)*rrij
          ael63_nucl(i,j)=elpp63_nucl(i,j)*rrij
          ael32_nucl(i,j)=elpp32_nucl(i,j)*rrij
          sigmaii_nucl(i,j)=sigma_nucl(i,j)/sqrt(1-(chi_nucl(i,j)+chi_nucl(j,i)- &
         2*chi_nucl(i,j)*chi_nucl(j,i))/(1-chi_nucl(i,j)*chi_nucl(j,i)))
        enddo
        do j=1,i-1
          aa_nucl(i,j)=aa_nucl(j,i)
          bb_nucl(i,j)=bb_nucl(j,i)
          ael3_nucl(i,j)=ael3_nucl(j,i)
          ael6_nucl(i,j)=ael6_nucl(j,i)
          ael63_nucl(i,j)=ael63_nucl(j,i)
          ael32_nucl(i,j)=ael32_nucl(j,i)
          elpp3_nucl(i,j)=elpp3_nucl(j,i)
          elpp6_nucl(i,j)=elpp6_nucl(j,i)
          elpp63_nucl(i,j)=elpp63_nucl(j,i)
          elpp32_nucl(i,j)=elpp32_nucl(j,i)
          eps_nucl(i,j)=eps_nucl(j,i)
          sigma_nucl(i,j)=sigma_nucl(j,i)
          sigmaii_nucl(i,j)=sigmaii_nucl(j,i)
        enddo
      enddo

      write(iout,*) "tube param"
      read(itube,*) epspeptube,sigmapeptube,acavtubpep,bcavtubpep, &
      ccavtubpep,dcavtubpep,tubetranenepep
      sigmapeptube=sigmapeptube**6
      sigeps=dsign(1.0D0,epspeptube)
      epspeptube=dabs(epspeptube)
      pep_aa_tube=4.0d0*epspeptube*sigmapeptube**2
      pep_bb_tube=-sigeps*4.0d0*epspeptube*sigmapeptube
      write(iout,*) pep_aa_tube,pep_bb_tube,tubetranenepep
      do i=1,ntyp
       read(itube,*) epssctube,sigmasctube,acavtub(i),bcavtub(i), &
      ccavtub(i),dcavtub(i),tubetranene(i)
       sigmasctube=sigmasctube**6
       sigeps=dsign(1.0D0,epssctube)
       epssctube=dabs(epssctube)
       sc_aa_tube_par(i)=4.0d0*epssctube*sigmasctube**2
       sc_bb_tube_par(i)=-sigeps*4.0d0*epssctube*sigmasctube
      write(iout,*) sc_aa_tube_par(i), sc_bb_tube_par(i),tubetranene(i)
      enddo
!-----------------READING SC BASE POTENTIALS-----------------------------
      allocate(eps_scbase(ntyp_molec(1),ntyp_molec(2)))
      allocate(sigma_scbase(ntyp_molec(1),ntyp_molec(2)))
      allocate(chi_scbase(ntyp_molec(1),ntyp_molec(2),2))
      allocate(chipp_scbase(ntyp_molec(1),ntyp_molec(2),2))
      allocate(alphasur_scbase(4,ntyp_molec(1),ntyp_molec(2)))
      allocate(sigmap1_scbase(ntyp_molec(1),ntyp_molec(2)))
      allocate(sigmap2_scbase(ntyp_molec(1),ntyp_molec(2)))
      allocate(chis_scbase(ntyp_molec(1),ntyp_molec(2),2))
      allocate(dhead_scbasei(ntyp_molec(1),ntyp_molec(2)))
      allocate(dhead_scbasej(ntyp_molec(1),ntyp_molec(2)))
      allocate(rborn_scbasei(ntyp_molec(1),ntyp_molec(2)))
      allocate(rborn_scbasej(ntyp_molec(1),ntyp_molec(2)))
      allocate(wdipdip_scbase(3,ntyp_molec(1),ntyp_molec(2)))
      allocate(wqdip_scbase(2,ntyp_molec(1),ntyp_molec(2)))
      allocate(alphapol_scbase(ntyp_molec(1),ntyp_molec(2)))
      allocate(epsintab_scbase(ntyp_molec(1),ntyp_molec(2)))


      do i=1,ntyp_molec(1)
       do j=1,ntyp_molec(2)-1 ! without U then we will take T for U
        write (*,*) "Im in ", i, " ", j
        read(isidep_scbase,*) &
        eps_scbase(i,j),sigma_scbase(i,j),chi_scbase(i,j,1),&
        chi_scbase(i,j,2),chipp_scbase(i,j,1),chipp_scbase(i,j,2)
         write(*,*) "eps",eps_scbase(i,j)
        read(isidep_scbase,*) &
       (alphasur_scbase(k,i,j),k=1,4),sigmap1_scbase(i,j),sigmap2_scbase(i,j), &
       chis_scbase(i,j,1),chis_scbase(i,j,2)
        read(isidep_scbase,*) &
       dhead_scbasei(i,j), &
       dhead_scbasej(i,j), &
       rborn_scbasei(i,j),rborn_scbasej(i,j)
        read(isidep_scbase,*) &
       (wdipdip_scbase(k,i,j),k=1,3), &
       (wqdip_scbase(k,i,j),k=1,2)
        read(isidep_scbase,*) &
       alphapol_scbase(i,j), &
       epsintab_scbase(i,j)
       END DO
      END DO
      allocate(aa_scbase(ntyp_molec(1),ntyp_molec(2)))
      allocate(bb_scbase(ntyp_molec(1),ntyp_molec(2)))

      do i=1,ntyp_molec(1)
       do j=1,ntyp_molec(2)-1
          epsij=eps_scbase(i,j)
          rrij=sigma_scbase(i,j)
!          r0(i,j)=rrij
!          r0(j,i)=rrij
          rrij=rrij**expon
!          epsij=eps(i,j)
          sigeps=dsign(1.0D0,epsij)
          epsij=dabs(epsij)
          aa_scbase(i,j)=epsij*rrij*rrij
          bb_scbase(i,j)=-sigeps*epsij*rrij
        enddo
       enddo
!-----------------READING PEP BASE POTENTIALS-------------------
      allocate(eps_pepbase(ntyp_molec(2)))
      allocate(sigma_pepbase(ntyp_molec(2)))
      allocate(chi_pepbase(ntyp_molec(2),2))
      allocate(chipp_pepbase(ntyp_molec(2),2))
      allocate(alphasur_pepbase(4,ntyp_molec(2)))
      allocate(sigmap1_pepbase(ntyp_molec(2)))
      allocate(sigmap2_pepbase(ntyp_molec(2)))
      allocate(chis_pepbase(ntyp_molec(2),2))
      allocate(wdipdip_pepbase(3,ntyp_molec(2)))


       do j=1,ntyp_molec(2)-1 ! without U then we will take T for U
        write (*,*) "Im in ", i, " ", j
        read(isidep_pepbase,*) &
        eps_pepbase(j),sigma_pepbase(j),chi_pepbase(j,1),&
        chi_pepbase(j,2),chipp_pepbase(j,1),chipp_pepbase(j,2)
         write(*,*) "eps",eps_pepbase(j)
        read(isidep_pepbase,*) &
       (alphasur_pepbase(k,j),k=1,4),sigmap1_pepbase(j),sigmap2_pepbase(j), &
       chis_pepbase(j,1),chis_pepbase(j,2)
        read(isidep_pepbase,*) &
       (wdipdip_pepbase(k,j),k=1,3)
       END DO
      allocate(aa_pepbase(ntyp_molec(2)))
      allocate(bb_pepbase(ntyp_molec(2)))

       do j=1,ntyp_molec(2)-1
          epsij=eps_pepbase(j)
          rrij=sigma_pepbase(j)
!          r0(i,j)=rrij
!          r0(j,i)=rrij
          rrij=rrij**expon
!          epsij=eps(i,j)
          sigeps=dsign(1.0D0,epsij)
          epsij=dabs(epsij)
          aa_pepbase(j)=epsij*rrij*rrij
          bb_pepbase(j)=-sigeps*epsij*rrij
        enddo
!--------------READING SC PHOSPHATE------------------------------------- 
!--------------READING SC PHOSPHATE------------------------------------- 
      allocate(eps_scpho(ntyp_molec(1)))
      allocate(sigma_scpho(ntyp_molec(1)))
      allocate(chi_scpho(ntyp_molec(1),2))
      allocate(chipp_scpho(ntyp_molec(1),2))
      allocate(alphasur_scpho(4,ntyp_molec(1)))
      allocate(sigmap1_scpho(ntyp_molec(1)))
      allocate(sigmap2_scpho(ntyp_molec(1)))
      allocate(chis_scpho(ntyp_molec(1),2))
      allocate(wqq_scpho(ntyp_molec(1)))
      allocate(wqdip_scpho(2,ntyp_molec(1)))
      allocate(alphapol_scpho(ntyp_molec(1)))
      allocate(epsintab_scpho(ntyp_molec(1)))
      allocate(dhead_scphoi(ntyp_molec(1)))
      allocate(rborn_scphoi(ntyp_molec(1)))
      allocate(rborn_scphoj(ntyp_molec(1)))
      allocate(alphi_scpho(ntyp_molec(1)))


!      j=1
       do j=1,ntyp_molec(1) ! without U then we will take T for U
        write (*,*) "Im in scpho ", i, " ", j
        read(isidep_scpho,*) &
        eps_scpho(j),sigma_scpho(j),chi_scpho(j,1),&
        chi_scpho(j,2),chipp_scpho(j,1),chipp_scpho(j,2)
         write(*,*) "eps",eps_scpho(j)
        read(isidep_scpho,*) &
       (alphasur_scpho(k,j),k=1,4),sigmap1_scpho(j),sigmap2_scpho(j), &
       chis_scpho(j,1),chis_scpho(j,2)
        read(isidep_scpho,*) &
       (wqdip_scpho(k,j),k=1,2),wqq_scpho(j),dhead_scphoi(j)
        read(isidep_scpho,*) &
         epsintab_scpho(j),alphapol_scpho(j),rborn_scphoi(j),rborn_scphoj(j), &
         alphi_scpho(j)

       END DO
      allocate(aa_scpho(ntyp_molec(1)))
      allocate(bb_scpho(ntyp_molec(1)))
       do j=1,ntyp_molec(1)
          epsij=eps_scpho(j)
          rrij=sigma_scpho(j)
!          r0(i,j)=rrij
!          r0(j,i)=rrij
          rrij=rrij**expon
!          epsij=eps(i,j)
          sigeps=dsign(1.0D0,epsij)
          epsij=dabs(epsij)
          aa_scpho(j)=epsij*rrij*rrij
          bb_scpho(j)=-sigeps*epsij*rrij
        enddo


        read(isidep_peppho,*) &
        eps_peppho,sigma_peppho
        read(isidep_peppho,*) &
       (alphasur_peppho(k),k=1,4),sigmap1_peppho,sigmap2_peppho
        read(isidep_peppho,*) &
       (wqdip_peppho(k),k=1,2)

          epsij=eps_peppho
          rrij=sigma_peppho
!          r0(i,j)=rrij
!          r0(j,i)=rrij
          rrij=rrij**expon
!          epsij=eps(i,j)
          sigeps=dsign(1.0D0,epsij)
          epsij=dabs(epsij)
          aa_peppho=epsij*rrij*rrij
          bb_peppho=-sigeps*epsij*rrij


      allocate(aad(ntyp,2),bad(ntyp,2)) !(ntyp,2)
      do i=1,ntyp
        do j=1,2
          bad(i,j)=0.0D0
        enddo
      enddo
! Ions by Aga

       allocate(alphapolcat(ntyp,ntyp),epsheadcat(ntyp,ntyp),sig0headcat(ntyp,ntyp))
       allocate(alphapolcat2(ntyp,ntyp))
       allocate(sigiso1cat(ntyp,ntyp),rborn1cat(ntyp,ntyp),rborn2cat(ntyp,ntyp),sigmap1cat(ntyp,ntyp))
       allocate(sigmap2cat(ntyp,ntyp),sigiso2cat(ntyp,ntyp))
       allocate(chis1cat(ntyp,ntyp),chis2cat(ntyp,ntyp),wquadcat(ntyp,ntyp),chipp1cat(ntyp,ntyp),chipp2cat(ntyp,ntyp))
       allocate(epsintabcat(ntyp,ntyp))
       allocate(dtailcat(2,ntyp,ntyp))
       allocate(alphasurcat(4,ntyp,ntyp),alphisocat(4,ntyp,ntyp))
       allocate(wqdipcat(2,ntyp,ntyp))
       allocate(wstatecat(4,ntyp,ntyp))
       allocate(dheadcat(2,2,ntyp,ntyp))
       allocate(nstatecat(ntyp,ntyp))
       allocate(debaykapcat(ntyp,ntyp))

      if (.not.allocated(epscat)) allocate (epscat(0:ntyp1,0:ntyp1))
      if (.not.allocated(sigmacat)) allocate(sigmacat(0:ntyp1,0:ntyp1))
!      if (.not.allocated(chicat)) allocate(chicat(ntyp1,ntyp1)) !(ntyp,ntyp)
      if (.not.allocated(chi1cat)) allocate(chi1cat(ntyp1,ntyp1)) !(ntyp,ntyp)
      if (.not.allocated(chi2cat)) allocate(chi2cat(ntyp1,ntyp1)) !(ntyp,ntyp)


      allocate (ichargecat(-ntyp_molec(5):ntyp_molec(5)))
! i to SC, j to jon, isideocat - nazwa pliku z ktorego czytam parametry
       if (oldion.eq.0) then
            if (.not.allocated(icharge)) then ! this mean you are oprating in old sc-sc mode
            allocate(icharge(1:ntyp1))
            read(iion,*) (icharge(i),i=1,ntyp)
            else
             read(iion,*) ijunk
            endif

            do i=-ntyp_molec(5),ntyp_molec(5)
             read(iion,*) msc(i,5),restok(i,5),ichargecat(i)
             print *,msc(i,5),restok(i,5)
            enddo
            ip(5)=0.2
!DIR$ NOUNROLL 
      do j=1,ntyp_molec(5)-1
       do i=1,ntyp
!       do j=1,ntyp_molec(5)
!        write (*,*) "Im in ALAB", i, " ", j
        read(iion,*) &
       epscat(i,j),sigmacat(i,j), &
!       chicat(i,j),chicat(j,i),chippcat(i,j),chippcat(j,i), &
       chi1cat(i,j),chi2cat(i,j),chipp1cat(i,j),chipp2cat(i,j), &

       (alphasurcat(k,i,j),k=1,4),sigmap1cat(i,j),sigmap2cat(i,j),&
!       chiscat(i,j),chiscat(j,i), &
       chis1cat(i,j),chis2cat(i,j), &

       nstatecat(i,j),(wstatecat(k,i,j),k=1,4), &                           !5 w tej lini - 1 integer pierwszy
       dheadcat(1,1,i,j),dheadcat(1,2,i,j),dheadcat(2,1,i,j),dheadcat(2,2,i,j),&
       dtailcat(1,i,j),dtailcat(2,i,j), &
       epsheadcat(i,j),sig0headcat(i,j), &
!wdipcat = w1 , w2
!       rborncat(i,j),rborncat(j,i),&
       rborn1cat(i,j),rborn2cat(i,j),&
       (wqdipcat(k,i,j),k=1,2), &
       alphapolcat(i,j),alphapolcat2(j,i), &
       (alphisocat(k,i,j),k=1,4),sigiso1cat(i,j),sigiso2cat(i,j),epsintabcat(i,j),debaykapcat(i,j)
!       print *,eps(i,j),sigma(i,j),"SIGMAP",i,j,sigmap1(i,j),sigmap2(j,i) 
       END DO
      END DO
      allocate(aa_aq_cat(-ntyp:ntyp,ntyp),bb_aq_cat(-ntyp:ntyp,ntyp))
      do i=1,ntyp
        do j=1,ntyp_molec(5)-1 !without zinc
          epsij=epscat(i,j)
          rrij=sigmacat(i,j)
          rrij=rrij**expon
          sigeps=dsign(1.0D0,epsij)
          epsij=dabs(epsij)
          aa_aq_cat(i,j)=epsij*rrij*rrij
          bb_aq_cat(i,j)=-sigeps*epsij*rrij
         enddo
       enddo
       do i=1,ntyp
       do j=1,ntyp_molec(5)
      if (i.eq.10) then
      write (iout,*) 'i= ', i, ' j= ', j
      write (iout,*) 'epsi0= ', epscat(i,j)
      write (iout,*) 'sigma0= ', sigmacat(i,j)
      write (iout,*) 'chi1= ', chi1cat(i,j)
      write (iout,*) 'chi1= ', chi2cat(i,j)
      write (iout,*) 'chip1= ', chipp1cat(1,j)
      write (iout,*) 'chip2= ', chipp2cat(1,j)
      write (iout,*) 'alphasur1= ', alphasurcat(1,1,j)
      write (iout,*) 'alphasur2= ', alphasurcat(2,1,j)
      write (iout,*) 'alphasur3= ', alphasurcat(3,1,j)
      write (iout,*) 'alphasur4= ', alphasurcat(4,1,j)
      write (iout,*) 'sig1= ', sigmap1cat(1,j)
      write (iout,*) 'sig2= ', sigmap2cat(1,j)
      write (iout,*) 'chis1= ', chis1cat(1,j)
      write (iout,*) 'chis1= ', chis2cat(1,j)
      write (iout,*) 'nstatecat(i,j)= ', nstatecat(1,j)
      write (iout,*) 'wstatecat(k,i,j),k=1= ',wstatecat(1,1,j)
      write (iout,*) 'dhead= ', dheadcat(1,1,1,j)
      write (iout,*) 'dhead2= ', dheadcat(1,2,1,j)
      write (iout,*) 'a1= ', rborn1cat(i,j)
      write (iout,*) 'a2= ', rborn2cat(i,j)
      write (iout,*) 'epsin= ', epsintabcat(1,j), epsintabcat(j,1)
      write (iout,*) 'alphapol1= ',  alphapolcat(1,j)
      write (iout,*) 'alphapol2= ',  alphapolcat(j,1)
      write (iout,*) 'w1= ', wqdipcat(1,i,j)
      write (iout,*) 'w2= ', wqdipcat(2,i,j)
      write (iout,*) 'debaykapcat(i,j)= ',  debaykapcat(1,j)
      endif

      If ((i.eq.1).and.(j.eq.27)) then
      write (iout,*) 'SEP'
      Write (iout,*) 'w1= ', wqdipcat(1,1,27)
      Write (iout,*) 'w2= ', wqdipcat(2,1,27)
      endif

       enddo
       enddo

      endif
! here two denotes the Zn2+ and Cu2+
      write(iout,*) "before TRANPARM"
      allocate(aomicattr(0:3,2))
      allocate(athetacattran(0:6,5,2))
      allocate(agamacattran(3,5,2))
      allocate(acatshiftdsc(5,2))
      allocate(bcatshiftdsc(5,2))
      allocate(demorsecat(5,2))
      allocate(alphamorsecat(5,2))
      allocate(x0catleft(5,2))
      allocate(x0catright(5,2))
      allocate(x0cattrans(5,2))
      allocate(ntrantyp(2))
      do i=1,1 ! currently only Zn2+

      read(iiontran,*) ntrantyp(i)
!ntrantyp=4
!| ao0 ao1 ao2 ao3
!ASP| a1 a2 a3 aa0 aa1 aa2 aa3 aa4 aa5 aa6 ad bd De alpha x0 -1 -.5
!CYS| a1 a2 a3 aa0 aa1 aa2 aa3 aa4 aa5 aa6 ad bd De alpha x0left x0right x0transi
!GLU| a1 a2 a3 aa0 aa1 aa2 aa3 aa4 aa5 aa6 ad bd De alpha x0 -1 -0.5
!HIS| a1 a2 a3 aa0 aa1 aa2 aa3 aa4 aa5 aa6 ad bd De alpha x0 -1 -.5
      read(iiontran,*) (aomicattr(j,i),j=0,3)
      do j=1,ntrantyp(i)
       read (iiontran,*) (agamacattran(k,j,i),k=1,3),&
       (athetacattran(k,j,i),k=0,6),acatshiftdsc(j,i),bcatshiftdsc(j,i),&
       demorsecat(j,i),alphamorsecat(j,i),x0catleft(j,i),x0catright(j,i),&
       x0cattrans(j,i)
      enddo
      enddo
#ifdef CLUSTER
!
! Define the SC-p interaction constants
!
      do i=1,20
        do j=1,2
          eps_scp(i,j)=-1.5d0
          rscp(i,j)=4.0d0
        enddo
      enddo
#endif
      allocate(itortyp_nucl(ntyp1_molec(2))) !(-ntyp1:ntyp1)
      read (itorp_nucl,*) ntortyp_nucl
!      print *,"ntortyp_nucl",ntortyp_nucl,ntyp_molec(2)
!el from energy module---------
      allocate(nterm_nucl(ntortyp_nucl,ntortyp_nucl)) !(-maxtor:maxtor,-maxtor:maxtor,2)
      allocate(nlor_nucl(ntortyp_nucl,ntortyp_nucl)) !(-maxtor:maxtor,-maxtor:maxtor,2)

      allocate(vlor1_nucl(maxlor,ntortyp_nucl,ntortyp_nucl)) !(maxlor,-maxtor:maxtor,-maxtor:maxtor)
      allocate(vlor2_nucl(maxlor,ntortyp_nucl,ntortyp_nucl))
      allocate(vlor3_nucl(maxlor,ntortyp_nucl,ntortyp_nucl)) !(maxlor,maxtor,maxtor)
      allocate(v0_nucl(ntortyp_nucl,ntortyp_nucl)) !(-maxtor:maxtor,-maxtor:maxtor,2)

      allocate(v1_nucl(maxterm,ntortyp_nucl,ntortyp_nucl))
      allocate(v2_nucl(maxterm,ntortyp_nucl,ntortyp_nucl)) !(maxterm,-maxtor:maxtor,-maxtor:maxtor,2)
!el---------------------------
      nterm_nucl(:,:)=0
      nlor_nucl(:,:)=0
!el--------------------
      read (itorp_nucl,*) &
        (itortyp_nucl(i),i=1,ntyp_molec(2))
!        print *,itortyp_nucl(:)
!c      write (iout,*) 'ntortyp',ntortyp
      do i=1,ntortyp_nucl
        do j=1,ntortyp_nucl
          read (itorp_nucl,*) nterm_nucl(i,j),nlor_nucl(i,j)
!           print *,nterm_nucl(i,j),nlor_nucl(i,j)
          v0ij=0.0d0
          si=-1.0d0
          do k=1,nterm_nucl(i,j)
            read (itorp_nucl,*) kk,v1_nucl(k,i,j),v2_nucl(k,i,j)
            v0ij=v0ij+si*v1_nucl(k,i,j)
            si=-si
          enddo
          do k=1,nlor_nucl(i,j)
            read (itorp_nucl,*) kk,vlor1_nucl(k,i,j),&
              vlor2_nucl(k,i,j),vlor3_nucl(k,i,j)
            v0ij=v0ij+vlor1_nucl(k,i,j)/(1+vlor3_nucl(k,i,j)**2)
          enddo
          v0_nucl(i,j)=v0ij
        enddo
      enddo


!elwrite(iout,*) "parmread kontrol before oldscp"
!
! Define the SC-p interaction constants
!
#ifdef OLDSCP
      do i=1,20
! "Soft" SC-p repulsion (causes helices to be too flat, but facilitates 
! helix formation)
!       aad(i,1)=0.3D0*4.0D0**12
! Following line for constants currently implemented
! "Hard" SC-p repulsion (gives correct turn spacing in helices)
        aad(i,1)=1.5D0*4.0D0**12
!       aad(i,1)=0.17D0*5.6D0**12
        aad(i,2)=aad(i,1)
! "Soft" SC-p repulsion
        bad(i,1)=0.0D0
! Following line for constants currently implemented
!       aad(i,1)=0.3D0*4.0D0**6
! "Hard" SC-p repulsion
        bad(i,1)=3.0D0*4.0D0**6
!       bad(i,1)=-2.0D0*0.17D0*5.6D0**6
        bad(i,2)=bad(i,1)
!       aad(i,1)=0.0D0
!       aad(i,2)=0.0D0
!       bad(i,1)=1228.8D0
!       bad(i,2)=1228.8D0
      enddo
#else
!
! 8/9/01 Read the SC-p interaction constants from file
!
      do i=1,ntyp
        read (iscpp,*) (eps_scp(i,j),rscp(i,j),j=1,2)
      enddo
      do i=1,ntyp
        aad(i,1)=dabs(eps_scp(i,1))*rscp(i,1)**12
        aad(i,2)=dabs(eps_scp(i,2))*rscp(i,2)**12
        bad(i,1)=-2*eps_scp(i,1)*rscp(i,1)**6
        bad(i,2)=-2*eps_scp(i,2)*rscp(i,2)**6
      enddo

      if (lprint) then
        write (iout,*) "Parameters of SC-p interactions:"
        do i=1,20
          write (iout,'(4f8.3,4e12.4)') eps_scp(i,1),rscp(i,1),&
           eps_scp(i,2),rscp(i,2),aad(i,1),bad(i,1),aad(i,2),bad(i,2)
        enddo
      endif
#endif
      allocate(aad_nucl(ntyp_molec(2)),bad_nucl(ntyp_molec(2))) !(ntyp,2)

      do i=1,ntyp_molec(2)
        read (iscpp_nucl,*) eps_scp_nucl(i),rscp_nucl(i)
      enddo
      do i=1,ntyp_molec(2)
        aad_nucl(i)=dabs(eps_scp_nucl(i))*rscp_nucl(i)**12
        bad_nucl(i)=-2*eps_scp_nucl(i)*rscp_nucl(i)**6
      enddo
      r0pp=1.12246204830937298142*5.16158
      epspp=4.95713/4
      AEES=108.661
      BEES=0.433246

!
! Define the constants of the disulfide bridge
!
!      ebr=-5.50D0
!
! Old arbitrary potential - commented out.
!
!      dbr= 4.20D0
!      fbr= 3.30D0
!
! Constants of the disulfide-bond potential determined based on the RHF/6-31G**
! energy surface of diethyl disulfide.
! A. Liwo and U. Kozlowska, 11/24/03
!
!      D0CM = 3.78d0
!      AKCM = 15.1d0
!      AKTH = 11.0d0
!      AKCT = 12.0d0
!      V1SS =-1.08d0
!      V2SS = 7.61d0
!      V3SS = 13.7d0
#ifndef CLUSTER

      if (dyn_ss) then
       ss_depth=(ebr/wsc-0.25*eps(1,1))*ssscale
        Ht=(Ht/wsc-0.25*eps(1,1))*ssscale
        akcm=akcm/wsc*ssscale
        akth=akth/wsc*ssscale
        akct=akct/wsc*ssscale
        v1ss=v1ss/wsc*ssscale
        v2ss=v2ss/wsc*ssscale
        v3ss=v3ss/wsc*ssscale
      else
        ss_depth=ebr/wstrain-0.25*eps(1,1)*wsc/wstrain
      endif
#endif
      if (lprint) then
      write (iout,'(/a)') "Disulfide bridge parameters:"
      write (iout,'(a,f10.2)') 'S-S bridge energy: ',ebr
      write (iout,'(2(a,f10.2))') 'd0cm:',d0cm,' akcm:',akcm
      write (iout,'(2(a,f10.2))') 'akth:',akth,' akct:',akct
      write (iout,'(3(a,f10.2))') 'v1ss:',v1ss,' v2ss:',v2ss,&
       ' v3ss:',v3ss
      endif
      return
      end subroutine parmread
#ifndef CLUSTER
!-----------------------------------------------------------------------------
! mygetenv.F
!-----------------------------------------------------------------------------
      subroutine mygetenv(string,var)
!
! Version 1.0
!
! This subroutine passes the environmental variables to FORTRAN program.
! If the flags -DMYGETENV and -DMPI are not for compilation, it calls the
! standard FORTRAN GETENV subroutine. If both flags are set, the subroutine
! reads the environmental variables from $HOME/.env
!
! Usage: As for the standard FORTRAN GETENV subroutine.
! 
! Purpose: some versions/installations of MPI do not transfer the environmental
! variables to slave processors, if these variables are set in the shell script
! from which mpirun is called.
!
! A.Liwo, 7/29/01
!
#ifdef MPI
      use MPI_data
      include "mpif.h"
#endif
!      implicit none
      character*(*) :: string,var
#if defined(MYGETENV) && defined(MPI) 
!      include "DIMENSIONS.ZSCOPT"
!      include "mpif.h"
!      include "COMMON.MPI"
!el      character*360 ucase
!el      external ucase
      character(len=360) :: string1(360),karta
      character(len=240) :: home
      integer i,n !,ilen
!el      external ilen
      call getenv("HOME",home)
      open(99,file=home(:ilen(home))//"/.env",status="OLD",err=112)
      do while (.true.)
        read (99,end=111,err=111,'(a)') karta
        do i=1,80
          string1(i)=" "
        enddo
        call split_string(karta,string1,80,n)
        if (ucase(string1(1)(:ilen(string1(1)))).eq."SETENV" .and. &
         string1(2)(:ilen(string1(2))).eq.string(:ilen(string)) ) then
           var=string1(3)
           print *,"Processor",me,": ",var(:ilen(var)),&
            " assigned to ",string(:ilen(string))
           close(99)
           return
        endif  
      enddo    
 111  print *,"Environment variable ",string(:ilen(string))," not set."
      close(99)
      return
 112  print *,"Error opening environment file!"
#else
      call getenv(string,var)
#endif
      return
      end subroutine mygetenv
!-----------------------------------------------------------------------------
! readrtns.F
!-----------------------------------------------------------------------------
      subroutine read_general_data(*)

      use control_data, only:indpdb,symetr,r_cut_ele,rlamb_ele,ions,&
          scelemode,TUBEmode,tor_mode,energy_dec,r_cut_ang,r_cut_mart,&
          rlamb_mart,constr_dist,vacuum
         
      use energy_data, only:distchainmax,tubeR0,tubecenter,dyn_ss,constr_homology
      use geometry_data, only:boxxsize,boxysize,boxzsize,bordtubetop,&
          bordtubebot,tubebufthick,buftubebot,buftubetop,buflipbot, bufliptop,bordlipbot,bordliptop,     &
        lipbufthick,lipthick
!      implicit none
!      include "DIMENSIONS"
!      include "DIMENSIONS.ZSCOPT"
!      include "DIMENSIONS.FREE"
!      include "COMMON.TORSION"
!      include "COMMON.INTERACT"
!      include "COMMON.IOUNITS"
!      include "COMMON.TIME1"
!      include "COMMON.PROT"
!      include "COMMON.PROTFILES"
!      include "COMMON.CHAIN"
!      include "COMMON.NAMES"
!      include "COMMON.FFIELD"
!      include "COMMON.ENEPS"
!      include "COMMON.WEIGHTS"
!      include "COMMON.FREE"
!      include "COMMON.CONTROL"
!      include "COMMON.ENERGIES"
       
      character(len=800) :: controlcard
      integer :: i,j,k,ii,n_ene_found
      integer :: ind,itype1,itype2,itypf,itypsc,itypp
!el      integer ilen
!el      external ilen
!el      character*16 ucase
      character(len=16) :: key
!el      external ucase
      call card_concat(controlcard,.true.)
      call readi(controlcard,"N_ENE",n_eneW,max_eneW)
      if (n_eneW.gt.max_eneW) then
        write (iout,*) "Error: parameter out of range: N_ENE",n_eneW,&
          max_eneW
        return 1
      endif
      call readi(controlcard,"NPARMSET",nparmset,1)
!elwrite(iout,*)"in read_gen data"
      separate_parset = index(controlcard,"SEPARATE_PARSET").gt.0
      call readi(controlcard,"IPARMPRINT",iparmprint,1)
      write (iout,*) "PARMPRINT",iparmprint
      if (nparmset.gt.max_parm) then
        write (iout,*) "Error: parameter out of range: NPARMSET",&
          nparmset, Max_Parm
        return 1
      endif
!elwrite(iout,*)"in read_gen data"
      call readi(controlcard,"MAXIT",maxit,5000)
      call reada(controlcard,"FIMIN",fimin,1.0d-3)
      call readi(controlcard,"ENSEMBLES",ensembles,0)
      hamil_rep=index(controlcard,"HAMIL_REP").gt.0
      write (iout,*) "Number of energy parameter sets",nparmset
      allocate(isampl(nparmset))
      call multreadi(controlcard,"ISAMPL",isampl,nparmset,1)
      write (iout,*) "MaxSlice",MaxSlice
      call readi(controlcard,"NSLICE",nslice,1)
!elwrite(iout,*)"in read_gen data"
      call flush(iout)
      if (nslice.gt.MaxSlice) then
        write (iout,*) "Error: parameter out of range: NSLICE",nslice,&
          MaxSlice
        return 1
      endif
      write (iout,*) "Frequency of storing conformations",&
       (isampl(i),i=1,nparmset)
      write (iout,*) "Maxit",maxit," Fimin",fimin
      call readi(controlcard,"NQ",nQ,1)
      if (nQ.gt.MaxQ) then
        write (iout,*) "Error: parameter out of range: NQ",nq,&
          maxq
        return 1
      endif
      indpdb=0
      if (index(controlcard,"CLASSIFY").gt.0) indpdb=1
      call reada(controlcard,"DELTA",delta,1.0d-2)
      call readi(controlcard,"EINICHECK",einicheck,2)
      call reada(controlcard,"DELTRMS",deltrms,5.0d-2)
      call reada(controlcard,"DELTRGY",deltrgy,5.0d-2)
      call readi(controlcard,"RESCALE",rescale_modeW,1)
      call reada(controlcard,'BOXX',boxxsize,100.0d0)
      call reada(controlcard,'BOXY',boxysize,100.0d0)
      call reada(controlcard,'BOXZ',boxzsize,100.0d0)
      call reada(controlcard,"LIPTHICK",lipthick,0.0d0)
      call reada(controlcard,"LIPAQBUF",lipbufthick,0.0d0)
      if (lipthick.gt.0.0d0) then
       bordliptop=(boxzsize+lipthick)/2.0
       bordlipbot=bordliptop-lipthick
      if ((bordliptop.gt.boxzsize).or.(bordlipbot.lt.0.0)) &
      write(iout,*) "WARNING WRONG SIZE OF LIPIDIC PHASE"
      buflipbot=bordlipbot+lipbufthick
      bufliptop=bordliptop-lipbufthick
      if ((lipbufthick*2.0d0).gt.lipthick) &
       write(iout,*) "WARNING WRONG SIZE OF LIP AQ BUF"
      endif !lipthick.gt.0
      write(iout,*) "bordliptop=",bordliptop
      write(iout,*) "bordlipbot=",bordlipbot
      write(iout,*) "bufliptop=",bufliptop
      write(iout,*) "buflipbot=",buflipbot

      energy_dec=(index(controlcard,'ENERGY_DEC').gt.0)
      call readi(controlcard,"SCELEMODE",scelemode,0)
      vacuum=(index(controlcard,'VACUUM'))
      call readi(controlcard,"OLDION",oldion,0)
      dyn_ss=(index(controlcard,'DYN_SS').gt.0)
      print *,"SCELE",scelemode
      call readi(controlcard,'TORMODE',tor_mode,0)
!C      if(me.eq.king .or. .not. out1file .and. fg_rank.eq.0) then
        write(iout,*) "torsional and valence angle mode",tor_mode

      call readi(controlcard,'TUBEMOD',tubemode,0)
      call readi(controlcard,'CONSTR_HOMOL',constr_homology,0)
!c      if (constr_homology) tole=dmax1(tole,1.5d0)
      write (iout,*) "with_homology_constr ",with_dihed_constr, &
       " CONSTR_HOMOLOGY",constr_homology
!      read_homol_frag = index(controlcard,"READ_HOMOL_FRAG").gt.0
!      out_template_coord = index(controlcard,"OUT_TEMPLATE_COORD").gt.0
!      out_template_restr = index(controlcard,"OUT_TEMPLATE_RESTR").gt.0

      if (TUBEmode.gt.0) then
       call reada(controlcard,"XTUBE",tubecenter(1),0.0d0)
       call reada(controlcard,"YTUBE",tubecenter(2),0.0d0)
       call reada(controlcard,"ZTUBE",tubecenter(3),0.0d0)
       call reada(controlcard,"RTUBE",tubeR0,0.0d0)
       call reada(controlcard,"TUBETOP",bordtubetop,boxzsize)
       call reada(controlcard,"TUBEBOT",bordtubebot,0.0d0)
       call reada(controlcard,"TUBEBUF",tubebufthick,1.0d0)
       buftubebot=bordtubebot+tubebufthick
       buftubetop=bordtubetop-tubebufthick
      endif
      ions=index(controlcard,"IONS").gt.0
      call reada(controlcard,"R_CUT_ELE",r_cut_ele,25.0d0)
      call reada(controlcard,"LAMBDA_ELE",rlamb_ele,0.3d0)
      write(iout,*) "R_CUT_ELE=",r_cut_ele
      call reada(controlcard,"R_CUT_MART",r_cut_mart,15.0d0)
      call reada(controlcard,"LAMBDA_MART",rlamb_mart,0.3d0)
      call reada(controlcard,"R_CUT_ANG",r_cut_ang,4.2d0)
      check_conf=index(controlcard,"NO_CHECK_CONF").eq.0
      call reada(controlcard,'DISTCHAINMAX',distchainmax,50.0d0)
      call readi(controlcard,'SYM',symetr,1)
      write (iout,*) "DISTCHAINMAX",distchainmax
      write (iout,*) "delta",delta
      write (iout,*) "einicheck",einicheck
      write (iout,*) "rescale_mode",rescale_modeW
      call flush(iout)
      bxfile=index(controlcard,"BXFILE").gt.0
      cxfile=index(controlcard,"CXFILE").gt.0
      if (nslice .eq. 1 .and. .not.bxfile .and. .not.cxfile) &
       bxfile=.true.
      histfile=index(controlcard,"HISTFILE").gt.0
      histout=index(controlcard,"HISTOUT").gt.0
      entfile=index(controlcard,"ENTFILE").gt.0
      zscfile=index(controlcard,"ZSCFILE").gt.0
      with_dihed_constr = index(controlcard,"WITH_DIHED_CONSTR").gt.0
      write (iout,*) "with_dihed_constr ",with_dihed_constr
      call readi(controlcard,'CONSTR_DIST',constr_dist,0)
      return
      end subroutine read_general_data
!------------------------------------------------------------------------------
      subroutine read_efree(*)
!
! Read molecular data
!
!      implicit none
!      include 'DIMENSIONS'
!      include 'DIMENSIONS.ZSCOPT'
!      include 'DIMENSIONS.COMPAR'
!      include 'DIMENSIONS.FREE'
!      include 'COMMON.IOUNITS'
!      include 'COMMON.TIME1'
!      include 'COMMON.SBRIDGE'
!      include 'COMMON.CONTROL'
!      include 'COMMON.CHAIN'
!      include 'COMMON.HEADER'
!      include 'COMMON.GEO'
!      include 'COMMON.FREE'
      character(len=320) :: controlcard !,ucase
      integer :: iparm,ib,i,j,npars
!el      integer ilen
!el      external ilen
     
      if (hamil_rep) then
        npars=1
      else
        npars=nParmSet
      endif

!      call alloc_wham_arrays
!      allocate(nT_h(nParmSet))
!      allocate(replica(nParmSet))
!      allocate(umbrella(nParmSet))
!      allocate(read_iset(nParmSet))
!      allocate(nT_h(nParmSet))

      do iparm=1,npars

      call card_concat(controlcard,.true.)
      call readi(controlcard,'NT',nT_h(iparm),1)
      write (iout,*) "iparm",iparm," nt",nT_h(iparm)
      call flush(iout)
      if (nT_h(iparm).gt.MaxT_h) then
        write (iout,*)  "Error: parameter out of range: NT",nT_h(iparm),&
          MaxT_h
        return 1
      endif
      replica(iparm)=index(controlcard,"REPLICA").gt.0
      umbrella(iparm)=index(controlcard,"UMBRELLA").gt.0
      read_iset(iparm)=index(controlcard,"READ_ISET").gt.0
      write (iout,*) "nQ",nQ," nT",nT_h(iparm)," replica ",&
        replica(iparm)," umbrella ",umbrella(iparm),&
        " read_iset",read_iset(iparm)
      call flush(iout)
      do ib=1,nT_h(iparm)
        call card_concat(controlcard,.true.)
        call readi(controlcard,'NR',nR(ib,iparm),1)
        if (umbrella(iparm)) then
          nRR(ib,iparm)=1
        else
          nRR(ib,iparm)=nR(ib,iparm)
        endif
        if (nR(ib,iparm).gt.MaxR) then
          write (iout,*)  "Error: parameter out of range: NR",&
            nR(ib,iparm),MaxR
        return 1
        endif
        call reada(controlcard,'TEMP',beta_h(ib,iparm),298.0d0)
        beta_h(ib,iparm)=1.0d0/(beta_h(ib,iparm)*1.987D-3)
        call multreada(controlcard,'FI',f(1,ib,iparm),nR(ib,iparm),&
          0.0d0)
        do i=1,nR(ib,iparm)
          call card_concat(controlcard,.true.)
          call multreada(controlcard,'KH',KH(1,i,ib,iparm),nQ,&
            100.0d0)
          call multreada(controlcard,'Q0',Q0(1,i,ib,iparm),nQ,&
            0.0d0)
        enddo
      enddo
      do ib=1,nT_h(iparm)
        write (iout,*) "ib",ib," beta_h",&
          1.0d0/(0.001987*beta_h(ib,iparm))
        write (iout,*) "nR",nR(ib,iparm)
        write (iout,*) "fi",(f(i,ib,iparm),i=1,nR(ib,iparm))
        do i=1,nR(ib,iparm)
          write (iout,*) "i",i," Kh",(Kh(j,i,ib,iparm),j=1,nQ),&
            "q0",(q0(j,i,ib,iparm),j=1,nQ)
        enddo
        call flush(iout)
      enddo

      enddo

      if (hamil_rep) then

       do iparm=2,nParmSet
          nT_h(iparm)=nT_h(1)
         do ib=1,nT_h(iparm)
           nR(ib,iparm)=nR(ib,1)
           if (umbrella(iparm)) then
             nRR(ib,iparm)=1
           else
             nRR(ib,iparm)=nR(ib,1)
           endif
           beta_h(ib,iparm)=beta_h(ib,1)
           do i=1,nR(ib,iparm)
             f(i,ib,iparm)=f(i,ib,1)
             do j=1,nQ
               KH(j,i,ib,iparm)=KH(j,i,ib,1) 
               Q0(j,i,ib,iparm)=Q0(j,i,ib,1) 
             enddo
           enddo
           replica(iparm)=replica(1)
           umbrella(iparm)=umbrella(1)
           read_iset(iparm)=read_iset(1)
         enddo
       enddo
        
      endif

      return
      end subroutine read_efree
!-----------------------------------------------------------------------------
      subroutine read_protein_data(*)
!      implicit none
!      include "DIMENSIONS"
!      include "DIMENSIONS.ZSCOPT"
!      include "DIMENSIONS.FREE"
#ifdef MPI
      use MPI_data
      include "mpif.h"
      integer :: IERROR,ERRCODE!,STATUS(MPI_STATUS_SIZE)
!      include "COMMON.MPI"
#endif
!      include "COMMON.CHAIN"
!      include "COMMON.IOUNITS"
!      include "COMMON.PROT"
!      include "COMMON.PROTFILES"
!      include "COMMON.NAMES"
!      include "COMMON.FREE"
!      include "COMMON.OBCINKA"
      character(len=64) :: nazwa
      character(len=16000) :: controlcard
      integer :: i,ii,ib,iR,iparm,nthr,npars !,ilen,iroof
!el      external ilen,iroof
      if (hamil_rep) then
        npars=1
      else
        npars=nparmset
      endif

      do iparm=1,npars

! Read names of files with conformation data.
      if (replica(iparm)) then
        nthr = 1
      else
        nthr = nT_h(iparm)
      endif
      do ib=1,nthr
      do ii=1,nRR(ib,iparm)
      write (iout,*) "Parameter set",iparm," temperature",ib,&
       " window",ii
      call flush(iout)
      call card_concat(controlcard,.true.) 
      write (iout,*) controlcard(:ilen(controlcard))
      call readi(controlcard,"NFILE_BIN",nfile_bin(ii,ib,iparm),0)
      call readi(controlcard,"NFILE_ASC",nfile_asc(ii,ib,iparm),0)
      call readi(controlcard,"NFILE_CX",nfile_cx(ii,ib,iparm),0)
      call readi(controlcard,"REC_START",rec_start(ii,ib,iparm),1)
      call readi(controlcard,"REC_END",rec_end(ii,ib,iparm),&
       maxstr*isampl(iparm)+rec_start(ii,ib,iparm)-1)
      call reada(controlcard,"TIME_START",&
        time_start_collect(ii,ib,iparm),0.0d0)
      call reada(controlcard,"TIME_END",time_end_collect(ii,ib,iparm),&
        1.0d10)
      write (iout,*) "rec_start",rec_start(ii,ib,iparm),&
       " rec_end",rec_end(ii,ib,iparm)
      write (iout,*) "time_start",time_start_collect(ii,ib,iparm),&
       " time_end",time_end_collect(ii,ib,iparm)
      call flush(iout)
      if (replica(iparm)) then
        call readi(controlcard,"TOTRAJ",totraj(ii,iparm),1)
        write (iout,*) "Number of trajectories",totraj(ii,iparm)
        call flush(iout)
      endif
      if (nfile_bin(ii,ib,iparm).lt.2 &
          .and. nfile_asc(ii,ib,iparm).eq.0 &
          .and. nfile_cx(ii,ib,iparm).eq.0) then
        write (iout,*) "Error - no action specified!"
        return 1
      endif
      if (nfile_bin(ii,ib,iparm).gt.0) then
        call card_concat(controlcard,.false.)
        call split_string(controlcard,protfiles(1,1,ii,ib,iparm),&
         maxfile_prot,nfile_bin(ii,ib,iparm))
#ifdef DEBUG
        write(iout,*)"nfile_bin",nfile_bin(ii,ib,iparm)
        write(iout,*) (protfiles(i,1,ii,ib,iparm),&
          i=1,nfile_bin(ii,ib,iparm))
#endif
      endif
      if (nfile_asc(ii,ib,iparm).gt.0) then
        call card_concat(controlcard,.false.)
        call split_string(controlcard,protfiles(1,2,ii,ib,iparm),&
         maxfile_prot,nfile_asc(ii,ib,iparm))
#ifdef DEBUG
        write(iout,*) "nfile_asc(ii,ib,iparm)",nfile_asc(ii,ib,iparm)
        write(iout,*) (protfiles(i,2,ii,ib,iparm),&
          i=1,nfile_asc(ii,ib,iparm))
#endif
      else if (nfile_cx(ii,ib,iparm).gt.0) then
        call card_concat(controlcard,.false.)
        call split_string(controlcard,protfiles(1,2,ii,ib,iparm),&
         maxfile_prot,nfile_cx(ii,ib,iparm))
#ifdef DEBUG
        write(iout,*) "nfile_cx(ii,ib,iparm)",nfile_cx(ii,ib,iparm)
        write(iout,*) (protfiles(i,2,ii,ib,iparm),&
         i=1,nfile_cx(ii,ib,iparm))
#endif
      endif
      call flush(iout)
      enddo
      enddo

      enddo
      return
      end subroutine read_protein_data
!-------------------------------------------------------------------------------
      subroutine readsss(rekord,lancuch,wartosc,default)
!      implicit none
      character*(*) :: rekord,lancuch,wartosc,default
      character(len=80) :: aux
      integer :: lenlan,lenrec,iread,ireade
!el      external ilen
!el      logical iblnk
!el      external iblnk
      lenlan=ilen(lancuch)
      lenrec=ilen(rekord)
      iread=index(rekord,lancuch(:lenlan)//"=")
!      print *,"rekord",rekord," lancuch",lancuch
!      print *,"iread",iread," lenlan",lenlan," lenrec",lenrec
      if (iread.eq.0) then
        wartosc=default
        return
      endif
      iread=iread+lenlan+1
!      print *,"iread",iread
!      print *,"|",rekord(iread:iread),"|",iblnk(rekord(iread:iread))
      do while (iread.le.lenrec .and. iblnk(rekord(iread:iread)))
        iread=iread+1
!      print *,"|",rekord(iread:iread),"|",iblnk(rekord(iread:iread))
      enddo
!      print *,"iread",iread
      if (iread.gt.lenrec) then
         wartosc=default
        return
      endif
      ireade=iread+1
!      print *,"ireade",ireade
      do while (ireade.lt.lenrec .and. &
         .not.iblnk(rekord(ireade:ireade)))
        ireade=ireade+1
      enddo
      wartosc=rekord(iread:ireade)
      return
      end subroutine readsss
!----------------------------------------------------------------------------
      subroutine multreads(rekord,lancuch,tablica,dim,default)
!      implicit none
      integer :: dim,i
      character*(*) rekord,lancuch,tablica(dim),default
      character(len=80) :: aux
      integer :: lenlan,lenrec,iread,ireade
!el      external ilen
!el      logical iblnk
!el      external iblnk
      do i=1,dim
        tablica(i)=default
      enddo
      lenlan=ilen(lancuch)
      lenrec=ilen(rekord)
      iread=index(rekord,lancuch(:lenlan)//"=")
!      print *,"rekord",rekord," lancuch",lancuch
!      print *,"iread",iread," lenlan",lenlan," lenrec",lenrec
      if (iread.eq.0) return
      iread=iread+lenlan+1
      do i=1,dim
!      print *,"iread",iread
!      print *,"|",rekord(iread:iread),"|",iblnk(rekord(iread:iread))
      do while (iread.le.lenrec .and. iblnk(rekord(iread:iread)))
        iread=iread+1
!      print *,"|",rekord(iread:iread),"|",iblnk(rekord(iread:iread))
      enddo
!      print *,"iread",iread
      if (iread.gt.lenrec) return
      ireade=iread+1
!      print *,"ireade",ireade
      do while (ireade.lt.lenrec .and. &
         .not.iblnk(rekord(ireade:ireade)))
        ireade=ireade+1
      enddo
      tablica(i)=rekord(iread:ireade)
      iread=ireade+1
      enddo
      end subroutine multreads
!----------------------------------------------------------------------------
      subroutine split_string(rekord,tablica,dim,nsub)
!      implicit none
      integer :: dim,nsub,i,ii,ll,kk
      character*(*) tablica(dim)
      character*(*) rekord
!el      integer ilen
!el      external ilen
      do i=1,dim
        tablica(i)=" "
      enddo
      ii=1
      ll = ilen(rekord)
      nsub=0
      do i=1,dim
! Find the start of term name
        kk = 0
        do while (ii.le.ll .and. rekord(ii:ii).eq." ") 
          ii = ii+1
        enddo
! Parse the name into TABLICA(i) until blank found
        do while (ii.le.ll .and. rekord(ii:ii).ne." ") 
          kk = kk+1
          tablica(i)(kk:kk)=rekord(ii:ii)
          ii = ii+1
        enddo
        if (kk.gt.0) nsub=nsub+1
        if (ii.gt.ll) return
      enddo
      return
      end subroutine split_string
!--------------------------------------------------------------------------------
! readrtns_compar.F
!--------------------------------------------------------------------------------
      subroutine read_compar
!
! Read molecular data
!
      use conform_compar, only:alloc_compar_arrays
      use control_data, only:pdbref
      use geometry_data, only:deg2rad,rad2deg
!      implicit none
!      include 'DIMENSIONS'
!      include 'DIMENSIONS.ZSCOPT'
!      include 'DIMENSIONS.COMPAR'
!      include 'DIMENSIONS.FREE'
!      include 'COMMON.IOUNITS'
!      include 'COMMON.TIME1'
!      include 'COMMON.SBRIDGE'
!      include 'COMMON.CONTROL'
!      include 'COMMON.COMPAR'
!      include 'COMMON.CHAIN'
!      include 'COMMON.HEADER'
!      include 'COMMON.GEO'
!      include 'COMMON.FREE'
      character(len=320) :: controlcard !,ucase
      character(len=64) :: wfile
!el      integer ilen
!el      external ilen
      integer :: i,j,k
!elwrite(iout,*)"jestesmy w read_compar"
      call card_concat(controlcard,.true.)
      pdbref=(index(controlcard,'PDBREF').gt.0)
      call reada(controlcard,'CUTOFF_UP',rmscut_base_up,4.0d0)
      call reada(controlcard,'CUTOFF_LOW',rmscut_base_low,3.0d0)
      call reada(controlcard,'RMSUP_LIM',rmsup_lim,4.0d0)
      call reada(controlcard,'RMSUPUP_LIM',rmsupup_lim,7.5d0)
      verbose = index(controlcard,"VERBOSE").gt.0
      lgrp=index(controlcard,"STATIN").gt.0
      lgrp_out=index(controlcard,"STATOUT").gt.0
      merge_helices=index(controlcard,"DONT_MERGE_HELICES").eq.0
      binary = index(controlcard,"BINARY").gt.0
      rmscut_base_up=rmscut_base_up/50
      rmscut_base_low=rmscut_base_low/50
      call reada(controlcard,"FRAC_SEC",frac_sec,0.66666666d0)
      call readi(controlcard,'NLEVEL',nlevel,1)
      if (nlevel.lt.0) then
        allocate(nfrag(2))
        call alloc_compar_arrays(maxfrag,1)
        goto 121
      else
        allocate(nfrag(nlevel))
      endif
! Read the data pertaining to elementary fragments (level 1)
      call readi(controlcard,'NFRAG',nfrag(1),0)
      write(iout,*)"nfrag(1)",nfrag(1)
      call alloc_compar_arrays(nfrag(1),nlevel)
      do j=1,nfrag(1)
        call card_concat(controlcard,.true.)
        write (iout,*) controlcard(:ilen(controlcard))
        call readi(controlcard,'NPIECE',npiece(j,1),0)
        call readi(controlcard,'N_SHIFT1',n_shift(1,j,1),0)
        call readi(controlcard,'N_SHIFT2',n_shift(2,j,1),0)
        call reada(controlcard,'ANGCUT',ang_cut(j),50.0d0)
        call reada(controlcard,'MAXANG',ang_cut1(j),360.0d0)
        call reada(controlcard,'FRAC_MIN',frac_min(j),0.666666d0)
        call reada(controlcard,'NC_FRAC',nc_fragm(j,1),0.5d0)
        call readi(controlcard,'NC_REQ',nc_req_setf(j,1),0)
        call readi(controlcard,'RMS',irms(j,1),0)
        call readi(controlcard,'LOCAL',iloc(j),1)
        call readi(controlcard,'ELCONT',ielecont(j,1),1)
        if (ielecont(j,1).eq.0) then
          call readi(controlcard,'SCCONT',isccont(j,1),1)
        endif
        ang_cut(j)=ang_cut(j)*deg2rad
        ang_cut1(j)=ang_cut1(j)*deg2rad
        do k=1,npiece(j,1)
          call card_concat(controlcard,.true.)
          call readi(controlcard,'IFRAG1',ifrag(1,k,j),0)
          call readi(controlcard,'IFRAG2',ifrag(2,k,j),0)
        enddo
        write(iout,*)"j",j," npiece",npiece(j,1)," ifrag",&
          (ifrag(1,k,j),ifrag(2,k,j),&
         k=1,npiece(j,1))," ang_cut",ang_cut(j)*rad2deg,&
          " ang_cut1",ang_cut1(j)*rad2deg
        write(iout,*)"n_shift",n_shift(1,j,1),n_shift(2,j,1)
        write(iout,*)"nc_frac",nc_fragm(j,1)," nc_req",nc_req_setf(j,1)
        write(iout,*)"irms",irms(j,1)," ielecont",ielecont(j,1),&
          " ilocal",iloc(j)," isccont",isccont(j,1)
      enddo
! Read data pertaning to higher levels
      do i=2,nlevel
        call card_concat(controlcard,.true.)
        call readi(controlcard,'NFRAG',NFRAG(i),0)
        write (iout,*) "i",i," nfrag",nfrag(i)
        do j=1,nfrag(i)
          call card_concat(controlcard,.true.)
          if (i.eq.2) then
            call readi(controlcard,'ELCONT',ielecont(j,i),0)
            if (ielecont(j,i).eq.0) then
              call readi(controlcard,'SCCONT',isccont(j,i),1)
            endif
            call readi(controlcard,'RMS',irms(j,i),0)
          else
            ielecont(j,i)=0
            isccont(j,i)=0
            irms(j,i)=1
          endif
          call readi(controlcard,'NPIECE',npiece(j,i),0)
          call readi(controlcard,'N_SHIFT1',n_shift(1,j,i),0)
          call readi(controlcard,'N_SHIFT2',n_shift(2,j,i),0)
          call multreadi(controlcard,'IPIECE',ipiece(1,j,i),&
            npiece(j,i),0)
          call reada(controlcard,'NC_FRAC',nc_fragm(j,i),0.5d0)
          call readi(controlcard,'NC_REQ',nc_req_setf(j,i),0)
          write(iout,*) "j",j," npiece",npiece(j,i)," n_shift",&
            n_shift(1,j,i),n_shift(2,j,i)," ielecont",ielecont(j,i),&
            " isccont",isccont(j,i)," irms",irms(j,i)
          write(iout,*) "ipiece",(ipiece(k,j,i),k=1,npiece(j,i))
          write(iout,*)"n_shift",n_shift(1,j,i),n_shift(2,j,i)
          write(iout,*)"nc_frac",nc_fragm(j,i),&
           " nc_req",nc_req_setf(j,i)
        enddo
      enddo
      if (binary) write (iout,*) "Classes written in binary format."
      return
  121 continue
      call reada(controlcard,'ANGCUT_HEL',angcut_hel,50.0d0)
      call reada(controlcard,'MAXANG_HEL',angcut1_hel,60.0d0)
      call reada(controlcard,'ANGCUT_BET',angcut_bet,90.0d0)
      call reada(controlcard,'MAXANG_BET',angcut1_bet,360.0d0)
      call reada(controlcard,'ANGCUT_STRAND',angcut_strand,90.0d0)
      call reada(controlcard,'MAXANG_STRAND',angcut1_strand,60.0d0)
      call reada(controlcard,'FRAC_MIN',frac_min_set,0.666666d0)
      call reada(controlcard,'NC_FRAC_HEL',ncfrac_hel,0.5d0)
      call readi(controlcard,'NC_REQ_HEL',ncreq_hel,0)
      call reada(controlcard,'NC_FRAC_BET',ncfrac_bet,0.5d0)
      call reada(controlcard,'NC_FRAC_PAIR',ncfrac_pair,0.3d0)
      call readi(controlcard,'NC_REQ_BET',ncreq_bet,0)
      call readi(controlcard,'NC_REQ_PAIR',ncreq_pair,0)
      call readi(controlcard,'NSHIFT_HEL',nshift_hel,3)
      call readi(controlcard,'NSHIFT_BET',nshift_bet,3)
      call readi(controlcard,'NSHIFT_STRAND',nshift_strand,3)
      call readi(controlcard,'NSHIFT_PAIR',nshift_pair,3)
      call readi(controlcard,'RMS_SINGLE',irms_single,0)
      call readi(controlcard,'CONT_SINGLE',icont_single,1)
      call readi(controlcard,'LOCAL_SINGLE',iloc_single,1)
      call readi(controlcard,'RMS_PAIR',irms_pair,0)
      call readi(controlcard,'CONT_PAIR',icont_pair,1)
      call readi(controlcard,'SPLIT_BET',isplit_bet,0)
      angcut_hel=angcut_hel*deg2rad
      angcut1_hel=angcut1_hel*deg2rad
      angcut_bet=angcut_bet*deg2rad
      angcut1_bet=angcut1_bet*deg2rad
      angcut_strand=angcut_strand*deg2rad
      angcut1_strand=angcut1_strand*deg2rad
      write (iout,*) "Automatic detection of structural elements"
      write (iout,*) 'NC_FRAC_HEL',ncfrac_hel,' NC_REQ_HEL',ncreq_hel,&
                     ' NC_FRAC_BET',ncfrac_bet,' NC_REQ_BET',ncreq_bet,&
                 ' RMS_SINGLE',irms_single,' CONT_SINGLE',icont_single,&
                 ' NC_FRAC_PAIR',ncfrac_pair,' NC_REQ_PAIR',ncreq_pair,&
        ' RMS_PAIR',irms_pair,' CONT_PAIR',icont_pair,&
        ' SPLIT_BET',isplit_bet
      write (iout,*) 'NSHIFT_HEL',nshift_hel,' NSHIFT_BET',nshift_bet,&
        ' NSHIFT_STRAND',nshift_strand,' NSHIFT_PAIR',nshift_pair
      write (iout,*) 'ANGCUT_HEL',angcut_hel*rad2deg,&
        ' MAXANG_HEL',angcut1_hel*rad2deg
      write (iout,*) 'ANGCUT_BET',angcut_bet*rad2deg,&
                     ' MAXANG_BET',angcut1_bet*rad2deg
      write (iout,*) 'ANGCUT_STRAND',angcut_strand*rad2deg,&
                     ' MAXANG_STRAND',angcut1_strand*rad2deg
      write (iout,*) 'FRAC_MIN',frac_min_set
      return
      end subroutine read_compar
!--------------------------------------------------------------------------------
! read_ref_str.F
!--------------------------------------------------------------------------------
      subroutine read_ref_structure(*)
!
! Read the reference structure from the PDB file or from a PDB file or in the form of the dihedral
! angles.
!
      use control_data, only:pdbref 
      use geometry_data, only:nres,cref,c,dc,nsup,dc_norm,nend_sup,&
                              nstart_sup,nstart_seq,nperm,nres0
      use energy_data, only:nct,nnt,icont_ref,ncont_ref,itype,molnum
      use compare, only:seq_comp !,contact,elecont
      use geometry, only:chainbuild,dist
      use io_config, only:readpdb
!
      use conform_compar, only:contact,elecont
!      implicit none
!      include 'DIMENSIONS'
!      include 'DIMENSIONS.ZSCOPT'
!      include 'DIMENSIONS.COMPAR'
!      include 'COMMON.IOUNITS'
!      include 'COMMON.GEO'
!      include 'COMMON.VAR'
!      include 'COMMON.INTERACT'
!      include 'COMMON.LOCAL'
!      include 'COMMON.NAMES'
!      include 'COMMON.CHAIN'
!      include 'COMMON.FFIELD'
!      include 'COMMON.SBRIDGE'
!      include 'COMMON.HEADER'
!      include 'COMMON.CONTROL'
!      include 'COMMON.CONTACTS1'
!      include 'COMMON.PEPTCONT'
!      include 'COMMON.TIME1'
!      include 'COMMON.COMPAR'
      character(len=4) :: sequence(nres)
!el      integer rescode
!el      real(kind=8) :: x(maxvar)
      integer :: itype_pdb(nres,5)
!el      logical seq_comp
      integer :: i,j,k,nres_pdb,iaux,mnum
      real(kind=8) :: ddsc !el,dist
      integer :: kkk !,ilen
!el      external ilen
!
      nres0=nres
      write (iout,*) "pdbref",pdbref
      if (pdbref) then
        read(inp,'(a)') pdbfile
        write (iout,'(2a,1h.)') 'PDB data will be read from file ',&
          pdbfile(:ilen(pdbfile))
        open(ipdbin,file=pdbfile,status='old',err=33)
        goto 34 
  33    write (iout,'(a)') 'Error opening PDB file.'
        return 1
  34    continue
        do i=1,nres
          mnum=molnum(i)
          itype_pdb(i,mnum)=itype(i,mnum)
        enddo

        call readpdb

        do i=1,nres
          iaux=itype_pdb(i,mnum)
          itype_pdb(i,mnum)=itype(i,mnum)
          itype(i,mnum)=iaux
        enddo
        close (ipdbin)
        do kkk=1,nperm
        nres_pdb=nres
        nres=nres0
        nstart_seq=nnt
        if (nsup.le.(nct-nnt+1)) then
          do i=0,nct-nnt+1-nsup
            if (seq_comp(itype(nnt+i,molnum(nnt+i)),itype_pdb(nstart_sup,molnum(nstart_sup)),&
              nsup)) then
              do j=nnt+nsup-1,nnt,-1
                do k=1,3
                  cref(k,nres+j+i,kkk)=cref(k,nres_pdb+j,kkk)
                enddo
              enddo
              do j=nnt+nsup-1,nnt,-1
                do k=1,3
                  cref(k,j+i,kkk)=cref(k,j,kkk)
                enddo
                write(iout,*) "J",j,"J+I",j+i
                phi_ref(j+i)=phi_ref(j)
                theta_ref(j+i)=theta_ref(j)
                alph_ref(j+i)=alph_ref(j)
                omeg_ref(j+i)=omeg_ref(j)
              enddo
#ifdef DEBUG
              do j=nnt,nct
                write (iout,'(i5,3f10.5,5x,3f10.5)') &
                  j,(cref(k,j,kkk),k=1,3),(cref(k,j+nres,kkk),k=1,3)
              enddo
#endif
              nstart_seq=nnt+i
              nstart_sup=nnt+i
              goto 111
            endif
          enddo
          write (iout,'(a)') &
                  'Error - sequences to be superposed do not match.'
          return 1
        else
          do i=0,nsup-(nct-nnt+1)
            if (seq_comp(itype(nnt,molnum(nnt)),itype_pdb(nstart_sup+i,molnum(nstart_sup+i)),&
              nct-nnt+1)) &
            then
              nstart_sup=nstart_sup+i
              nsup=nct-nnt+1
              goto 111
            endif
          enddo 
          write (iout,'(a)') &
                  'Error - sequences to be superposed do not match.'
        endif
        enddo
  111   continue
        write (iout,'(a,i5)') &
         'Experimental structure begins at residue',nstart_seq
      else
        call read_angles(inp,*38)
        goto 39
   38   write (iout,'(a)') 'Error reading reference structure.'
        return 1
   39   call chainbuild 
        kkk=1    
        nstart_sup=nnt
        nstart_seq=nnt
        nsup=nct-nnt+1
        do i=1,2*nres
          do j=1,3
            cref(j,i,kkk)=c(j,i)
          enddo
        enddo
      endif
      nend_sup=nstart_sup+nsup-1
      do i=1,2*nres
        do j=1,3
          c(j,i)=cref(j,i,kkk)
        enddo
      enddo
      do i=1,nres
        mnum=molnum(i)
        do j=1,3
          dc(j,nres+i)=cref(j,nres+i,kkk)-cref(j,i,kkk)
        enddo
        if (itype(i,mnum).ne.10) then
          ddsc = dist(i,nres+i)
          do j=1,3
            dc_norm(j,nres+i)=dc(j,nres+i)/ddsc
          enddo
        else
          do j=1,3
            dc_norm(j,nres+i)=0.0d0
          enddo
        endif
!        write (iout,*) "i",i," dc_norm",(dc_norm(k,nres+i),k=1,3),
!         " norm",dc_norm(1,nres+i)**2+dc_norm(2,nres+i)**2+
!         dc_norm(3,nres+i)**2
        do j=1,3
          dc(j,i)=c(j,i+1)-c(j,i)
        enddo
        ddsc = dist(i,i+1)
        do j=1,3
          dc_norm(j,i)=dc(j,i)/ddsc
        enddo
      enddo
!      print *,"Calling contact"
      call contact(.true.,ncont_ref,icont_ref(1,1),&
        nstart_sup,nend_sup)
!      print *,"Calling elecont"
      call elecont(.true.,ncont_pept_ref,&
         icont_pept_ref(1,1),&
         nstart_sup,nend_sup)
       write (iout,'(a,i3,a,i3,a,i3,a)') &
          'Number of residues to be superposed:',nsup,&
          ' (from residue',nstart_sup,' to residue',&
          nend_sup,').'
      return
      end subroutine read_ref_structure
!--------------------------------------------------------------------------------
! geomout.F
!--------------------------------------------------------------------------------
      subroutine pdboutW(ii,temp,efree,etot,entropy,rmsdev)

      use geometry_data, only:nres,c,boxxsize,boxysize,boxzsize
      use energy_data, only:nss,nnt,nct,ihpb,jhpb,itype,molnum
      use energy, only:boxshift
!      implicit real*8 (a-h,o-z)
!      include 'DIMENSIONS'
!      include 'DIMENSIONS.ZSCOPT'
!      include 'COMMON.CHAIN'
!      include 'COMMON.INTERACT'
!      include 'COMMON.NAMES'
!      include 'COMMON.IOUNITS'
!      include 'COMMON.HEADER'
!      include 'COMMON.SBRIDGE'
      character(len=50) :: tytul
      character(len=1),dimension(24) :: chainid=reshape((/'A','B','C',&
                      'D','E','F','G','H','I','J','K','L','M','N','O',&
                      'P','Q','R','S','V','W','X','Y','Z'/),shape(chainid))
      integer,dimension(nres) :: ica !(maxres)
      real(kind=8) :: temp,efree,etot,entropy,rmsdev,xj,yj,zj
      integer :: ii,i,j,iti,ires,iatom,ichain,mnum
      write(ipdb,'("REMARK CONF",i8," TEMPERATURE",f7.1," RMS",0pf7.2)')&
        ii,temp,rmsdev
      write (ipdb,'("REMARK DIMENSIONLESS FREE ENERGY",1pe15.5)') &
        efree
      write (ipdb,'("REMARK ENERGY",1pe15.5," ENTROPY",1pe15.5)') &
        etot,entropy
      iatom=0
      ichain=1
      ires=0
      do i=nnt,nct
        mnum=molnum(i)
        iti=itype(i,mnum)
        if (iti.eq.ntyp1_molec(mnum)) then
          if (itype(i-1,molnum(i-1)).eq.ntyp1_molec(mnum)) then
          ichain=ichain+1
          ichain=mod(ichain,24)
          if (ichain.eq.0) ichain=24
          ires=0
          write (ipdb,'(a)') 'TER'
          endif
        else
        ires=ires+1
        iatom=iatom+1
        ica(i)=iatom
        if (mnum.ne.5) then
        write (ipdb,10) iatom,restyp(iti,mnum),chainid(ichain),&
           ires,(c(j,i),j=1,3)
        else
        xj=boxshift(c(1,i)-c(1,2),boxxsize)
        yj=boxshift(c(2,i)-c(2,2),boxysize)
        zj=boxshift(c(3,i)-c(3,2),boxzsize)
        write (ipdb,10) iatom,restyp(iti,mnum),chainid(ichain),&
           ires,c(1,2)+xj,c(2,2)+yj,c(3,2)+zj
        endif
        if ((iti.ne.10).and.(mnum.ne.5)) then
          iatom=iatom+1
          write (ipdb,20) iatom,restyp(iti,mnum),chainid(ichain),&
            ires,(c(j,nres+i),j=1,3)
        endif
        endif
      enddo
      write (ipdb,'(a)') 'TER'
      do i=nnt,nct-1
        mnum=molnum(i)
        if (itype(i,mnum).eq.ntyp1_molec(mnum)) cycle
        if (itype(i,mnum).eq.10 .and. itype(i+1,mnum).ne.ntyp1_molec(mnum)) then
          write (ipdb,30) ica(i),ica(i+1)
        else if (itype(i,mnum).ne.10 .and. itype(i+1,mnum).ne.ntyp1_molec(mnum)) then
          write (ipdb,30) ica(i),ica(i+1),ica(i)+1
        else if (itype(i,mnum).ne.10 .and. itype(i+1,mnum).eq.ntyp1_molec(mnum)) then
          write (ipdb,30) ica(i),ica(i)+1
        endif
      enddo
      if (itype(nct,molnum(nct)).ne.10) then
        write (ipdb,30) ica(nct),ica(nct)+1
      endif
      do i=1,nss
        write (ipdb,30) ica(ihpb(i)-nres)+1,ica(jhpb(i)-nres)+1
      enddo
      write (ipdb,'(a6)') 'ENDMDL'
  10  FORMAT ('ATOM',I7,'  CA  ',A3,1X,A1,I4,4X,3F8.3,f15.3)
  20  FORMAT ('ATOM',I7,'  CB  ',A3,1X,A1,I4,4X,3F8.3,f15.3)
  30  FORMAT ('CONECT',8I5)
      return
      end subroutine pdboutW
#endif

      subroutine read_constr_homology
      use energy_data
      use control, only:init_int_table,homology_partition
      use MD_data, only:iset
      use geometry_data !only:nres,deg2rad,c,dc,nres_molec,crefjlee,cref
      use MPI_data, only:kolor
      use io_config, only:readpdb_template,readpdb
!      implicit none
!      include 'DIMENSIONS'
!#ifdef MPI
!      include 'mpif.h'
!#endif
!      include 'COMMON.SETUP'
!      include 'COMMON.CONTROL'
!      include 'COMMON.HOMOLOGY'
!      include 'COMMON.CHAIN'
!      include 'COMMON.IOUNITS'
!      include 'COMMON.MD'
!      include 'COMMON.QRESTR'
!      include 'COMMON.GEO'
!      include 'COMMON.INTERACT'
!      include 'COMMON.NAMES'
!      include 'COMMON.VAR'
!

!     double precision odl_temp,sigma_odl_temp,waga_theta,waga_d,
!    &                 dist_cut
!     common /przechowalnia/ odl_temp(maxres,maxres,max_template),
!    &    sigma_odl_temp(maxres,maxres,max_template)
      character*2 kic2
      character*24 model_ki_dist, model_ki_angle
      character*500 controlcard
      integer :: ki,i,ii,j,k,l
      integer, dimension (:), allocatable :: ii_in_use
      integer :: i_tmp,idomain_tmp,&
      irec,ik,iistart,nres_temp
!      integer :: iset
!      external :: ilen
      logical :: liiflag,lfirst
      integer :: i01,i10
!
!     FP - Nov. 2014 Temporary specifications for new vars
!
      real(kind=8) :: rescore_tmp,x12,y12,z12,rescore2_tmp,&
                       rescore3_tmp, dist_cut
      real(kind=8), dimension (:,:),allocatable :: rescore
      real(kind=8), dimension (:,:),allocatable :: rescore2
      real(kind=8), dimension (:,:),allocatable :: rescore3
      real(kind=8) :: distal
      character*24 tpl_k_rescore
      character*256 pdbfile

! -----------------------------------------------------------------
! Reading multiple PDB ref structures and calculation of retraints
! not using pre-computed ones stored in files model_ki_{dist,angle}
! FP (Nov., 2014)
! -----------------------------------------------------------------
!
!
! Alternative: reading from input
      call card_concat(controlcard,.true.)
      call reada(controlcard,"HOMOL_DIST",waga_dist,1.0d0)
      call reada(controlcard,"HOMOL_ANGLE",waga_angle,1.0d0)
      call reada(controlcard,"HOMOL_THETA",waga_theta,1.0d0) ! new
      call reada(controlcard,"HOMOL_SCD",waga_d,1.0d0) ! new
      call reada(controlcard,'DIST_CUT',dist_cut,5.0d0) ! for diff ways of calc sigma
      call reada(controlcard,'DIST2_CUT',dist2_cut,9999.0d0)
      call readi(controlcard,"HOMOL_NSET",homol_nset,1)
      read2sigma=(index(controlcard,'READ2SIGMA').gt.0)
      start_from_model=(index(controlcard,'START_FROM_MODELS').gt.0)
!      if(.not.read2sigma.and.start_from_model) then
!          if(me1.eq.king .or. .not. out1file .and. fg_rank.eq.0)&
!           write(iout,*) 'START_FROM_MODELS works only with READ2SIGMA'
!          start_from_model=.false.
!          iranconf=(indpdb.le.0)
!      endif
!      if(start_from_model)&! .and. (me1.eq.king .or. .not. out1file))&
!         write(iout,*) 'START_FROM_MODELS is ON'
!      if(start_from_model .and. rest) then 
!        if(me.eq.king .or. .not. out1file .and. fg_rank.eq.0) then
!         write(iout,*) 'START_FROM_MODELS is OFF'
!         write(iout,*) 'remove restart keyword from input'
!        endif
!      endif
!      if (start_from_model) nmodel_start=constr_homology
      if(.not.allocated(waga_homology)) allocate (waga_homology(homol_nset))
      if (homol_nset.gt.1)then
         call card_concat(controlcard,.true.)
         read(controlcard,*) (waga_homology(i),i=1,homol_nset)
!         if(me.eq.king .or. .not. out1file .and. fg_rank.eq.0) then
!          write(iout,*) "iset homology_weight "
!         do i=1,homol_nset
 !          write(iout,*) i,waga_homology(i)
 !         enddo
 !        endif
         iset=mod(kolor,homol_nset)+1
      else
       iset=1
       waga_homology(1)=1.0
      endif

!d      write (iout,*) "nnt",nnt," nct",nct
!d      call flush(iout)
       if (.false.) then
       print *,"here klapaciuj"
!      if (read_homol_frag) then
!        call read_klapaucjusz
      else

      lim_odl=0
      lim_dih=0
!
!      write(iout,*) 'nnt=',nnt,'nct=',nct
!
!      do i = nnt,nct
!        do k=1,constr_homology
!         idomain(k,i)=0
!        enddo
!      enddo
!       idomain=0

!      ii=0
!      do i = nnt,nct-2 
!        do j=i+2,nct 
!        ii=ii+1
!        ii_in_use(ii)=0
!        enddo
!      enddo
      ii_in_use=0
      if(.not.allocated(pdbfiles_chomo)) allocate(pdbfiles_chomo(constr_homology)) 
      if(.not.allocated(chomo)) allocate(chomo(3,2*nres+2,constr_homology)) 

      do k=1,constr_homology

        read(inp,'(a)') pdbfile
        pdbfiles_chomo(k)=pdbfile
!        if(me.eq.king .or. .not. out1file) &
         write (iout,'(a,5x,a)') 'HOMOL: Opening PDB file',&
        pdbfile(:ilen(pdbfile))
        open(ipdbin,file=pdbfile,status='old',err=33)
        goto 34
  33    write (iout,'(a,5x,a)') 'Error opening PDB file',&
        pdbfile(:ilen(pdbfile))
        stop
  34    continue
!        print *,'Begin reading pdb data'
!
! Files containing res sim or local scores (former containing sigmas)
!

        write(kic2,'(bz,i2.2)') k

        tpl_k_rescore="template"//kic2//".sco"
        write(iout,*) "tpl_k_rescore=",tpl_k_rescore
!        unres_pdb=.false.
        nres_temp=nres
        write(iout,*) "read2sigma",read2sigma
       
        if (read2sigma) then
          call readpdb_template(k)
        else
          call readpdb
        endif
        write(iout,*) "after readpdb"
        if(.not.allocated(nres_chomo)) allocate(nres_chomo(constr_homology))
        nres_chomo(k)=nres
        nres=nres_temp
        if(.not.allocated(rescore)) allocate(rescore(constr_homology,nres))
        if(.not.allocated(rescore2)) allocate(rescore2(constr_homology,nres))
        if(.not.allocated(rescore3)) allocate(rescore3(constr_homology,nres))
        if(.not.allocated(ii_in_use)) allocate(ii_in_use(nres*(nres-1)))
        if(.not.allocated(idomain)) allocate(idomain(constr_homology,nres))
        if(.not.allocated(l_homo)) allocate(l_homo(constr_homology,1000*nres))
        if(.not.allocated(ires_homo)) allocate(ires_homo(nres*200))
        if(.not.allocated(jres_homo)) allocate(jres_homo(nres*200))
        if(.not.allocated(odl)) allocate(odl(constr_homology,nres*200))
        if(.not.allocated(sigma_odl)) allocate(sigma_odl(constr_homology,nres*200))
        if(.not.allocated(dih)) allocate(dih(constr_homology,nres))
        if(.not.allocated(sigma_dih)) allocate(sigma_dih(constr_homology,nres))
        if(.not.allocated(thetatpl)) allocate(thetatpl(constr_homology,nres))
        if(.not.allocated(sigma_theta)) allocate(sigma_theta(constr_homology,nres))
!        if(.not.allocated(thetatpl)) allocate(thetatpl(constr_homology,nres))
        if(.not.allocated(sigma_d)) allocate(sigma_d(constr_homology,nres))
        if(.not.allocated(xxtpl)) allocate(xxtpl(constr_homology,nres))
        if(.not.allocated(yytpl)) allocate(yytpl(constr_homology,nres))
        if(.not.allocated(zztpl)) allocate(zztpl(constr_homology,nres))
!        if(.not.allocated(distance)) allocate(distance(constr_homology))
!        if(.not.allocated(distancek)) allocate(distancek(constr_homology))


!
!     Distance restraints
!
!          ... --> odl(k,ii)
! Copy the coordinates from reference coordinates (?)
        do i=1,2*nres_chomo(k)
          do j=1,3
            c(j,i)=cref(j,i,1)
!           write (iout,*) "c(",j,i,") =",c(j,i)
          enddo
        enddo
!
! From read_dist_constr (commented out 25/11/2014 <-> res sim)
!
!         write(iout,*) "tpl_k_rescore - ",tpl_k_rescore
          open (ientin,file=tpl_k_rescore,status='old')
          if (nnt.gt.1) rescore(k,1)=0.0d0
          do irec=nnt,nct ! loop for reading res sim 
            if (read2sigma) then
             read (ientin,*,end=1401) i_tmp,rescore2_tmp,rescore_tmp,&
                                     rescore3_tmp,idomain_tmp
             i_tmp=i_tmp+nnt-1
           write (*,*) "i_tmp", i_tmp,nnt 
             idomain(k,i_tmp)=idomain_tmp
             rescore(k,i_tmp)=rescore_tmp
             rescore2(k,i_tmp)=rescore2_tmp
             rescore3(k,i_tmp)=rescore3_tmp
!             if (.not. out1file .or. me.eq.king)&
!             write(iout,'(a7,i5,3f10.5,i5)') "rescore",&
!                           i_tmp,rescore2_tmp,rescore_tmp,&
!                                     rescore3_tmp,idomain_tmp
            else
             idomain(k,irec)=1
             read (ientin,*,end=1401) rescore_tmp

!           rescore(k,irec)=rescore_tmp+1.0d0 ! to avoid 0 values
             rescore(k,irec)=0.5d0*(rescore_tmp+0.5d0) ! alt transf to reduce scores
!           write(iout,*) "rescore(",k,irec,") =",rescore(k,irec)
            endif
          enddo
 1401   continue
        close (ientin)
        if (waga_dist.ne.0.0d0) then
          ii=0
          do i = nnt,nct-2
            do j=i+2,nct

              x12=c(1,i)-c(1,j)
              y12=c(2,i)-c(2,j)
              z12=c(3,i)-c(3,j)
              distal=dsqrt(x12*x12+y12*y12+z12*z12)
!              write (iout,*) k,i,j,distal,dist2_cut

            if (idomain(k,i).eq.idomain(k,j).and.idomain(k,i).ne.0 &
                 .and. distal.le.dist2_cut ) then

              ii=ii+1
              ii_in_use(ii)=1
              l_homo(k,ii)=.true.

!             write (iout,*) "k",k
!             write (iout,*) "i",i," j",j," constr_homology",
!    &                       constr_homology
              ires_homo(ii)=i
              jres_homo(ii)=j
              odl(k,ii)=distal
              if (read2sigma) then
                sigma_odl(k,ii)=0
                do ik=i,j
                 sigma_odl(k,ii)=sigma_odl(k,ii)+rescore2(k,ik)
                enddo
                sigma_odl(k,ii)=sigma_odl(k,ii)/(j-i+1)
                if (odl(k,ii).gt.dist_cut) sigma_odl(k,ii) = &
              sigma_odl(k,ii)*dexp(0.5d0*(odl(k,ii)/dist_cut)**2-0.5d0)
              else
                if (odl(k,ii).le.dist_cut) then
                 sigma_odl(k,ii)=rescore(k,i)+rescore(k,j)
                else
#ifdef OLDSIGMA
                 sigma_odl(k,ii)=(rescore(k,i)+rescore(k,j))* &
                           dexp(0.5d0*(odl(k,ii)/dist_cut)**2)
#else
                 sigma_odl(k,ii)=(rescore(k,i)+rescore(k,j))* &
                           dexp(0.5d0*(odl(k,ii)/dist_cut)**2-0.5d0)
#endif
                endif
              endif
              sigma_odl(k,ii)=1.0d0/(sigma_odl(k,ii)*sigma_odl(k,ii))
            else
!              ii=ii+1
!              l_homo(k,ii)=.false.
            endif
            enddo
          enddo
        lim_odl=ii
        endif
!        write (iout,*) "Distance restraints set"
!        call flush(iout)
!
!     Theta, dihedral and SC retraints
!
        if (waga_angle.gt.0.0d0) then
!         open (ientin,file=tpl_k_sigma_dih,status='old')
!         do irec=1,maxres-3 ! loop for reading sigma_dih
!            read (ientin,*,end=1402) i,j,ki,l,sigma_dih(k,i+nnt-1) ! j,ki,l what for?
!            if (i+nnt-1.gt.lim_dih) lim_dih=i+nnt-1 ! right?
!            sigma_dih(k,i+nnt-1)=sigma_dih(k,i+nnt-1)* ! not inverse because of use of res. similarity
!    &                            sigma_dih(k,i+nnt-1)
!         enddo
!1402   continue
!         close (ientin)
          do i = nnt+3,nct
            if (idomain(k,i).eq.0) then
               sigma_dih(k,i)=0.0
               cycle
            endif
            dih(k,i)=phiref(i) ! right?
!           read (ientin,*) sigma_dih(k,i) ! original variant
!             write (iout,*) "dih(",k,i,") =",dih(k,i)
!             write(iout,*) "rescore(",k,i,") =",rescore(k,i),
!    &                      "rescore(",k,i-1,") =",rescore(k,i-1),
!    &                      "rescore(",k,i-2,") =",rescore(k,i-2),
!    &                      "rescore(",k,i-3,") =",rescore(k,i-3)

            sigma_dih(k,i)=(rescore(k,i)+rescore(k,i-1)+ &
                          rescore(k,i-2)+rescore(k,i-3))/4.0
!            if (read2sigma) sigma_dih(k,i)=sigma_dih(k,i)/4.0
!           write (iout,*) "Raw sigmas for dihedral angle restraints"
!           write (iout,'(i5,10(2f8.2,4x))') i,sigma_dih(k,i)
!           sigma_dih(k,i)=hmscore(k)*rescore(k,i)*rescore(k,i-1)*
!                          rescore(k,i-2)*rescore(k,i-3)  !  right expression ?
!   Instead of res sim other local measure of b/b str reliability possible
            if (sigma_dih(k,i).ne.0) &
            sigma_dih(k,i)=1.0d0/(sigma_dih(k,i)*sigma_dih(k,i))
!           sigma_dih(k,i)=sigma_dih(k,i)*sigma_dih(k,i)
          enddo
          lim_dih=nct-nnt-2
        endif
!        write (iout,*) "Dihedral angle restraints set"
!        call flush(iout)

        if (waga_theta.gt.0.0d0) then
!         open (ientin,file=tpl_k_sigma_theta,status='old')
!         do irec=1,maxres-2 ! loop for reading sigma_theta, right bounds?
!            read (ientin,*,end=1403) i,j,ki,sigma_theta(k,i+nnt-1) ! j,ki what for?
!            sigma_theta(k,i+nnt-1)=sigma_theta(k,i+nnt-1)* ! not inverse because of use of res. similarity
!    &                              sigma_theta(k,i+nnt-1)
!         enddo
!1403   continue
!         close (ientin)

          do i = nnt+2,nct ! right? without parallel.
!         do i = i=1,nres ! alternative for bounds acc to readpdb?
!         do i=ithet_start,ithet_end ! with FG parallel.
             if (idomain(k,i).eq.0) then
              sigma_theta(k,i)=0.0
              cycle
             endif
             thetatpl(k,i)=thetaref(i)
!            write (iout,*) "thetatpl(",k,i,") =",thetatpl(k,i)
!            write(iout,*)  "rescore(",k,i,") =",rescore(k,i),
!    &                      "rescore(",k,i-1,") =",rescore(k,i-1),
!    &                      "rescore(",k,i-2,") =",rescore(k,i-2)
!            read (ientin,*) sigma_theta(k,i) ! 1st variant
             sigma_theta(k,i)=(rescore(k,i)+rescore(k,i-1)+ &
                             rescore(k,i-2))/3.0
!             if (read2sigma) sigma_theta(k,i)=sigma_theta(k,i)/3.0
             if (sigma_theta(k,i).ne.0) &
             sigma_theta(k,i)=1.0d0/(sigma_theta(k,i)*sigma_theta(k,i))

!            sigma_theta(k,i)=hmscore(k)*rescore(k,i)*rescore(k,i-1)*
!                             rescore(k,i-2) !  right expression ?
!            sigma_theta(k,i)=sigma_theta(k,i)*sigma_theta(k,i)
          enddo
        endif
!        write (iout,*) "Angle restraints set"
!        call flush(iout)

        if (waga_d.gt.0.0d0) then
!       open (ientin,file=tpl_k_sigma_d,status='old')
!         do irec=1,maxres-1 ! loop for reading sigma_theta, right bounds?
!            read (ientin,*,end=1404) i,j,sigma_d(k,i+nnt-1) ! j,ki what for?
!            sigma_d(k,i+nnt-1)=sigma_d(k,i+nnt-1)* ! not inverse because of use of res. similarity
!    &                          sigma_d(k,i+nnt-1)
!         enddo
!1404   continue

          do i = nnt,nct ! right? without parallel.
!         do i=2,nres-1 ! alternative for bounds acc to readpdb?
!         do i=loc_start,loc_end ! with FG parallel.
               if (itype(i,1).eq.10) cycle
               if (idomain(k,i).eq.0 ) then
                  sigma_d(k,i)=0.0
                  cycle
               endif
               xxtpl(k,i)=xxref(i)
               yytpl(k,i)=yyref(i)
               zztpl(k,i)=zzref(i)
!              write (iout,*) "xxtpl(",k,i,") =",xxtpl(k,i)
!              write (iout,*) "yytpl(",k,i,") =",yytpl(k,i)
!              write (iout,*) "zztpl(",k,i,") =",zztpl(k,i)
!              write(iout,*)  "rescore(",k,i,") =",rescore(k,i)
               sigma_d(k,i)=rescore3(k,i) !  right expression ?
               if (sigma_d(k,i).ne.0) &
               sigma_d(k,i)=1.0d0/(sigma_d(k,i)*sigma_d(k,i))

!              sigma_d(k,i)=hmscore(k)*rescore(k,i) !  right expression ?
!              sigma_d(k,i)=sigma_d(k,i)*sigma_d(k,i)
!              read (ientin,*) sigma_d(k,i) ! 1st variant
          enddo
        endif
      enddo
!      write (iout,*) "SC restraints set"
!      call flush(iout)
!
! remove distance restraints not used in any model from the list
! shift data in all arrays
!
!      write (iout,*) "waga_dist",waga_dist," nnt",nnt," nct",nct
      if (waga_dist.ne.0.0d0) then
        ii=0
        liiflag=.true.
        lfirst=.true.
        do i=nnt,nct-2
         do j=i+2,nct
          ii=ii+1
!          if (idomain(k,i).eq.idomain(k,j).and.idomain(k,i).ne.0
!     &            .and. distal.le.dist2_cut ) then
!          write (iout,*) "i",i," j",j," ii",ii
!          call flush(iout)
          if (ii_in_use(ii).eq.0.and.liiflag.or. &
          ii_in_use(ii).eq.1.and.liiflag.and.ii.eq.lim_odl) then
            liiflag=.false.
            i10=ii
            if (lfirst) then
              lfirst=.false.
              iistart=ii
            else
              if(i10.eq.lim_odl) i10=i10+1
              do ki=0,i10-i01-1
               ires_homo(iistart+ki)=ires_homo(ki+i01)
               jres_homo(iistart+ki)=jres_homo(ki+i01)
               ii_in_use(iistart+ki)=ii_in_use(ki+i01)
               do k=1,constr_homology
                odl(k,iistart+ki)=odl(k,ki+i01)
                sigma_odl(k,iistart+ki)=sigma_odl(k,ki+i01)
                l_homo(k,iistart+ki)=l_homo(k,ki+i01)
               enddo
              enddo
              iistart=iistart+i10-i01
            endif
          endif
          if (ii_in_use(ii).ne.0.and..not.liiflag) then
             i01=ii
             liiflag=.true.
          endif
         enddo
        enddo
        lim_odl=iistart-1
      endif
!      write (iout,*) "Removing distances completed"
!      call flush(iout)
      endif ! .not. klapaucjusz

      if (constr_homology.gt.0) call homology_partition
      write (iout,*) "After homology_partition"
      call flush(iout)
      if (constr_homology.gt.0) call init_int_table
      write (iout,*) "After init_int_table"
      call flush(iout)
!      endif ! .not. klapaucjusz
!      endif
!      if (constr_homology.gt.0) call homology_partition
!      write (iout,*) "After homology_partition"
!      call flush(iout)
!      if (constr_homology.gt.0) call init_int_table
!      write (iout,*) "After init_int_table"
!      call flush(iout)
!      write (iout,*) "ithet_start =",ithet_start,"ithet_end =",ithet_end
!      write (iout,*) "loc_start =",loc_start,"loc_end =",loc_end
!
! Print restraints
!
#ifdef DEBUG
 !this debug needs correction
      if (.not.out_template_restr) return
!d      write(iout,*) "waga_theta",waga_theta,"waga_d",waga_d
      if(me1.eq.king .or. .not. out1file .and. fg_rank.eq.0) then
       write (iout,*) "Distance restraints from templates"
       do ii=1,lim_odl
       write(iout,'(3i7,100(2f8.2,1x,l1,4x))') &
        ii,ires_homo(ii),jres_homo(ii),&
        (odl(ki,ii),1.0d0/dsqrt(sigma_odl(ki,ii)),l_homo(ki,ii),&
        ki=1,constr_homology)
       enddo
       write (iout,*) "Dihedral angle restraints from templates"
       do i=nnt+3,nct
        write (iout,'(i7,a4,100(2f8.2,4x))') i,restyp(itype(i,1),1),&
            (rad2deg*dih(ki,i),&
            rad2deg/dsqrt(sigma_dih(ki,i)),ki=1,constr_homology)
       enddo
       write (iout,*) "Virtual-bond angle restraints from templates"
       do i=nnt+2,nct
        write (iout,'(i7,a4,100(2f8.2,4x))') i,restyp(itype(i,1),1),&
            (rad2deg*thetatpl(ki,i),&
            rad2deg/dsqrt(sigma_theta(ki,i)),ki=1,constr_homology)
       enddo
       write (iout,*) "SC restraints from templates"
       do i=nnt,nct
        write(iout,'(i7,100(4f8.2,4x))') i,&
        (xxtpl(ki,i),yytpl(ki,i),zztpl(ki,i), &
         1.0d0/dsqrt(sigma_d(ki,i)),ki=1,constr_homology)
       enddo
      endif
#endif
      return
      end subroutine read_constr_homology
      subroutine seq2chains
!c
!c Split the total UNRES sequence, which has dummy residues separating
!c the chains, into separate chains. The length of  chain ichain is
!c contained in chain_length(ichain), the first and last non-dummy
!c residues are in chain_border(1,ichain) and chain_border(2,ichain),
!c respectively. The lengths pertain to non-dummy residues only.
!c
!      implicit none
!      include 'DIMENSIONS'
      use energy_data, only:molnum,nchain,chain_length,ireschain,chain_border,&
                           itype
      use geometry_data, only: nres
      implicit none
!      integer ireschain(nres)
      integer ii,ichain,i,j,mnum
      logical new_chain
      print *,"in seq2"
      ichain=1
      new_chain=.true.
      if (.not.allocated(chain_length)) allocate(chain_length(10000))
      if (.not.allocated(chain_border)) allocate(chain_border(2,10000))
           
      chain_length(ichain)=0
      ii=1 
      do while (ii.lt.nres)
        write(iout,*) "in seq2chains",ii,new_chain
        mnum=molnum(ii)
        if (itype(ii,mnum).eq.ntyp1_molec(mnum)) then
          if (.not.new_chain) then
            new_chain=.true.
            chain_border(2,ichain)=ii-1
            ichain=ichain+1
            chain_border(1,ichain)=ii+1
            chain_length(ichain)=0
          endif
        else
          if (new_chain) then
            chain_border(1,ichain)=ii
            new_chain=.false.
          endif
          chain_length(ichain)=chain_length(ichain)+1
        endif
        ii=ii+1
      enddo
      if (itype(nres,molnum(nres)).eq.ntyp1_molec(molnum(nres))) then
        ii=ii-1
      else
        chain_length(ichain)=chain_length(ichain)+1
      endif
      if (chain_length(ichain).gt.0) then
        chain_border(2,ichain)=ii
        nchain=ichain
      else
        nchain=ichain-1
      endif
      ireschain=0
      do i=1,nchain
        do j=chain_border(1,i),chain_border(2,i)
          ireschain(j)=i
        enddo
      enddo
      return
      end subroutine
      subroutine chain_symmetry(npermchain,tabpermchain)
!c
!c Determine chain symmetry. nperm is the number of permutations and
!c tabperchain contains the allowed permutations of the chains.
!c
!      implicit none
!      include "DIMENSIONS"
!      include "COMMON.IOUNITS"
      use energy_data, only:molnum,nchain,chain_length,ireschain,chain_border,&
                           itype
      use geometry_data, only: nres
 
      implicit none
      integer itemp(50),&
       npermchain,tabpermchain(50,5040),&
       tabperm(50,5040),mapchain(50),&
       iflag(nres)
      integer i,j,k,l,ii,nchain_group,nequiv(50),iieq,&
       nperm,npermc,ind,mnum
      integer,dimension(:,:),allocatable :: iequiv
      if (.not.allocated(iequiv)) allocate(iequiv(1000,nres))
      if (nchain.eq.1) then
        npermchain=1
        tabpermchain(1,1)=1
!c        print*,"npermchain",npermchain," tabpermchain",tabpermchain(1,1)
        return
      endif
!c
!c Look for equivalent chains
#ifdef DEBUG
      write(iout,*) "nchain",nchain
      do i=1,nchain
        write(iout,*) "chain",i," from",chain_border(1,i),&
           " to",chain_border(2,i)
        write(iout,*)&
        "sequence ",(itype(j,molnum(j)),j=chain_border(1,i),chain_border(2,i))
      enddo
#endif
      do i=1,nchain
        iflag(i)=0
      enddo
      nchain_group=0
      do i=1,nchain
        if (iflag(i).gt.0) cycle
        iflag(i)=1
        nchain_group=nchain_group+1
        iieq=1
        iequiv(iieq,nchain_group)=i
        do j=i+1,nchain
          if (iflag(j).gt.0.or.chain_length(i).ne.chain_length(j)) cycle
!c          k=0
!c          do while(k.lt.chain_length(i) .and.
!c     &     itype(chain_border(1,i)+k).eq.itype(chain_border(1,j)+k))
          do k=0,chain_length(i)-1
!c            k=k+1
            mnum=molnum(k+1)
            if (itype(chain_border(1,i)+k,mnum).ne.&
               itype(chain_border(1,j)+k,mnum)) exit
          enddo
          if (k.lt.chain_length(i)) cycle
          iflag(j)=1
          iieq=iieq+1
          iequiv(iieq,nchain_group)=j
        enddo
        nequiv(nchain_group)=iieq
      enddo
      write(iout,*) "Number of equivalent chain groups:",nchain_group
      write(iout,*) "Equivalent chain groups"
      do i=1,nchain_group
        write(iout,*) "group",i," #members",nequiv(i)," chains",&
           (iequiv(j,i),j=1,nequiv(i))
      enddo
      ind=0
      do i=1,nchain_group
        do j=1,nequiv(i)
          ind=ind+1
          mapchain(ind)=iequiv(j,i)
        enddo
      enddo
      write (iout,*) "mapchain"
      do i=1,nchain
        write (iout,*) i,mapchain(i)
      enddo
      ii=0
      do i=1,nchain_group
        call permut(nequiv(i),nperm,tabperm)
        if (ii.eq.0) then
          ii=nequiv(i)
          npermchain=nperm
          do j=1,nperm
            do k=1,ii
              tabpermchain(k,j)=iequiv(tabperm(k,j),i)
            enddo
          enddo
        else
          npermc=npermchain
          npermchain=npermchain*nperm
          ind=0
          do k=1,nperm
            do j=1,npermc
              ind=ind+1
              do l=1,ii
                tabpermchain(l,ind)=tabpermchain(l,j)
              enddo
              do l=1,nequiv(i)
                tabpermchain(ii+l,ind)=iequiv(tabperm(l,k),i)
              enddo
            enddo
          enddo
          ii=ii+nequiv(i)
        endif
      enddo
      do i=1,npermchain
        do j=1,nchain
          itemp(mapchain(j))=tabpermchain(j,i)
        enddo
        do j=1,nchain
          tabpermchain(j,i)=itemp(j)
        enddo
      enddo
      write(iout,*) "Number of chain permutations",npermchain
      write(iout,*) "Permutations"
      do i=1,npermchain
        write(iout,'(20i4)') (tabpermchain(j,i),j=1,nchain)
      enddo
      return
      end subroutine
      integer function tperm(i,iperm,tabpermchain)
!      implicit none
!      include 'DIMENSIONS'
      integer i,iperm
      integer tabpermchain(50,5040)
      if (i.eq.0) then
        tperm=0
      else
        tperm=tabpermchain(i,iperm)
      endif
      return
      end function

!------------------------------------------------------------------------------
      end module io_wham
!-----------------------------------------------------------------------------
!-----------------------------------------------------------------------------

