       subroutine quindet2(c,b,d,n,mu,no) 
        real (kind=8) :: mu ,x
        real (kind=8) ,dimension(n) :: c,b,d
        real (kind=8) ,dimension(3,5) :: r
        integer ::i,j,k,l,ll,rr,w,n,no
! the arrays c,b i d contain the diagonal subdiagonal and subsubdiagonal  elements of a simmetric quindiagonalmatrix. the value of the output parameter   no is the number of eigenvalues greater than mu;
        r(2,1)=c(1)-mu
        r(2,2)=b(2)
        r(3,1)=b(2)
        r(2,3)=d(3)
        r(3,2)=c(2)-mu
        r(3,3)=b(3)
        r(3,4)=d(4)
        r(2,4)=0
        r(2,5)=0
        r(3,5)=0
        if (r(2,1).ge.0) then
           no=1
        else 
           no=0
        endif
! k count the major stages
        do k=2,n 
          rr=1
          do i=2,1,-1
           if (k.gt.i) then
             w=3-i
!interchange row w and row 3 if necessary
             if (dabs(r(3,1)).gt. dabs(r(w,1))) then
               do j=1,i+3 
                 x=r(3,j)
                 r(3,j)=r(w,j)
                 r(w,j)=x
               enddo
               if (r(3,1).ge.0.eqv.r(w,1).ge.0) rr=-rr
             endif
!elimination of subdiagonal elements
             if (r(w,1).eq.0) then 
               x=0
             else
               x=r(3,1)/r(w,1)
             endif
             do j=2,i+3
               r(3,j-1)=r(3,j)-x*r(w,j)
             enddo
             r(3,i+3)=0
           endif
          enddo ! i
        
          if (r(3,1).lt.0) rr=-rr
          if (rr.gt.0) no=no+1
! update elements of array r
          do i = 1,2 
            do j = 1,5
              r(i,j)=r(i+1,j)
            enddo
          enddo
          if ((k+1).le.n) then 
            r(3,1)=d(k+1)
            r(3,2)=b(k+1)
            r(3,3)=c(k+1)-mu
          endif
          if ((k+2).le.n) then
            r(3,4)=b(k+2)
          else
            r(3,4)=0
          endif
          if ((k+3).le.n) then
           r(3,5)=d(k+3)
          else 
           r(3,5)=0
          endif
        enddo ! k
      endsubroutine 
