      module prng
      implicit none
!-----------------------------------------------------------------------------
!-----------------------------------------------------------------------------
!
#if defined(AIX) || defined(AMD64)
!      block data prngblk
      integer,parameter :: nmax=1021
      integer(kind=8),dimension(2,0:nmax) :: iparam
!      common/ksrprng/iparam(2,0:nmax)
      integer,private :: i,j
      data (iparam(1,i),iparam(2,i),i=   0,  29) / &
       11848219, 11848219, 11848237, 11848237, 11848241, 11848241,&
       11848247, 11848247, 11848253, 11848253, 11848271, 11848271,&
       11848297, 11848297, 11848313, 11848313, 11848339, 11848339,&
       11848351, 11848351, 11848357, 11848357, 11848363, 11848363,&
       11848367, 11848367, 11848373, 11848373, 11848379, 11848379,&
       11848393, 11848393, 11848433, 11848433, 11848451, 11848451,&
       11848469, 11848469, 11848477, 11848477, 11848489, 11848489,&
       11848493, 11848493, 11848513, 11848513, 11848523, 11848523,&
       11848531, 11848531, 11848537, 11848537, 11848553, 11848553,&
       11848589, 11848589, 11848591, 11848591, 11848601, 11848601 /
      data (iparam(1,i),iparam(2,i),i=  30,  59) / &
       11848619, 11848619, 11848637, 11848637, 11848663, 11848663,&
       11848673, 11848673, 11848679, 11848679, 11848691, 11848691,&
       11848699, 11848699, 11848709, 11848709, 11848717, 11848717,&
       11848721, 11848721, 11848729, 11848729, 11848741, 11848741,&
       11848751, 11848751, 11848757, 11848757, 11848787, 11848787,&
       11848801, 11848801, 11848829, 11848829, 11848853, 11848853,&
       11848861, 11848861, 11848867, 11848867, 11848873, 11848873,&
       11848891, 11848891, 11848909, 11848909, 11848919, 11848919,&
       11848931, 11848931, 11848937, 11848937, 11848961, 11848961,&
       11848981, 11848981, 11849021, 11849021, 11849039, 11849039 /
      data (iparam(1,i),iparam(2,i),i=  60,  89) / &
       11849053, 11849053, 11849059, 11849059, 11849069, 11849069,&
       11849077, 11849077, 11849087, 11849087, 11849093, 11849093,&
       11849107, 11849107, 11849111, 11849111, 11849129, 11849129,&
       11849137, 11849137, 11849177, 11849177, 11849183, 11849183,&
       11849203, 11849203, 11849231, 11849231, 11849237, 11849237,&
       11849239, 11849239, 11849249, 11849249, 11849251, 11849251,&
       11849269, 11849269, 11849273, 11849273, 11849291, 11849291,&
       11849297, 11849297, 11849309, 11849309, 11849339, 11849339,&
       11849359, 11849359, 11849363, 11849363, 11849399, 11849399,&
       11849401, 11849401, 11849413, 11849413, 11849417, 11849417 /
      data (iparam(1,i),iparam(2,i),i=  90, 119) / &
       11849437, 11849437, 11849443, 11849443, 11849473, 11849473,&
       11849491, 11849491, 11849503, 11849503, 11849507, 11849507,&
       11849557, 11849557, 11849567, 11849567, 11849569, 11849569,&
       11849573, 11849573, 11849587, 11849587, 11849599, 11849599,&
       11849633, 11849633, 11849641, 11849641, 11849653, 11849653,&
       11849659, 11849659, 11849671, 11849671, 11849683, 11849683,&
       11849689, 11849689, 11849693, 11849693, 11849699, 11849699,&
       11849701, 11849701, 11849707, 11849707, 11849713, 11849713,&
       11849723, 11849723, 11849741, 11849741, 11849743, 11849743,&
       11849759, 11849759, 11849767, 11849767, 11849771, 11849771 /
      data (iparam(1,i),iparam(2,i),i= 120, 149) / &
       11849791, 11849791, 11849801, 11849801, 11849809, 11849809,&
       11849813, 11849813, 11849869, 11849869, 11849881, 11849881,&
       11849891, 11849891, 11849909, 11849909, 11849923, 11849923,&
       11849933, 11849933, 11849947, 11849947, 11849987, 11849987,&
       11850001, 11850001, 11850011, 11850011, 11850019, 11850019,&
       11850023, 11850023, 11850031, 11850031, 11850049, 11850049,&
       11850061, 11850061, 11850073, 11850073, 11850077, 11850077,&
       11850103, 11850103, 11850109, 11850109, 11850121, 11850121,&
       11850127, 11850127, 11850133, 11850133, 11850149, 11850149,&
       11850161, 11850161, 11850169, 11850169, 11850191, 11850191 /
      data (iparam(1,i),iparam(2,i),i= 150, 179) / &
       11850233, 11850233, 11850247, 11850247, 11850259, 11850259,&
       11850269, 11850269, 11850283, 11850283, 11850301, 11850301,&
       11850341, 11850341, 11850347, 11850347, 11850367, 11850367,&
       11850373, 11850373, 11850379, 11850379, 11850389, 11850389,&
       11850407, 11850407, 11850427, 11850427, 11850437, 11850437,&
       11850469, 11850469, 11850481, 11850481, 11850511, 11850511,&
       11850529, 11850529, 11850541, 11850541, 11850557, 11850557,&
       11850607, 11850607, 11850611, 11850611, 11850667, 11850667,&
       11850677, 11850677, 11850679, 11850679, 11850701, 11850701,&
       11850731, 11850731, 11850739, 11850739, 11850749, 11850749 /
      data (iparam(1,i),iparam(2,i),i= 180, 209) / &
       11850791, 11850791, 11850803, 11850803, 11850829, 11850829,&
       11850833, 11850833, 11850859, 11850859, 11850877, 11850877,&
       11850899, 11850899, 11850907, 11850907, 11850913, 11850913,&
       11850919, 11850919, 11850931, 11850931, 11850941, 11850941,&
       11850947, 11850947, 11850953, 11850953, 11850961, 11850961,&
       11850983, 11850983, 11850991, 11850991, 11850997, 11850997,&
       11851031, 11851031, 11851033, 11851033, 11851051, 11851051,&
       11851061, 11851061, 11851067, 11851067, 11851093, 11851093,&
       11851109, 11851109, 11851123, 11851123, 11851127, 11851127,&
       11851139, 11851139, 11851157, 11851157, 11851163, 11851163 /
      data (iparam(1,i),iparam(2,i),i= 210, 239) / &
       11851181, 11851181, 11851201, 11851201, 11851219, 11851219,&
       11851291, 11851291, 11851303, 11851303, 11851309, 11851309,&
       11851313, 11851313, 11851319, 11851319, 11851349, 11851349,&
       11851351, 11851351, 11851361, 11851361, 11851373, 11851373,&
       11851403, 11851403, 11851409, 11851409, 11851423, 11851423,&
       11851447, 11851447, 11851451, 11851451, 11851481, 11851481,&
       11851493, 11851493, 11851519, 11851519, 11851523, 11851523,&
       11851529, 11851529, 11851547, 11851547, 11851549, 11851549,&
       11851559, 11851559, 11851577, 11851577, 11851589, 11851589,&
       11851591, 11851591, 11851597, 11851597, 11851603, 11851603 /
      data (iparam(1,i),iparam(2,i),i= 240, 269) / &
       11851607, 11851607, 11851613, 11851613, 11851621, 11851621,&
       11851627, 11851627, 11851639, 11851639, 11851673, 11851673,&
       11851681, 11851681, 11851727, 11851727, 11851753, 11851753,&
       11851759, 11851759, 11851787, 11851787, 11851793, 11851793,&
       11851799, 11851799, 11851813, 11851813, 11851841, 11851841,&
       11851859, 11851859, 11851867, 11851867, 11851891, 11851891,&
       11851909, 11851909, 11851919, 11851919, 11851927, 11851927,&
       11851933, 11851933, 11851949, 11851949, 11851967, 11851967,&
       11851997, 11851997, 11852017, 11852017, 11852051, 11852051,&
       11852053, 11852053, 11852059, 11852059, 11852083, 11852083 /
      data (iparam(1,i),iparam(2,i),i= 270, 299) / &
       11852089, 11852089, 11852129, 11852129, 11852147, 11852147,&
       11852149, 11852149, 11852161, 11852161, 11852171, 11852171,&
       11852177, 11852177, 11852209, 11852209, 11852221, 11852221,&
       11852237, 11852237, 11852251, 11852251, 11852263, 11852263,&
       11852273, 11852273, 11852279, 11852279, 11852287, 11852287,&
       11852293, 11852293, 11852297, 11852297, 11852303, 11852303,&
       11852311, 11852311, 11852327, 11852327, 11852339, 11852339,&
       11852341, 11852341, 11852359, 11852359, 11852369, 11852369,&
       11852437, 11852437, 11852453, 11852453, 11852459, 11852459,&
       11852473, 11852473, 11852513, 11852513, 11852531, 11852531 /
      data (iparam(1,i),iparam(2,i),i= 300, 329) / &
       11852537, 11852537, 11852539, 11852539, 11852557, 11852557,&
       11852573, 11852573, 11852579, 11852579, 11852591, 11852591,&
       11852609, 11852609, 11852611, 11852611, 11852623, 11852623,&
       11852641, 11852641, 11852647, 11852647, 11852657, 11852657,&
       11852663, 11852663, 11852717, 11852717, 11852719, 11852719,&
       11852741, 11852741, 11852759, 11852759, 11852767, 11852767,&
       11852773, 11852773, 11852803, 11852803, 11852807, 11852807,&
       11852809, 11852809, 11852831, 11852831, 11852833, 11852833,&
       11852837, 11852837, 11852857, 11852857, 11852873, 11852873,&
       11852879, 11852879, 11852891, 11852891, 11852917, 11852917 /
      data (iparam(1,i),iparam(2,i),i= 330, 359) / &
       11852921, 11852921, 11852957, 11852957, 11852959, 11852959,&
       11852969, 11852969, 11852983, 11852983, 11852989, 11852989,&
       11853001, 11853001, 11853013, 11853013, 11853019, 11853019,&
       11853031, 11853031, 11853089, 11853089, 11853133, 11853133,&
       11853157, 11853157, 11853161, 11853161, 11853181, 11853181,&
       11853203, 11853203, 11853217, 11853217, 11853221, 11853221,&
       11853227, 11853227, 11853241, 11853241, 11853307, 11853307,&
       11853319, 11853319, 11853323, 11853323, 11853329, 11853329,&
       11853367, 11853367, 11853383, 11853383, 11853419, 11853419,&
       11853421, 11853421, 11853427, 11853427, 11853449, 11853449 /
      data (iparam(1,i),iparam(2,i),i= 360, 389) / &
       11853451, 11853451, 11853463, 11853463, 11853529, 11853529,&
       11853557, 11853557, 11853571, 11853571, 11853601, 11853601,&
       11853613, 11853613, 11853617, 11853617, 11853629, 11853629,&
       11853649, 11853649, 11853659, 11853659, 11853679, 11853679,&
       11853689, 11853689, 11853719, 11853719, 11853731, 11853731,&
       11853757, 11853757, 11853761, 11853761, 11853773, 11853773,&
       11853791, 11853791, 11853817, 11853817, 11853839, 11853839,&
       11853847, 11853847, 11853857, 11853857, 11853869, 11853869,&
       11853883, 11853883, 11853887, 11853887, 11853889, 11853889,&
       11853893, 11853893, 11853899, 11853899, 11853911, 11853911 /
      data (iparam(1,i),iparam(2,i),i= 390, 419) / &
       11853931, 11853931, 11853943, 11853943, 11853979, 11853979,&
       11853991, 11853991, 11854001, 11854001, 11854009, 11854009,&
       11854019, 11854019, 11854057, 11854057, 11854061, 11854061,&
       11854147, 11854147, 11854159, 11854159, 11854163, 11854163,&
       11854169, 11854169, 11854211, 11854211, 11854247, 11854247,&
       11854261, 11854261, 11854267, 11854267, 11854279, 11854279,&
       11854303, 11854303, 11854327, 11854327, 11854331, 11854331,&
       11854333, 11854333, 11854363, 11854363, 11854379, 11854379,&
       11854399, 11854399, 11854411, 11854411, 11854429, 11854429,&
       11854433, 11854433, 11854439, 11854439, 11854441, 11854441 /
      data (iparam(1,i),iparam(2,i),i= 420, 449) / &
       11854463, 11854463, 11854477, 11854477, 11854489, 11854489,&
       11854517, 11854517, 11854519, 11854519, 11854523, 11854523,&
       11854529, 11854529, 11854567, 11854567, 11854571, 11854571,&
       11854573, 11854573, 11854603, 11854603, 11854607, 11854607,&
       11854681, 11854681, 11854691, 11854691, 11854709, 11854709,&
       11854723, 11854723, 11854757, 11854757, 11854783, 11854783,&
       11854793, 11854793, 11854813, 11854813, 11854847, 11854847,&
       11854853, 11854853, 11854873, 11854873, 11854877, 11854877,&
       11854883, 11854883, 11854891, 11854891, 11854897, 11854897,&
       11854901, 11854901, 11854919, 11854919, 11854937, 11854937 /
      data (iparam(1,i),iparam(2,i),i= 450, 479) / &
       11854961, 11854961, 11854963, 11854963, 11854979, 11854979,&
       11855003, 11855003, 11855017, 11855017, 11855023, 11855023,&
       11855029, 11855029, 11855033, 11855033, 11855111, 11855111,&
       11855141, 11855141, 11855147, 11855147, 11855149, 11855149,&
       11855159, 11855159, 11855177, 11855177, 11855203, 11855203,&
       11855213, 11855213, 11855219, 11855219, 11855231, 11855231,&
       11855267, 11855267, 11855269, 11855269, 11855303, 11855303,&
       11855309, 11855309, 11855321, 11855321, 11855329, 11855329,&
       11855339, 11855339, 11855351, 11855351, 11855353, 11855353,&
       11855357, 11855357, 11855359, 11855359, 11855381, 11855381 /
      data (iparam(1,i),iparam(2,i),i= 480, 509) / &
       11855383, 11855383, 11855387, 11855387, 11855399, 11855399,&
       11855407, 11855407, 11855413, 11855413, 11855489, 11855489,&
       11855491, 11855491, 11855507, 11855507, 11855521, 11855521,&
       11855531, 11855531, 11855549, 11855549, 11855551, 11855551,&
       11855567, 11855567, 11855581, 11855581, 11855587, 11855587,&
       11855593, 11855593, 11855633, 11855633, 11855653, 11855653,&
       11855663, 11855663, 11855687, 11855687, 11855689, 11855689,&
       11855699, 11855699, 11855713, 11855713, 11855731, 11855731,&
       11855737, 11855737, 11855743, 11855743, 11855747, 11855747,&
       11855759, 11855759, 11855773, 11855773, 11855801, 11855801 /
      data (iparam(1,i),iparam(2,i),i= 510, 539) / &
       11855807, 11855807, 11855813, 11855813, 11855827, 11855827,&
       11855839, 11855839, 11855869, 11855869, 11855881, 11855881,&
       11855903, 11855903, 11855911, 11855911, 11855933, 11855933,&
       11855959, 11855959, 11855989, 11855989, 11855993, 11855993,&
       11855999, 11855999, 11856001, 11856001, 11856023, 11856023,&
       11856049, 11856049, 11856071, 11856071, 11856101, 11856101,&
       11856107, 11856107, 11856113, 11856113, 11856139, 11856139,&
       11856151, 11856151, 11856161, 11856161, 11856179, 11856179,&
       11856193, 11856193, 11856199, 11856199, 11856223, 11856223,&
       11856239, 11856239, 11856263, 11856263, 11856269, 11856269 /
      data (iparam(1,i),iparam(2,i),i= 540, 569) / &
       11856281, 11856281, 11856287, 11856287, 11856307, 11856307,&
       11856311, 11856311, 11856329, 11856329, 11856343, 11856343,&
       11856359, 11856359, 11856371, 11856371, 11856373, 11856373,&
       11856409, 11856409, 11856419, 11856419, 11856461, 11856461,&
       11856469, 11856469, 11856473, 11856473, 11856479, 11856479,&
       11856511, 11856511, 11856517, 11856517, 11856541, 11856541,&
       11856547, 11856547, 11856553, 11856553, 11856583, 11856583,&
       11856629, 11856629, 11856641, 11856641, 11856653, 11856653,&
       11856659, 11856659, 11856673, 11856673, 11856697, 11856697,&
       11856709, 11856709, 11856727, 11856727, 11856731, 11856731 /
      data (iparam(1,i),iparam(2,i),i= 570, 599) / &
       11856763, 11856763, 11856809, 11856809, 11856811, 11856811,&
       11856821, 11856821, 11856841, 11856841, 11856857, 11856857,&
       11856877, 11856877, 11856883, 11856883, 11856899, 11856899,&
       11856919, 11856919, 11856947, 11856947, 11856953, 11856953,&
       11856979, 11856979, 11857003, 11857003, 11857033, 11857033,&
       11857037, 11857037, 11857039, 11857039, 11857049, 11857049,&
       11857061, 11857061, 11857067, 11857067, 11857073, 11857073,&
       11857081, 11857081, 11857091, 11857091, 11857093, 11857093,&
       11857099, 11857099, 11857123, 11857123, 11857127, 11857127,&
       11857147, 11857147, 11857151, 11857151, 11857193, 11857193 /
      data (iparam(1,i),iparam(2,i),i= 600, 629) / &
       11857217, 11857217, 11857229, 11857229, 11857243, 11857243,&
       11857249, 11857249, 11857267, 11857267, 11857277, 11857277,&
       11857291, 11857291, 11857303, 11857303, 11857309, 11857309,&
       11857327, 11857327, 11857331, 11857331, 11857333, 11857333,&
       11857361, 11857361, 11857367, 11857367, 11857369, 11857369,&
       11857393, 11857393, 11857399, 11857399, 11857409, 11857409,&
       11857421, 11857421, 11857423, 11857423, 11857451, 11857451,&
       11857453, 11857453, 11857457, 11857457, 11857477, 11857477,&
       11857481, 11857481, 11857493, 11857493, 11857499, 11857499,&
       11857519, 11857519, 11857523, 11857523, 11857529, 11857529 /
      data (iparam(1,i),iparam(2,i),i= 630, 659) / &
       11857543, 11857543, 11857561, 11857561, 11857589, 11857589,&
       11857591, 11857591, 11857613, 11857613, 11857621, 11857621,&
       11857661, 11857661, 11857667, 11857667, 11857693, 11857693,&
       11857697, 11857697, 11857709, 11857709, 11857711, 11857711,&
       11857751, 11857751, 11857753, 11857753, 11857759, 11857759,&
       11857763, 11857763, 11857777, 11857777, 11857787, 11857787,&
       11857793, 11857793, 11857801, 11857801, 11857817, 11857817,&
       11857819, 11857819, 11857831, 11857831, 11857837, 11857837,&
       11857873, 11857873, 11857877, 11857877, 11857883, 11857883,&
       11857889, 11857889, 11857907, 11857907, 11857913, 11857913 /
      data (iparam(1,i),iparam(2,i),i= 660, 689) / &
       11857931, 11857931, 11857969, 11857969, 11857991, 11857991,&
       11857999, 11857999, 11858009, 11858009, 11858017, 11858017,&
       11858023, 11858023, 11858029, 11858029, 11858039, 11858039,&
       11858051, 11858051, 11858057, 11858057, 11858059, 11858059,&
       11858101, 11858101, 11858111, 11858111, 11858131, 11858131,&
       11858149, 11858149, 11858159, 11858159, 11858177, 11858177,&
       11858191, 11858191, 11858201, 11858201, 11858227, 11858227,&
       11858243, 11858243, 11858267, 11858267, 11858269, 11858269,&
       11858279, 11858279, 11858281, 11858281, 11858291, 11858291,&
       11858311, 11858311, 11858323, 11858323, 11858359, 11858359 /
      data (iparam(1,i),iparam(2,i),i= 690, 719) / &
       11858377, 11858377, 11858381, 11858381, 11858387, 11858387,&
       11858423, 11858423, 11858443, 11858443, 11858447, 11858447,&
       11858479, 11858479, 11858533, 11858533, 11858543, 11858543,&
       11858551, 11858551, 11858557, 11858557, 11858569, 11858569,&
       11858573, 11858573, 11858579, 11858579, 11858597, 11858597,&
       11858599, 11858599, 11858629, 11858629, 11858657, 11858657,&
       11858659, 11858659, 11858683, 11858683, 11858701, 11858701,&
       11858719, 11858719, 11858723, 11858723, 11858729, 11858729,&
       11858747, 11858747, 11858779, 11858779, 11858783, 11858783,&
       11858801, 11858801, 11858807, 11858807, 11858813, 11858813 /
      data (iparam(1,i),iparam(2,i),i= 720, 749) / &
       11858839, 11858839, 11858851, 11858851, 11858893, 11858893,&
       11858897, 11858897, 11858921, 11858921, 11858947, 11858947,&
       11858953, 11858953, 11858969, 11858969, 11858971, 11858971,&
       11858989, 11858989, 11859017, 11859017, 11859031, 11859031,&
       11859049, 11859049, 11859061, 11859061, 11859073, 11859073,&
       11859077, 11859077, 11859079, 11859079, 11859083, 11859083,&
       11859101, 11859101, 11859109, 11859109, 11859137, 11859137,&
       11859139, 11859139, 11859151, 11859151, 11859157, 11859157,&
       11859163, 11859163, 11859167, 11859167, 11859179, 11859179,&
       11859187, 11859187, 11859229, 11859229, 11859233, 11859233 /
      data (iparam(1,i),iparam(2,i),i= 750, 779) / &
       11859241, 11859241, 11859247, 11859247, 11859269, 11859269,&
       11859293, 11859293, 11859307, 11859307, 11859311, 11859311,&
       11859349, 11859349, 11859359, 11859359, 11859371, 11859371,&
       11859377, 11859377, 11859383, 11859383, 11859427, 11859427,&
       11859433, 11859433, 11859451, 11859451, 11859457, 11859457,&
       11859461, 11859461, 11859473, 11859473, 11859481, 11859481,&
       11859487, 11859487, 11859493, 11859493, 11859503, 11859503,&
       11859509, 11859509, 11859539, 11859539, 11859541, 11859541,&
       11859563, 11859563, 11859569, 11859569, 11859571, 11859571,&
       11859583, 11859583, 11859599, 11859599, 11859611, 11859611 /
      data (iparam(1,i),iparam(2,i),i= 780, 809) / &
       11859643, 11859643, 11859707, 11859707, 11859713, 11859713,&
       11859719, 11859719, 11859739, 11859739, 11859751, 11859751,&
       11859791, 11859791, 11859817, 11859817, 11859821, 11859821,&
       11859833, 11859833, 11859847, 11859847, 11859853, 11859853,&
       11859877, 11859877, 11859889, 11859889, 11859893, 11859893,&
       11859901, 11859901, 11859907, 11859907, 11859917, 11859917,&
       11859923, 11859923, 11859929, 11859929, 11859961, 11859961,&
       11859979, 11859979, 11859989, 11859989, 11859997, 11859997,&
       11860021, 11860021, 11860031, 11860031, 11860039, 11860039,&
       11860049, 11860049, 11860081, 11860081, 11860087, 11860087 /
      data (iparam(1,i),iparam(2,i),i= 810, 839) / &
       11860097, 11860097, 11860103, 11860103, 11860109, 11860109,&
       11860117, 11860117, 11860133, 11860133, 11860151, 11860151,&
       11860171, 11860171, 11860207, 11860207, 11860223, 11860223,&
       11860231, 11860231, 11860243, 11860243, 11860267, 11860267,&
       11860301, 11860301, 11860307, 11860307, 11860327, 11860327,&
       11860379, 11860379, 11860397, 11860397, 11860411, 11860411,&
       11860469, 11860469, 11860477, 11860477, 11860483, 11860483,&
       11860487, 11860487, 11860489, 11860489, 11860493, 11860493,&
       11860517, 11860517, 11860547, 11860547, 11860567, 11860567,&
       11860573, 11860573, 11860613, 11860613, 11860619, 11860619 /
      data (iparam(1,i),iparam(2,i),i= 840, 869) / &
       11860627, 11860627, 11860637, 11860637, 11860643, 11860643,&
       11860649, 11860649, 11860661, 11860661, 11860669, 11860669,&
       11860687, 11860687, 11860691, 11860691, 11860697, 11860697,&
       11860699, 11860699, 11860703, 11860703, 11860727, 11860727,&
       11860741, 11860741, 11860753, 11860753, 11860777, 11860777,&
       11860787, 11860787, 11860789, 11860789, 11860811, 11860811,&
       11860837, 11860837, 11860859, 11860859, 11860867, 11860867,&
       11860889, 11860889, 11860897, 11860897, 11860963, 11860963,&
       11860969, 11860969, 11860973, 11860973, 11860993, 11860993,&
       11861011, 11861011, 11861033, 11861033, 11861071, 11861071 /
      data (iparam(1,i),iparam(2,i),i= 870, 899) / &
       11861081, 11861081, 11861089, 11861089, 11861093, 11861093,&
       11861099, 11861099, 11861107, 11861107, 11861131, 11861131,&
       11861141, 11861141, 11861159, 11861159, 11861167, 11861167,&
       11861191, 11861191, 11861197, 11861197, 11861207, 11861207,&
       11861219, 11861219, 11861221, 11861221, 11861231, 11861231,&
       11861237, 11861237, 11861273, 11861273, 11861293, 11861293,&
       11861299, 11861299, 11861303, 11861303, 11861327, 11861327,&
       11861351, 11861351, 11861357, 11861357, 11861363, 11861363,&
       11861371, 11861371, 11861401, 11861401, 11861407, 11861407,&
       11861411, 11861411, 11861413, 11861413, 11861429, 11861429 /
      data (iparam(1,i),iparam(2,i),i= 900, 929) / &
       11861441, 11861441, 11861467, 11861467, 11861527, 11861527,&
       11861539, 11861539, 11861543, 11861543, 11861557, 11861557,&
       11861569, 11861569, 11861573, 11861573, 11861579, 11861579,&
       11861581, 11861581, 11861599, 11861599, 11861611, 11861611,&
       11861617, 11861617, 11861627, 11861627, 11861639, 11861639,&
       11861651, 11861651, 11861659, 11861659, 11861671, 11861671,&
       11861683, 11861683, 11861687, 11861687, 11861693, 11861693,&
       11861701, 11861701, 11861711, 11861711, 11861713, 11861713,&
       11861749, 11861749, 11861791, 11861791, 11861803, 11861803,&
       11861819, 11861819, 11861827, 11861827, 11861849, 11861849 /
      data (iparam(1,i),iparam(2,i),i= 930, 959) / &
       11861873, 11861873, 11861879, 11861879, 11861887, 11861887,&
       11861911, 11861911, 11861917, 11861917, 11861921, 11861921,&
       11861923, 11861923, 11861953, 11861953, 11861959, 11861959,&
       11861987, 11861987, 11862007, 11862007, 11862013, 11862013,&
       11862029, 11862029, 11862031, 11862031, 11862049, 11862049,&
       11862077, 11862077, 11862083, 11862083, 11862157, 11862157,&
       11862167, 11862167, 11862199, 11862199, 11862203, 11862203,&
       11862217, 11862217, 11862223, 11862223, 11862229, 11862229,&
       11862233, 11862233, 11862239, 11862239, 11862241, 11862241,&
       11862259, 11862259, 11862269, 11862269, 11862271, 11862271 /
      data (iparam(1,i),iparam(2,i),i= 960, 989) / &
       11862293, 11862293, 11862307, 11862307, 11862313, 11862313,&
       11862317, 11862317, 11862343, 11862343, 11862353, 11862353,&
       11862373, 11862373, 11862391, 11862391, 11862439, 11862439,&
       11862469, 11862469, 11862493, 11862493, 11862527, 11862527,&
       11862547, 11862547, 11862563, 11862563, 11862569, 11862569,&
       11862577, 11862577, 11862581, 11862581, 11862611, 11862611,&
       11862623, 11862623, 11862661, 11862661, 11862673, 11862673,&
       11862679, 11862679, 11862701, 11862701, 11862703, 11862703,&
       11862713, 11862713, 11862761, 11862761, 11862791, 11862791,&
       11862803, 11862803, 11862839, 11862839, 11862841, 11862841 /
      data (iparam(1,i),iparam(2,i),i= 990,1019) / &
       11862857, 11862857, 11862869, 11862869, 11862881, 11862881,&
       11862911, 11862911, 11862919, 11862919, 11862959, 11862959,&
       11862979, 11862979, 11862989, 11862989, 11862997, 11862997,&
       11863021, 11863021, 11863031, 11863031, 11863037, 11863037,&
       11863039, 11863039, 11863057, 11863057, 11863067, 11863067,&
       11863073, 11863073, 11863099, 11863099, 11863109, 11863109,&
       11863121, 11863121, 11863123, 11863123, 11863133, 11863133,&
       11863151, 11863151, 11863153, 11863153, 11863171, 11863171,&
       11863183, 11863183, 11863207, 11863207, 11863213, 11863213,&
       11863237, 11863237, 11863249, 11863249, 11863253, 11863253 /
      data (iparam(1,i),iparam(2,i),i=1020,1021) / &
       11863259, 11863259, 11863279, 11863279 /
!      end
!-----------------------------------------------------------------------------
#else
!      block data prngblk
!
! Sequence of prime numbers represented as pairs of 16-bit integers
! modulo 2**16, obtained from Mal Kalos August 28, 1992.  Only 98
! continuation cards are allowed by ksr Fortran, so several DATA
! statements are used to initialize 1022 generators.
!
! @cornell university, 1992
!
      integer,parameter :: nmax=1021,nmax1=2*nmax+2
      integer,dimension(16,0:nmax) :: l,n
      integer,private :: i,j
!      common/ksrprng/l(16,0:nmax),n(16,0:nmax)
!*ksr*subpage /ksrprng/

! High order quads in arrays "l" and "n" are initialized to zero : rows 1-2
! Rows 5-16 remain uninitialized.  They are just pads, never used.
      DATA ((l(i,j),i=1,2),j=0,nmax)/nmax1*0.0/
      DATA ((n(i,j),i=1,2),j=0,nmax)/nmax1*0.0/

! The rest of array "l" and "n" are initialized to a 20-bit seed
      DATA ((l(i,j),i=3,4),j=0,489)/ &
       180, 51739,180, 51757,180, 51761,180, 51767,180,51773,&
       180, 51791,180, 51817,180, 51833,180, 51859,180, 51871,&
       180, 51877,180, 51883,180, 51887,180, 51893,180, 51899,&
       180, 51913,180, 51953,180, 51971,180, 51989,180, 51997,&
       180, 52009,180, 52013,180, 52033,180, 52043,180, 52051,&
       180, 52057,180, 52073,180, 52109,180, 52111,180, 52121,&
       180, 52139,180, 52157,180, 52183,180, 52193,180, 52199,&
       180, 52211,180, 52219,180, 52229,180, 52237,180, 52241,&
       180, 52249,180, 52261,180, 52271,180, 52277,180, 52307,&
       180, 52321,180, 52349,180, 52373,180, 52381,180, 52387,&
       180, 52393,180, 52411,180, 52429,180, 52439,180, 52451,&
       180, 52457,180, 52481,180, 52501,180, 52541,180, 52559,&
       180, 52573,180, 52579,180, 52589,180, 52597,180, 52607,&
       180, 52613,180, 52627,180, 52631,180, 52649,180, 52657,&
       180, 52697,180, 52703,180, 52723,180, 52751,180, 52757,&
       180, 52759,180, 52769,180, 52771,180, 52789,180, 52793,&
       180, 52811,180, 52817,180, 52829,180, 52859,180, 52879,&
       180, 52883,180, 52919,180, 52921,180, 52933,180, 52937,&
       180, 52957,180, 52963,180, 52993,180, 53011,180, 53023,&
       180, 53027,180, 53077,180, 53087,180, 53089,180, 53093,&
       180, 53107,180, 53119,180, 53153,180, 53161,180, 53173,&
       180, 53179,180, 53191,180, 53203,180, 53209,180, 53213,&
       180, 53219,180, 53221,180, 53227,180, 53233,180, 53243,&
       180, 53261,180, 53263,180, 53279,180, 53287,180, 53291,&
       180, 53311,180, 53321,180, 53329,180, 53333,180, 53389,&
       180, 53401,180, 53411,180, 53429,180, 53443,180, 53453,&
       180, 53467,180, 53507,180, 53521,180, 53531,180, 53539,&
       180, 53543,180, 53551,180, 53569,180, 53581,180, 53593,&
       180, 53597,180, 53623,180, 53629,180, 53641,180, 53647,&
       180, 53653,180, 53669,180, 53681,180, 53689,180, 53711,&
       180, 53753,180, 53767,180, 53779,180, 53789,180, 53803,&
       180, 53821,180, 53861,180, 53867,180, 53887,180, 53893,&
       180, 53899,180, 53909,180, 53927,180, 53947,180, 53957,&
       180, 53989,180, 54001,180, 54031,180, 54049,180, 54061,&
       180, 54077,180, 54127,180, 54131,180, 54187,180, 54197,&
       180, 54199,180, 54221,180, 54251,180, 54259,180, 54269,&
       180, 54311,180, 54323,180, 54349,180, 54353,180, 54379,&
       180, 54397,180, 54419,180, 54427,180, 54433,180, 54439,&
       180, 54451,180, 54461,180, 54467,180, 54473,180, 54481,&
       180, 54503,180, 54511,180, 54517,180, 54551,180, 54553,&
       180, 54571,180, 54581,180, 54587,180, 54613,180, 54629,&
       180, 54643,180, 54647,180, 54659,180, 54677,180, 54683,&
       180, 54701,180, 54721,180, 54739,180, 54811,180, 54823,&
       180, 54829,180, 54833,180, 54839,180, 54869,180, 54871,&
       180, 54881,180, 54893,180, 54923,180, 54929,180, 54943,&
       180, 54967,180, 54971,180, 55001,180, 55013,180, 55039,&
       180, 55043,180, 55049,180, 55067,180, 55069,180, 55079,&
       180, 55097,180, 55109,180, 55111,180, 55117,180, 55123,&
       180, 55127,180, 55133,180, 55141,180, 55147,180, 55159,&
       180, 55193,180, 55201,180, 55247,180, 55273,180, 55279,&
       180, 55307,180, 55313,180, 55319,180, 55333,180, 55361,&
       180, 55379,180, 55387,180, 55411,180, 55429,180, 55439,&
       180, 55447,180, 55453,180, 55469,180, 55487,180, 55517,&
       180, 55537,180, 55571,180, 55573,180, 55579,180, 55603,&
       180, 55609,180, 55649,180, 55667,180, 55669,180, 55681,&
       180, 55691,180, 55697,180, 55729,180, 55741,180, 55757,&
       180, 55771,180, 55783,180, 55793,180, 55799,180, 55807,&
       180, 55813,180, 55817,180, 55823,180, 55831,180, 55847,&
       180, 55859,180, 55861,180, 55879,180, 55889,180, 55957,&
       180, 55973,180, 55979,180, 55993,180, 56033,180, 56051,&
       180, 56057,180, 56059,180, 56077,180, 56093,180, 56099,&
       180, 56111,180, 56129,180, 56131,180, 56143,180, 56161,&
       180, 56167,180, 56177,180, 56183,180, 56237,180, 56239,&
       180, 56261,180, 56279,180, 56287,180, 56293,180, 56323,&
       180, 56327,180, 56329,180, 56351,180, 56353,180, 56357,&
       180, 56377,180, 56393,180, 56399,180, 56411,180, 56437,&
       180, 56441,180, 56477,180, 56479,180, 56489,180, 56503,&
       180, 56509,180, 56521,180, 56533,180, 56539,180, 56551,&
       180, 56609,180, 56653,180, 56677,180, 56681,180, 56701,&
       180, 56723,180, 56737,180, 56741,180, 56747,180, 56761,&
       180, 56827,180, 56839,180, 56843,180, 56849,180, 56887,&
       180, 56903,180, 56939,180, 56941,180, 56947,180, 56969,&
       180, 56971,180, 56983,180, 57049,180, 57077,180, 57091,&
       180, 57121,180, 57133,180, 57137,180, 57149,180, 57169,&
       180, 57179,180, 57199,180, 57209,180, 57239,180, 57251,&
       180, 57277,180, 57281,180, 57293,180, 57311,180, 57337,&
       180, 57359,180, 57367,180, 57377,180, 57389,180, 57403,&
       180, 57407,180, 57409,180, 57413,180, 57419,180, 57431,&
       180, 57451,180, 57463,180, 57499,180, 57511,180, 57521,&
       180, 57529,180, 57539,180, 57577,180, 57581,180, 57667,&
       180, 57679,180, 57683,180, 57689,180, 57731,180, 57767,&
       180, 57781,180, 57787,180, 57799,180, 57823,180, 57847,&
       180, 57851,180, 57853,180, 57883,180, 57899,180, 57919,&
       180, 57931,180, 57949,180, 57953,180, 57959,180, 57961,&
       180, 57983,180, 57997,180, 58009,180, 58037,180, 58039,&
       180, 58043,180, 58049,180, 58087,180, 58091,180, 58093,&
       180, 58123,180, 58127,180, 58201,180, 58211,180, 58229,&
       180, 58243,180, 58277,180, 58303,180, 58313,180, 58333,&
       180, 58367,180, 58373,180, 58393,180, 58397,180, 58403,&
       180, 58411,180, 58417,180, 58421,180, 58439,180, 58457,&
       180, 58481,180, 58483,180, 58499,180, 58523,180, 58537,&
       180, 58543,180, 58549,180, 58553,180, 58631,180, 58661,&
       180, 58667,180, 58669,180, 58679,180, 58697,180, 58723,&
       180, 58733,180, 58739,180, 58751,180, 58787,180, 58789,&
       180, 58823,180, 58829,180, 58841,180, 58849,180, 58859,&
       180, 58871,180, 58873,180, 58877,180, 58879,180, 58901,&
       180, 58903,180, 58907,180, 58919,180, 58927,180, 58933,&
       180, 59009,180, 59011,180, 59027,180, 59041,180, 59051/
      DATA ((l(i,j),i=3,4),j=490,979)/ &
       180, 59069,180, 59071,180, 59087,180, 59101,180, 59107,&
       180, 59113,180, 59153,180, 59173,180, 59183,180, 59207,&
       180, 59209,180, 59219,180, 59233,180, 59251,180, 59257,&
       180, 59263,180, 59267,180, 59279,180, 59293,180, 59321,&
       180, 59327,180, 59333,180, 59347,180, 59359,180, 59389,&
       180, 59401,180, 59423,180, 59431,180, 59453,180, 59479,&
       180, 59509,180, 59513,180, 59519,180, 59521,180, 59543,&
       180, 59569,180, 59591,180, 59621,180, 59627,180, 59633,&
       180, 59659,180, 59671,180, 59681,180, 59699,180, 59713,&
       180, 59719,180, 59743,180, 59759,180, 59783,180, 59789,&
       180, 59801,180, 59807,180, 59827,180, 59831,180, 59849,&
       180, 59863,180, 59879,180, 59891,180, 59893,180, 59929,&
       180, 59939,180, 59981,180, 59989,180, 59993,180, 59999,&
       180, 60031,180, 60037,180, 60061,180, 60067,180, 60073,&
       180, 60103,180, 60149,180, 60161,180, 60173,180, 60179,&
       180, 60193,180, 60217,180, 60229,180, 60247,180, 60251,&
       180, 60283,180, 60329,180, 60331,180, 60341,180, 60361,&
       180, 60377,180, 60397,180, 60403,180, 60419,180, 60439,&
       180, 60467,180, 60473,180, 60499,180, 60523,180, 60553,&
       180, 60557,180, 60559,180, 60569,180, 60581,180, 60587,&
       180, 60593,180, 60601,180, 60611,180, 60613,180, 60619,&
       180, 60643,180, 60647,180, 60667,180, 60671,180, 60713,&
       180, 60737,180, 60749,180, 60763,180, 60769,180, 60787,&
       180, 60797,180, 60811,180, 60823,180, 60829,180, 60847,&
       180, 60851,180, 60853,180, 60881,180, 60887,180, 60889,&
       180, 60913,180, 60919,180, 60929,180, 60941,180, 60943,&
       180, 60971,180, 60973,180, 60977,180, 60997,180, 61001,&
       180, 61013,180, 61019,180, 61039,180, 61043,180, 61049,&
       180, 61063,180, 61081,180, 61109,180, 61111,180, 61133,&
       180, 61141,180, 61181,180, 61187,180, 61213,180, 61217,&
       180, 61229,180, 61231,180, 61271,180, 61273,180, 61279,&
       180, 61283,180, 61297,180, 61307,180, 61313,180, 61321,&
       180, 61337,180, 61339,180, 61351,180, 61357,180, 61393,&
       180, 61397,180, 61403,180, 61409,180, 61427,180, 61433,&
       180, 61451,180, 61489,180, 61511,180, 61519,180, 61529,&
       180, 61537,180, 61543,180, 61549,180, 61559,180, 61571,&
       180, 61577,180, 61579,180, 61621,180, 61631,180, 61651,&
       180, 61669,180, 61679,180, 61697,180, 61711,180, 61721,&
       180, 61747,180, 61763,180, 61787,180, 61789,180, 61799,&
       180, 61801,180, 61811,180, 61831,180, 61843,180, 61879,&
       180, 61897,180, 61901,180, 61907,180, 61943,180, 61963,&
       180, 61967,180, 61999,180, 62053,180, 62063,180, 62071,&
       180, 62077,180, 62089,180, 62093,180, 62099,180, 62117,&
       180, 62119,180, 62149,180, 62177,180, 62179,180, 62203,&
       180, 62221,180, 62239,180, 62243,180, 62249,180, 62267,&
       180, 62299,180, 62303,180, 62321,180, 62327,180, 62333,&
       180, 62359,180, 62371,180, 62413,180, 62417,180, 62441,&
       180, 62467,180, 62473,180, 62489,180, 62491,180, 62509,&
       180, 62537,180, 62551,180, 62569,180, 62581,180, 62593,&
       180, 62597,180, 62599,180, 62603,180, 62621,180, 62629,&
       180, 62657,180, 62659,180, 62671,180, 62677,180, 62683,&
       180, 62687,180, 62699,180, 62707,180, 62749,180, 62753,&
       180, 62761,180, 62767,180, 62789,180, 62813,180, 62827,&
       180, 62831,180, 62869,180, 62879,180, 62891,180, 62897,&
       180, 62903,180, 62947,180, 62953,180, 62971,180, 62977,&
       180, 62981,180, 62993,180, 63001,180, 63007,180, 63013,&
       180, 63023,180, 63029,180, 63059,180, 63061,180, 63083,&
       180, 63089,180, 63091,180, 63103,180, 63119,180, 63131,&
       180, 63163,180, 63227,180, 63233,180, 63239,180, 63259,&
       180, 63271,180, 63311,180, 63337,180, 63341,180, 63353,&
       180, 63367,180, 63373,180, 63397,180, 63409,180, 63413,&
       180, 63421,180, 63427,180, 63437,180, 63443,180, 63449,&
       180, 63481,180, 63499,180, 63509,180, 63517,180, 63541,&
       180, 63551,180, 63559,180, 63569,180, 63601,180, 63607,&
       180, 63617,180, 63623,180, 63629,180, 63637,180, 63653,&
       180, 63671,180, 63691,180, 63727,180, 63743,180, 63751,&
       180, 63763,180, 63787,180, 63821,180, 63827,180, 63847,&
       180, 63899,180, 63917,180, 63931,180, 63989,180, 63997,&
       180, 64003,180, 64007,180, 64009,180, 64013,180, 64037,&
       180, 64067,180, 64087,180, 64093,180, 64133,180, 64139,&
       180, 64147,180, 64157,180, 64163,180, 64169,180, 64181,&
       180, 64189,180, 64207,180, 64211,180, 64217,180, 64219,&
       180, 64223,180, 64247,180, 64261,180, 64273,180, 64297,&
       180, 64307,180, 64309,180, 64331,180, 64357,180, 64379,&
       180, 64387,180, 64409,180, 64417,180, 64483,180, 64489,&
       180, 64493,180, 64513,180, 64531,180, 64553,180, 64591,&
       180, 64601,180, 64609,180, 64613,180, 64619,180, 64627,&
       180, 64651,180, 64661,180, 64679,180, 64687,180, 64711,&
       180, 64717,180, 64727,180, 64739,180, 64741,180, 64751,&
       180, 64757,180, 64793,180, 64813,180, 64819,180, 64823,&
       180, 64847,180, 64871,180, 64877,180, 64883,180, 64891,&
       180, 64921,180, 64927,180, 64931,180, 64933,180, 64949,&
       180, 64961,180, 64987,180, 65047,180, 65059,180, 65063,&
       180, 65077,180, 65089,180, 65093,180, 65099,180, 65101,&
       180, 65119,180, 65131,180, 65137,180, 65147,180, 65159,&
       180, 65171,180, 65179,180, 65191,180, 65203,180, 65207,&
       180, 65213,180, 65221,180, 65231,180, 65233,180, 65269,&
       180, 65311,180, 65323,180, 65339,180, 65347,180, 65369,&
       180, 65393,180, 65399,180, 65407,180, 65431,180, 65437,&
       180, 65441,180, 65443,180, 65473,180, 65479,180, 65507,&
       180, 65527,180, 65533,181, 13,181, 15,181, 33,&
       181, 61,181, 67,181, 141,181, 151,181, 183,&
       181, 187,181, 201,181, 207,181, 213,181, 217,&
       181, 223,181, 225,181, 243,181, 253,181, 255,&
       181, 277,181, 291,181, 297,181, 301,181, 327,&
       181, 337,181, 357,181, 375,181, 423,181, 453,&
       181, 477,181, 511,181, 531,181, 547,181, 553,&
       181, 561,181, 565,181, 595,181, 607,181, 645/
      DATA ((l(i,j),i=3,4),j=980,nmax)/ &
       181, 657,181, 663,181, 685,181, 687,181, 697,&
       181, 745,181, 775,181, 787,181, 823,181, 825,&
       181, 841,181, 853,181, 865,181, 895,181, 903,&
       181, 943,181, 963,181, 973,181, 981,181, 1005,&
       181,1015,181,1021,181,1023,181,1041,181,1051,&
       181, 1057,181, 1083,181, 1093,181, 1105,181, 1107,&
       181, 1117,181, 1135,181, 1137,181, 1155,181, 1167,&
       181, 1191,181, 1197,181, 1221,181, 1233,181, 1237,&
       181, 1243,181, 1263/
      DATA ((n(i,j),i=3,4),j=0,489)/ &
       180, 51739,180, 51757,180, 51761,180, 51767,180, 51773,&
       180, 51791,180, 51817,180, 51833,180, 51859,180, 51871,&
       180, 51877,180, 51883,180, 51887,180, 51893,180, 51899,&
       180, 51913,180, 51953,180, 51971,180, 51989,180, 51997,&
       180, 52009,180, 52013,180, 52033,180, 52043,180, 52051,&
       180, 52057,180, 52073,180, 52109,180, 52111,180, 52121,&
       180, 52139,180, 52157,180, 52183,180, 52193,180, 52199,&
       180, 52211,180, 52219,180, 52229,180, 52237,180, 52241,&
       180, 52249,180, 52261,180, 52271,180, 52277,180, 52307,&
       180, 52321,180, 52349,180, 52373,180, 52381,180, 52387,&
       180, 52393,180, 52411,180, 52429,180, 52439,180, 52451,&
       180, 52457,180, 52481,180, 52501,180, 52541,180, 52559,&
       180, 52573,180, 52579,180, 52589,180, 52597,180, 52607,&
       180, 52613,180, 52627,180, 52631,180, 52649,180, 52657,&
       180, 52697,180, 52703,180, 52723,180, 52751,180, 52757,&
       180, 52759,180, 52769,180, 52771,180, 52789,180, 52793,&
       180, 52811,180, 52817,180, 52829,180, 52859,180, 52879,&
       180, 52883,180, 52919,180, 52921,180, 52933,180, 52937,&
       180, 52957,180, 52963,180, 52993,180, 53011,180, 53023,&
       180, 53027,180, 53077,180, 53087,180, 53089,180, 53093,&
       180, 53107,180, 53119,180, 53153,180, 53161,180, 53173,&
       180, 53179,180, 53191,180, 53203,180, 53209,180, 53213,&
       180, 53219,180, 53221,180, 53227,180, 53233,180, 53243,&
       180, 53261,180, 53263,180, 53279,180, 53287,180, 53291,&
       180, 53311,180, 53321,180, 53329,180, 53333,180, 53389,&
       180, 53401,180, 53411,180, 53429,180, 53443,180, 53453,&
       180, 53467,180, 53507,180, 53521,180, 53531,180, 53539,&
       180, 53543,180, 53551,180, 53569,180, 53581,180, 53593,&
       180, 53597,180, 53623,180, 53629,180, 53641,180, 53647,&
       180, 53653,180, 53669,180, 53681,180, 53689,180, 53711,&
       180, 53753,180, 53767,180, 53779,180, 53789,180, 53803,&
       180, 53821,180, 53861,180, 53867,180, 53887,180, 53893,&
       180, 53899,180, 53909,180, 53927,180, 53947,180, 53957,&
       180, 53989,180, 54001,180, 54031,180, 54049,180, 54061,&
       180, 54077,180, 54127,180, 54131,180, 54187,180, 54197,&
       180, 54199,180, 54221,180, 54251,180, 54259,180, 54269,&
       180, 54311,180, 54323,180, 54349,180, 54353,180, 54379,&
       180, 54397,180, 54419,180, 54427,180, 54433,180, 54439,&
       180, 54451,180, 54461,180, 54467,180, 54473,180, 54481,&
       180, 54503,180, 54511,180, 54517,180, 54551,180, 54553,&
       180, 54571,180, 54581,180, 54587,180, 54613,180, 54629,&
       180, 54643,180, 54647,180, 54659,180, 54677,180, 54683,&
       180, 54701,180, 54721,180, 54739,180, 54811,180, 54823,&
       180, 54829,180, 54833,180, 54839,180, 54869,180, 54871,&
       180, 54881,180, 54893,180, 54923,180, 54929,180, 54943,&
       180, 54967,180, 54971,180, 55001,180, 55013,180, 55039,&
       180, 55043,180, 55049,180, 55067,180, 55069,180, 55079,&
       180, 55097,180, 55109,180, 55111,180, 55117,180, 55123,&
       180, 55127,180, 55133,180, 55141,180, 55147,180, 55159,&
       180, 55193,180, 55201,180, 55247,180, 55273,180, 55279,&
       180, 55307,180, 55313,180, 55319,180, 55333,180, 55361,&
       180, 55379,180, 55387,180, 55411,180, 55429,180, 55439,&
       180, 55447,180, 55453,180, 55469,180, 55487,180, 55517,&
       180, 55537,180, 55571,180, 55573,180, 55579,180, 55603,&
       180, 55609,180, 55649,180, 55667,180, 55669,180, 55681,&
       180, 55691,180, 55697,180, 55729,180, 55741,180, 55757,&
       180, 55771,180, 55783,180, 55793,180, 55799,180, 55807,&
       180, 55813,180, 55817,180, 55823,180, 55831,180, 55847,&
       180, 55859,180, 55861,180, 55879,180, 55889,180, 55957,&
       180, 55973,180, 55979,180, 55993,180, 56033,180, 56051,&
       180, 56057,180, 56059,180, 56077,180, 56093,180, 56099,&
       180, 56111,180, 56129,180, 56131,180, 56143,180, 56161,&
       180, 56167,180, 56177,180, 56183,180, 56237,180, 56239,&
       180, 56261,180, 56279,180, 56287,180, 56293,180, 56323,&
       180, 56327,180, 56329,180, 56351,180, 56353,180, 56357,&
       180, 56377,180, 56393,180, 56399,180, 56411,180, 56437,&
       180, 56441,180, 56477,180, 56479,180, 56489,180, 56503,&
       180, 56509,180, 56521,180, 56533,180, 56539,180, 56551,&
       180, 56609,180, 56653,180, 56677,180, 56681,180, 56701,&
       180, 56723,180, 56737,180, 56741,180, 56747,180, 56761,&
       180, 56827,180, 56839,180, 56843,180, 56849,180, 56887,&
       180, 56903,180, 56939,180, 56941,180, 56947,180, 56969,&
       180, 56971,180, 56983,180, 57049,180, 57077,180, 57091,&
       180, 57121,180, 57133,180, 57137,180, 57149,180, 57169,&
       180, 57179,180, 57199,180, 57209,180, 57239,180, 57251,&
       180, 57277,180, 57281,180, 57293,180, 57311,180, 57337,&
       180, 57359,180, 57367,180, 57377,180, 57389,180, 57403,&
       180, 57407,180, 57409,180, 57413,180, 57419,180, 57431,&
       180, 57451,180, 57463,180, 57499,180, 57511,180, 57521,&
       180, 57529,180, 57539,180, 57577,180, 57581,180, 57667,&
       180, 57679,180, 57683,180, 57689,180, 57731,180, 57767,&
       180, 57781,180, 57787,180, 57799,180, 57823,180, 57847,&
       180, 57851,180, 57853,180, 57883,180, 57899,180, 57919,&
       180, 57931,180, 57949,180, 57953,180, 57959,180, 57961,&
       180, 57983,180, 57997,180, 58009,180, 58037,180, 58039,&
       180, 58043,180, 58049,180, 58087,180, 58091,180, 58093,&
       180, 58123,180, 58127,180, 58201,180, 58211,180, 58229,&
       180, 58243,180, 58277,180, 58303,180, 58313,180, 58333,&
       180, 58367,180, 58373,180, 58393,180, 58397,180, 58403,&
       180, 58411,180, 58417,180, 58421,180, 58439,180, 58457,&
       180, 58481,180, 58483,180, 58499,180, 58523,180, 58537,&
       180, 58543,180, 58549,180, 58553,180, 58631,180, 58661,&
       180, 58667,180, 58669,180, 58679,180, 58697,180, 58723,&
       180, 58733,180, 58739,180, 58751,180, 58787,180, 58789,&
       180, 58823,180, 58829,180, 58841,180, 58849,180, 58859,&
       180, 58871,180, 58873,180, 58877,180, 58879,180, 58901,&
       180, 58903,180, 58907,180, 58919,180, 58927,180, 58933,&
       180, 59009,180, 59011,180, 59027,180, 59041,180, 59051/
      DATA ((n(i,j),i=3,4),j=490,979)/ &
       180, 59069,180, 59071,180, 59087,180, 59101,180, 59107,&
       180, 59113,180, 59153,180, 59173,180, 59183,180, 59207,&
       180, 59209,180, 59219,180, 59233,180, 59251,180, 59257,&
       180, 59263,180, 59267,180, 59279,180, 59293,180, 59321,&
       180, 59327,180, 59333,180, 59347,180, 59359,180, 59389,&
       180, 59401,180, 59423,180, 59431,180, 59453,180, 59479,&
       180, 59509,180, 59513,180, 59519,180, 59521,180, 59543,&
       180, 59569,180, 59591,180, 59621,180, 59627,180, 59633,&
       180, 59659,180, 59671,180, 59681,180, 59699,180, 59713,&
       180, 59719,180, 59743,180, 59759,180, 59783,180, 59789,&
       180, 59801,180, 59807,180, 59827,180, 59831,180, 59849,&
       180, 59863,180, 59879,180, 59891,180, 59893,180, 59929,&
       180, 59939,180, 59981,180, 59989,180, 59993,180, 59999,&
       180, 60031,180, 60037,180, 60061,180, 60067,180, 60073,&
       180, 60103,180, 60149,180, 60161,180, 60173,180, 60179,&
       180, 60193,180, 60217,180, 60229,180, 60247,180, 60251,&
       180, 60283,180, 60329,180, 60331,180, 60341,180, 60361,&
       180, 60377,180, 60397,180, 60403,180, 60419,180, 60439,&
       180, 60467,180, 60473,180, 60499,180, 60523,180, 60553,&
       180, 60557,180, 60559,180, 60569,180, 60581,180, 60587,&
       180, 60593,180, 60601,180, 60611,180, 60613,180, 60619,&
       180, 60643,180, 60647,180, 60667,180, 60671,180, 60713,&
       180, 60737,180, 60749,180, 60763,180, 60769,180, 60787,&
       180, 60797,180, 60811,180, 60823,180, 60829,180, 60847,&
       180, 60851,180, 60853,180, 60881,180, 60887,180, 60889,&
       180, 60913,180, 60919,180, 60929,180, 60941,180, 60943,&
       180, 60971,180, 60973,180, 60977,180, 60997,180, 61001,&
       180, 61013,180, 61019,180, 61039,180, 61043,180, 61049,&
       180, 61063,180, 61081,180, 61109,180, 61111,180, 61133,&
       180, 61141,180, 61181,180, 61187,180, 61213,180, 61217,&
       180, 61229,180, 61231,180, 61271,180, 61273,180, 61279,&
       180, 61283,180, 61297,180, 61307,180, 61313,180, 61321,&
       180, 61337,180, 61339,180, 61351,180, 61357,180, 61393,&
       180, 61397,180, 61403,180, 61409,180, 61427,180, 61433,&
       180, 61451,180, 61489,180, 61511,180, 61519,180, 61529,&
       180, 61537,180, 61543,180, 61549,180, 61559,180, 61571,&
       180, 61577,180, 61579,180, 61621,180, 61631,180, 61651,&
       180, 61669,180, 61679,180, 61697,180, 61711,180, 61721,&
       180, 61747,180, 61763,180, 61787,180, 61789,180, 61799,&
       180, 61801,180, 61811,180, 61831,180, 61843,180, 61879,&
       180, 61897,180, 61901,180, 61907,180, 61943,180, 61963,&
       180, 61967,180, 61999,180, 62053,180, 62063,180, 62071,&
       180, 62077,180, 62089,180, 62093,180, 62099,180, 62117,&
       180, 62119,180, 62149,180, 62177,180, 62179,180, 62203,&
       180, 62221,180, 62239,180, 62243,180, 62249,180, 62267,&
       180, 62299,180, 62303,180, 62321,180, 62327,180, 62333,&
       180, 62359,180, 62371,180, 62413,180, 62417,180, 62441,&
       180, 62467,180, 62473,180, 62489,180, 62491,180, 62509,&
       180, 62537,180, 62551,180, 62569,180, 62581,180, 62593,&
       180, 62597,180, 62599,180, 62603,180, 62621,180, 62629,&
       180, 62657,180, 62659,180, 62671,180, 62677,180, 62683,&
       180, 62687,180, 62699,180, 62707,180, 62749,180, 62753,&
       180, 62761,180, 62767,180, 62789,180, 62813,180, 62827,&
       180, 62831,180, 62869,180, 62879,180, 62891,180, 62897,&
       180, 62903,180, 62947,180, 62953,180, 62971,180, 62977,&
       180, 62981,180, 62993,180, 63001,180, 63007,180, 63013,&
       180, 63023,180, 63029,180, 63059,180, 63061,180, 63083,&
       180, 63089,180, 63091,180, 63103,180, 63119,180, 63131,&
       180, 63163,180, 63227,180, 63233,180, 63239,180, 63259,&
       180, 63271,180, 63311,180, 63337,180, 63341,180, 63353,&
       180, 63367,180, 63373,180, 63397,180, 63409,180, 63413,&
       180, 63421,180, 63427,180, 63437,180, 63443,180, 63449,&
       180, 63481,180, 63499,180, 63509,180, 63517,180, 63541,&
       180, 63551,180, 63559,180, 63569,180, 63601,180, 63607,&
       180, 63617,180, 63623,180, 63629,180, 63637,180, 63653,&
       180, 63671,180, 63691,180, 63727,180, 63743,180, 63751,&
       180, 63763,180, 63787,180, 63821,180, 63827,180, 63847,&
       180, 63899,180, 63917,180, 63931,180, 63989,180, 63997,&
       180, 64003,180, 64007,180, 64009,180, 64013,180, 64037,&
       180, 64067,180, 64087,180, 64093,180, 64133,180, 64139,&
       180, 64147,180, 64157,180, 64163,180, 64169,180, 64181,&
       180, 64189,180, 64207,180, 64211,180, 64217,180, 64219,&
       180, 64223,180, 64247,180, 64261,180, 64273,180, 64297,&
       180, 64307,180, 64309,180, 64331,180, 64357,180, 64379,&
       180, 64387,180, 64409,180, 64417,180, 64483,180, 64489,&
       180, 64493,180, 64513,180, 64531,180, 64553,180, 64591,&
       180, 64601,180, 64609,180, 64613,180, 64619,180, 64627,&
       180, 64651,180, 64661,180, 64679,180, 64687,180, 64711,&
       180, 64717,180, 64727,180, 64739,180, 64741,180, 64751,&
       180, 64757,180, 64793,180, 64813,180, 64819,180, 64823,&
       180, 64847,180, 64871,180, 64877,180, 64883,180, 64891,&
       180, 64921,180, 64927,180, 64931,180, 64933,180, 64949,&
       180, 64961,180, 64987,180, 65047,180, 65059,180, 65063,&
       180, 65077,180, 65089,180, 65093,180, 65099,180, 65101,&
       180, 65119,180, 65131,180, 65137,180, 65147,180, 65159,&
       180, 65171,180, 65179,180, 65191,180, 65203,180, 65207,&
       180, 65213,180, 65221,180, 65231,180, 65233,180, 65269,&
       180, 65311,180, 65323,180, 65339,180, 65347,180, 65369,&
       180, 65393,180, 65399,180, 65407,180, 65431,180, 65437,&
       180, 65441,180, 65443,180, 65473,180, 65479,180, 65507,&
       180, 65527,180, 65533,181, 13,181, 15,181, 33,&
       181, 61,181, 67,181, 141,181, 151,181, 183,&
       181, 187,181, 201,181, 207,181, 213,181, 217,&
       181, 223,181, 225,181, 243,181, 253,181, 255,&
       181, 277,181, 291,181, 297,181, 301,181, 327,&
       181, 337,181, 357,181, 375,181, 423,181, 453,&
       181, 477,181, 511,181, 531,181, 547,181, 553,&
       181, 561,181, 565,181, 595,181, 607,181, 645/
      DATA ((n(i,j),i=3,4),j=980,nmax)/ &
       181, 657,181, 663,181, 685,181, 687,181, 697,&
       181, 745,181, 775,181, 787,181, 823,181, 825,&
       181, 841,181, 853,181, 865,181, 895,181, 903,&
       181, 943,181, 963,181, 973,181, 981,181, 1005,&
       181, 1015,181, 1021,181, 1023,181, 1041,181, 1051,&
       181, 1057,181, 1083,181, 1093,181, 1105,181, 1107,&
       181, 1117,181, 1135,181, 1137,181, 1155,181, 1167,&
       181, 1191,181, 1197,181, 1221,181, 1233,181, 1237,&
       181, 1243,181, 1263/
!      end
#endif
!-----------------------------------------------------------------------------
!
!
!-----------------------------------------------------------------------------
      contains
!-----------------------------------------------------------------------------
! prng_32.f
!-----------------------------------------------------------------------------
#if defined(AIX) || defined(AMD64)
      real(kind=8) function prng_next(me)
!      implicit none
      integer :: me
!
! Calling sequence:
!      <new random number> = prng_next ( <ordinal of generator desired> )
!      <vector of random #s> = vprng ( <ordinal>, <vector>, <length> )
!
! This code is based on a sequential algorithm provided by Mal Kalos.
! This version uses a single 64-bit word to store the initial seeds
! and additive constants.
! A 64-bit floating point number is returned.
!
! The array "iparam" is full-word aligned, being padded by zeros to
! let each generator be on a subpage boundary.
! That is, rows 1 and 2 in a given column of the array are for real, 
! rows 3-16 are bogus.
!
! July 12, 1993: double the number of sequences.  We should have been
!                using two packets per seed, rather than four
! October 31, 1993: merge the two arrays of seeds and constants,
!                and switch to 64-bit arithmetic.
! June 1994: port to RS6K.  Internal state is kept as 2 64-bit integers
! The ishft function is defined only on 32-bit integers, so we will
! shift numbers by dividing by 2**11 and then adding on 2**53-1.
!
! November 1994: ishift now works on 64-bit numbers (though it gives a
! warning).  Thus we go back to using it.  John Zollweg also added the
! vprng() routine to return vectors of real*8 random numbers.
!
      real(kind=8),parameter :: recip53 = 2.0D0**(-53)
      integer(kind=8),parameter :: two = 2**11
      integer(kind=8) :: m,ishift
!      parameter ( m = 34522712143931 )          ! 11**13
!      parameter ( ishift = 9007199254740991 )   ! 2**53-1

!EL      integer nmax 
!EL      integer*8 iparam
!EL      parameter(nmax=1021)
!EL      common/ksrprng/iparam(2,0:nmax)

      integer(kind=8) :: next

!rc  g77 doesn't support integer*8 constants
      m = dint(34522712143931.0d0)
      ishift = dint(9007199254740991.0d0)
      if(me.gt.nmax) me=mod(me,nmax)

! RS6K porting note: ishift now takes 64-bit integers , with a warning
      if ( 0.le.me .and. me.le.nmax ) then
         next = iparam(1,me)*m + iparam(2,me)
         iparam(1,me) = next
         prng_next = recip53 * ishft( next, -11 )
      else
         prng_next=-1.0D0
      endif

      end function prng_next
!-----------------------------------------------------------------------------
!
!   vprng(me, rn, num)       Get a vector of random numbers
!
      subroutine vprng(me,rn,num)

      real(kind=8),parameter :: recip53 = 2.0D0**(-53)
      real(kind=8),dimension(1) :: rn

      integer(kind=8) :: m
!EL ,iparam
!      parameter ( m = 34522712143931 )          ! 11**13
!EL      integer nmax,
      integer :: num, me,i
!EL      parameter(nmax=1021)
!EL      common/ksrprng/iparam(2,0:nmax)

      integer(kind=8) :: next

!rc  g77 doesn't support integer*8 constants
      m = dint(34522712143931.0d0)

      if ( 0.le.me .and. me.le.nmax ) then
         do 1 i=1,num
            next = iparam(1,me)*m + iparam(2,me)
            iparam(1,me) = next
            rn(i) = recip53 * ishft( next, -11 )
    1    continue
      else
         rn(1)=-1.0D0
      endif
      return
      end subroutine vprng
!-----------------------------------------------------------------------------
!
!   prng_chkpnt          Get the current state of a generator
!
! Calling sequence:
!   logical prng_chkpnt, status
!   status = prng_chkpnt (me, iseed)    where
!
!     me is the particular generator whose state is being gotten
!     seed is an 4-element integer array where the "l"-values will be saved
!
      logical function prng_chkpnt(me,iseed)
!      implicit none
      integer :: me
      integer(kind=8) :: iseed

!EL      integer nmax 
!EL      integer*8 iparam
!EL      parameter(nmax=1021)
!EL      common/ksrprng/iparam(2,0:nmax)

      if (me .lt. 0 .or. me .gt. nmax) then
         prng_chkpnt=.false.
      else
         prng_chkpnt=.true.
         iseed=iparam(1,me)
      endif
      end function prng_chkpnt
!-----------------------------------------------------------------------------
!
!   prng_restart          Restart generator from a saved state
!
! Calling sequence:
!   logical prng_restart, status
!   status = prng_restart (me, iseed)    where
!
!     me is the particular generator being restarted
!     iseed is a 8-byte integer containing the "l"-values
!
      logical function prng_restart(me,iseed)
!      implicit none
      integer :: me
      integer(kind=8) :: iseed

!EL      integer nmax 
!EL      integer*8 iparam
!EL      parameter(nmax=1021)
!EL      common/ksrprng/iparam(2,0:nmax)
      
      if(me.gt.nmax) me=mod(me,nmax)
      if (me .lt. 0 .or. me .gt. nmax) then
         prng_restart=.false.
         return
      else
         prng_restart=.true.
         iparam(1,me)=iseed
      endif
      end function prng_restart
!-----------------------------------------------------------------------------
#else
      real(kind=4) function prng_next(me)
!rc      logical prng_restart, prng_chkpnt
!
! Calling sequence: 
!      <new random number> = prng_next ( <ordinal of generator desired> )
!
! This code is based on a sequential algorithm provided by Mal Kalos.
! This version uses 4 16-bit packets, and uses a block data common
! area for the initial seeds and constants.  A 64-bit floating point
! number is returned.
!
! The arrays "l" and "n" are full-word aligned, being padded by zeros
! That is, rows 1-4 in a given column are for real, rows 5-16 are bogus
!
! July 12, 1993: double the number of sequences.  We should have been
!                using two packets per seed, rather than four
!
      real(kind=4),parameter :: tpm12 = 1.d0/65536.d0
      integer,dimension(4) :: iseed
      integer :: me
!EL      parameter(nmax=1021)
!     external prngblk
!el      integer,dimension(16,0:nmax) :: l,n
!EL      common/ksrprng/l(16,0:nmax),n(16,0:nmax)
!*ksr*subpage /ksrprng/
      integer :: m1,m2,m3,m4,l1,l2,l3,l4,i1,i2,i3,i4
      data m1,m2,m3,m4 / 0, 8037, 61950, 30779/
      if (me .lt. 0 .or. me .gt. nmax) then
         prng_next=-1.0
         return
      endif
      l1=l(1,me)
      l2=l(2,me)
      l3=l(3,me)
      l4=l(4,me)
      i1=l1*m4+l2*m3+l3*m2+l4*m1 + n(1,me)
      i2=l2*m4+l3*m3+l4*m2 + n(2,me)
      i3=l3*m4+l4*m3 + n(3,me)
      i4=l4*m4 + n(4,me)
      l4=and(i4,65535)
      i3=i3+ishft(i4,-16)
      l3=and(i3,65535)
      i2=i2+ishft(i3,-16)
      l2=and(i2,65535)
      l1=and(i1+ishft(i2,-16),65535)
      prng_next=tpm12*(l1+tpm12*(l2+tpm12*(l3+tpm12*l4)))
      l(1,me)=l1
      l(2,me)=l2
      l(3,me)=l3
      l(4,me)=l4
      return
      end function prng_next
!-----------------------------------------------------------------------------
!
!   prng_chkpnt          Get the current state of a generator
!
! Calling sequence:
!   logical prng_chkpnt, status
!   status = prng_chkpnt (me, iseed)    where
!
!     me is the particular generator whose state is being gotten
!     seed is an 4-element integer array where the "l"-values will be saved
!
!rc      entry prng_chkpnt (me, iseed)
      logical function prng_chkpnt(me,iseed)
      integer,dimension(4) :: iseed
      integer :: me
!el      parameter(nmax=1021)
!el      common/ksrprng/l(16,0:nmax),n(16,0:nmax) 
      if (me .lt. 0 .or. me .gt. nmax) then
         prng_chkpnt=.false.
      else
         prng_chkpnt=.true.
         iseed(1)=l(1,me)
         iseed(2)=l(2,me)
         iseed(3)=l(3,me)
         iseed(4)=l(4,me)
      endif
      return
      end function prng_chkpnt
!-----------------------------------------------------------------------------
!   prng_restart          Restart generator from a saved state
!
! Calling sequence:
!   logical prng_restart, status
!   status = prng_restart (me, iseed)    where
!
!     me is the particular generator being restarted
!     seed is an 4-element integer array containing the "l"-values
!
!rc      entry prng_restart (me, iseed)
      logical function prng_restart(me,iseed)

      integer,dimension(4) :: iseed
      integer :: me
!el      parameter(nmax=1021)
!el      common/ksrprng/l(16,0:nmax),n(16,0:nmax) 
      if (me .lt. 0 .or. me .gt. nmax) then
         prng_restart=.false.
         return
      else
        prng_restart=.true.
         l(1,me)=iseed(1)
         l(2,me)=iseed(2)
         l(3,me)=iseed(3)
         l(4,me)=iseed(4)
      endif
      return
      end function prng_restart
#endif
!-----------------------------------------------------------------------------
!-----------------------------------------------------------------------------
      end module prng
