      module prng
      implicit none
!-----------------------------------------------------------------------------
!-----------------------------------------------------------------------------
!
!      block data prngblk
      integer,parameter :: nmax=1021
      integer(kind=8),dimension(2,0:nmax) :: iparam
!      common/ksrprng/iparam(2,0:nmax)
      integer,private :: i
      data (iparam(1,i),iparam(2,i),i=   0,  29) / &
       11848219, 11848219, 11848237, 11848237, 11848241, 11848241,&
       11848247, 11848247, 11848253, 11848253, 11848271, 11848271,&
       11848297, 11848297, 11848313, 11848313, 11848339, 11848339,&
       11848351, 11848351, 11848357, 11848357, 11848363, 11848363,&
       11848367, 11848367, 11848373, 11848373, 11848379, 11848379,&
       11848393, 11848393, 11848433, 11848433, 11848451, 11848451,&
       11848469, 11848469, 11848477, 11848477, 11848489, 11848489,&
       11848493, 11848493, 11848513, 11848513, 11848523, 11848523,&
       11848531, 11848531, 11848537, 11848537, 11848553, 11848553,&
       11848589, 11848589, 11848591, 11848591, 11848601, 11848601 /
      data (iparam(1,i),iparam(2,i),i=  30,  59) / &
       11848619, 11848619, 11848637, 11848637, 11848663, 11848663,&
       11848673, 11848673, 11848679, 11848679, 11848691, 11848691,&
       11848699, 11848699, 11848709, 11848709, 11848717, 11848717,&
       11848721, 11848721, 11848729, 11848729, 11848741, 11848741,&
       11848751, 11848751, 11848757, 11848757, 11848787, 11848787,&
       11848801, 11848801, 11848829, 11848829, 11848853, 11848853,&
       11848861, 11848861, 11848867, 11848867, 11848873, 11848873,&
       11848891, 11848891, 11848909, 11848909, 11848919, 11848919,&
       11848931, 11848931, 11848937, 11848937, 11848961, 11848961,&
       11848981, 11848981, 11849021, 11849021, 11849039, 11849039 /
      data (iparam(1,i),iparam(2,i),i=  60,  89) / &
       11849053, 11849053, 11849059, 11849059, 11849069, 11849069,&
       11849077, 11849077, 11849087, 11849087, 11849093, 11849093,&
       11849107, 11849107, 11849111, 11849111, 11849129, 11849129,&
       11849137, 11849137, 11849177, 11849177, 11849183, 11849183,&
       11849203, 11849203, 11849231, 11849231, 11849237, 11849237,&
       11849239, 11849239, 11849249, 11849249, 11849251, 11849251,&
       11849269, 11849269, 11849273, 11849273, 11849291, 11849291,&
       11849297, 11849297, 11849309, 11849309, 11849339, 11849339,&
       11849359, 11849359, 11849363, 11849363, 11849399, 11849399,&
       11849401, 11849401, 11849413, 11849413, 11849417, 11849417 /
      data (iparam(1,i),iparam(2,i),i=  90, 119) / &
       11849437, 11849437, 11849443, 11849443, 11849473, 11849473,&
       11849491, 11849491, 11849503, 11849503, 11849507, 11849507,&
       11849557, 11849557, 11849567, 11849567, 11849569, 11849569,&
       11849573, 11849573, 11849587, 11849587, 11849599, 11849599,&
       11849633, 11849633, 11849641, 11849641, 11849653, 11849653,&
       11849659, 11849659, 11849671, 11849671, 11849683, 11849683,&
       11849689, 11849689, 11849693, 11849693, 11849699, 11849699,&
       11849701, 11849701, 11849707, 11849707, 11849713, 11849713,&
       11849723, 11849723, 11849741, 11849741, 11849743, 11849743,&
       11849759, 11849759, 11849767, 11849767, 11849771, 11849771 /
      data (iparam(1,i),iparam(2,i),i= 120, 149) / &
       11849791, 11849791, 11849801, 11849801, 11849809, 11849809,&
       11849813, 11849813, 11849869, 11849869, 11849881, 11849881,&
       11849891, 11849891, 11849909, 11849909, 11849923, 11849923,&
       11849933, 11849933, 11849947, 11849947, 11849987, 11849987,&
       11850001, 11850001, 11850011, 11850011, 11850019, 11850019,&
       11850023, 11850023, 11850031, 11850031, 11850049, 11850049,&
       11850061, 11850061, 11850073, 11850073, 11850077, 11850077,&
       11850103, 11850103, 11850109, 11850109, 11850121, 11850121,&
       11850127, 11850127, 11850133, 11850133, 11850149, 11850149,&
       11850161, 11850161, 11850169, 11850169, 11850191, 11850191 /
      data (iparam(1,i),iparam(2,i),i= 150, 179) / &
       11850233, 11850233, 11850247, 11850247, 11850259, 11850259,&
       11850269, 11850269, 11850283, 11850283, 11850301, 11850301,&
       11850341, 11850341, 11850347, 11850347, 11850367, 11850367,&
       11850373, 11850373, 11850379, 11850379, 11850389, 11850389,&
       11850407, 11850407, 11850427, 11850427, 11850437, 11850437,&
       11850469, 11850469, 11850481, 11850481, 11850511, 11850511,&
       11850529, 11850529, 11850541, 11850541, 11850557, 11850557,&
       11850607, 11850607, 11850611, 11850611, 11850667, 11850667,&
       11850677, 11850677, 11850679, 11850679, 11850701, 11850701,&
       11850731, 11850731, 11850739, 11850739, 11850749, 11850749 /
      data (iparam(1,i),iparam(2,i),i= 180, 209) / &
       11850791, 11850791, 11850803, 11850803, 11850829, 11850829,&
       11850833, 11850833, 11850859, 11850859, 11850877, 11850877,&
       11850899, 11850899, 11850907, 11850907, 11850913, 11850913,&
       11850919, 11850919, 11850931, 11850931, 11850941, 11850941,&
       11850947, 11850947, 11850953, 11850953, 11850961, 11850961,&
       11850983, 11850983, 11850991, 11850991, 11850997, 11850997,&
       11851031, 11851031, 11851033, 11851033, 11851051, 11851051,&
       11851061, 11851061, 11851067, 11851067, 11851093, 11851093,&
       11851109, 11851109, 11851123, 11851123, 11851127, 11851127,&
       11851139, 11851139, 11851157, 11851157, 11851163, 11851163 /
      data (iparam(1,i),iparam(2,i),i= 210, 239) / &
       11851181, 11851181, 11851201, 11851201, 11851219, 11851219,&
       11851291, 11851291, 11851303, 11851303, 11851309, 11851309,&
       11851313, 11851313, 11851319, 11851319, 11851349, 11851349,&
       11851351, 11851351, 11851361, 11851361, 11851373, 11851373,&
       11851403, 11851403, 11851409, 11851409, 11851423, 11851423,&
       11851447, 11851447, 11851451, 11851451, 11851481, 11851481,&
       11851493, 11851493, 11851519, 11851519, 11851523, 11851523,&
       11851529, 11851529, 11851547, 11851547, 11851549, 11851549,&
       11851559, 11851559, 11851577, 11851577, 11851589, 11851589,&
       11851591, 11851591, 11851597, 11851597, 11851603, 11851603 /
      data (iparam(1,i),iparam(2,i),i= 240, 269) / &
       11851607, 11851607, 11851613, 11851613, 11851621, 11851621,&
       11851627, 11851627, 11851639, 11851639, 11851673, 11851673,&
       11851681, 11851681, 11851727, 11851727, 11851753, 11851753,&
       11851759, 11851759, 11851787, 11851787, 11851793, 11851793,&
       11851799, 11851799, 11851813, 11851813, 11851841, 11851841,&
       11851859, 11851859, 11851867, 11851867, 11851891, 11851891,&
       11851909, 11851909, 11851919, 11851919, 11851927, 11851927,&
       11851933, 11851933, 11851949, 11851949, 11851967, 11851967,&
       11851997, 11851997, 11852017, 11852017, 11852051, 11852051,&
       11852053, 11852053, 11852059, 11852059, 11852083, 11852083 /
      data (iparam(1,i),iparam(2,i),i= 270, 299) / &
       11852089, 11852089, 11852129, 11852129, 11852147, 11852147,&
       11852149, 11852149, 11852161, 11852161, 11852171, 11852171,&
       11852177, 11852177, 11852209, 11852209, 11852221, 11852221,&
       11852237, 11852237, 11852251, 11852251, 11852263, 11852263,&
       11852273, 11852273, 11852279, 11852279, 11852287, 11852287,&
       11852293, 11852293, 11852297, 11852297, 11852303, 11852303,&
       11852311, 11852311, 11852327, 11852327, 11852339, 11852339,&
       11852341, 11852341, 11852359, 11852359, 11852369, 11852369,&
       11852437, 11852437, 11852453, 11852453, 11852459, 11852459,&
       11852473, 11852473, 11852513, 11852513, 11852531, 11852531 /
      data (iparam(1,i),iparam(2,i),i= 300, 329) / &
       11852537, 11852537, 11852539, 11852539, 11852557, 11852557,&
       11852573, 11852573, 11852579, 11852579, 11852591, 11852591,&
       11852609, 11852609, 11852611, 11852611, 11852623, 11852623,&
       11852641, 11852641, 11852647, 11852647, 11852657, 11852657,&
       11852663, 11852663, 11852717, 11852717, 11852719, 11852719,&
       11852741, 11852741, 11852759, 11852759, 11852767, 11852767,&
       11852773, 11852773, 11852803, 11852803, 11852807, 11852807,&
       11852809, 11852809, 11852831, 11852831, 11852833, 11852833,&
       11852837, 11852837, 11852857, 11852857, 11852873, 11852873,&
       11852879, 11852879, 11852891, 11852891, 11852917, 11852917 /
      data (iparam(1,i),iparam(2,i),i= 330, 359) / &
       11852921, 11852921, 11852957, 11852957, 11852959, 11852959,&
       11852969, 11852969, 11852983, 11852983, 11852989, 11852989,&
       11853001, 11853001, 11853013, 11853013, 11853019, 11853019,&
       11853031, 11853031, 11853089, 11853089, 11853133, 11853133,&
       11853157, 11853157, 11853161, 11853161, 11853181, 11853181,&
       11853203, 11853203, 11853217, 11853217, 11853221, 11853221,&
       11853227, 11853227, 11853241, 11853241, 11853307, 11853307,&
       11853319, 11853319, 11853323, 11853323, 11853329, 11853329,&
       11853367, 11853367, 11853383, 11853383, 11853419, 11853419,&
       11853421, 11853421, 11853427, 11853427, 11853449, 11853449 /
      data (iparam(1,i),iparam(2,i),i= 360, 389) / &
       11853451, 11853451, 11853463, 11853463, 11853529, 11853529,&
       11853557, 11853557, 11853571, 11853571, 11853601, 11853601,&
       11853613, 11853613, 11853617, 11853617, 11853629, 11853629,&
       11853649, 11853649, 11853659, 11853659, 11853679, 11853679,&
       11853689, 11853689, 11853719, 11853719, 11853731, 11853731,&
       11853757, 11853757, 11853761, 11853761, 11853773, 11853773,&
       11853791, 11853791, 11853817, 11853817, 11853839, 11853839,&
       11853847, 11853847, 11853857, 11853857, 11853869, 11853869,&
       11853883, 11853883, 11853887, 11853887, 11853889, 11853889,&
       11853893, 11853893, 11853899, 11853899, 11853911, 11853911 /
      data (iparam(1,i),iparam(2,i),i= 390, 419) / &
       11853931, 11853931, 11853943, 11853943, 11853979, 11853979,&
       11853991, 11853991, 11854001, 11854001, 11854009, 11854009,&
       11854019, 11854019, 11854057, 11854057, 11854061, 11854061,&
       11854147, 11854147, 11854159, 11854159, 11854163, 11854163,&
       11854169, 11854169, 11854211, 11854211, 11854247, 11854247,&
       11854261, 11854261, 11854267, 11854267, 11854279, 11854279,&
       11854303, 11854303, 11854327, 11854327, 11854331, 11854331,&
       11854333, 11854333, 11854363, 11854363, 11854379, 11854379,&
       11854399, 11854399, 11854411, 11854411, 11854429, 11854429,&
       11854433, 11854433, 11854439, 11854439, 11854441, 11854441 /
      data (iparam(1,i),iparam(2,i),i= 420, 449) / &
       11854463, 11854463, 11854477, 11854477, 11854489, 11854489,&
       11854517, 11854517, 11854519, 11854519, 11854523, 11854523,&
       11854529, 11854529, 11854567, 11854567, 11854571, 11854571,&
       11854573, 11854573, 11854603, 11854603, 11854607, 11854607,&
       11854681, 11854681, 11854691, 11854691, 11854709, 11854709,&
       11854723, 11854723, 11854757, 11854757, 11854783, 11854783,&
       11854793, 11854793, 11854813, 11854813, 11854847, 11854847,&
       11854853, 11854853, 11854873, 11854873, 11854877, 11854877,&
       11854883, 11854883, 11854891, 11854891, 11854897, 11854897,&
       11854901, 11854901, 11854919, 11854919, 11854937, 11854937 /
      data (iparam(1,i),iparam(2,i),i= 450, 479) / &
       11854961, 11854961, 11854963, 11854963, 11854979, 11854979,&
       11855003, 11855003, 11855017, 11855017, 11855023, 11855023,&
       11855029, 11855029, 11855033, 11855033, 11855111, 11855111,&
       11855141, 11855141, 11855147, 11855147, 11855149, 11855149,&
       11855159, 11855159, 11855177, 11855177, 11855203, 11855203,&
       11855213, 11855213, 11855219, 11855219, 11855231, 11855231,&
       11855267, 11855267, 11855269, 11855269, 11855303, 11855303,&
       11855309, 11855309, 11855321, 11855321, 11855329, 11855329,&
       11855339, 11855339, 11855351, 11855351, 11855353, 11855353,&
       11855357, 11855357, 11855359, 11855359, 11855381, 11855381 /
      data (iparam(1,i),iparam(2,i),i= 480, 509) / &
       11855383, 11855383, 11855387, 11855387, 11855399, 11855399,&
       11855407, 11855407, 11855413, 11855413, 11855489, 11855489,&
       11855491, 11855491, 11855507, 11855507, 11855521, 11855521,&
       11855531, 11855531, 11855549, 11855549, 11855551, 11855551,&
       11855567, 11855567, 11855581, 11855581, 11855587, 11855587,&
       11855593, 11855593, 11855633, 11855633, 11855653, 11855653,&
       11855663, 11855663, 11855687, 11855687, 11855689, 11855689,&
       11855699, 11855699, 11855713, 11855713, 11855731, 11855731,&
       11855737, 11855737, 11855743, 11855743, 11855747, 11855747,&
       11855759, 11855759, 11855773, 11855773, 11855801, 11855801 /
      data (iparam(1,i),iparam(2,i),i= 510, 539) / &
       11855807, 11855807, 11855813, 11855813, 11855827, 11855827,&
       11855839, 11855839, 11855869, 11855869, 11855881, 11855881,&
       11855903, 11855903, 11855911, 11855911, 11855933, 11855933,&
       11855959, 11855959, 11855989, 11855989, 11855993, 11855993,&
       11855999, 11855999, 11856001, 11856001, 11856023, 11856023,&
       11856049, 11856049, 11856071, 11856071, 11856101, 11856101,&
       11856107, 11856107, 11856113, 11856113, 11856139, 11856139,&
       11856151, 11856151, 11856161, 11856161, 11856179, 11856179,&
       11856193, 11856193, 11856199, 11856199, 11856223, 11856223,&
       11856239, 11856239, 11856263, 11856263, 11856269, 11856269 /
      data (iparam(1,i),iparam(2,i),i= 540, 569) / &
       11856281, 11856281, 11856287, 11856287, 11856307, 11856307,&
       11856311, 11856311, 11856329, 11856329, 11856343, 11856343,&
       11856359, 11856359, 11856371, 11856371, 11856373, 11856373,&
       11856409, 11856409, 11856419, 11856419, 11856461, 11856461,&
       11856469, 11856469, 11856473, 11856473, 11856479, 11856479,&
       11856511, 11856511, 11856517, 11856517, 11856541, 11856541,&
       11856547, 11856547, 11856553, 11856553, 11856583, 11856583,&
       11856629, 11856629, 11856641, 11856641, 11856653, 11856653,&
       11856659, 11856659, 11856673, 11856673, 11856697, 11856697,&
       11856709, 11856709, 11856727, 11856727, 11856731, 11856731 /
      data (iparam(1,i),iparam(2,i),i= 570, 599) / &
       11856763, 11856763, 11856809, 11856809, 11856811, 11856811,&
       11856821, 11856821, 11856841, 11856841, 11856857, 11856857,&
       11856877, 11856877, 11856883, 11856883, 11856899, 11856899,&
       11856919, 11856919, 11856947, 11856947, 11856953, 11856953,&
       11856979, 11856979, 11857003, 11857003, 11857033, 11857033,&
       11857037, 11857037, 11857039, 11857039, 11857049, 11857049,&
       11857061, 11857061, 11857067, 11857067, 11857073, 11857073,&
       11857081, 11857081, 11857091, 11857091, 11857093, 11857093,&
       11857099, 11857099, 11857123, 11857123, 11857127, 11857127,&
       11857147, 11857147, 11857151, 11857151, 11857193, 11857193 /
      data (iparam(1,i),iparam(2,i),i= 600, 629) / &
       11857217, 11857217, 11857229, 11857229, 11857243, 11857243,&
       11857249, 11857249, 11857267, 11857267, 11857277, 11857277,&
       11857291, 11857291, 11857303, 11857303, 11857309, 11857309,&
       11857327, 11857327, 11857331, 11857331, 11857333, 11857333,&
       11857361, 11857361, 11857367, 11857367, 11857369, 11857369,&
       11857393, 11857393, 11857399, 11857399, 11857409, 11857409,&
       11857421, 11857421, 11857423, 11857423, 11857451, 11857451,&
       11857453, 11857453, 11857457, 11857457, 11857477, 11857477,&
       11857481, 11857481, 11857493, 11857493, 11857499, 11857499,&
       11857519, 11857519, 11857523, 11857523, 11857529, 11857529 /
      data (iparam(1,i),iparam(2,i),i= 630, 659) / &
       11857543, 11857543, 11857561, 11857561, 11857589, 11857589,&
       11857591, 11857591, 11857613, 11857613, 11857621, 11857621,&
       11857661, 11857661, 11857667, 11857667, 11857693, 11857693,&
       11857697, 11857697, 11857709, 11857709, 11857711, 11857711,&
       11857751, 11857751, 11857753, 11857753, 11857759, 11857759,&
       11857763, 11857763, 11857777, 11857777, 11857787, 11857787,&
       11857793, 11857793, 11857801, 11857801, 11857817, 11857817,&
       11857819, 11857819, 11857831, 11857831, 11857837, 11857837,&
       11857873, 11857873, 11857877, 11857877, 11857883, 11857883,&
       11857889, 11857889, 11857907, 11857907, 11857913, 11857913 /
      data (iparam(1,i),iparam(2,i),i= 660, 689) / &
       11857931, 11857931, 11857969, 11857969, 11857991, 11857991,&
       11857999, 11857999, 11858009, 11858009, 11858017, 11858017,&
       11858023, 11858023, 11858029, 11858029, 11858039, 11858039,&
       11858051, 11858051, 11858057, 11858057, 11858059, 11858059,&
       11858101, 11858101, 11858111, 11858111, 11858131, 11858131,&
       11858149, 11858149, 11858159, 11858159, 11858177, 11858177,&
       11858191, 11858191, 11858201, 11858201, 11858227, 11858227,&
       11858243, 11858243, 11858267, 11858267, 11858269, 11858269,&
       11858279, 11858279, 11858281, 11858281, 11858291, 11858291,&
       11858311, 11858311, 11858323, 11858323, 11858359, 11858359 /
      data (iparam(1,i),iparam(2,i),i= 690, 719) / &
       11858377, 11858377, 11858381, 11858381, 11858387, 11858387,&
       11858423, 11858423, 11858443, 11858443, 11858447, 11858447,&
       11858479, 11858479, 11858533, 11858533, 11858543, 11858543,&
       11858551, 11858551, 11858557, 11858557, 11858569, 11858569,&
       11858573, 11858573, 11858579, 11858579, 11858597, 11858597,&
       11858599, 11858599, 11858629, 11858629, 11858657, 11858657,&
       11858659, 11858659, 11858683, 11858683, 11858701, 11858701,&
       11858719, 11858719, 11858723, 11858723, 11858729, 11858729,&
       11858747, 11858747, 11858779, 11858779, 11858783, 11858783,&
       11858801, 11858801, 11858807, 11858807, 11858813, 11858813 /
      data (iparam(1,i),iparam(2,i),i= 720, 749) / &
       11858839, 11858839, 11858851, 11858851, 11858893, 11858893,&
       11858897, 11858897, 11858921, 11858921, 11858947, 11858947,&
       11858953, 11858953, 11858969, 11858969, 11858971, 11858971,&
       11858989, 11858989, 11859017, 11859017, 11859031, 11859031,&
       11859049, 11859049, 11859061, 11859061, 11859073, 11859073,&
       11859077, 11859077, 11859079, 11859079, 11859083, 11859083,&
       11859101, 11859101, 11859109, 11859109, 11859137, 11859137,&
       11859139, 11859139, 11859151, 11859151, 11859157, 11859157,&
       11859163, 11859163, 11859167, 11859167, 11859179, 11859179,&
       11859187, 11859187, 11859229, 11859229, 11859233, 11859233 /
      data (iparam(1,i),iparam(2,i),i= 750, 779) / &
       11859241, 11859241, 11859247, 11859247, 11859269, 11859269,&
       11859293, 11859293, 11859307, 11859307, 11859311, 11859311,&
       11859349, 11859349, 11859359, 11859359, 11859371, 11859371,&
       11859377, 11859377, 11859383, 11859383, 11859427, 11859427,&
       11859433, 11859433, 11859451, 11859451, 11859457, 11859457,&
       11859461, 11859461, 11859473, 11859473, 11859481, 11859481,&
       11859487, 11859487, 11859493, 11859493, 11859503, 11859503,&
       11859509, 11859509, 11859539, 11859539, 11859541, 11859541,&
       11859563, 11859563, 11859569, 11859569, 11859571, 11859571,&
       11859583, 11859583, 11859599, 11859599, 11859611, 11859611 /
      data (iparam(1,i),iparam(2,i),i= 780, 809) / &
       11859643, 11859643, 11859707, 11859707, 11859713, 11859713,&
       11859719, 11859719, 11859739, 11859739, 11859751, 11859751,&
       11859791, 11859791, 11859817, 11859817, 11859821, 11859821,&
       11859833, 11859833, 11859847, 11859847, 11859853, 11859853,&
       11859877, 11859877, 11859889, 11859889, 11859893, 11859893,&
       11859901, 11859901, 11859907, 11859907, 11859917, 11859917,&
       11859923, 11859923, 11859929, 11859929, 11859961, 11859961,&
       11859979, 11859979, 11859989, 11859989, 11859997, 11859997,&
       11860021, 11860021, 11860031, 11860031, 11860039, 11860039,&
       11860049, 11860049, 11860081, 11860081, 11860087, 11860087 /
      data (iparam(1,i),iparam(2,i),i= 810, 839) / &
       11860097, 11860097, 11860103, 11860103, 11860109, 11860109,&
       11860117, 11860117, 11860133, 11860133, 11860151, 11860151,&
       11860171, 11860171, 11860207, 11860207, 11860223, 11860223,&
       11860231, 11860231, 11860243, 11860243, 11860267, 11860267,&
       11860301, 11860301, 11860307, 11860307, 11860327, 11860327,&
       11860379, 11860379, 11860397, 11860397, 11860411, 11860411,&
       11860469, 11860469, 11860477, 11860477, 11860483, 11860483,&
       11860487, 11860487, 11860489, 11860489, 11860493, 11860493,&
       11860517, 11860517, 11860547, 11860547, 11860567, 11860567,&
       11860573, 11860573, 11860613, 11860613, 11860619, 11860619 /
      data (iparam(1,i),iparam(2,i),i= 840, 869) /  &
       11860627, 11860627, 11860637, 11860637, 11860643, 11860643,&
       11860649, 11860649, 11860661, 11860661, 11860669, 11860669,&
       11860687, 11860687, 11860691, 11860691, 11860697, 11860697,&
       11860699, 11860699, 11860703, 11860703, 11860727, 11860727,&
       11860741, 11860741, 11860753, 11860753, 11860777, 11860777,&
       11860787, 11860787, 11860789, 11860789, 11860811, 11860811,&
       11860837, 11860837, 11860859, 11860859, 11860867, 11860867,&
       11860889, 11860889, 11860897, 11860897, 11860963, 11860963,&
       11860969, 11860969, 11860973, 11860973, 11860993, 11860993,&
       11861011, 11861011, 11861033, 11861033, 11861071, 11861071 /
      data (iparam(1,i),iparam(2,i),i= 870, 899) / &
       11861081, 11861081, 11861089, 11861089, 11861093, 11861093,&
       11861099, 11861099, 11861107, 11861107, 11861131, 11861131,&
       11861141, 11861141, 11861159, 11861159, 11861167, 11861167,&
       11861191, 11861191, 11861197, 11861197, 11861207, 11861207,&
       11861219, 11861219, 11861221, 11861221, 11861231, 11861231,&
       11861237, 11861237, 11861273, 11861273, 11861293, 11861293,&
       11861299, 11861299, 11861303, 11861303, 11861327, 11861327,&
       11861351, 11861351, 11861357, 11861357, 11861363, 11861363,&
       11861371, 11861371, 11861401, 11861401, 11861407, 11861407,&
       11861411, 11861411, 11861413, 11861413, 11861429, 11861429 /
      data (iparam(1,i),iparam(2,i),i= 900, 929) / &
       11861441, 11861441, 11861467, 11861467, 11861527, 11861527,&
       11861539, 11861539, 11861543, 11861543, 11861557, 11861557,&
       11861569, 11861569, 11861573, 11861573, 11861579, 11861579,&
       11861581, 11861581, 11861599, 11861599, 11861611, 11861611,&
       11861617, 11861617, 11861627, 11861627, 11861639, 11861639,&
       11861651, 11861651, 11861659, 11861659, 11861671, 11861671,&
       11861683, 11861683, 11861687, 11861687, 11861693, 11861693,&
       11861701, 11861701, 11861711, 11861711, 11861713, 11861713,&
       11861749, 11861749, 11861791, 11861791, 11861803, 11861803,&
       11861819, 11861819, 11861827, 11861827, 11861849, 11861849 /
      data (iparam(1,i),iparam(2,i),i= 930, 959) / &
       11861873, 11861873, 11861879, 11861879, 11861887, 11861887,&
       11861911, 11861911, 11861917, 11861917, 11861921, 11861921,&
       11861923, 11861923, 11861953, 11861953, 11861959, 11861959,&
       11861987, 11861987, 11862007, 11862007, 11862013, 11862013,&
       11862029, 11862029, 11862031, 11862031, 11862049, 11862049,&
       11862077, 11862077, 11862083, 11862083, 11862157, 11862157,&
       11862167, 11862167, 11862199, 11862199, 11862203, 11862203,&
       11862217, 11862217, 11862223, 11862223, 11862229, 11862229,&
       11862233, 11862233, 11862239, 11862239, 11862241, 11862241,&
       11862259, 11862259, 11862269, 11862269, 11862271, 11862271 /
      data (iparam(1,i),iparam(2,i),i= 960, 989) / &
       11862293, 11862293, 11862307, 11862307, 11862313, 11862313,&
       11862317, 11862317, 11862343, 11862343, 11862353, 11862353,&
       11862373, 11862373, 11862391, 11862391, 11862439, 11862439,&
       11862469, 11862469, 11862493, 11862493, 11862527, 11862527,&
       11862547, 11862547, 11862563, 11862563, 11862569, 11862569,&
       11862577, 11862577, 11862581, 11862581, 11862611, 11862611,&
       11862623, 11862623, 11862661, 11862661, 11862673, 11862673,&
       11862679, 11862679, 11862701, 11862701, 11862703, 11862703,&
       11862713, 11862713, 11862761, 11862761, 11862791, 11862791,&
       11862803, 11862803, 11862839, 11862839, 11862841, 11862841 /
      data (iparam(1,i),iparam(2,i),i= 990,1019) / &
       11862857, 11862857, 11862869, 11862869, 11862881, 11862881,&
       11862911, 11862911, 11862919, 11862919, 11862959, 11862959,&
       11862979, 11862979, 11862989, 11862989, 11862997, 11862997,&
       11863021, 11863021, 11863031, 11863031, 11863037, 11863037,&
       11863039, 11863039, 11863057, 11863057, 11863067, 11863067,&
       11863073, 11863073, 11863099, 11863099, 11863109, 11863109,&
       11863121, 11863121, 11863123, 11863123, 11863133, 11863133,&
       11863151, 11863151, 11863153, 11863153, 11863171, 11863171,&
       11863183, 11863183, 11863207, 11863207, 11863213, 11863213,&
       11863237, 11863237, 11863249, 11863249, 11863253, 11863253 /
      data (iparam(1,i),iparam(2,i),i=1020,1021) / &
       11863259, 11863259, 11863279, 11863279 /
!      end
!-----------------------------------------------------------------------------
!
!
!-----------------------------------------------------------------------------
      contains
!-----------------------------------------------------------------------------
! prng.f
!-----------------------------------------------------------------------------
      real(kind=8) function prng_next(me)
!      implicit none
      integer :: me
!
! Calling sequence:
!      <new random number> = prng_next ( <ordinal of generator desired> )
!      <vector of random #s> = vprng ( <ordinal>, <vector>, <length> )
!
! This code is based on a sequential algorithm provided by Mal Kalos.
! This version uses a single 64-bit word to store the initial seeds
! and additive constants.
! A 64-bit floating point number is returned.
!
! The array "iparam" is full-word aligned, being padded by zeros to
! let each generator be on a subpage boundary.
! That is, rows 1 and 2 in a given column of the array are for real, 
! rows 3-16 are bogus.
!
! July 12, 1993: double the number of sequences.  We should have been
!                using two packets per seed, rather than four
! October 31, 1993: merge the two arrays of seeds and constants,
!                and switch to 64-bit arithmetic.
! June 1994: port to RS6K.  Internal state is kept as 2 64-bit integers
! The ishft function is defined only on 32-bit integers, so we will
! shift numbers by dividing by 2**11 and then adding on 2**53-1.
!
! November 1994: ishift now works on 64-bit numbers (though it gives a
! warning).  Thus we go back to using it.  John Zollweg also added the
! vprng() routine to return vectors of real*8 random numbers.
!
      real(kind=8),parameter :: recip53 = 2.0D0**(-53)
      integer(kind=8),parameter :: two = 2**11
      integer(kind=8) :: m,ishift
!      parameter ( m = 34522712143931 )          ! 11**13
!      parameter ( ishift = 9007199254740991 )   ! 2**53-1

!EL      integer,parameter :: nmax = 1021
!EL      integer(kind=8) :: iparam
!EL      common/ksrprng/iparam(2,0:nmax)

      integer(kind=8) :: next

!rc  g77 doesn't support integer*8 constants
      m = dint(34522712143931.0d0)
      ishift = dint(9007199254740991.0d0)

! RS6K porting note: ishift now takes 64-bit integers , with a warning
      if ( 0.le.me .and. me.le.nmax ) then
         next = iparam(1,me)*m + iparam(2,me)
         iparam(1,me) = next
         prng_next = recip53 * ishft( next, -11 )
      else
         prng_next=-1.0D0
      endif

      end function prng_next
!-----------------------------------------------------------------------------
      subroutine vprng(me,rn,num)

      real(kind=8),parameter :: recip53 = 2.0D0**(-53)
      real(kind=8),dimension(1) :: rn
      integer(kind=8) :: m
!EL,iparam
!      parameter ( m = 34522712143931 )          ! 11**13
!EL      integer,parameter :: nmax=1021
      integer :: num, me,i

!EL      common/ksrprng/iparam(2,0:nmax)

      integer(kind=8) :: next

!rc  g77 doesn't support integer*8 constants
      m = dint(34522712143931.0d0)

      if ( 0.le.me .and. me.le.nmax ) then
         do 1 i=1,num
            next = iparam(1,me)*m + iparam(2,me)
            iparam(1,me) = next
            rn(i) = recip53 * ishft( next, -11 )
    1    continue
      else
         rn(1)=-1.0D0
      endif
      return
      end subroutine vprng
!-----------------------------------------------------------------------------
!
!   prng_chkpnt          Get the current state of a generator
!
! Calling sequence:
!   logical prng_chkpnt, status
!   status = prng_chkpnt (me, iseed)    where
!
!     me is the particular generator whose state is being gotten
!     seed is an 4-element integer array where the "l"-values will be saved
!
      logical function prng_chkpnt(me,iseed)
!      implicit none
      integer :: me 
      integer(kind=8) :: iseed

!EL      integer,parameter :: nmax=1021
!EL      integer(kind=8) :: iparam
!EL      common/ksrprng/iparam(2,0:nmax)

      if (me .lt. 0 .or. me .gt. nmax) then
         prng_chkpnt=.false.
      else
         prng_chkpnt=.true.
         iseed=iparam(1,me)
      endif
      end function prng_chkpnt
!-----------------------------------------------------------------------------
!
!   prng_restart          Restart generator from a saved state
!
! Calling sequence:
!   logical prng_restart, status
!   status = prng_restart (me, iseed)    where
!
!     me is the particular generator being restarted
!     iseed is a 8-byte integer containing the "l"-values
!
      logical function prng_restart(me,iseed)
!      implicit none
      integer :: me
      integer(kind=8) :: iseed

!EL      integer,parameter :: nmax=1021
!EL      integer(kind=8) :: iparam
!EL      common/ksrprng/iparam(2,0:nmax)

      if (me .lt. 0 .or. me .gt. nmax) then
         prng_restart=.false.
         return
      else
         prng_restart=.true.
         iparam(1,me)=iseed
      endif
      end function prng_restart
!-----------------------------------------------------------------------------
!-----------------------------------------------------------------------------
      end module prng
