      module io_units
!-----------------------------------------------------------------------
! common.iounits
! I/O units used by the program
!-----------------------------------------------------------------------
! 9/18/99 - unit ifourier and filename fouriername included to identify
! the file from which the coefficients of second-order Fourier expansion
! of the local-interaction energy are read.
! 8/9/01 - file for SCP interaction constants named scpname (unit iscpp)
! included.
!-----------------------------------------------------------------------
! General I/O units & files
!      common /iounits/
      integer :: inp,iout,igeom,intin,ipdb,imol2,ipdbin,ithep,irotam,&
       itorp,itordp,ifourier,ielep,isidep,iscpp,icbase,istat,ientin,&
       ientout,izs1,isecpred,ibond,irest2,iifrag,icart,irest1,isccor,&
       ithep_pdb,irotam_pdb,iliptranpar,itube,   &
       ibond_nucl,ithep_nucl,irotam_nucl,itorp_nucl,itordp_nucl,     &
       isidep_nucl,iscpp_nucl,isidep_scbase,isidep_pepbase,isidep_scpho,&
       isidep_peppho,iion,iionnucl,iiontran,ilipbond,ilipnonbond,&
       iwaterwater,iwatersc,irotam_end,imartprot
#ifdef WHAM_RUN
! el wham iounits
      integer :: isidep1,ihist,iweight,izsc,idistr
#endif
#ifdef CLUSTER
! el cluster iounits
      integer :: jrms,jplot
#endif
!
!      common /fnames/
      character(len=256) :: outname,intname,pdbname,mol2name,statname,&
       intinname,entname,prefix,secpred,rest2name,qname,cartname,&
       tmpdir,mremd_rst_name,curdir,pref_orig
#ifdef CLUSTER
      integer :: isidep1
      character(len=256) :: rmsname,prefintin,prefout
#endif
!#ifdef WHAM_RUN
! el wham iounits
      character(len=256) :: restartnam,scratchdir,sidepname,pdbfile,&
                            histname,zscname
      character(len=4) :: liczba
      character(len=3) :: pot
!#endif
! Parameter files
!      common /parfiles/
      character(len=256) :: bondname,thetname,rotname,torname,tordname,&
       fouriername,elename,sidename,scpname,sccorname,patname,&
       thetname_pdb,rotname_pdb,liptranname,tubename,         &
       bondname_nucl,thetname_nucl,rotname_nucl,torname_nucl, &
       tordname_nucl,sidename_nucl,scpname_nucl,              &
       sidename_scbase,pepname_pepbase,pepname_scpho,pepname_peppho, &
       ionname,ionnuclname,iontranname,lipbondname,lipnonbondname,&
       iwaterwatername,iwaterscname,rotname_end,lipprotname
!-----------------------------------------------------------------------
! INP    - main input file
! IOUT   - list file
! IGEOM  - geometry output in the form of virtual-chain internal coordinates
! INTIN  - geometry input (for multiple conformation processing) in int. coords.
! IPDB   - Cartesian-coordinate output in PDB format
! IMOL2  - Cartesian-coordinate output in Tripos mol2 format
! IPDBIN - PDB input file
! ITHEP  - virtual-bond torsional angle parametrs
! IROTAM - side-chain geometry and local-interaction parameters
! ITORP  - torsional parameters
! ITORDP  - double torsional parameters
! IFOURIER - coefficients of the expansion of local-interaction energy 
! IELEP  - electrostatic-interaction parameters
! ISIDEP - side-chain interaction parameters.
! ISCPP  - SCp interaction parameters.
! IBOND  - virtual-bond constant parameters and moments of inertia.
! ISCCOR - parameters of the potential of SCCOR term
! ICBASE - data base with Cartesian coords of known structures.
! ISTAT  - energies and other conf. characteristics from an MCM run.
! IENTIN - entropy from preceeding simulation(s) to be read in.
! SECPRED - SECONDARY STRUCTURE PREDICTION for dihedral constraint generation.
!-----------------------------------------------------------------------------
!-----------------------------------------------------------------------------
      end module io_units
