      module control_data
!-----------------------------------------------------------------------------
! Max. number of types of dihedral angles & multiplicity of torsional barriers
! and the number of terms in double torsionals
      integer,parameter :: maxlor=3,maxterm=10 !maxtor=4
      integer,parameter :: maxtermd_1=8,maxtermd_2=8
!-----------------------------------------------------------------------------
! Max. number of groups of interactions that a given SC is involved in
      integer,parameter :: maxint_gr=2
!-----------------------------------------------------------------------------
! Max. number of residue types and parameters in expressions for 
! virtual-bond angle bending potentials
!      integer,parameter :: maxthetyp=3,maxthetyp1=maxthetyp+1
!      integer,parameter :: maxtheterm=20
!      integer,parameter :: maxtheterm2=6,maxtheterm3=4
!      integer,parameter :: maxsingle=6,maxdouble=4
!      integer,parameter :: mmaxtheterm=maxtheterm
!-----------------------------------------------------------------------------
! Max number of torsional terms in SCCOR
      integer,parameter :: maxterm_sccor=7000
!-----------------------------------------------------------------------------
! Max. number of lobes in SC distribution
!      integer,parameter :: maxlob=4 in geometry
!-----------------------------------------------------------------------------
! Max. number of S-S bridges
!      integer,parameter :: maxss=20
!-----------------------------------------------------------------------------
!-----------------------------------------------------------------------------
! commom.control
!      common /cntrl/
      integer :: modecalc,iscode,indpdb,indback,indphi,iranconf,&
       icheckgrad,iprint,i2ndstr,mucadyn,constr_dist,symetr,shield_mode,&
       tubemode,genconstr,afmlog,selfguide,scelemode,tor_mode,oldion,DRY_MARTINI,&
       vacuum
      logical :: minim,refstr,pdbref,overlapsc,&
       energy_dec,sideadd,lsecondary,read_cart,unres_pdb,&
       vdisulf,searchsc,lmuca,dccart,extconf,out1file,&
       gnorm_check,gradout,split_ene,with_theta_constr,protein,ions,nucleic,&
       raw_psipred,beta_amino,NO_CHECK_GEOM
#ifdef CLUSTER
      integer :: iopt,nend,nstart,outpdb,outmol2,nclust !cluster
      logical :: punch_dist,print_dist,lside,lprint_cart,lprint_int,&
                 caonly,efree,from_bx,from_cx,from_cart  ! cluster
#else
      logical :: outpdb,outmol2
#endif
!... minim = .true. means DO minimization.
!... energy_dec = .true. means print energy decomposition matrix
!-----------------------------------------------------------------------------
! common.header
!      common /header/
      character(len=80) :: titel
!-----------------------------------------------------------------------------
! common.spitele
!      common /splitele/
      real(kind=8) :: r_cut,rlamb,r_cut_ele,rlamb_ele,r_cut_mart,rlamb_mart,&
                      r_cut_ang,graddelta
!-----------------------------------------------------------------------------
! common.time1
!     FOUND_NAN - set by calcf to stop sumsl via stopx
!      COMMON/TIME1/
      real(kind=8) :: TIMLIM,SAFETY,WALLTIME
!      common /timing/
      real(kind=8) :: t_eelecij,t_enegrad,t_MDsetup,t_langsetup,t_MD,&
             t_sdsetup,time_stoch,time_fric,time_fsample,time_sumene,&
             time_enecalc,time_vec,time_bcast,time_reduce,time_gather,&
             time_sendrecv,time_barrier_e,time_barrier_g,time_scatter,&
             time_ginvmult,time_bcast7,time_bcastc,time_bcastw,&
       time_allreduce,&
       time_lagrangian,time_cartgrad,&
       time_sumgradient,time_intcartderiv,time_inttocart,time_intfcart,&
       time_mat,time_fricmatmult,&
       time_scatter_fmat,time_scatter_ginv,&
       time_scatter_fmatmult,time_scatter_ginvmult,&
       t_eshort,t_elong,t_etotal
#if defined(WHAM_RUN) || defined(CLUSTER)
!       common /stoptim/
!el       integer :: WhatsUp,ndelta
       integer :: ndelta
       logical :: cutoffviol,cutoffeval,llocal
!       common /timing/ wham
! Timers and counters for the respective routines
       real(kind=8) :: t_func,t_grad,t_fhel,t_fbet,t_ghel,t_gbet,&
                  t_viol,t_gviol,t_map,t_alamap,t_betamap
       integer :: n_func,n_grad,n_fhel,n_fbet,n_ghel,n_gbet,n_viol,&
                  n_gviol,n_map,n_alamap,n_betamap
#endif
!-----------------------------------------------------------------------------
      integer,parameter :: MaxMoveType = 4
!-----------------------------------------------------------------------------
! Max. number of processors.
!      integer,parameter :: maxprocs=2048
!el      integer,parameter :: maxprocs=4200
!-----------------------------------------------------------------------------
!-----------------------------------------------------------------------------
      end module control_data
