      module mcm_data
!-----------------------------------------------------------------------------
! Max. number of stored confs. in MC/MCM simulation
      integer,parameter :: maxsave=20
!-----------------------------------------------------------------------------
! common.mce
!      common /mce/
      real(kind=8) :: emin,emax
      logical :: ent_read
!      common /pool/
      real(kind=8) :: pool_fraction
!      common /mce_counters/
      integer :: save_frequency,message_frequency,pool_read_freq,&
       pool_save_freq,print_freq
!-----------------------------------------------------------------------------
! commom.mcm
!... Following COMMON block contains general variables controlling the MC/MCM
!... procedure
!-----------------------------------------------------------------------------
!      common /mcm/
      real(kind=8) :: Tcur,Tmin,Tmax,TstepH,TstepC,RanFract,&
       overlap_cut,e_up,delte,Rbol,betbol
      integer :: nstepH,nstepC,maxacc,maxgen,maxtrial,maxtrial_iter,&
       maxrepm,maxoverlap,ntrial,max_mcm_it,ngen,ntherm,nrepm,neneval,&
       nsave,nsweep,print_mc
      integer,dimension(:),allocatable :: nsave_part !(max_cg_procs)
      logical :: print_stat,print_int
!-----------------------------------------------------------------------------
!... The meaning of the above variables is as follows:
!... Tcur,Tmin,Tmax - Current,minimum and maximum temperature, respectively;
!... NstepC,NStepH - Number of cooling and heating steps, respectively;
!... TstepH,TstepC - factors by which T is multiplied in order to be
!...                 increased or decreased.
!... betbol - Boltzmann's inverse temperature (1/(Rbol*Tcur));
!... Rbol - the gas constant;
!... RanFract - the chance that a new conformation will be random-generated;
!... maxacc - maximum number of accepted conformations;
!... maxgen,ngen - Maximum and current number of generated conformations;
!... maxtrial,ntrial - maximum number of trials before temperature is increased
!...                   and current number of trials, respectively;
!... maxrepm,nrepm - maximum number of allowed minima repetition and current
!...                 number of minima repetitions, respectively;
!... maxoverlap - max. # of overlapping confs generated in a single iteration;
!... neneval - number of energy evaluations;
!... nsave - number of confs. in the backup array;
!... nsweep - the number of macroiterations in generating the distributions.
!------------------------------------------------------------------------------
!... Following COMMON block contains variables controlling motion.
!------------------------------------------------------------------------------
!      common /move/
      real(kind=8),dimension(:),allocatable :: sumpro_type !(0:MaxMoveType)
      integer :: nmove
      integer,dimension(:),allocatable :: moves,moves_acc !(-1:MaxMoveType+1)
!... maxgen,ngen - Maximum and current number of generated conformations;
!      common /accept_stats/
      integer :: nacc_tot
!      common /windows/
      integer :: nwindow
      integer,dimension(:),allocatable :: winstart,winend,winlen !(maxres)
!      common /moveID/
      character(len=16),dimension(:),allocatable :: MovTypID !(-1:MaxMoveType+1)
!-----------------------------------------------------------------------------
! common.var
! Store the angles and variables corresponding to old conformations (for use
! in MCM).
!      common /oldgeo/
      real(kind=8),dimension(:,:),allocatable :: varsave !(maxvar,maxsave)(maxvar=6*maxres)
      real(kind=8),dimension(:),allocatable :: esave !(maxsave)
      integer,dimension(:),allocatable :: Origin !(maxsave)
      integer :: nstore
!-----------------------------------------------------------------------------
!-----------------------------------------------------------------------------
      end module mcm_data
