#!/bin/sh
export POT=GB
export INPUT=$1
export INTIN=1L2Y_wham
export OUTPUT=1L2Y_clust
export PDB=CART
export COORD=CX
export PRINTCOOR=PRINT_PDB
#-----------------------------------------------------------------------------
CLUSTER_WHAM_BIN=/users2/adasko/unres4/unres4/bin/cluster_wham_ifort_MPI_GAB.exe
#-----------------------------------------------------------------------------
DD=/users2/adasko/unres4/unres4/PARAM
export BONDPAR=$DD/bond_AM1.parm
export THETPAR=$DD/theta_abinitio.parm
export ROTPAR=$DD/rotamers_AM1_aura.10022007.parm
export TORPAR=$DD/torsion_631Gdp.parm
export TORDPAR=$DD/torsion_double_631Gdp.parm
export ELEPAR=$DD/electr_631Gdp.parm
export SIDEPAR=$DD/scinter_$POT.parm
export FOURIER=$DD/fourier_opt.parm.1igd_hc_iter3_3
export SCPPAR=$DD/scp.parm
export SCCORPAR=$DD/sccor_am1_pawel.dat
export THETPARPDB=$DD/thetaml.5parm
export ROTPARPDB=$DD/scgauss.parm
export PATTERN=$DD/patterns.cart
export CONTFUNC=GB
export SIDEP=$DD/contact.3.parm
export SCRATCHDIR=.
#-----------------------------------------------------------------------------
echo CTEST_FULL_OUTPUT
mpiexec  -np $2 $CLUSTER_WHAM_BIN 
./cluster_wham_check.sh $1 
