      module clust_data
!-----------------------------------------------------------------------------
!*****************************************************************
!
! Array dimensions for the clustering programs:
!
! Max. number of conformations in the data set.
!
      integer,PARAMETER :: MAXCONF=13000
      integer,parameter :: maxstr_proc=maxconf
!
! Max. number of "distances" between conformations.
!
      integer,PARAMETER :: MAXDIST=(maxstr_proc*(maxstr_proc-1))/2
!
! Max. number of clusters. Should be set to MAXCONF; change only if there are
! problems with memory. In such a case be suspicious about the results, however!
!
      integer,PARAMETER :: MAXGR=maxstr_proc
!
! Max. number of conformations in a cluster. Remark above applies also here.
!
      integer,PARAMETER :: MAXINGR=maxstr_proc
!
! Max. number of cut-off values
!
      integer,PARAMETER :: MAX_CUT=5
!
! Max. number of properties
!
      integer,PARAMETER :: MAXPROP=5
!
! Max. number of temperatures
      integer,parameter :: maxT=5
!
! Max. number of S-S bridges
      integer,parameter :: maxss=20
!
!******************************************************************
!COMMON.CLUSTER
!      common /clu/
      real(kind=4),dimension(:),allocatable :: diss !(maxdist)
      real(kind=8),dimension(:),allocatable :: energy,totfree !(0:maxconf)
      real(kind=8),dimension(:,:),allocatable :: enetb !(max_ene,maxstr_proc)
      real(kind=8),dimension(:),allocatable :: entfac !(maxconf)
      real(kind=8),dimension(:),allocatable :: totfree_gr !(maxgr)
      real(kind=8),dimension(:),allocatable :: rcutoff !(max_cut+1)
      real(kind=8) :: ecut
      integer :: ncut
      logical :: min_var,tree,plot_tree,lgrp
!      common /clu1/
      integer,dimension(:),allocatable :: licz,iass !(maxgr)
      integer,dimension(:,:),allocatable :: nconf !(maxgr,maxingr)
      integer,dimension(:,:),allocatable :: iass_tot !(maxgr,max_cut)
      integer,dimension(:),allocatable :: list_conf !(maxconf)
      integer :: ngr
!      common /alles/
      real(kind=4),dimension(:,:,:),allocatable :: allcart !(3,maxres2,maxstr_proc)
      real(kind=8),dimension(:),allocatable :: rmstb !(maxconf)
      integer,dimension(:),allocatable :: mult !(maxres)
      integer,dimension(:),allocatable :: nss_all !(maxstr_proc)
      integer,dimension(:,:),allocatable :: ihpb_all,jhpb_all !(maxss,maxstr_proc)
      integer,dimension(:),allocatable :: icc,iscore !(maxconf)
      integer :: nprop
!COMMON.TEMPFAC
!      common /factemp/
      real(kind=8),dimension(:,:),allocatable :: tempfac !(2,maxres)
!COMMON.FREE
!      common /free/
      integer :: nT
      real(kind=8) :: prob_limit
      real(kind=8),dimension(:),allocatable :: beta_h !(maxT)
!-----------------------------------------------------------------------------
      end module clust_data
